;******************
;* Scramble v1.1  *
;******************
;Author: criminL <Email: criminL@helpdesk.zaz.net>
;If you steal any of this code please at least give me credit.
;Report and bugs, comments, or suggestions to criminL@helpdesk.zaz.net
;I used a different type of scoring in this scramble game, hopefully to make it
;more fun for everyone. I hope you enjoy it.

;SPECIAL THANKS;
;mutilator (phrase list), Rappy (original scramble, comma aliases)

ON *:LOAD: {
  if ($version < 5.7) {
    echo -i4ea *** Scramble v1.0b by criminL <Email: criminL@helpdesk.zaz.net> cannot be loaded, You are using an incompatible mIRC version, please download the most current mIRC version from 4http://www.mirc.com
    echo -a Script is now unloading...
    unload -rs $script
    echo -i4ea Unload complete.
    return
  } 
  echo -i4ea *** Scramble v1.0b by criminL <Email: criminL@helpdesk.zaz.net> successfully loaded...
  echo -a Running readme.txt...
  run notepad $scriptdirreadme.txt
  echo -ea Initial load sequence completed.
}

#scramble off
ON *:TEXT:*:#: {
  if ($1- == %scrambledAnswer) {
    .timerSkipScramble off
    .disable #scramble
    msg # Correct answer recieved by $nick $+ . The answer was %scrambledAnswer $+ .
    msg #  $+ $nick $+ , you earned %scrambleScore points...
    inc %scrambleScore@ [ $+ [ $nick ] ] %scrambleScore
    if ((%scrambleScore@ [ $+ [ $nick ] ] > %scrambleHighScore) || (%scrambleHighScore == $null)) {
      %scrambleHighScore = %scrambleScore@ [ $+ [ $nick ] ]
      if ($nick != %scrambleLeader) {
        msg # Congratulations $nick $+ , You have taken the lead!
        %scrambleLeader = $nick
      }
    }
    msg # Score total: $comma(%scrambleScore@ [ $+ [ $nick ] ] ) Leader: %scrambleLeader ( $+ $comma(%scrambleHighScore) $+ )
    .timerNewScramble 1 10 NewScramble #
    return
  }
  if ((?hint iswm $1) && (%scrambleHintGiven == $null)) {
    set -u10 %scrambleHintGiven 1
    msg # Hint: %scrambledHint
    return
  }
  if ((?skip iswm $1) && (%scrambleSkipped == $null)) {
    set -u10 %scrambleSkipped 1
    SkipScramble #
    return
  }
  if ((?refresh iswm $1) && (%scrambleRefresh == $null)) {
    set -u10 %scrambleRefresh 1
    %scrambled = $scramble(%scrambledAnswer) 
    while (%scrambled == %scrambledAnswer) {
      %scrambled = $scramble(%scrambledAnswer)
    }
    msg # Scrambled phrase: %scrambled
  }
}
#scramble end
alias -l NewScramble {
  var %newScrambleTemp = $read -n $scriptdirscramble.txt
  %scrambleScore = 120
  %scrambledAnswer = $gettok(%newScrambleTemp,1,126)
  %scrambledHint = $gettok(%newScrambleTemp,2,126)
  %scrambled = $scramble(%scrambledAnswer) 
  while (%scrambled == %scrambledAnswer) {
    %scrambled = $scramble(%scrambledAnswer)
  }
  msg $$1 -
  msg $1 Scrambled phrase: %scrambled
  msg $1 Hint: %scrambledHint
  .enable #scramble
  dec -c %scrambleScore
  .timerSkipScramble 1 120 SkipScramble $$1
}
alias StartScramble {
  %scrambleStart = 1
  msg # Scramble Game is now: Enabled
  msg # Scoring is simple, each questioned is timed. The highest possible score is 120 points.
  msg # Other commands: !hint, !refresh or !skip Enjoy! =)
  .timerNewScramble 1 10 NewScramble #
}
alias StopScramble {
  .timerNewScramble off
  .timerSkipScramble off
  .disable #scramble
  msg # Scramble Game is now: Disabled
  if (%scrambleLeader) msg # The game WINNER is %scrambleLeader with the score of $comma(%scrambleScore@ [ $+ [ %scrambleLeader ] ] ) $+ .
  unset %scramble*
}
alias SkipScramble {
  msg $$1 Answer: %scrambledAnswer
  NewScramble $1
}
alias scramble {
  tokenize 32 $1
  var %parm = $1, %parmLength = $len(%parm), %randParmChar, %scramble, %indx = 1
  while (%parm) {
    %randParmChar = $mid(%parm,$r(1,$len(%parm)),1)
    if ($count(%parm,%randParmChar) > 1) %parm = $remove(%parm,%randParmChar) $+ $str(%randParmChar,$calc($ifmatch - 1))
    else %parm = $remove(%parm,%randParmChar)
    %scramble = %scramble $+ %randParmChar
    if ($len($gettok(%scramble,%indx,160)) == $len($gettok($1-,%indx,32))) {
      inc %indx
      %parm = $gettok($1-,%indx,32)
      %parmLength = $len(%parm)
      %scramble = %scramble $+ $chr(160)
    }
  }
  return $replacecs(%scramble,$chr(160),$chr(32))
}
alias comma {
  if ($1 !isnum) return ERR_COMMA
  if (. isin $1) tokenize 46 $1
  if ($len($1) < 4) return $iif($2,$addtok($1,$2,46),$1)
  var %a = $len($1) + 1, %b, %c
  while (%a) {
    dec %a
    if (3 // %b) {
      if (%b = $len($1)) return $iif($2,$addtok(%c,$2,46),%c)
      set %c $addtok($mid($1,%a,1),%c,44)
    }
    else set %c $mid($1,%a,1) $+ %c
    inc %b
  }
  return $iif($2,$addtok(%c,$2,46),%c)
}

menu channel {
  Games
  .Word Scramble
  ..Currently ( $+ $iif(%scrambleStart,ON,OFF) $+ ): {
    if (%scrambleStart) StopScramble
    else StartScramble
  }
  ..Word List
  ...Add: {
    var %addScrambleWord = $$?="Enter word or phrase to add:", %addScrambleHint = $$?="Enter Hint for %addScrambleWord $+ :"
    write $scriptdirscramble.txt $addtok(%addScrambleWord,%addScrambleHint,126)
  }
  ...Edit:run notepad $scriptdirscramble.txt
  ..-
  ..Scores
  ...Clear Scores:unset %scrambleScore@* %scrambleLeader %scrambleHighScore
  ...Clear Leader:unset %scrambleLeader %scrambleHighScore
}
