#include <windows.h>
#include <stdio.h>

// Rivest's Cipher 4 toolkit for mIRC32
//
// Hurriedly made by Quension.  (C) 2000 by Quension too.
// For free, noncommercial use only, at your own risk.
//
// You can modify the source and distribute both source and any DLLs built
// by you (subject to export rules governing strong encryption), as long as
// you don't charge any money for it.  You must also make clear the fact
// that it has been modified.  Commercial use is strictly prohibited.

// Designed for the lcc-win32 compiler (http://www.cs.virginia.edu/~lcc-win32/).
// Written in ANSI C for little-endian platforms.


/* cool stuff */
typedef unsigned char u_char;

#define Min(a,b)	((a) < (b) ? (a) : (b))		// minimum of the two

struct halfbyte {
    unsigned f2:4;
    unsigned f1:4;
};
#define half(x)		((struct halfbyte *)(&(x)))	// field split (for hex conversion)

#define SplitIncoming(x,y,z)	if(strlen(data) < (x)) { *data = '\0'; return 3; } \
	ptr++; \
	while (*ptr && *ptr != '\001') \
		ptr++; \
	if (!*ptr) { *data = '\0'; return 3; } \
	*ptr++ = '\0'; \
	if((buflen = strlen(ptr)) < (y)) { *data = '\0'; return 3; } \
	if((keylen = strlen(data)) < (z)) { *data = '\0'; return 3; }

/* export prototypes */
int __declspec(dllexport) FAR PASCAL rc4_symmetric(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL rc4_enc_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL rc4_enc_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL rc4_dec_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL rc4_dec_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs1_enc_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs1_enc_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs1_dec_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs1_dec_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs2_enc_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs2_enc_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs2_dec_raw(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cs2_dec_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL get_rnd_hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cnv_raw2hex(HWND,HWND,char *,char *,BOOL,BOOL);
int __declspec(dllexport) FAR PASCAL cnv_hex2raw(HWND,HWND,char *,char *,BOOL,BOOL);

/* internal prototypes */
void init_state();
void mix_state(int);
void crypt(int);
void loop_256(u_char *, u_char *, int);
void gen_random(u_char *, int);
void hex_out(u_char *, u_char *, int);
void hex_in(u_char *, u_char *, int);
void swap(u_char *, u_char *);
int rand_range(int, int);

/* globals */
u_char key[256];
u_char state[256];
u_char scratch[256];
u_char cryptbuf[900];

u_char hex_table[16] = {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'};

/* ------------------------------------------------------------------------ */
/* The entry point.  Just says 'hi'. */
BOOL WINAPI __declspec(dllexport) LibMain(HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)
{
	if (fdwReason == DLL_PROCESS_ATTACH)
    	init_state();
	return TRUE;
}

/* ------------------------------------------------------------------------ */
// rc4_symmetric:  in(hexxed key, hexxed data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL rc4_symmetric(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the hexxed key, rest is hexxed data to crypt */
	SplitIncoming(5,2,2);

	keylen = Min(keylen,512);			// raw key length cannot exceed array space
	hex_in(data,scratch,keylen);		// decode the hexxed key
	loop_256(key,scratch,(keylen/2));	// make the key
    mix_state(0);						// mix the state array
	hex_in(ptr,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	hex_out(cryptbuf,data,buflen);		// send out in hex
	data[buflen*2] = '\0';				// string terminator
    
    return 3;
}

// rc4_enc_r2h:  in(raw key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL rc4_enc_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is raw data to encrypt */
	SplitIncoming(3,1,1);

	loop_256(key,data,keylen);		// make the key
    mix_state(0);					// mix the state array
	buflen = Min(buflen,449);		// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);	// load the crypt array
    crypt(buflen);					// crypt in place
    hex_out(cryptbuf,data,buflen);	// send out in hex
    data[buflen*2] = '\0';			// string terminator

    return 3;
}

// rc4_enc_h2h:  in(hexxed key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL rc4_enc_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the hexxed key, rest is raw data to encrypt */
	SplitIncoming(4,1,2);

	keylen = Min(keylen,512);			// raw key length cannot exceed array space
	hex_in(data,scratch,keylen);		// decode the hexxed key
	loop_256(key,scratch,(keylen/2));	// make the key
    mix_state(0);						// mix the state array
	buflen = Min(buflen,449);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);		// load the crypt array
    crypt(buflen);						// crypt in place
    hex_out(cryptbuf,data,buflen);		// send out in hex
    data[buflen*2] = '\0';				// string terminator
    
    return 3;
}

// rc4_dec_r2r:  in(raw key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL rc4_dec_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is hexxed data to decrypt */
	SplitIncoming(4,2,1);

	loop_256(key,data,keylen);		// make the key
    mix_state(0);					// mix the state array
	hex_in(ptr,cryptbuf,buflen);	// decode the hexxed data
	buflen /= 2;					// raw length now, not hexxed length
    crypt(buflen);					// crypt in place
	memcpy(data,cryptbuf,buflen);	// send out in raw
	data[buflen] = '\0';			// string terminator

    return 3;
}

// rc4_dec_h2r:  in(hexxed key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL rc4_dec_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the hexxed key, rest is hexxed data to decrypt */
	SplitIncoming(5,2,2);

	keylen = Min(keylen,512);			// raw key length cannot exceed array space
	hex_in(data,scratch,keylen);		// decode the hexxed key
	loop_256(key,scratch,(keylen/2));	// make the key
    mix_state(0);						// mix the state array
	hex_in(ptr,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	memcpy(data,cryptbuf,buflen);		// send out in raw
	data[buflen] = '\0';				// string terminator
    
    return 3;
}

// cs1_enc_r2h:  in(raw key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL cs1_enc_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;
	register int i;

	/* first \001-separated param is the raw key, rest is raw data to encrypt */
	SplitIncoming(3,1,1);

	keylen = Min(keylen,246);			// leave room for the initialization vector
    memcpy(scratch,data,keylen);		// copy key to scratchpad
	for (i=keylen; i < keylen+10; i++)	// append IV to key
    	scratch[i] = rand_range(0,255);
	loop_256(key,scratch,keylen+10);	// make the key (+IV)
    mix_state(0);						// mix the state array
	buflen = Min(buflen,439);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);		// load the crypt array
    crypt(buflen);						// crypt in place
	hex_out(&scratch[keylen],data,10);	// send out IV in hex
    hex_out(cryptbuf,data+20,buflen);	// append encrypted data in hex
    data[(buflen*2)+20] = '\0';			// string terminator

    return 3;
}

// cs1_enc_h2h:  in(hexxed key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL cs1_enc_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;
	register int i;

	/* first \001-separated param is the raw key, rest is raw data to encrypt */
	SplitIncoming(4,1,2);

	keylen = Min(keylen,492);			// leave room for the initialization vector
	hex_in(data,scratch,keylen);		// decode the hexxed key
	keylen /= 2;						// raw data length, not hexxed length
	for (i=keylen; i < keylen+10; i++)	// append IV to key
    	scratch[i] = rand_range(0,255);
	loop_256(key,scratch,keylen+10);	// make the key (+IV)
    mix_state(0);						// mix the state array
	buflen = Min(buflen,439);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);		// load the crypt array
    crypt(buflen);						// crypt in place
	hex_out(&scratch[keylen],data,10);	// send out IV in hex
    hex_out(cryptbuf,data+20,buflen);	// append encrypted data in hex
    data[(buflen*2)+20] = '\0';			// string terminator

    return 3;
}

// cs1_dec_r2r:  in(raw key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL cs1_dec_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is hexxed data to decrypt */
	SplitIncoming(24,22,1);

	keylen = Min(keylen,246);			// leave room for initialization vector
    memcpy(scratch,data,keylen);		// copy key to scratchpad
    hex_in(ptr,&scratch[keylen],20);	// append IV to key
	loop_256(key,scratch,keylen+10);	// make the key
    mix_state(0);						// mix the state array
	buflen -= 20;						// no more IV
	hex_in(ptr+20,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	memcpy(data,cryptbuf,buflen);		// send out in raw
	data[buflen] = '\0';				// string terminator

    return 3;
}

// cs1_dec_h2r:  in(hexxed key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL cs1_dec_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is hexxed data to decrypt */
	SplitIncoming(25,22,2);

	keylen = Min(keylen,492);			// leave room for the initialization vector
	hex_in(data,scratch,keylen);		// decode the hexxed key
	keylen /= 2;						// raw data length, not hexxed length
    hex_in(ptr,&scratch[keylen],20);	// append IV to key
	loop_256(key,scratch,keylen+10);	// make the key
    mix_state(0);						// mix the state array
	buflen -= 20;						// no more IV
	hex_in(ptr+20,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	memcpy(data,cryptbuf,buflen);		// send out in raw
	data[buflen] = '\0';				// string terminator

    return 3;
}

// cs2_enc_r2h:  in(raw key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL cs2_enc_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;
	register int i;

	/* first \001-separated param is the raw key, rest is raw data to encrypt */
	SplitIncoming(3,1,1);

	keylen = Min(keylen,246);			// leave room for the initialization vector
    memcpy(scratch,data,keylen);		// copy key to scratchpad
	for (i=keylen; i < keylen+10; i++)	// append IV to key
    	scratch[i] = rand_range(0,255);
	loop_256(key,scratch,keylen+10);	// make the key (+IV)
    mix_state(key[scratch[keylen]]);	// mix the state array
	buflen = Min(buflen,439);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);		// load the crypt array
    crypt(buflen);						// crypt in place
	hex_out(&scratch[keylen],data,10);	// send out IV in hex
    hex_out(cryptbuf,data+20,buflen);	// append encrypted data in hex
    data[(buflen*2)+20] = '\0';			// string terminator

    return 3;
}

// cs2_enc_h2h:  in(hexxed key, raw data)  out(hexxed data)
int __declspec(dllexport) FAR PASCAL cs2_enc_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;
	register int i;

	/* first \001-separated param is the raw key, rest is raw data to encrypt */
	SplitIncoming(4,1,2);

	keylen = Min(keylen,492);			// leave room for the initialization vector
	hex_in(data,scratch,keylen);		// decode the hexxed key
	keylen /= 2;						// raw data length, not hexxed length
	for (i=keylen; i < keylen+10; i++)	// append IV to key
    	scratch[i] = rand_range(0,255);
	loop_256(key,scratch,keylen+10);	// make the key (+IV)
    mix_state(key[scratch[keylen]]);	// mix the state array
	buflen = Min(buflen,439);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,ptr,buflen);		// load the crypt array
    crypt(buflen);						// crypt in place
	hex_out(&scratch[keylen],data,10);	// send out IV in hex
    hex_out(cryptbuf,data+20,buflen);	// append encrypted data in hex
    data[(buflen*2)+20] = '\0';			// string terminator

    return 3;
}

// cs2_dec_r2r:  in(raw key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL cs2_dec_raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is hexxed data to decrypt */
	SplitIncoming(24,22,1);

	keylen = Min(keylen,246);			// leave room for initialization vector
    memcpy(scratch,data,keylen);		// copy key to scratchpad
    hex_in(ptr,&scratch[keylen],20);	// append IV to key
	loop_256(key,scratch,keylen+10);	// make the key
    mix_state(key[scratch[keylen]]);	// mix the state array
	buflen -= 20;						// no more IV
	hex_in(ptr+20,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	memcpy(data,cryptbuf,buflen);		// send out in raw
	data[buflen] = '\0';				// string terminator

    return 3;
}

// cs2_dec_h2r:  in(hexxed key, hexxed data)  out(raw data)
int __declspec(dllexport) FAR PASCAL cs2_dec_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	int buflen = 0;
    int keylen = 0;
	char *ptr = data;

	/* first \001-separated param is the raw key, rest is hexxed data to decrypt */
	SplitIncoming(25,22,2);

	keylen = Min(keylen,492);			// leave room for the initialization vector
	hex_in(data,scratch,keylen);		// decode the hexxed key
	keylen /= 2;						// raw data length, not hexxed length
    hex_in(ptr,&scratch[keylen],20);	// append IV to key
	loop_256(key,scratch,keylen+10);	// make the key
    mix_state(key[scratch[keylen]]);	// mix the state array
	buflen -= 20;						// no more IV
	hex_in(ptr+20,cryptbuf,buflen);		// decode the hexxed data
	buflen /= 2;						// raw length now, not hexxed length
    crypt(buflen);						// crypt in place
	memcpy(data,cryptbuf,buflen);		// send out in raw
	data[buflen] = '\0';				// string terminator

    return 3;
}

int __declspec(dllexport) FAR PASCAL get_rnd_hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	register int i;
    int num;

	if ((num = atoi(data)) < 1) { *data = '\0'; return 3; }
    
	num = Min(num,449);						// hexxed data length cannot exceed mirc limits
    for (i = 0; i < num; i++)				// generate random bytes
    	cryptbuf[i] = rand_range(0,255);
	hex_out(cryptbuf,data,num);				// send out in hex
    data[num*2] = '\0';						// string terminator

	return 3;
}

int __declspec(dllexport) FAR PASCAL cnv_raw2hex(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
    int len;
    
    if (!(len = strlen(data))) { *data = '\0'; return 3; }
    
    len = Min(len,449);			// hexxed data length cannot exceed mirc limits
    memcpy(cryptbuf,data,len);	// copy to temp buffer
    hex_out(cryptbuf,data,len);	// send out in hex
    data[len*2] = '\0';			// string terminator
    
    return 3;
}

int __declspec(dllexport) FAR PASCAL cnv_hex2raw(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
    int len;
    
    if ((len = strlen(data)) < 2) { *data = '\0'; return 3; }
    
	hex_in(data,cryptbuf,len);	// decode into temp buffer
	len /= 2;					// 2:1 hex:byte ratio
    memcpy(data,cryptbuf,len);	// send out in raw
    data[len] = '\0';			// string terminator
    
    return 3;
}

/* ------------------------------------------------------------------------ */
/* initialize the state array (state[0] = 0, state[1] = 1 ...) */
void init_state()
{
	register int i;
	for (i = 0; i < 256; i++)
		state[i] = i;
}

/* mix the state array */
void mix_state(int c)
{
	register int i,j;
	while (c-- >= 0)	// loop used for CS-2
		for (i=0,j=0; i < 256; i++)		// standard RC4 mix
		{
			j = (j + state[i] + key[i]) % 256;
			swap(&state[i], &state[j]);
		}
}

/* crypt in place in the crypt array */
void crypt(int buflen)
{
	register int c,i,j,t;
	for (c=0,i=0,j=0; c < buflen; c++)	// standard RC4 crypt
	{
		i = (i + 1) % 256;
		j = (j + state[i]) % 256;
		swap(&state[i], &state[j]);
		t = (state[i] + state[j]) % 256;
		cryptbuf[c] = state[t] ^ cryptbuf[c];
	}
}

/* loop the data in 'from' into the 256-byte array 'to' */
void loop_256(u_char *to, u_char *from, int len)
{
    register int i,j;
    for (i=0,j=0; i < 256; i++)
    {
        to[i] = from[j++];
        if (j >= len)
        	j = 0;
    }
}

/* generate 'num' random bytes */
void gen_random(u_char *out, int num)
{
    register int i;
    for (i = 0; i < num; i++)
    	out[i] = rand_range(0,255);
}

/* translate raw data 'in' (size 'len') into hex 'out' (size 'len' * 2) */
void hex_out(u_char *in, u_char *out, int len)
{
    register int i,j;
    for (i=0,j=0; i < len; i++)
    {
        out[j++] = hex_table[half(in[i])->f1];
        out[j++] = hex_table[half(in[i])->f2];
    }
}

/* translate hex data 'in' (size 'len') into raw 'out' (size 'len' / 2) */
void hex_in(u_char *in, u_char *out, int len)
{
    register int i,j;
    for (i=0,j=0; i < len; j++)
    {
        switch (in[i++])
        {
            case '0': half(out[j])->f1 = 0; break;
            case '1': half(out[j])->f1 = 1; break;
            case '2': half(out[j])->f1 = 2; break;
            case '3': half(out[j])->f1 = 3; break;
            case '4': half(out[j])->f1 = 4; break;
            case '5': half(out[j])->f1 = 5; break;
            case '6': half(out[j])->f1 = 6; break;
            case '7': half(out[j])->f1 = 7; break;
            case '8': half(out[j])->f1 = 8; break;
            case '9': half(out[j])->f1 = 9; break;
            case 'a': case 'A': half(out[j])->f1 = 10; break;
            case 'b': case 'B': half(out[j])->f1 = 11; break;
            case 'c': case 'C': half(out[j])->f1 = 12; break;
            case 'd': case 'D': half(out[j])->f1 = 13; break;
            case 'e': case 'E': half(out[j])->f1 = 14; break;
            case 'f': case 'F': half(out[j])->f1 = 15; break;
        }
        switch (in[i++])
        {
            case '0': half(out[j])->f2 = 0; break;
            case '1': half(out[j])->f2 = 1; break;
            case '2': half(out[j])->f2 = 2; break;
            case '3': half(out[j])->f2 = 3; break;
            case '4': half(out[j])->f2 = 4; break;
            case '5': half(out[j])->f2 = 5; break;
            case '6': half(out[j])->f2 = 6; break;
            case '7': half(out[j])->f2 = 7; break;
            case '8': half(out[j])->f2 = 8; break;
            case '9': half(out[j])->f2 = 9; break;
            case 'a': case 'A': half(out[j])->f2 = 10; break;
            case 'b': case 'B': half(out[j])->f2 = 11; break;
            case 'c': case 'C': half(out[j])->f2 = 12; break;
            case 'd': case 'D': half(out[j])->f2 = 13; break;
            case 'e': case 'E': half(out[j])->f2 = 14; break;
            case 'f': case 'F': half(out[j])->f2 = 15; break;
        }
    }
}

/* swap the two bytes given */
void swap(u_char *c1, u_char *c2)
{
	register u_char c3;
     c3 = *c1;
	*c1 = *c2;
	*c2 =  c3;
}

/* return a random number in a given range */
int rand_range(int from, int to)
{
	return (from + (rand() % (to - from + 1)));
}


