;---------<  ProjectX mIRC Scripters Crew  >-----------
; Filename..: pxpaint.mrc [PxPaint]
; Release...: v1.00
; Author....: Urmac
; Bugreport.: urmac@projectx.mx.dk
; Date......: April 5, 1999
; URL.......: http://www.projectx.mx.dk/
; E-mail....: info@projectx.mx.dk
;--------------------------------------------------------------------------

;-------- -  -
; Aliases
;-------- -  -
alias pxpaint.action {
  if (%paint.select) {
    inc %paint.action
    if (%paint.select == Brush) {
      write -l $+ %paint.action pxpaint-a.txt //drawdot @PxPaint %paint.colour %paint.brush.size %mouse.x %mouse.y 
      write -l $+ %paint.action pxpaint-u.txt //drawdot @PxPaint %paint.background %paint.brush.size %mouse.x %mouse.y | unset %mouse.x %mouse.y | h
    }
    if (%paint.select == Line) { 
      write -l $+ %pxpaint.action pxpaint-a.txt //drawline @PxPaint %paint.colour %paint.line.size %paint.mousex %paint.mousey %mouse.x %mouse.y 
      write -l $+ %pxpaint.action pxpaint-u.txt //drawline @PxPaint %paint.background %paint.line.size %paint.mousex %paint.mousey %mouse.x %mouse.y | h
    }
    if (%paint.select == Text) { 
      if (%paint.text) {
        write -l $+ %paint.action pxpaint-a.txt //drawtext -prb @PxPaint %paint.colour %paint.background Arial 18 %mouse.x %mouse.y $calc($len(%paint.text) * 15) 19 %paint.text 
        write -l $+ %paint.action pxpaint-u.txt //drawtext -prb @PxPaint %paint.background %paint.background Arial 18 %mouse.x %mouse.y $calc($len(%paint.text) * 15) 19 %paint.text | unset %text %mouse.x %mouse.y | h
      }
    }
    if (%paint.select == Eraser) { 
      write -l $+ %paint.action pxpaint-a.txt //drawdot @PxPaint 0 %paint.eraser.size %mouse.x %mouse.y 
      write -l $+ %paint.action pxpaint-u.txt //drawdot @PxPaint %paint.background %paint.eraser.size %mouse.x %mouse.y | unset %mouse.x %mouse.y | h
    }
  }
}
alias pxpaint.undo {
  if (%paint.action) {
    if (%paint.action == 1) { %paint.do = $read -l1 pxpaint-u.txt | %paint.do | dec %paint.action | unset %paint.do | .remove pxpaint-a.txt | .remove pxpaint-u.txt | h }
    if (%paint.action <= 0) { %paint.action = 0 | .clear @pxpaint | h } | %paint.do = $read -l $+ %paint.action pxpaint-u.txt
    if (/drawfill isin %paint.do) { %paint.do | %paint.background = 0 }
    %paint.do | unset %paint.do | %paint.do = $read -l $+ $calc(%paint.action - 1) pxpaint-a.txt | %paint.do
    write -d pxpaint-a.txt | write -d pxpaint-u.txt | if (%paint.pic) { drawpic -t @pxpaint 0 1 1 %paint.pic } | dec %paint.action | pxpaint.do
  }
}
alias pxpaint.do {
  if ($exists(pxpaint-u.txt)) {
    unset %paint.do %paint.dotemp
    :loop { 
      inc %paint.dotemp
      if (%paint.dotemp > %paint.action) { unset %paint.do %paint.dotemp | h }
      %paint.do = $read -l $+ %paint.dotemp pxpaint-a.txt
      %paint.do | unset %paint.do | goto loop 
    }
  }
}
menu @'PxPaint {
  dclick:window -c @'PxPaint | h
}
menu @pxpaint.logo {
  dclick:window -c @pxpaint.logo | h
}
alias pxpaint.write {
  if (%pcx) { goto pcx } | elseif (%pcx == $null) { %pcx = 7 | goto pcx }
  :pcx | if (%pcx2) { goto pb } | elseif (%pcx2 == $null) { %pcx2 = 3 | goto pb }
  :pb | if (%paint.brush.size) { goto pl } | elseif (%paint.brush.size == $null) { %paint.brush.size = 3 | goto pl }
  :pl | if (%paint.line.size) { goto c } | elseif (%paint.line.size == $null) { %paint.line.size = 3 | goto c }
  :c | if (%paint.colour) { goto b } | elseif (%paint.colour == $null) { %paint.colour = 1 | goto b }
  :b | if (%paint.background) { goto e } | elseif (%paint.background == $null) { %paint.background = 0 | goto e }
  :e | if (%paint.eraser.size) { goto end } | elseif (%paint.eraser.size == $null) { %paint.eraser.size = 3 | goto end }
  :end | writeini projectx.ini PxPaint brush.size %paint.brush.size | writeini projectx.ini PxPaint line.size %paint.line.size 
  writeini projectx.ini PxPaint eraser.size %paint.eraser.size | writeini projectx.ini PxPaint background %paint.background
  writeini projectx.ini PxPaint colour %paint.colour | writeini projectx.ini PxPaint pcx %pcx | writeini projectx.ini PxPaint pcx2 %pcx2
}
alias pxpaint.load {
  if ($exists($mircdirprojectx.ini)) {
    %paint.brush.size = $readini projectx.ini pxpaint brush.size | if (%paint.brush.size == $null) { pxpaint.write | h }
    %paint.line.size = $readini projectx.ini pxpaint line.size | %paint.colour = $readini projectx.ini pxpaint colour
    %paint.background = $readini projectx.ini pxpaint background | %pcx = $readini projectx.ini pxpaint pcx
    %pcx2 = $readini projectx.ini pxpaint pcx2 | %paint.eraser.size = $readini projectx.ini pxpaint eraser.size
  }
  elseif ($exists($mircdirprojectx.ini) == $false) { write projectx.ini | pxpaint.write }
}
alias h halt
alias clearall if ($window(@pxpaint)) { if ($window(@paint.colour)) { clearall | .timer 1 0 /drawfill @pxpaint 0 0 0 0 | .timer 1 0 /pxpaint.x } | if ($window(@paint.colour) == $null) { clearall | .timer 1 0 /drawfill @pxpaint 0 0 0 0 } } | if ($window(@pxpaint)) { clearall }
alias pxpaint.dline drawline @paint.colour 1 1 0 0 0 200 | drawline @paint.colour 1 1 50 0 50 200 | drawline @paint.colour 1 1 25 0 25 200 | drawline @paint.colour 1 1 0 0 50 0 | drawline @paint.colour 1 1 0 24 50 24 | drawline @paint.colour 1 1 0 49 50 49 | drawline @paint.colour 1 1 0 74 50 74 | drawline @paint.colour 1 1 0 99 50 99 | drawline @paint.colour 1 1 0 124 50 124 | drawline @paint.colour 1 1 0 149 50 149 | drawline @paint.colour 1 1 0 174 50 174 | drawline @paint.colour 1 1 0 199 50 199
alias pxpaint.paint if ($window(@pxpaint)) { h } | else { window -apsfkl14 +tnse @PxPaint 60 78 480 300 | titlebar @PxPaint v1.00 by Urmac | unset %paint.* %pcx %pcx2 | pxpaint.load | pxpaint.x | font -b @pxpaint 11 Arial | aline -l10 @pxpaint Eraser | aline -l10 @pxpaint Draw Dot | aline -l10 @pxpaint Line Tool | aline -l10 @pxpaint Text Tool | aline -l10 @pxpaint Select Colour | aline -l10 @pxpaint ------------------------ | aline -l10 @pxpaint About ProjectX | aline -l10 @pxpaint About PxPaint | drawfill @PxPaint %paint.background %paint.background 0 0 }
menu @pxpaint {
  mouse:{
    if (%paint.temper) {
      %mouse.x = $mouse.x | %mouse.y = $mouse.y
      if (%paint.select == Eraser) { drawdot @PxPaint 0 %paint.eraser.size %mouse.x %mouse.y | pxpaint.action }
      if (%paint.select == Brush) { drawdot @PxPaint %paint.colour %paint.brush.size %mouse.x %mouse.y | pxpaint.action }
    }
  }
  sclick:{
    %mouse.x = $mouse.x | %mouse.y = $mouse.y
    if (%paint.select == Text) {
      %paint.text = $?="Enter Text" | if (* iswm %paint.text) {
        if (%paint.background == %paint.colour) {
          if (%paint.background == 1) { %paint.colour = 0 | .drawtext -cpb @PxPaint %paint.colour %paint.background Arial 18 %mouse.x %mouse.y $calc($len(%paint.text) * 15) 19 %paint.text | pxpaint.x | pxpaint.action }
          if (%paint.background != 1) { %paint.colour = 1 | .drawtext -cpb @PxPaint %paint.colour %paint.background Arial 18 %mouse.x %mouse.y $calc($len(%paint.text) * 15) 19 %paint.text | pxpaint.x | pxpaint.action } 
        }
        if (%paint.background != %paint.colour) { .drawtext -cpb @PxPaint %paint.colour %paint.background Arial 18 %mouse.x %mouse.y $calc($len(%paint.text) * 15) 19 %paint.text | pxpaint.action }
      }
    }
    if (%paint.select == Line) { if (%paint.background == %paint.colour) { %paint.colour = 1 | %paint.mousex = $mouse.x | %paint.mousey = $mouse.y } | if (%paint.background != %paint.colour) { %paint.mousex = $mouse.x | %paint.mousey = $mouse.y } }
    if (%paint.select == Eraser) { %paint.temper = dot | drawdot @PxPaint 0 %paint.eraser.size %mouse.x %mouse.y | pxpaint.action } 
    if (%paint.select == Brush) { 
      if (%paint.background == %paint.colour) {
        if (%paint.background == 1) { %paint.colour = 0 | %paint.temper = dot | drawdot @PxPaint %paint.colour %paint.brush.size %mouse.x %mouse.y | pxpaint.x | pxpaint.action }
        if (%paint.background != 1) { %paint.colour = 1 | %paint.temper = dot | drawdot @PxPaint %paint.colour %paint.brush.size %mouse.x %mouse.y | pxpaint.x | pxpaint.action }
      }
      if (%paint.background != %paint.colour) { %paint.temper = dot | drawdot @pxpaint %paint.colour %paint.brush.size %mouse.x %mouse.y | pxpaint.action }
    }
  }
  uclick:{
    %mouse.x = $mouse.x | %mouse.y = $mouse.y
    if (%paint.select == Line) { drawline @PxPaint %paint.colour %paint.line.size %paint.mousex %paint.mousey %mouse.x %mouse.y | pxpaint.action } 
    if (%paint.select == Eraser) { unset %paint.temper | h }
    if (%paint.select == Brush) { unset %paint.temper | h }
  }
  lbclick:{
    if ($1 == 1) { %paint.select = Eraser | h }
    if ($1 == 2) { %paint.select = Brush | h }
    if ($1 == 3) { %paint.select = Line | h }
    if ($1 == 4) { %paint.select = Text | h }
    if ($1 == 6) { unset %paint.select | h }
    if ($1 == 5) { %paint.select = colour | pxpaint.x }
    if ($1 == 7) { unset %paint.select | px.about }
    if ($1 == 8) { unset %paint.select | pxpaint.about } 
  }
}
alias pxpaint.colour.set drawrect @paint.colour $rgb(1) 5 1 25 23 23 | drawrect @paint.colour $rgb(2) 5 1 50 23 23 | drawrect @paint.colour $rgb(3) 5 1 75 23 23 | drawrect @paint.colour $rgb(4) 5 1 100 23 23 | drawrect @paint.colour $rgb(5) 5 1 125 23 23 | drawrect @paint.colour $rgb(6) 5 1 150 23 23 | drawrect @paint.colour $rgb(7) 5 1 175 23 23 | drawrect @paint.colour $rgb(8) 5 26 0 23 23 | drawrect @paint.colour $rgb(9) 5 26 25 23 23 | drawrect @paint.colour $rgb(10) 5 26 50 23 23 | drawrect @paint.colour $rgb(11) 5 26 75 23 23 | drawrect @paint.colour $rgb(12) 5 26 100 23 23 | drawrect @paint.colour $rgb(13) 5 26 125 23 23 | drawrect @paint.colour $rgb(14) 5 26 150 23 23 | drawrect @paint.colour $rgb(15) 5 26 175 23 23 | pxpaint.dline
alias pxpaint.x {
  if ($window(@paint.colour) == $null) { window -kp +tb @Paint.Colour 716 78 58 226 }
  drawtext -o @paint.colour 0 0 Arial %pcx %pcx2 X | clear @paint.colour | drawfill @paint.colour 0 0 0 0 | pxpaint.colour.set
  if (%paint.colour == 0) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 3 X | %pcx = 8 | %pcx2 = 3 | pxpaint.write }
  if (%paint.colour == 1) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 28 X | %pcx = 8 | %pcx2 = 28 | pxpaint.write }
  if (%paint.colour == 2) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 53 X | %pcx = 8 | %pcx2 = 53 | pxpaint.write }
  if (%paint.colour == 3) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 78 X | %pcx = 8 | %pcx2 = 78 | pxpaint.write }
  if (%paint.colour == 4) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 103 X | %pcx = 8 | %pcx2 = 103 | pxpaint.write }
  if (%paint.colour == 5) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 128 X | %pcx = 8 | %pcx2 = 128 | pxpaint.write }
  if (%paint.colour == 6) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 153 X | %pcx = 8 | %pcx2 = 153 | pxpaint.write }
  if (%paint.colour == 7) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 8 178 X | %pcx = 8 | %pcx2 = 178 | pxpaint.write }
  if (%paint.colour == 8) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 3 X | %pcx = 32 | %pcx2 = 3 | pxpaint.write }
  if (%paint.colour == 9) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 28 X | %pcx = 32 | %pcx2 = 28 | pxpaint.write }
  if (%paint.colour == 10) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 53 X | %pcx = 32 | %pcx2 = 53 | pxpaint.write }
  if (%paint.colour == 11) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 78 X | %pcx = 32 | %pcx2 = 78 | pxpaint.write }
  if (%paint.colour == 12) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 103 X | %pcx = 32 | %pcx2 = 103 | pxpaint.write }
  if (%paint.colour == 13) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 128 X | %pcx = 32 | %pcx2 = 128 | pxpaint.write }
  if (%paint.colour == 14) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 153 X | %pcx = 32 | %pcx2 = 153 | pxpaint.write }
  if (%paint.colour == 15) { drawtext -or @paint.colour $rgb(1) $rgb(0) Arial 32 178 X | %pcx = 32 | %pcx2 = 178 | pxpaint.write }
}
menu @paint.colour {
  sclick:{
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 0) && ($mouse.y <= 23) { %paint.colour = 0 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 25) && ($mouse.y <= 48) { %paint.colour = 1 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 50) && ($mouse.y <= 73) { %paint.colour = 2 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 75) && ($mouse.y <= 98) { %paint.colour = 3 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 100) && ($mouse.y <= 124) { %paint.colour = 4 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 125) && ($mouse.y <= 148) { %paint.colour = 5 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 150) && ($mouse.y <= 173) { %paint.colour = 6 | pxpaint.x }
    if ($mouse.x >= 0) && ($mouse.x <= 23) && ($mouse.y >= 175) && ($mouse.y <= 198) { %paint.colour = 7 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 0) && ($mouse.y <= 23) { %paint.colour = 8 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 25) && ($mouse.y <= 48) { %paint.colour = 9 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 50) && ($mouse.y <= 73) { %paint.colour = 10 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 75) && ($mouse.y <= 98) { %paint.colour = 11 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 100) && ($mouse.y <= 124) { %paint.colour = 12 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 125) && ($mouse.y <= 148) { %paint.colour = 13 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 150) && ($mouse.y <= 173) { %paint.colour = 14 | pxpaint.x }
    if ($mouse.x >= 25) && ($mouse.x <= 48) && ($mouse.y >= 175) && ($mouse.y <= 198) { %paint.colour = 15 | pxpaint.x }
  }
}
;-------- -  -
; Popups
;-------- -  -
menu menubar,channel {
  ProjectX Paint v1.00
  .&PxPaint:pxpaint.paint
  .&Visit Help Page:px.www http://www.projectx.mx.dk/scripts/help/paint.shtml
  .-
  .&About ProjectX:px.about | px.www http://www.projectx.mx.dk/px.html
}
menu @PxPaint {
  &New:%paint.background = 0 | if (%paint.select) { writeini projectx.ini PxPaint Select %paint.select } | pxpaint.write | unset %paint.* %mouse.* %pc* | .remove pxpaint-a.txt | .remove pxpaint-u.txt | %paint.select = $readini projectx.ini PxPaint Select | remini projectx.ini PxPaint Select | .clear @pxpaint | drawfill @pxpaint 0 0 0 0 | pxpaint.load | if ($window(@paint.colour)) { pxpaint.x }
  &Paint Bucket:{
    .clear @PxPaint | drawfill @PxPaint %paint.colour %paint.colour 0 0 
    %paint.background = %paint.colour | inc %paint.action
    write -l $+ %paint.action pxpaint-a.txt //drawfill @PxPaint %paint.colour %paint.colour 0 0
    write -l $+ %paint.action pxpaint-u.txt //drawfill @PxPaint 0 0 0 0 | unset %mouse.x %mouse.y | pxpaint.write
  }
  -
  &Save:{
    %paint.filesave = $?="Enter a filename"
    if (%paint.filesave) { goto next } | else { h }
    :next | %paint.dir = $sdir="Select a Directory"
    if (%paint.dir) {
      if ($chr(32) isin %paint.dir) { %paint.dir = $shortfn(%paint.dir) }
      if ($chr(32) isin %paint.filesave) { %paint.filesave = $replace(%paint.filesave,$chr(32),_) }
      if ($right(%paint.filesave,4) == .bmp) { %paint.filesave = $remove(%paint.filesave,.bmp) }
      drawsave @pxpaint %paint.dir $+ %paint.filesave $+ .bmp | unset %paint.filesave %paint.dir
    }
  }
  &Load:{ %paint.pic = $dir="Select a .bmp file" *.bmp | if (%paint.pic) { drawpic -t @pxpaint 0 1 1 $shortfn(%paint.pic) | pxpaint.do | unset %paint.pic } }
  -
  &Undo:pxpaint.undo
  -
  &Line Size
  .Current Size $+ $chr(58) %paint.line.size:h
  .-
  .Size 1:%paint.line.size = 1 | pxpaint.write 
  .Size 2:%paint.line.size = 2 | pxpaint.write 
  .Size 3:%paint.line.size = 3 | pxpaint.write 
  .Size 4:%paint.line.size = 4 | pxpaint.write 
  .Size 5:%paint.line.size = 5 | pxpaint.write 
  .-
  .Custom:%paint.temp = %paint.line.size | %paint.line.size = $?="Enter Custom Size" | if ($! != $null) { pxpaint.write } | if ($! == $null) { %paint.line.size = %paint.temp | unset %paint.temp | h }
  &Brush Size
  .Current Size $+ $chr(58) %paint.brush.size:h
  .-
  .Size 1:%paint.brush.size = 1 | pxpaint.write 
  .Size 2:%paint.brush.size = 2 | pxpaint.write 
  .Size 3:%paint.brush.size = 3 | pxpaint.write 
  .Size 4:%paint.brush.size = 4 | pxpaint.write 
  .Size 5:%paint.brush.size = 5 | pxpaint.write 
  .-
  .Custom:%paint.temp = %paint.brush.size | %paint.brush.size = $?="Enter Custom Size" | if ($! != $null) { pxpaint.write } | if ($! == $null) { %paint.brush.size = %paint.temp | unset %paint.temp | h }
  &Eraser Size
  .Current Size $+ $chr(58) %paint.eraser.size:h
  .-
  .Size 1:%paint.eraser.size = 1 | pxpaint.write
  .Size 2:%paint.eraser.size = 2 | pxpaint.write 
  .Size 3:%paint.eraser.size = 3 | pxpaint.write
  .Size 4:%paint.eraser.size = 4 | pxpaint.write 
  .Size 5:%paint.eraser.size = 5 | pxpaint.write 
  .-
  .Custom:%paint.temp = %paint.eraser.size | %paint.eraser.size = $?="Enter Custom Size" | if ($! != $null) { pxpaint.write } | if ($! == $null) { %paint.eraser.size = %paint.temp | unset %paint.temp | h }
  -
  &Close:window -c @PxPaint | pxpaint.write | if ($window(@paint.colour)) { window -c @paint.colour } | unset %mouse.* %paint.* %pc* %text | .remove pxpaint-a.txt | .remove pxpaint-u.txt
}
;-------- -  -
;Dialogs
;-------- -  -
alias pxpaint.about if ($exists(pxpaintv100.bmp)) { dialog -m pxpaint pxpaint } | else { dialog -m pxpaint2 pxpaint2 }
dialog pxpaint {
  title "About PxPaint v1.00"
  size -1 -1 220 120
  text "Author: Urmac", 1, 10 10 70 14,center
  text "Bugreport: ", 2, 10 24 50 25,center
  text "urmac@projectx.mx.dk", 3, 62 24 107 18,center
  button "Close", 4, 175 7 37 17,ok
  box "Still to Come...", 5, 4 50 118 62
  text "Solid && Hollow Squares", 8, -2 93 130 15,center
  text "Solid && Hollow Circles", 7, -6 78 130 15,center
  text "Games vs Computer", 6, 6 63 100 15,center
  button "Visit Help Page", 9, 132 95 81 20,default
  icon 10, 130 10 84 99, pxpaintv100.bmp,index
}
on *:dialog:PxPaint:sclick:*:{ if ($did == 9) { px.www http://www.projectx.mx.dk/scripts/help/paint.shtml } | if ($did == 10) { window -pk +et @pxpaint.logo 211 304 370 173 | titlebar @PxPaint.Logo - (double click to close) - | drawpic -t @pxpaint.logo 0 0 0 pxpaintv100.bmp } }
dialog pxpaint2 {
  title "About PxPaint v1.00"
  size -1 -1 220 120
  text "Author: Urmac", 1, 10 10 70 14,center
  text "Bugreport: ", 2, 10 24 50 25,center
  text "urmac@projectx.mx.dk", 3, 62 24 107 18,center
  button "Close", 4, 175 7 37 17,ok
  box "Still to Come...", 5, 4 50 118 62
  text "Solid && Hollow Squares", 8, -2 93 130 15,center
  text "Solid && Hollow Circles", 7, -6 78 130 15,center
  text "Games vs Computer", 6, 6 63 100 15,center
  button "Visit Help Page", 9, 132 95 81 20,default
}
on *:dialog:PxPaint2:sclick:*:{ if ($did == 9) { px.www http://www.projectx.mx.dk/scripts/help/paint.shtml } }

;-------- -  -
; Remote
;-------- -  -
on *:load:if ($version < 5.5) { echo $colour(info) -a $px.lp PxPaint v1.00 requires mIRC 5.5 or higher. Visit http://www.mirc.co.uk/ for the latest version of mIRC. | unload -rs $script | halt } | echo $colour(info) -ae $px.lp PxPaint v1.00 loaded. (by Urmac <urmac@projectx.mx.dk>) | px.about | .events on | pxpaint.load
on *:start:if ($version < 5.5) { echo $colour(info) -a $px.lp PxPaint v1.00 requires mIRC 5.5 or higher. Visit http://www.mirc.co.uk/ for the latest version of mIRC. | unload -rs $script | halt } | .events on | .remove pxpaint-a.txt | .remove pxpaint-u.txt | pxpaint.load
on *:close:@pxpaint:pxpaint.write | unset %text %mouse.* %paint.* %pc* | .remove pxpaint-a.txt | .remove pxpaint-u.txt | if ($window(@paint.colour)) { window -c @paint.colour }
on *:connect:.events on | %px.using = %px.using [px paint 1.00]
on *:disconnect:unset %px.using

;-------- -  -
; ProjectX
;-------- -  -
alias px.about {
  window -ao +bfs @ProjectX $px.centerwin(370 220) 370 220 @ProjectX fixedsys
  px.aline ...........................................
  px.aline ...............................__..._.._...
  px.aline .....___..____.__.._.___..___././_.\.\/./..
  px.aline ..../._.\.__/._.`/./.-_)/.__/.._/..)..(...
  px.aline .../.!__/_/..\___/./\___/\__/\__/../_/\_\..
  px.aline ../_/.--------./__/.---------------------..
  px.aline ............mIRC.Scripting.Crew............
  px.aline ...........................................
  px.aline ......The.Official.ProjectX.Homepage:......
  px.aline ........http://www!projectx!mx!dk/.........
  px.aline .......E-mail:.info@projectx!mx!dk.........
  px.aline ...........................................
  titlebar @ProjectX (double click window to close)
}
alias -l px.aline aline @ProjectX $replace($1-,., ,!,.)
alias -l px.centerwin return $int($calc(( [ $window(-3).w ] - $1) / 2)) $int($calc(( [ $window(-3).h ] - $2) / 2))
alias -l px.get return $readini [ $shortfn($mircdir) ] $+ projectx.ini $$1 $$2
alias -l px.lp return ***
alias -l px.set if ($3) { writeini [ $shortfn($mircdir) ] $+ projectx.ini $1 $2 $3- } | else { remini [ $shortfn($mircdir) ] $+ projectx.ini $$1 $2 }
alias -l px.using return ProjectX %px.using [http://www.projectx.mx.dk/]
alias -l px.www {
  %px.browser = $px.get(projectx,browser) | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = [ $readini $mircdirmirc.ini files browser ]  | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile( [ $left( [ $mircdir ] ,3) ] ,netscape.exe,1)  | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile(c:\,netscape.exe,1) | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile(d:\,netscape.exe,1) | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile( [ $left( [ $mircdir ] ,3) ] ,iexplore.exe,1) | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile(c:\,iexplore.exe,1) | if ($exists( [ %px.browser ] )) { goto end }
  %px.browser = $findfile(d:\,iexplore.exe,1) | if ($exists( [ %px.browser ] )) { goto end }
  unset %px.browser | return | :end | px.set ProjectX Browser %px.browser | run %px.browser $1 | unset %px.browser
}
alias quit if ($1) { quit $1- } | else { quit ProjectX)(http://www.projectx.mx.dk/ }
menu @ProjectX {
  dclick:window -c @ProjectX
  ProjectX Website: px.www http://www.projectx.mx.dk/px.html 
}
ctcp *:*:{
  if (($fulladdress !isin %projectx.version) && ($1 isin version ver script addon add-on)) {
    .ctcpreply $nick $upper($1) $px.using
    set %projectx.version %projectx.version $fulladdress
    .timerPXVer 1 3 set %projectx.version $remove(%projectx.version,$fulladdress)
  }
}
