;---------<  ProjectX mIRC Scripters Crew  >-----------
; Filename..: pxstats2.mrc [ProjectX Channel Statistics]
; Release...: v2.00
; Author....: Zmodem
; Bugreport.: zmodem@projectx.mx.dk
; Date......: September 5, 2000
; URL.......: http://www.projectx.mx.dk/
; E-mail....: info@projectx.mx.dk
; Extra.....: Channel statistics addon that allows you to find information on a channel (Ops/Voice/Regular, etc...)
;------------------------------------------------------


;-------- -  -
; Aliases
;-------- -  -

alias -l pxstats_check_type if ($opent == null) || ($opent !isnum) || ($opent < 0) || ($opent > 1) { .disable #pxstats_Open_Desktop 0 }
alias -l zecho echo -a  $+ $colour(info) $+ *** $1-
alias -l snagchan if ($dialog(pxstats)) { return $gettok($did(pxstats,2),3,32) }
alias -l qtime .timerQTIME $+ $1 off | .timerQTIME $+ $1 1 0 $1-
alias -l getpercent return $round($calc($1 / $2 * 100),$iif($3,$3,0)) $+ %
alias -l about {
  if ($dialog(pxstats_a) == $null) {
    dialog - $+ $iif($opent == 1,md,m) pxstats_a pxstats_a | return
  }
}
alias -l status {
  if ($dialog(pxstats_m) == $null) { 
    dialog - $+ $iif($opent == 1,md,m) pxstats_m pxstats_m | return
  }
}
alias -l pxsc {
  if ($dialog(pxstats_m) == $null) { return }
  did -ra pxstats_m 1 $1-
}
alias -l check_folder if ($exists($scriptdirstats) == $false) { .mkdir $scriptdirstats }
alias -l writetext {
  check_folder
  write $scriptdirstats\ $+ $1 $+ .txt $2-
}
alias -l writehtml {
  check_folder
  write $scriptdirstats\ $+ $1 $+ .html $2-
}
alias -l usertype {
  if ($did(pxstats_save,14).state == 1) { return file }
  return msg
}
alias -l readmefile {
  if ($exists($scriptdirpxstats2readme.txt)) { run $scriptdirpxstats2readme.txt | return }
  zecho Error locating Readme file! Re-download this file if you have misplaced or lost this file
}
alias -l pxstats_load_addon {
  if ($exists($scriptdirstats) == $false) { .mkdir $scriptdirStats }
  .disable #pxstats_Open_Desktop 0
  .disable #pxstats_SaveAs
  .enable #pxstats_SaveNone
}
alias -l pxstats_selchan {
  if ($dialog(pxstats_selchan) == $null) {
    dialog - $+ $iif($opent == 1,md,m) pxstats_selchan pxstats_selchan | return
  }
}
alias -l pxstats_save {
  if ($dialog(pxstats_save) == $null) {
    dialog - $+ $iif($opent == 1,md,m) pxstats_save pxstats_save | return
  }
}
alias -l closeall {
  $iif($dialog(pxstats),dialog -x pxstats)
  $iif($dialog(pxstats_selchan),dialog -x pxstats_selchan)
  $iif($dialog(pxstats_save),dialog -x pxstats_save)
  $iif($dialog(pxstats_a),dialog -x pxstats_a)
  $iif($dialog(pxstats_m),dialog -x pxstats_m)
}
alias -l pxisopen {
  if ($dialog(pxstats) == $null) {
    $iif($dialog(pxstats_selchan),dialog -x pxstats_selchan)
    $iif($dialog(pxstats_save),dialog -x pxstats_save)
    $iif($dialog(pxstats_m),dialog -x pxstats_m)
    .timerPXSTATS2 off
  }
}
alias -l saveas {
  if ($group(#pxstats_SaveAs) == on) { return text }
  if ($group(#pxstats_SaveNone) == on) { return none }
  if ($group(#pxstats_SaveAs) == off) && ($group(#pxstats_SaveNone) == off) { return html }
}
alias -l opent {
  if ($group(#pxstats_Open_Desktop) == on) { return 1 }
  if ($group(#pxstats_Open_Desktop) == off) { return 0 }
  if ($group(#pxstats_Open_Desktop) == $null) { return null }
  ;This was a safe value that's evaluated due to my previous version. Never you mind it ;-)
}
alias -l runstat {
  var %tmp.calc = $calc($len($gettok($did(pxstats,2),2,58)) - 1), %tmp.chanc = $right($gettok($did(pxstats,2),2,58),%tmp.calc), %tmp.txt = %tmp.chanc $+ .txt, %tmp.html = %tmp.chanc $+ .html, %tmp.txtfile = $scriptdirstats\ $+ %tmp.txt, %tmp.htmlfile = $scriptdirstats\ $+ %tmp.html
  if ($exists(%tmp.txtfile) == $false) && ($exists(%tmp.htmlfile) == $false) { zecho The stat file for this channel: %tmp.chanc is not found! Please try re-scanning this channel again! | return }
  if ($exists(%tmp.txtfile)) { run %tmp.txtfile | return }
  px.www %tmp.htmlfile
}
alias -l makestat {
  var %tmp.calc = $calc($len($gettok($did(pxstats,2),2,58)) - 1), %tmp.chanc = $right($gettok($did(pxstats,2),2,58),%tmp.calc)
  if ($me !ison %tmp.chanc) { zecho You are no longer on this channel: %tmp.chanc $+ ! Please rejoin this channel to create this file! | return }
  pxstats %tmp.chanc
  $iif($1,return)
  status
}
alias -l build_dcc {
  did -r pxstats_save 18
  var %tmp.max = $calc($ini($mircini,dccnicks,0) - 1), %tmp.inc = 1, %tmp.nick
  if (%tmp.max == 0) { return }
  did -a pxstats_save 18 $readini $mircini dccnicks n0
  while (%tmp.inc <= %tmp.max) {
    %tmp.nick = $readini $mircini dccnicks n [ $+ [ %tmp.inc ] ]
    did -a pxstats_save 18 %tmp.nick
    inc %tmp.inc
    %tmp.nick = $null
  }
  did -c pxstats_save 18 1
}
alias -l remallstats {
  check_folder
  if ($?!="Are you sure you want to completely remove all stats from the $scriptdirstats $+ ?") {
    var %tmp.max = $findfile($scriptdirstats\,*.*,0)
    if (%tmp.max == 0) { zecho No stats files found! | return }
    while (%tmp.max > 0) {
      .remove $findfile($scriptdirstats\,*.*,%tmp.max)
      dec %tmp.max
    }
    zecho All files in Stats folder have been removed!
    did -b pxstats_save 6
  }
}
alias -l save_chans {
  var %tmp.allchans = $chan(0), %tmp.incchans = 1, %tmp.incnicks, %tmp.maxnicks, %tmp.checkclones
  if (%tmp.allchans == $null) || (%tmp.allchans == 0) { return }
  did -r pxstats_save 9
  while (%tmp.incchans <= %tmp.allchans) {
    did -a pxstats_save 9 $chan(%tmp.incchans)
    inc %tmp.incchans
  }
  did -c pxstats_save 9 1
}
alias -l refresh_selchan_list {
  if ($server == $null) {
    zecho Not connected to server!
    $iif($dialog(pxstats_selchan),dialog -x pxstats_selchan)
    $iif($dialog(pxstats),dialog -x pxstats)
  }
  did -r pxstats_selchan 3
  var %tmp.max = $chan(0), %tmp.while = 1
  While (%tmp.max >= %tmp.while) {
    did -a pxstats_selchan 3 $chan(%tmp.while)
    inc %tmp.while
  }
}
alias -l output_newchan {
  var %tmp.chan = $did(pxstats_selchan,3,$did(pxstats_selchan,3).sel)), %tmp.lines = $did(pxstats_selchan,3).sel
  if ($server == $null) { 
    zecho Not connected to server!
    $iif($dialog(pxstats),dialog -x pxstats)
    dialog -x pxstats_selchan
    return
  }
  if (%tmp.chan == $null) { zecho No selection is made yet! | return }
  if ($me !ison %tmp.chan) {
    zecho You are no longer on this channel! Cannot scan it!
    refresh_selchan_list
    return
  }
  if (%tmp.lines) {
    if ($dialog(pxstats_save)) { did -ra pxstats_save 7 Outputting Statistics: %tmp.chan } 
    pxstats %tmp.chan 
    dialog -x pxstats_selchan
  }
}
alias -l pxstats {
  if ($server == $null) { zecho Not connected to a server! | return }
  if ($group(#pxstats2).status == on) { zecho Cannot comply with current statistical request. I am still awaiting your previous request! | return }
  if ($dialog(pxstats)) { goto timers }
  pxstats_check_type
  dialog - $+ $iif($opent == 1,md,m) pxstats pxstats
  :timers
  .timerPXSTATS2 off
  .timerPXSTATS2 0 0 pxisopen
  did -ra pxstats 2 Generating Database...This may take a while
  :resume
  %^_pxstats.tmp.Here = 0
  %^_pxstats.tmp.Away = 0
  %^_pxstats.tmp.IrcOps = 0
  .enable #pxstats2
  who $1
}
alias -l uselist {
  if ($dialog(pxstats) == $null) { zecho Main window must be open to gather stats! Try running another scan to correct this error! | return }
  var %tmp.total = $did(pxstats,4), %tmp.ops = $did(pxstats,7) : $did(pxstats,34), %tmp.voice = $did(pxstats,9) : $did(pxstats,35), %tmp.regular = $did(pxstats,11) : $did(pxstats,36), %tmp.Here = $did(pxstats,13) : $did(pxstats,37), %tmp.Away = $did(pxstats,15) : $did(pxstats,38), %tmp.IrcOps = $did(pxstats,17) : $did(pxstats,39), %tmp.Helpers = $did(pxstats,19) : $did(pxstats,40), %tmp.Chan = $did(pxstats_save,9)
  if ($1 == sendchan) {
    if ($me !ison %tmp.Chan) { zecho You are no longer on this channel: %tmp.Chan | save_chans | return }
    msg %tmp.Chan Channel Statistics For: %tmp.Chan -=[ $chr(160) Total Users: %tmp.Total $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Ops: %tmp.Ops $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Voice: %tmp.Voice $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Regulars: %tmp.Regular $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Here: %tmp.Here $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Away: %tmp.Away $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) IrcOps: %tmp.IrcOps $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Helpers: %tmp.Helpers $chr(160)  ]=-
    return
  }
  var %tmp.nick = $did(pxstats_save,18), %tmp.txt = %tmp.Chan $+ .txt, %tmp.html = %tmp.Chan $+ .html, %tmp.findtxt = $findfile($scriptdirstats\,%tmp.txt,1), %tmp.findhtml = $findfile($scriptdirstats\,%tmp.html,1)
  if (%tmp.nick == $null) { zecho Invalid User Selection! | return }
  if ($1 == file) {
    if ($exists(%tmp.findtxt) == $false) && ($exists(%tmp.findhtml) == $false) { zecho Stats file not created yet! Try clicking the 'Make Stats File' button before attempting this command. | return }
    if ($exists(%tmp.findtxt)) { dcc send %tmp.nick %tmp.findtxt | return }
    .dcc send %tmp.nick %tmp.findhtml
  }
  if ($1 == msg) {
    %tmp.Nick = $did(pxstats_save,12)
    if (%tmp.nick == $null) { zecho Invalid User Input! | return }
    .msg %tmp.Nick Channel Statistics For: %tmp.Chan -=[ $chr(160) Total Users: %tmp.Total $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Ops: %tmp.Ops $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Voice: %tmp.Voice $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Regulars: %tmp.Regular $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Here: %tmp.Here $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Away: %tmp.Away $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) IrcOps: %tmp.IrcOps $chr(160) $+ $chr(93) $+ $chr(160) $+ $chr(91) $+ $chr(160) Helpers: %tmp.Helpers $chr(160)  ]=-
  }
}

;-------- -  -
; Dialogs
;-------- -  -

dialog pxstats {
  option dbu
  size -1 -1 120 136
  title "ProjectX Channel Statistics v2.00"
  button "&OK", 1, 91 113 26 10, ok
  box "", 2, 3 3 114 106
  text "Total Users:", 3, 15 14 29 10
  edit "", 4, 55 12 35 10, center, multi, return, read
  box "", 5, 15 22 90 4
  text "Operators:", 6, 15 31 24 10
  edit "", 7, 55 29 17 10, center, multi, return, read
  edit "", 34, 71 29 19 10, center, multi, return, read
  text "Voiced:", 8, 15 42 20 10
  edit "", 9, 55 40 17 10, center, multi, return, read
  edit "", 35, 71 40 19 10, center, multi, return, read
  text "Regulars:", 10, 15 53 22 10
  edit "", 11, 55 51 17 10, center, multi, return, read
  edit "", 36, 71 51 19 10, center, multi, return, read
  text "Here:", 12, 15 64 22 10
  edit "", 13, 55 62 17 10, center, multi, return, read
  edit "", 37, 71 62 19 10, center, multi, return, read
  text "Away:", 14, 15 75 22 10
  edit "", 15, 55 73 17 10, center, multi, return, read
  edit "", 38, 71 73 19 10, center, multi, return, read
  text "IrcOps:", 16, 15 86 22 10
  edit "", 17, 55 84 17 10, center, multi, return, read
  edit "", 39, 71 84 19 10, center, multi, return, read
  text "Helpers:", 18, 15 97 22 10
  edit "", 19, 55 95 17 10, center, multi, return, read
  edit "", 40, 71 95 19 10, center, multi, return, read
  menu "&File", 21
  item "&New Scan...", 22
  item break, 23
  item "E&xit", 24, cancel
  menu "&Output", 25
  item "Saving Statistics...", 26
  menu "Dialog &Windows", 27
  item "Conform To Desktop", 28
  menu "&Help", 29
  item "&About...", 30
  item break, 31
  item "&Readme File...", 32
  button "Refres&h", 33, 61 113 25 10
}
dialog pxstats_selchan {
  option dbu
  size -1 -1 126 98
  title "Choose Channel..."
  button "&Close", 1, 97 84 25 10, ok
  box "Select Channel To Scan For Statistics...", 2, 4 2 118 77
  list 3, 7 11 112 70, vsbar, sort
  button "&Scan Now", 4, 4 84 35 10
  button "&Refresh", 5, 41 84 28 10
}
dialog pxstats_save {
  option dbu
  size -1 -1 175 143
  title "Statistical Reports..."
  button "C&lose", 1, 146 128 25 11, ok
  box "Saving", 2, 4 3 167 58
  radio "Save As A &Text File", 3, 9 13 56 10, group
  radio "Save As An &HTML File", 4, 9 27 64 10
  radio "&Don't Save At All", 5, 9 40 49 10
  button "&Show Stat File", 6, 88 13 50 10
  box "Outputting Statistics: ", 7, 4 63 167 60
  text "Output Statistics To A &Channel", 8, 9 76 73 10
  combo 9, 88 74 50 50, droplist
  button "&Send", 10, 142 74 24 11
  text "Send Stats To Another &User", 11, 9 94 71 10
  edit "", 12, 87 92 51 11, multi return autohs
  button "Se&nd", 13, 142 92 24 11
  radio "Send &File", 14, 9 106 32 11, group
  radio "Display Ms&g'd", 15, 46 106 42 11
  button "&Make Stats File", 16, 88 27 50 10
  button "Remove All &Files", 17, 88 41 50 10
  combo 18, 88 92 50 85, droplist edit
}
dialog pxstats_a {
  option dbu
  size -1 -1 122 75
  title "About ProjectX Channel Stats"
  button "&Close", 1, 93 62 25 10, ok
  edit "ProjectX Channel Statistics", 2, 4 2 115 18, multi, return, read, center
  text "ProjectX Channel Statistics was created by: Zmodem. All information can be viewed 'via' the Readme file. If you have any questions, e-mail the Author: zmodem@projectx.mx.dk", 3, 4 23 115 38, center
  text "E-mail", 4, 4 64 15 10
  link "Zmodem", 5, 21 64 43 12
}
dialog pxstats_m {
  option dbu
  size -1 -1 82 25
  title "Compiling Stats..."
  text "", 1, 1 3 80 10, center
  button "&Close", 2, 50 13 25 10, ok
}

;-------- -  -
; Menus
;-------- -  -

menu Channel {
  ProjectX Channel Statistics
  .# Statistics:pxstats #
  .-
  .About:about
  .View ReadMe:readmefile  
  .-
  .Unload:if ($?!="Are you positive that you want to Unload: ProjectX Channel Statistics v2.00?") { zecho Removed: ProjectX Channel Statistics v2.00 Successfully! Find versions of this and other ProjectX addons at: http://www.projectx.mx.dk | closeall | px.set $script | unset %^_pxstat* | $px.unreg(ChanStats) | .unload -rs $script }
  .-
  .ProjectX &Website:px.about | px.www http://www.projectx.mx.dk/px.html
}

;-------- -  -
; Dialog Events
;-------- -  -

;;Dialog: Main Stat Scanner
on *:dialog:pxstats:init:0: {
  pxstats_check_type
  $iif($opent == 1,did -c pxstats 28)
}
on *:dialog:pxstats:menu:22: {
  if ($server == $null) { zecho Not connected to a server! | dialog -x $dname | return }
  pxstats_selchan
}
on *:dialog:pxstats:menu:26: {
  if ($server == $null) { zecho Not connected to a server! | dialog -x $dname | return }
  if ($snagchan == may) { zecho Still building database...Please wait until database is completely finished! | return }
  pxstats_save
}

;FIXIT
on *:DIALOG:pxstats:menu:28: {
  if ($opent == 0) { .enable #pxstats_Open_Desktop | did -c $dname $did | return }
  .disable #pxstats_Open_Desktop
  did -u $dname $did
}
on *:DIALOG:pxstats:menu:30:about
on *:DIALOG:pxstats:sclick:31:makestat
on *:DIALOG:pxstats:menu:32:readmefile
on *:DIALOG:pxstats:sclick:33:makestat Refreshing

;;Dialog: Select Channel
on *:DIALOG:pxstats_selchan:init:0:refresh_selchan_list
on *:DIALOG:pxstats_selchan:dclick:3:output_newchan
on *:DIALOG:pxstats_selchan:sclick:4:output_newchan
on *:DIALOG:pxstats_selchan:sclick:5:refresh_selchan_list

;;Dialog: Saving Statisitics
on *:DIALOG:pxstats_save:init:0: {
  save_chans
  did -ra $dname 7 Outputting Statistics: $snagchan
  did -h $dname 12
  did -c $dname 9 1
  did -c $dname 14
  build_dcc
  if ($saveas == text) { did -c $dname 3 | goto end }
  if ($saveas == html) { did -c $dname 4 | goto end }
  did -c $dname 5
  did -b $dname 6,16
  return
  :end
  var %tmp.calc = $calc($len($gettok($did(pxstats,2),2,58)) - 1), %tmp.chanc = $right($gettok($did(pxstats,2),2,58),%tmp.calc), %tmp.txt = %tmp.chanc $+ .txt, %tmp.html = %tmp.chanc $+ .html, %tmp.txtfile = $scriptdirstats\ $+ %tmp.txt, %tmp.htmlfile = $scriptdirstats\ $+ %tmp.html
  $iif(($exists(%tmp.txtfile) == $false) && ($exists(%tmp.htmlfile) == $false),did -b $dname 6)
}
on *:DIALOG:pxstats_save:sclick:3,4,5: {
  if ($did == 3) { .enable #pxstats_SaveAs | did -e $dname 16 | return }
  if ($did isnum 4-5) {
    .disable #pxstats_SaveAs
    . $+ $iif($did == 4,disable,enable) #pxstats_SaveNone
    did - $+ $iif($did == 4,e,b) $dname 16 | return
  }
}
on *:DIALOG:pxstats_save:sclick:6:runstat
on *:DIALOG:pxstats_save:sclick:10:uselist sendchan
on *:DIALOG:pxstats_save:sclick:13:uselist $usertype
on *:DIALOG:pxstats_save:sclick:14,15: {
  if ($did == 14) {
    did -h $dname 12
    did -v $dname 18
    build_dcc
    return
  }
  did -v $dname 12
  did -h $dname 18
  return
}
on *:DIALOG:pxstats_save:sclick:16:makestat
on *:DIALOG:pxstats_save:sclick:17:qtime remallstats

;;Dialog About Screen
on *:DIALOG:pxstats_a:init:0:did -a $dname 2 $crlf v2.00
on *:DIALOG:pxstats_a:sclick:5:px.www mailto:zmodem@projectx.mx.dk

;;Make Stat Status Screen
on *:DIALOG:pxstats_m:init:0: did -h $dname 2

;-------- -  -
; Groups & Settings
;-------- -  -

;--<Raw Module
#pxstats2 off
raw 315:*: {
  pxsc Checking Dialogs
  if ($dialog(pxstats) == $null) { .disable #pxstats2 | haltdef | return }
  pxsc Setting Variables
  if (%^_pxstats.tmp.Here == $null) { %^_pxstats.tmp.Here = 0 }
  if (%^_pxstats.tmp.Away == $null) { %^_pxstats.tmp.Away = 0 }
  if (%^_pxstats.tmp.IrcOps == $null) { %^_pxstats.tmp.IrcOps = 0 }
  did -ra pxstats 2 Channel Statistics: $2
  did -ra pxstats 4 $nick($2,0)
  pxsc Performing Calculations: Ops
  var %tmp.full = $nick($2,0), %tmp.opC = $nick($2,0,o), %tmp.voiceC = $nick($2,0,v), %tmp.regularC = $nick($2,0,r), %tmp.helperC = $nick($2,0,h), %tmp.ops = $getpercent(%tmp.opC,%tmp.full), %tmp.voice = $getpercent(%tmp.voiceC,%tmp.full), %tmp.regular = $getpercent(%tmp.regularC,%tmp.full), %tmp.helper = $getpercent(%tmp.helperC,%tmp.full), %tmp.Away = $getpercent(%^_pxstats.tmp.Away,%tmp.full), %tmp.Here = $getpercent(%^_pxstats.tmp.Here,%tmp.full), %tmp.IrcOps = $getpercent(%^_pxstats.tmp.IrcOps,%tmp.full)
  pxsc Outputting to main dialog
  did -ra pxstats 7 %tmp.OpC
  did -ra pxstats 34 %tmp.ops
  did -ra pxstats 9 %tmp.VoiceC
  did -ra pxstats 35 %tmp.voice
  did -ra pxstats 11 %tmp.RegularC
  did -ra pxstats 36 %tmp.regular
  did -ra pxstats 13 %^_pxstats.tmp.Here
  did -ra pxstats 37 %tmp.Here
  did -ra pxstats 15 %^_pxstats.tmp.Away
  did -ra pxstats 38 %tmp.Away
  did -ra pxstats 17 %^_pxstats.tmp.IrcOps
  did -ra pxstats 39 %tmp.IrcOps
  did -ra pxstats 19 %tmp.HelperC
  did -ra pxstats 40 %tmp.Helper
  if ($saveas == none) { goto unset }
  .remove $scriptdirstats\ $+ $2 $+ .txt
  .remove $scriptdirstats\ $+ $2 $+ .html
  if ($saveas == text) {
    pxsc Creating Status Text File...
    check_folder
    write -c $scriptdirstats\ $+ $2 $+ .txt
    writetext $2 Channel Statistics For: $2
    writetext $2 $crlf
    writetext $2 ----------------------------------------------------
    writetext $2 Total Users: [ %tmp.full ]
    writetext $2 Total Ops: [ %tmp.OpC ][ %tmp.ops $+ % ]
    writetext $2 Total Voice: [ %tmp.VoiceC ][ %tmp.voice $+ % ]
    writetext $2 Total Regular: [ %tmp.RegularC ][ %tmp.regular $+ % ]
    writetext $2 Total Here: [ %^_pxstats.tmp.Here ][ %tmp.Here $+ % ]
    writetext $2 Total Away: [ %^_pxstats.tmp.Away ][ %tmp.Away $+ % ]
    writetext $2 Total IrcOps: [ %^_pxstats.tmp.IrcOps ][ %tmp.IrcOps $+ % ]
    writetext $2 Total Helpers: [ %tmp.HelperC ][ %tmp.helper $+ % ]
    writetext $2 End of /ChannelStats
    writetext $2 ----------------------------------------------------
    pxsc Status Text File Complete!
    if ($dialog(pxstats_save)) { did -e pxstats_save 6 }
    goto Unset
  }
  if ($saveas == html) {
    check_folder
    pxsc Building HTML File...
    write -c $scriptdirstats\ $+ $2 $+ .html
    writehtml $2 <html>
    writehtml $2 <head><title>Channel Stats Generated By: ProjectX Channel Statistics v2.00</title></head>
    writehtml $2 <body><center>
    writehtml $2 <font face="Arial,Helvetica,Geneva,Swiss,SunSans-Regular" size="5">ProjectX&nbsp;Channel&nbsp;Statistics<br></font>
    writehtml $2 <p><font face="Arial,Helvetica,Geneva,Swiss,SunSans-Regular" size="5"><tt><b><br></b></tt></font></p>
    writehtml $2 <p><font face="Arial,Helvetica,Geneva,Swiss,SunSans-Regular" size="5">
    writehtml $2 <table border="0" cellpadding="0" cellspacing="0" width="300" bgcolor="#535aa8"><tr><td> <font color="white" size="5"> $+ $2 $+ </font></td></tr></table>
    writehtml $2 <table border="0" cellpadding="0" cellspacing="0" width="300" bgcolor="#535aa8"><tr><td> <font color="white"><b>Total Users: %tmp.full $+ </b></font></td></tr></table>
    writehtml $2 <table border="1" cellpadding="0" cellspacing="1" width="300" bgcolor="#535aa8"><tr><td><center><font color="white" size="5"><b>Types</b></font><font size="4"></font></center></td>
    writehtml $2 <td><center><font size="5" color="white"><b>Totals</b></font></center></td>
    writehtml $2 <td><center><font color="white" size="5"><b>Percentages</b></font></center></td></tr>
    writehtml $2 <tr><td><center> <font color="white" size="4"><b>Ops</b></font></center></td>
    writehtml $2 <td><center> <font color="white"> $+ %tmp.opC $+ </font> </center></td>
    writehtml $2 <td><center> <font color="white"> $+ %tmp.ops $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center><font color="white" size="4"><b>Voices</b></font></center></td>
    writehtml $2 <td><center> <font color="white"> $+ %tmp.voiceC $+ </font> </center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.voice $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center> <font color="white" size="4"><b>Regulars</b></font></center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.regularC $+ </font> </center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.regular $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center><font color="white" size="4"><b>Here</b></font></center></td>
    writehtml $2 <td><center><font color="white"> $+ %^_pxstats.tmp.Here $+ </font> </center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.Here $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center><font size="4"></font><font color="white" size="4"><b>Away</b></font><font size="4"> </font></center></td>
    writehtml $2 <td><center><font color="white"> $+ %^_pxstats.tmp.Away $+ </font> </center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.Away $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center><font color="white" size="4"><b>IrcOps</b></font></center></td>
    writehtml $2 <td><center><font color="white"> $+ %^_pxstats.tmp.IrcOps $+ </font> </center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.IrcOps $+ $chr(37) $+ </font> </center></td></tr>
    writehtml $2 <tr><td><center><font color="white" size="4"><b>Helpers</b></font></center></td>
    writehtml $2 <td><center><font color="white"> $+ %tmp.HelperC $+ </font> </center></td>
    writehtml $2 <td><center> <font color="white"> $+ %tmp.Helper $+ $chr(37) $+ </font> </center></td></tr></table><br></font></center></body></html>
    pxsc HTML Stat File Complete! 
    if ($dialog(pxstats_save)) { did -e pxstats_save 6 }
  }
  :Unset
  unset %^_pxstats*
  .disable #pxstats2
  pxsc Make File Completed!
  $iif($dialog(pxstats_m),did -v pxstats_m 2)
  haltdef
}
raw 352:*: {
  pxsc Building Away + Ircop Users' Data
  if (H isin $7) { inc %^_pxstats.tmp.Here }
  if (G isin $7) { inc %^_pxstats.tmp.Away } 
  if ($chr(42) isin $7) { inc %^_pxstats.tmp.IrcOps }
  haltdef
}
#pxstats2 end


;--<Desktop Setting
#pxstats_Open_Desktop off
#pxstats_Open_Desktop end

;--<Save As
#pxstats_SaveAs on
#pxstats_SaveAs end
#pxstats_SaveNone off
#pxstats_SaveNone end


;-------- -  -
; PX & SCRIPT BASIC REMOTES
;-------- -  -

on *:CONNECT:.events on | $px.reg(PxChanStats,2.00)
on *:DISCONNECT:unset %px.using
on *:LOAD: {
  if ($version < 5.8) {
    echo $colour(info) -ae $px.lp ProjectX Channel Statistics v2.00 requires mIRC 5.8 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $shortfn($script)
  }
  else {
    echo $colour(info) -ae $px.lp ProjectX Channel Statistics v2.00 loaded. (by Zmodem <zmodem@projectx.mx.dk>)
    px.info | px.about | pxstats_load_addon
  }
}
on *:START: {
  if ($version < 5.8) {
    echo $colour(info) -ae $px.lp ProjectX Channel Statistics v2.00 requires mIRC 5.8 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $shortfn($script)
  }
}


;-------- -  -
; ProjectX
;-------- -  -

alias -l px.about {
  window -alk +ef @ProjectX $px.centerwin(370,199) 370 199 @ProjectX Fixedsys | clear @ProjectX
  px.aline ...............................__..._.._... | px.aline .....___..____.__.._.___..___././_.\.\/./.. | px.aline ..../._.\.__/._.`/./.-_)/.__/.._/..)..(... | px.aline .../.!__/_/..\___/./\___/\__/\__/../_/\_\.. |  px.aline ../_/.--------/__/..---------------------.. | px.aline .....................Scripting.Crew.....
  px.aline . | px.aline ......The.Official.ProjectX.Homepage:...... | px.aline ........http://www!projectx!mx!dk/......... | px.aline .......Email:.info@projectx!mx!dk......... | px.aline . | px.aline ......(Double click window to close) | sline @ProjectX 12
}
alias -l px.aline aline @ProjectX $replace($1-,., ,!,.,-, )
alias -l px.centerwin return $int($calc(($window(-3).w - $1) / 2)) $int($calc(($window(-3).h - $2) / 2))
alias -l px.get return $readini -n projectx.ini $1 $$2
alias -l px.info {
  var %. $shortfn($nopath($script))
  px.set %. name ProjectX Channel Statistics
  px.set %. author Zmodem
  px.set %. version 2.00
  px.set %. email zmodem@projectx.mx.dk
  px.set %. date September 5, 2000
  px.set %. extra N/A
}
alias -l px.lp return $iif($isalias(pxt.lp),$pxt.lp,***)
alias -l px.set $iif($3 != $null,writeini,remini) projectx.ini $$1-
alias -l px.using return ProjectX %px.using (12http://www.projectx.mx.dk/)
alias -l px.www if ($shortfn( [ $readini $mircini files browser ] )) run $ifmatch $$1
alias -l px.reg var %. = $chr(32) $+ $1 $+ $chr(40) $+ $2 $+ $chr(41) | %px.using = $addtok(%px.using,%.,44)
alias -l px.unreg if ($numtok(%px.using,44) < 2) { unset %px.using } | var %. = $remtok(%px.using,$matchtok(%px.using,$1,1,44),44) | if (%.) %px.using = %.
alias quit quit $iif($1,$1-,ProjectX :: www.projectx.mx.dk)
menu @ProjectX {
  dclick: window -c @ProjectX
}
ctcp &*:VERSION:*: .ctcpreply $nick VERSION $px.using | halt
