;---------<  ProjectX mIRC Scripters Crew  >-----------
; Filename..: pxco.mrc  [Channel Operator v2.00b]
; Release...: v2.00
; Author....: Mentor
; Bugreport.: mentor@projectx.mx.dk
; Date......: July 16, 1999
; URL.......: http://www.projectx.mx.dk/
; E-mail....: info@projectx.mx.dk
; Extra.....: Upgrade of ProjectX Kick Counter v1.10.
;------------------------------------------------------

;-------- -  -
; Aliases
;-------- -  -

; /fkick <#channel> <hostmask> [reason]
alias fkick {
  var %pxco.total = $nick($1,0,a)
  var %pxco.count = 1
  :loop
  if (($nick($1, %pxco.count, a) != $me) && ($2 iswm $address($nick($1, %pxco.count, a),5))) kick $1 $nick($1, %pxco.count, a),5) $3-
  if (%pxco.count < %pxco.total) { %pxco.count = %pxco.count + 1 | goto loop }
  unset %pcco.total %pcco.count
}

; /kban <#channel> <nick> [reason]
alias kban {  
  mode $1 +b $address($2, $calc($px.get(co, ban-mask) - 1)) | kick $1 $2 $3- | if ($px.get(co, ban-temporally)) .timer 1 $px.get(co, ban-time) mode $1 -b $address($2, $calc($px.get(co, ban-mask) - 1))
}

; /tban <#channel> <nick> <seconds> [reason]
alias tban {
  mode $1 +b $address($2, $calc($px.get(co, ban-mask) - 1)) | kick $1 $2 $4- | .timer 1 $3 mode $1 -b $address($2, $calc($px.get(co, ban-mask) - 1))
}

; /topic <#channel> <topic>
alias topic {
  topic $1- | pxco.data.add topics $2-
}

#pxco.kick on
; /kick <#channel> <nick> [reason]
alias kick {
  kick $1 $2 $iif($px.get(co, kick-counter), $iif($px.get(co, lsep), $px.get(co, lsep), )) $+ $iif($3-, $3-, $iif($px.get(co, kick-reasons), $pxco.reason, $me)) $+ $iif($px.get(co, kick-counter), $iif($px.get(co, msep), $px.get(co, msep), )) $+ $iif($px.get(co, kick-counter), $iif($px.get(co, kicks), $px.get(co, kicks), 1)) $+ $iif($px.get(co, kick-counter), $iif($px.get(co, rsep), $px.get(co, rsep), ))
  ; -- update kick reasons log:
  if ($3-) pxco.data.add reasons $3-
}

alias F5 {
  if ($px.get(co, kick-f5)) { 
    if ($1) kick # $1
    else echo $colour(info) -aei2t $px.lp Error: select a nickname in the channels nicklist first.
  }
}

on 1:KICK:#: {
  if ($nick == $me) { px.set co kicks $calc(1 + $iif($px.get(co, kicks), $px.get(co, kicks), 0)) }
}
#pxco.kick end

#pxco.ban on
; /ban <#channel> <nick>
alias ban {
  mode $1 +b $address($2, $calc($px.get(co, ban-mask) - 1))
  if ($px.get(co, ban-temporally)) .timer 1 $px.get(co, ban-time) mode # -b $address($1, $calc($px.get(co, ban-mask) - 1))
}

alias F6 {
  if ($px.get(co, ban-f6)) { 
    if ($1) { 
      mode # +b $address($1, $calc($px.get(co, ban-mask) - 1))
      if ($px.get(co, ban-temporally)) .timer 1 $px.get(co, ban-time) mode # -b $address($1, $calc($px.get(co, ban-mask) - 1))
    }
    else echo $colour(info) -aei2t $px.lp Error: select a nickname in the channels nicklist first.
  }
}

on 1:BAN:#: {
  if (($px.get(co, ban-protection)) && ($banmask iswm $address($me,5))) { mode # -b $banmask | if ($nick != $me) kick # $nick ban protection | echo $colour(info) -aei2t $px.lp Ban protection triggered by  $+ $address($nick, 5) $+  on # $+ ! }
  if (($px.get(co, ban-kick)) && ($bnick)) kick # $bnick
}
#pxco.ban end

alias -l pxco.reason {
  return $read $px.get(co, kick-file)
}

alias -l pxco.reset {
  if ($?!="Are you sure you want to reset your kick counter?" == $true) { px.set co kicks 1 | echo $colour(info) -ae $px.lp ProjectX kick counter has been reset. }
}

alias -l pxco.browse {
  px.set co reasons $dir="Select file with random kick reasons:" *.txt
  if ($px.get(co, reasons)) did -o pxco 21 21 $px.get(co,reasons)
}

alias -l pxco.style {
  goto $1
  :1 | px.set co style 4 | px.set co lsep $cr | px.set co msep )(kicks: | px.set co rsep $cr | return
  :2 | px.set co style 5 | px.set co lsep $cr | px.set co msep )(k: | px.set co rsep $cr | return
  :3 | px.set co style 6 | px.set co lsep $cr | px.set co msep )( | px.set co rsep $cr | return
  :4 | px.set co style 1 | px.set co lsep PX)( | px.set co msep )(kicks: | px.set co rsep $cr | return
  :5 | px.set co style 2 | px.set co lsep PX)( | px.set co msep )(k: | px.set co rsep $cr | return
  :6 | px.set co style 3 | px.set co lsep PX)( | px.set co msep )( | px.set co rsep $cr | return 
  :7 | px.set co style 7 | px.set co lsep $cr | px.set co msep $chr(160) $+ [kicks: | px.set co rsep ] | return
  :8 | px.set co style 8 | px.set co lsep $cr | px.set co msep $chr(160) $+ [k: | px.set co rsep ] | return
  :9 | px.set co style 9 | px.set co lsep $cr | px.set co msep $chr(160) $+ [ | px.set co rsep ] | return
}

alias -l pxco.data.add {
  var %pxco.inifile = [ $shortfn($scriptdir) ] $+ pxco.ini | window -h @pxco | loadbuf -t $+ $1 @pxco %pxco.inifile | remini %pxco.inifile $1 | flushini %pxco.inifile | write %pxco.inifile [ $+ $1] | var %pxco.count = $line(@pxco, 0) | :loop | if (%pxco.count == 0) goto end | if ($2- != $line(@pxco, %pxco.count)) write %pxco.inifile $line(@pxco, %pxco.count) | %pxco.count = %pxco.count - 1 | goto loop | :end | write %pxco.inifile $2- | window -c @pxco
}

alias -l pxco.data.clear {
  var %pxco.inifile = [ $shortfn($scriptdir) ] $+ pxco.ini | remini %pxco.inifile $1 | flushini %pxco.inifile | write %pxco.inifile [ $+ $1]
}

; -- Configuration dialog:
dialog pxco.configure {
  title  "ProjectX Channel Operator v2.00"
  size   -1 -1 445 355
  box    "General configuration:",1,5 5 345 70
  box    "Kick configuration:",2,5 80 435 135
  box    "Ban configuration:",3,5 220 435 100
  icon   4,343 12 110 61
  button "&Reset",5,375 140 55 21
  button "&Browse",6,315 186 55 21
  button "&Edit",7,375 186 55 21
  button "&Help",8,281 325 75 25
  button "&OK",9,363 325 75 25, ok default
  check  "Enable kick enhancement.",10,15 25 150 20
  check  "Enable ban enhancement.",11,15 45 150 20
  check  "Display kick counter.",12,15 100 130 20
  check  "Random kick reasons.",13,165 100 135 20
  check  "Assign 'F5' to /kick.",14,320 100 110 20
  check  "Always ban for",15,15 240 90 20
  check  "Enable ban protection.",16,230 240 150 20
  check  "Automatically kick on ban event.",17,15 265 175 20
  check  "Assign 'F6' to /ban.",18,230 265 150 20
  combo  19,15 140 355 150, drop
  combo  20,110 290 175 150, drop
  edit   "",21,15 185 295 23, autohs
  edit   "",22,110 240 29 23, autohs
  text   "Kick reason\counter style:",23,15 125 200 15
  text   "Database file with random kick reasons:",24,15 170 200 15
  text   "seconds.",25,145 243 50 15
  text   "Default banmask:",26,15 295 90 15
}

on *:DIALOG:pxco.configure:init:0:{
  ; -- ProjectX logo:
  if ($exists($scriptdirpxco.bmp)) did -g pxco.configure 4 $scriptdirpxco.bmp
  ; -- kick reasons:
  did -a $dname 19 *** lamer was kicked by $me (kick reason)(kicks: $+ $px.get(co, kicks) $+ )
  did -a $dname 19 *** lamer was kicked by $me (kick reason)(k: $+ $px.get(co, kicks) $+ )
  did -a $dname 19 *** lamer was kicked by $me (kick reason)( $+ $px.get(co, kicks) $+ )
  did -a $dname 19 *** lamer was kicked by $me (PX)(kick reason)(kicks: $+ $px.get(co, kicks) $+ )
  did -a $dname 19 *** lamer was kicked by $me (PX)(kick reason)(k: $+ $px.get(co, kicks) $+ ) 
  did -a $dname 19 *** lamer was kicked by $me (PX)(kick reason)( $+ $px.get(co, kicks) $+ ) 
  did -a $dname 19 *** lamer was kicked by $me (kick reason [kicks: $+ $px.get(co, kicks) $+ ])
  did -a $dname 19 *** lamer was kicked by $me (kick reason [k: $+ $px.get(co, kicks) $+ ])
  did -a $dname 19 *** lamer was kicked by $me (kick reason [ $+ $px.get(co, kicks) $+ ])
  did -c $dname 19 $px.get(co,kick-style)
  ; -- banmasks:
  did -a $dname 20 *!user@host.domain
  did -a $dname 20 *!*user@host.domain
  did -a $dname 20 *!*@host.domain
  did -a $dname 20 *!*user@*.domain
  did -a $dname 20 *!*@*.domain
  did -a $dname 20 nick!user@host.domain
  did -a $dname 20 nick!*user@host.domain
  did -a $dname 20 nick!*@host.domain
  did -a $dname 20 nick!*user@*.domain
  did -a $dname 20 nick!*@*.domain
  did -c $dname 20 $px.get(co, ban-mask)
  ; -- kick configuration:
  if ($px.get(co, kick-counter)) did -c $dname 12
  if ($px.get(co, kick-reasons)) did -c $dname 13
  if ($px.get(co, kick-f5)) did -c $dname 14
  did -a $dname 21 $px.get(co, kick-file)
  ; -- ban configuration:
  if ($px.get(co, ban-temporally)) did -c $dname 15
  if ($px.get(co, ban-protection)) did -c $dname 16
  if ($px.get(co, ban-kick)) did -c $dname 17
  if ($px.get(co, ban-f6)) did -c $dname 18
  did -a $dname 22 $iif($px.get(co, ban-time), $px.get(co, ban-time), 180)
  ; -- enable/disable kick support:
  if ($px.get(co, kick-support)) did -c $dname 10
  if ($did(10).state) { 
    if ($did(12).state) did -e $dname 5,19
    else did -b $dname 5,19
    if ($did(13).state) did -e $dname 6,7,21
    else did -b $dname 6,7,21
  }
  else did -b $dname 5,6,7,12,13,14,19,21
  ; -- enable/disable ban support:
  if ($px.get(co, ban-support)) did -c $dname 11
  if ($did(11).state) {
    did -e $dname 15,16,17,18,20
    if ($did(15).state) did -e $dname 22
    else did -b $dname 22
  }
  else did -b $dname 15,16,17,18,20,22
}

on *:DIALOG:pxco.configure:sclick:5: .timer 1 0 pxco.reset

on *:DIALOG:pxco.configure:sclick:6: .timer 1 0 pxco.browse

on *:DIALOG:pxco.configure:sclick:7: {
  if ($exists($shortfn($did(21)))) run $shortfn($did(21))
  else echo $colour(info) -ae $px.lp Error: no file with random kick reasons specified or the specified file does not exist.
}

on *:DIALOG:pxco.configure:sclick:8: px.www http://www.projectx.mx.dk/scripts/help/chanop.shtml

on *:DIALOG:pxco.configure:sclick:9: {
  ; -- save settings:
  px.set co kick-support $did(10).state
  px.set co ban-support $did(11).state
  px.set co kick-counter $did(12).state
  px.set co kick-reasons $did(13).state
  px.set co kick-f5 $did(14).state
  px.set co ban-temporally $did(15).state
  px.set co ban-protection $did(16).state
  px.set co ban-kick $did(17).state
  px.set co ban-f6 $did(18).state
  px.set co kick-style $did(19).sel
  if ($did(19).sel) pxco.style $did(19).sel
  px.set co ban-mask $did(20).sel
  px.set co kick-file $did(21)
  px.set co ban-time $did(22)
  ; -- control #groups:
  if ($did(10).state == 1) { .enable #pxco.kick } | else { .disable #pxco.kick } 
  if ($did(11).state == 1) { .enable #pxco.ban } | else { .disable #pxco.ban }
}

on *:DIALOG:pxco.configure:sclick:10: {
  did -e $dname 12,13,14
  if ($did(10).state) {
    if ($did(12).state) did -e $dname 5,19
    else did -b $dname 5,19
    if ($did(13).state) did -e $dname 6,7,21
    else did -b $dname 6,7,21
  }
  else did -b $dname 5,6,7,12,13,14,19,21
}

on *:DIALOG:pxco.configure:sclick:11: {
  if ($did(11).state) {
    did -e $dname 15,16,17,18,20
    if ($did(15).state) did -e $dname 22
    else did -b $dname 22
  }
  else did -b $dname 15,16,17,18,20,22
}

on *:DIALOG:pxco.configure:sclick:12: {
  if ($did(12).state) did -e $dname 5,19
  else did -b $dname 5,19
}

on *:DIALOG:pxco.configure:sclick:13: {
  if ($did(13).state) did -e $dname 6,7,21
  else did -b $dname 6,7,21
}

on *:DIALOG:pxco.configure:sclick:15: {
  if ($did(15).state) did -e $dname 22
  else did -b $dname 22
}

; -- Channel configuration dialog:
dialog pxco.channel {
  title  "ProjectX Channel Operator v2.00"
  size   -1 -1 400 165
  box    "", 1, 5 5 390 125
  button "&OK", 2, 335 135 60 25, ok default
  edit   "",3,15 40 370 35, autohs hsbar mulit
  text   "Commands to perform on join or rejoin:", 4, 15 25 380 15
  text   "Comment:",5, 20 80 50 15
  text   "You can use the mIRC scripting language to perform any command(s) you like when joining the specified channel.",6, 70 80 320 30
  text   "Example: /msg eggdrop OP my_pass | /msg #channel hello everyone!",7, 20 110 330 15

}

on *:DIALOG:pxco.channel:init:0:{
  did -a $dname 1 $px.get(co, channel) $+ :
  did -a $dname 3 $readini -n [ $shortfn($scriptdir) ] $+ pxco.ini $px.get(co, channel) onjoin
}

on *:DIALOG:pxco.channel:sclick:2:{
  pxco.data.clear $px.get(co, channel)
  pxco.data.add $px.get(co, channel) onjoin= $+ $did(3)
}

; -- Topic dialog:
dialog pxco.topic {
  title  "ProjectX Channel Operator v2.00"
  size   -1 -1 450 90
  box    "Topic:", 1, 5 5 440 50
  button "&OK", 2, 385 60 60 25, ok default 
  button "&Cancel", 3, 320 60 60 25, cancel
  button "Clear", 4, 395 25 43 21
  combo  5, 15 25 375 150, edit drop result
}

on *:DIALOG:pxco.topic:init:0:{
  ; -- load previous topics:
  loadbuf -ottopics $dname 5 [ $shortfn($scriptdir) ] $+ pxco.ini
  did -a $dname 5 $chan($px.get(co, channel)).topic
  did -c $dname 5 $did(5).lines 
}

on *:DIALOG:pxco.topic:sclick:2:{
  pxco.data.add topics $did(5,0)
  px.set co cancel 0
}

on *:DIALOG:pxco.topic:sclick:3:{
  px.set co cancel 1
}

on *:DIALOG:pxco.topic:sclick:4:{
  :loop | if ($did(5, 1)) { did -d $dname 5 1 | goto loop }
  pxco.data.clear topics
  did -b $dname 4
}

; -- Filter-kick dialog:
dialog pxco.filterkick {
  title  "ProjectX Channel Operator v2.00"
  size   -1 -1 400 115
  box    "Filter-kick:", 1, 5 5 390 75
  button "&OK", 2, 335 85 60 25, ok default
  button "&Cancel", 3, 270 85 60 25, cancel
  button "&Advanced", 4, 5 85 70 25
  button "Clear", 5, 345 20 43 21
  button "Clear", 6, 345 50 43 21
  combo  8, 80 20 260 150, edit drop
  combo  9, 80 50 260 150, edit drop
  text   "Hostmask:", 10, 15 22 60 15
  text   "Kick reason:", 11, 15 52 65 15
}

on *:DIALOG:pxco.filterkick:init:0:{
  ; -- load previous ban masks:
  loadbuf -otmasks $dname 8 [ $shortfn($scriptdir) ] $+ pxco.ini
  did -c $dname 8 $did(8).lines
  ; -- intialize kick reasons:
  loadbuf -otreasons $dname 9 [ $shortfn($scriptdir) ] $+ pxco.ini
  did -c $dname 9 $did(9).lines
}

on *:DIALOG:pxco.filterkick:sclick:2:{
  pxco.data.add masks $did(8,0)
  pxco.data.add reasons $did(9,0)
  fkick $px.get(co, channel) $did(8,0) $did(9,0)
}

on *:DIALOG:pxco.filterkick:sclick:4:{
  if ($dialog(pxco.configure)) { dialog -v pxco.configure pxco.configure } | else { dialog -m pxco.configure pxco.configure }
}

on *:DIALOG:pxco.filterkick:sclick:5:{
  :loop | if ($did(8, 1)) { did -d $dname 8 1 | goto loop }
  pxco.data.clear masks
  did -b $dname 5
}

on *:DIALOG:pxco.filterkick:sclick:6:{
  :loop | if ($did(9, 1)) { did -d $dname 9 1 | goto loop }
  pxco.data.clear reasons
  did -b $dname 6
}

; -- Kick reason dialog:
dialog pxco.kick {
  title  "ProjectX Channel Operator v2.00"
  size   -1 -1 400 85
  box    "Kick:", 1, 5 5 390 45
  button "&OK", 2, 335 55 60 25, ok default 
  button "&Cancel", 3, 270 55 60 25, cancel
  button "&Advanced", 4, 5 55 70 25
  button "Clear", 5, 345 20 43 21
  combo  6, 80 20 260 150, edit drop result
  text   "Kick reason:", 7, 15 25 65 15
}

on *:DIALOG:pxco.kick:init:0:{
  ; -- load previous kick reasons:
  loadbuf -otreasons $dname 6 [ $shortfn($scriptdir) ] $+ pxco.ini
  did -c $dname 6 $did(6).lines
}

on *:DIALOG:pxco.kick:sclick:2:{
  pxco.data.add reasons $did(6,0)
  px.set co cancel 0
}

on *:DIALOG:pxco.kick:sclick:3:{
  px.set co cancel 1
}

on *:DIALOG:pxco.kick:sclick:4:{
  if ($dialog(pxco.configure)) { dialog -v pxco.configure pxco.configure } | else { dialog -m pxco.configure pxco.configure }
}

on *:DIALOG:pxco.kick:sclick:5:{
  :loop | if ($did(6, 1)) { did -d $dname 6 1 | goto loop }
  pxco.data.clear reasons
  did -b $dname 5
}

;-------- -  -
; Popups
;-------- -  -

menu menubar,status {
  ProjectX Channel Operator
  .&Setup Channel Operator: dialog -m pxco.configure pxco.configure
  .Channel Operator &help: px.www http://www.projectx.mx.dk/scripts/help/chanop.shtml
  .-
  .ProjectX &Website: { px.about | px.www http://www.projectx.mx.dk/px.html }
}

menu channel {
  ProjectX Channel Operator
  .&Filter-kick: px.set co channel # | dialog -m pxco.filterkick pxco.filterkick
  .&Modes
  ..$iif(i isin $chan(#).mode,-i	(invite only),+i	(invite only)): if (i isin $chan(#).mode) mode # -i | else mode # +i
  ..$iif(k isin $chan(#).mode,-k	(secret key),+k	(secret key)): if (k isin $chan(#).mode) mode # -k | else mode # +k $?="Enter channel key:"
  ..$iif(l isin $chan(#).mode,-l	(limited users),+l	(limited users)): if (l isin $chan(#).mode) mode # -l | else mode # +l $?="Enter maximum number of users:"
  ..$iif(m isin $chan(#).mode,-m	(moderated),+m	(moderated)): if (m isin $chan(#).mode) mode # -m | else mode # +m
  ..$iif(n isin $chan(#).mode,-n	(external messages),+n	(external messages)): if (n isin $chan(#).mode) mode # -n | else mode # +n
  ..$iif(p isin $chan(#).mode,-p	(private),+p	(private)): if (p isin $chan(#).mode) mode # -p | else mode # +p
  ..$iif(s isin $chan(#).mode,-s	(secret),+s	(secret)): if (s isin $chan(#).mode) mode # -s | else mode # +s
  ..$iif(t isin $chan(#).mode,-t	(topic limited),+t	(topic limited)): if (t isin $chan(#).mode) mode # -t | else mode # +t
  .&On join configuration: px.set co channel # | dialog -m pxco.channel pxco.channel
  .&Topic: px.set co channel # | var %pxco.topic = $dialog(pxco.topic, pxco.topic) | if ($px.get(co, cancel) != 1) topic # %pxco.topic
  .-
  .&Setup Channel Operator: dialog -m pxco.configure pxco.configure
  .Channel Operator &help: px.www http://www.projectx.mx.dk/scripts/help/chanop.shtml
}

menu nicklist {
  ProjectX Channel Operator
  .&Kick: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) kick # $1 %pxco.reason 
  .&Ban 
  ..&Perm-ban: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) ban # $1 %pxco.reason
  ..&Temp-ban
  ...30 seconds: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 30 %pxco.reason
  ...60 seconds: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 60 %pxco.reason
  ...-
  ...10 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 600 %pxco.reason
  ...20 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 1200 %pxco.reason
  ...40 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 2400 %pxco.reason
  ...60 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 3600 %pxco.reason
  .Kban
  ..&Perm-ban: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) kban # $1 %pxco.reason
  ..&Temp-ban
  ...30 seconds: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 30 %pxco.reason
  ...60 seconds: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 60 %pxco.reason
  ...-
  ...10 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 600 %pxco.reason
  ...20 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 1200 %pxco.reason
  ...40 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 2400 %pxco.reason
  ...60 minutes: var %pxco.reason = $dialog(pxco.kick, pxco.kick) | if ($px.get(co, cancel) != 1) tban # $1 3600 %pxco.reason

  .-
  .&Setup Channel Operator: dialog -m pxco.configure pxco.configure
  .Channel Operator &help: px.www http://www.projectx.mx.dk/scripts/help/chanop.shtml
}

;-------- -  -
; Remote
;-------- -  -

on *:CONNECT: .events on | $px.reg(Channel Operator,v2.00)

on *:DISCONNECT: unset %px.using

on *:JOIN:*: {
  ; -- update Internal Address List and perform on (re)join commands if necessary:
  if ($nick == $me) {
    .enable #pxco.ial
    who #
    var %pxco.join = $readini -n [ $shortfn($scriptdir) ] $+ pxco.ini # onjoin
    if (%pxco.join) %pxco.join
  }
}

#pxco.ial off
; -- update Internal Address List:
raw 352:*: haltdef
#pxco.ial end

raw 315:*: haltdef | .disable #pxco.ial

on *:START: {
  if ($version < 5.6) {
    echo $colour(info) -aei2t $px.lp ProjectX Channel Operator v2.00 requires mIRC 5.6 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $script | halt
  }
  else { .ial ON }
}

on *:LOAD: {
  if ($version < 5.6) {
    echo $colour(info) -aei2t $px.lp ProjectX Channel Operator v2.00 requires mIRC 5.6 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $script | halt
  }
  else {
    echo $colour(info) -aei2t $px.lp ProjectX Channel Operator v2.00 loaded. (by Mentor <mentor@projectx.mx.dk>) | px.info | px.about
    ; -- initialization:
    px.set co kick-file $scriptdirpxco-kicks.txt | .ial ON | if ($?!="You need to configure ProjectX Channel Operator first in order to make it function properly.  Do you want to configure it now?" == $true) { dialog -m pxco.configure pxco.configure }
  }
}

;-------- -  -
; ProjectX
;-------- -  -

alias -l px.about {
  window -alk +ef @ProjectX $px.centerwin(370,199) 370 199 @ProjectX Fixedsys | clear @ProjectX
  px.aline ...............................__..._.._... | px.aline .....___..____.__.._.___..___././_.\.\/./.. | px.aline ..../._.\.__/._.`/./.-_)/.__/.._/..)..(... | px.aline .../.!__/_/..\___/./\___/\__/\__/../_/\_\.. |  px.aline ../_/.--------/__/..---------------------.. | px.aline .....................Scripting.Crew.....
  px.aline . | px.aline ......The.Official.ProjectX.Homepage:...... | px.aline ........http://www!projectx!mx!dk/......... | px.aline .......Email:.info@projectx!mx!dk......... | px.aline . | px.aline ......(Double click window to close) | sline @ProjectX 12
}
alias -l px.aline aline @ProjectX $replace($1-,., ,!,.,-, )
alias -l px.centerwin return $int($calc(($window(-3).w - $1) / 2)) $int($calc(($window(-3).h - $2) / 2))
alias -l px.get return $readini -n projectx.ini $1 $$2
alias -l px.info {
  var %. $shortfn($nopath($script))
  px.set %. name [Channel Operator]
  px.set %. author Mentor
  px.set %. version v2.00
  px.set %. email mentor@projectx.mx.dk
  px.set %. date July 16, 1999
  px.set %. extra Upgrade of ProjectX Kick Counter v1.10.
}
alias -l px.lp return $iif($isalias(pxt.lp),$pxt.lp,***)
alias -l px.set $iif($3 != $null,writeini,remini) projectx.ini $$1-
alias -l px.using return ProjectX %px.using (12http://www.projectx.mx.dk/)
alias -l px.www if ($shortfn( [ $readini $mircini files browser ] )) run $ifmatch $$1
alias -l px.reg { if ($1) { if (%px.using) %px.using = %px.using $+ , $1 $+ ( $+ $2 $+ ) | else %px.using = $1 $+ ( $+ $2 $+ ) } }
alias quit quit $iif($1,$1-,ProjectX :: www.projectx.mx.dk)
menu @ProjectX {
  dclick: window -c @ProjectX
}
ctcp &*:VERSION:*: .ctcpreply $nick VERSION $px.using | halt
