;---------<  ProjectX mIRC Scripters Crew  >-----------
; Filename..: px8ball.mrc ProjectX 8-Ball
; Release...: v2.20
; Author....: FolkLore
; Bugreport.: FolkLore@projectx.mx.dk
; Date......: Aug 22, 1999
; URL.......: http://www.projectx.mx.dk/
; E-mail....: info@projectx.mx.dk
; Extra.....: ProjectX 8-Ball script!
;------------------------------------------------------

;-------- -  -
; Base Aliases
;-------- -  -

alias -l px8ball.shortname { return 8-Ball }
alias -l px8ball.help { px.www http://www.projectx.mx.dk/scripts/help/8ball.shtml }
alias -l px8ball.nickname { return FolkLore }
alias -l px8ball.email { return FolkLore@projectx.mx.dk }
alias -l px8ball.lastmod { return Sept 24, 1999 }
alias -l px8ball.ver { return v2.20 }
alias -l px8ball.extrainfo { return ProjectX 8-Ball script! }
alias -l px8ball.fullname { return ProjectX 8-Ball }

alias -l px8ball.setup {
  if ($dialog(px8ball.main)) dialog -v px8ball.main px8ball.main
  else dialog -m px8ball.main px8ball.main
}

alias -l px8ball.release {
  if ($exists($scriptdirpx8ball.txt)) { .run $scriptdirpx8ball.txt }
  else echo $colour(info) -ae Release notes not found. Select "Online Help" for help on this addon
}

alias -l px8ball.pic {
  set %px8ball.picfile $scriptdir $+ $2 $+ .bmp
  if ($exists(%px8ball.picfile)) did -g $dname $1 %px8ball.picfile
}

alias -l px8ball.unload {
  if ($?!="Are you sure you want to unload?") {
    unset %px8ball.*
    px.set 8-Ball
    %px.using = $remove(%px.using, [ [ $chr(91) ] $+ [ $px8ball.ver ] $+ [ $chr(93) ] ] )
    if ($len(%px.using) < 2) unset %px.using
    .timer -o 1 0 .unload -rs $nopath($script)
    .timer -o 1 0 echo $colour(info) -ae $px.lp Unload of $px8ball.fullname successfully completed.
  }
}

;-------- -  -
; Aliases
;-------- -  -

alias px8ball.findlast {
  set %px8ball.lastc 0
  :repeater
  set %px8ball.topic n $+ %px8ball.lastc
  %px8ball.last = $readini $1 $2 %px8ball.topic

  if (%px8ball.last != $null) {
    inc %px8ball.lastc
    goto repeater
  }

  if (%px8ball.last == $null) { goto ender }
  :ender
  return %px8ball.lastc
}

;-------- -  -
; Popups
;-------- -  -

menu menubar,status,channel,query,nicklist {
  ProjectX 8-Ball
  .8-Ball: px8ball.setup
  .-
  .Online Help: px8ball.help
  .Release Notes: px8ball.release
  .-
  .Unload: px8ball.unload
  .-
  .ProjectX Website: {
    px.about
    px.www http://www.projectx.mx.dk/px.html
  }
}

;-------- -  -
; Dialogs
;-------- -  -

dialog px8ball.main {
  title  "ProjectX 8-Ball"
  size   -1 -1 209 105
  button "Close", 1, 350 203 65 25, Cancel
  button "Deactivate", 25, 280 203 65 25, Default
  button "Activate", 19, 210 203 65 25, Default
  button "Advertise!", 39, 140 203 65 25, Default
  icon   4, 8 203 34 22
  icon   55, 30 65 100 80
  option dbu
  tab "Attitude", 2, 5 5 202 87
  tab "Play Alone", 3
  tab "Options", 38
  tab "Colours", 33
  tab "Database", 8
  tab "About", 67
  text   "In this section, you can specify what attitude the 8-ball will have. A positive attitude will give you friendly and/or 'good news' answers, while a negative attitude will give you grumpy, and/or 'bad news' answers.", 40, 15 25 190 28, tab 2
  combo  7, 15 55 183 70, drop, tab 2
  text   "This section is used for playing alone. There will be no output in the channel, and your answers will be displayed right here on this tab.", 41, 15 25 180 16, tab 3
  text   "Question:", 20, 15 50 50 20, tab 3
  edit   "When is my next promotion due?", 21, 40 45 160 12, autohs, tab 3
  text   "Answer:", 22, 15 65 50 20, tab 3
  edit   "Your answer will be displayed here.", 23, 40 60 160 12, autohs, read, tab 3
  button "Ask [8-Ball]", 24, 160 77 40 12, Default, tab 3
  text   "Use these controls to edit, add, or modify the 8-Ball's databases.", 49, 15 25 185 12, tab 8
  text   "Category:", 9, 15 40 40 20, tab 8
  text   "Attitude:", 11, 15 55 40 20, tab 8
  text   "Reply:", 13, 15 70 40 20, tab 8
  combo  10, 40 37 105 70, drop, tab 8
  combo  12, 40 52 105 70, drop, tab 8
  edit   "", 14, 40 67 80 12, autohs, tab 8
  button "Add", 15, 125 67 20 11, Default, tab 8
  button "View Positives", 16, 150 37 50 11, Default, tab 8
  button "View Neutrals", 17, 150 52 50 11, Default, tab 8
  button "View Negatives", 18, 150 67 50 11, Default, tab 8
  text   "Select the colours you want for output when playing online with friends, by selecting your options in this tab. Only available if Enhanced output is enabled.", 47, 15 25 185 16, tab 33
  text   "Style Foreground:", 28, 15 42 70 12, tab 33
  text   "Style Background:", 29, 15 66 70 12, tab 33
  text   "Answer Foreground:", 30, 105 42 70 12, tab 33
  text   "Answer Background:", 31, 105 66 70 12, tab 33
  combo  34, 15 52 80 60, drop, tab 33
  combo  35, 15 76 80 60, drop, tab 33
  combo  36, 105 52 80 60, drop, tab 33
  combo  37, 105 76 80 60, drop, tab 33
  text   "In this section, you can select the 8-ball's output options. Do you want to use colours? What about an output style?", 6, 15 25 185 16, tab 38
  check  "Enable enhanced Output", 5, 15 40 180 12, tab 38
  text   "Style:", 27, 15 55 45 20, tab 38
  combo  32, 15 65 183 100, drop, tab 38
  text   "ProjectX 8-Ball v2.20", 57, 80 32 90 20, tab 67
  text   "Brought to you by", 58, 80 50 90 20, tab 67
  text   "ProjectX and FolkLore, (c) Sept. 1999", 59, 80 67 90 20, tab 67
}

on *:dialog:px8ball.main:init:0:{
  var %px8ball.random = $rand(1,3)
  did -h $dname 55
  px8ball.pic 4 projectx
  px8ball.pic 55 px8ball
  did -a $dname 7 Negative
  did -a $dname 7 Neutral
  did -a $dname 7 Positive
  did -a $dname 7 Random
  did -c $dname 7 4
  did -a $dname 10 What
  did -a $dname 10 Why
  did -a $dname 10 When
  did -a $dname 10 Who
  did -a $dname 10 How
  did -a $dname 10 Will
  did -a $dname 10 Where
  did -c $dname 10 1
  did -a $dname 12 Negative
  did -a $dname 12 Neutral
  did -a $dname 12 Positive
  did -c $dname 12 2
  if ($px.get(px8ball,out) == 1) { did -c $dname 5 }
  did -b $dname 15
  set %px8ball.file $scriptdirpx8-positive.txt
  if (%px8ball.random == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
  if (%px8ball.random == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
  if (%px8ball.random == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
  did -a $dname 32 [8-Ball]
  did -a $dname 32 ( 8-Ball )
  did -a $dname 32 -= 8-Ball =-
  did -a $dname 32 *** 8-Ball ***
  did -a $dname 32 < 8-Ball >
  did -a $dname 34,35,36,37 0 - White
  did -a $dname 34,35,36,37 1 - Black
  did -a $dname 34,35,36,37 2 - Blue
  did -a $dname 34,35,36,37 3 - Green
  did -a $dname 34,35,36,37 4 - Red
  did -a $dname 34,35,36,37 5 - Brown
  did -a $dname 34,35,36,37 6 - Purple
  did -a $dname 34,35,36,37 7 - Orange
  did -a $dname 34,35,36,37 8 - Yellow
  did -a $dname 34,35,36,37 9 - L/Green
  did -a $dname 34,35,36,37 10 - D/Cyan
  did -a $dname 34,35,36,37 11 - L/Cyan
  did -a $dname 34,35,36,37 12 - L/Blue
  did -a $dname 34,35,36,37 13 - Pink
  did -a $dname 34,35,36,37 14 - Grey
  did -a $dname 34,35,36,37 15 - L/Grey
  did -c $dname 34,35,36,37 1
  if ($px.get(px8ball,sfb) != $null) did -c $dname 34 $calc($px.get(px8ball,sfb)+1)
  if ($px.get(px8ball,sfg) != $null) did -c $dname 35 $calc($px.get(px8ball,sfg)+1)
  if ($px.get(px8ball,afb) != $null) did -c $dname 36 $calc($px.get(px8ball,afb)+1)
  if ($px.get(px8ball,afg) != $null) did -c $dname 37 $calc($px.get(px8ball,afg)+1)
  if ($px.get(px8ball,style) != 0) did -c $dname 32 $px.get(px8ball,style)
  if ($did($dname,5).state == 1) { did -e $dname 34,35,36,37 }
  if ($did($dname,5).state == 0) { did -b $dname 34,35,36,37 }
}

on *:dialog:px8ball.main:sclick:2: { did -h $dname 55 }
on *:dialog:px8ball.main:sclick:3: { did -h $dname 55 }

on *:dialog:px8ball.main:sclick:5:{ 
  px.set px8ball out $did($dname,5).state
  set %px8ball.out $did($dname,5).state
  if (%px8ball.out == 1) { did -e $dname 34,35,36,37 }
  if (%px8ball.out == 0) { did -b $dname 34,35,36,37 }
  px.set px8ball sfb 0
  px.set px8ball sfg 1
  px.set px8ball afb 0
  px.set px8ball afg 2
  set %px8ball.sfb 0
  set %px8ball.sfg 1
  set %px8ball.afb 0
  set %px8ball.afg 2
}

on *:dialog:px8ball.main:sclick:7: {
  if ($did($dname,7).sel == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
  if ($did($dname,7).sel == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
  if ($did($dname,7).sel == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
  if ($did($dname,7).sel == 4) { 
    set %px8ball.random $rand(1,3)
    if (%px8ball.random == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
    if (%px8ball.random == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
    if (%px8ball.random == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
  }
}

on *:dialog:px8ball.main:sclick:8: { did -h $dname 55 }

on *:dialog:px8ball.main:edit:14: { 
  if ($did($dname,14).text == $null) { did -b $dname 15 }
  if ($did($dname,14).text != $null) { did -e $dname 15 }
}

on *:dialog:px8ball.main:sclick:15: { 
  set %px8ball.section $did($dname,10).text
  set %px8ball.file $scriptdir $+ px8- $+ $did($dname,12).text $+ .txt
  set %px8ball.last n $+ $px8ball.findlast(%px8ball.file,%px8ball.section)
  if ($did($dname,14).text != $null) { writeini %px8ball.file %px8ball.section %px8ball.last $did($dname,14).text }
  else { echo $colour(info) -ta Nothing to add to database. Type something in the replay-filed first. }
}

on *:dialog:px8ball.main:sclick:16: { .run $scriptdirpx8-positive.txt }
on *:dialog:px8ball.main:sclick:17: { .run $scriptdirpx8-neutral.txt }
on *:dialog:px8ball.main:sclick:18: { .run $scriptdirpx8-negative.txt }

on *:dialog:px8ball.main:sclick:19: { 
  var %px8ball.random = $rand(1,3)
  if ($active == Status Window) { echo $colour(info) -ta You must join a channel, or open a query window first, before attempting to start a public game. }
  elseif ($active != Status Window) {
    msg $active  $+ %px8ball.sfb $+ , $+ %px8ball.sfg ProjectX 8-Ball activated! To ask a question, type:  $+ %px8ball.afb $+ , $+ %px8ball.afg !px8 question 
    .enable #px8public
    if ($did($dname,7).sel == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
    if ($did($dname,7).sel == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
    if ($did($dname,7).sel == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
    if ($did($dname,7).sel == 4) { 
      if (%px8ball.random == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
      if (%px8ball.random == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
      if (%px8ball.random == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
    }
  }
  dialog -x $dname $dname
}

on *:dialog:px8ball.main:sclick:24: { 
  var %px8ball.nick = $me, %px8ball.random = $rand(1,3), %px8ball.temp = $gettok($did($dname,21).text,1,32)
  var %px8ball.lastc, %px8ball.temp2, %px8ball.response
  if ($did($dname,7).sel == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
  if ($did($dname,7).sel == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
  if ($did($dname,7).sel == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
  if ($did($dname,7).sel == 4) { 
    if (%px8ball.random == 1) { set %px8ball.file $scriptdirpx8-negative.txt }
    if (%px8ball.random == 2) { set %px8ball.file $scriptdirpx8-neutral.txt }
    if (%px8ball.random == 3) { set %px8ball.file $scriptdirpx8-positive.txt }
  }
  if (%px8ball.temp == $null) { set %px8ball.topic2 None }
  elseif ($initopic(%px8ball.file,%px8ball.temp) != 0) { set %px8ball.topic2 %px8ball.temp }
  elseif ($initopic(%px8ball.file,%px8ball.temp) == 0) { set %px8ball.topic2 Unknown }
  set %px8ball.lastc $px8ball.findlast(%px8ball.file,%px8ball.topic2)
  set %px8ball.random $calc($rand(1,%px8ball.lastc)-1)
  set %px8ball.temp2 n $+ %px8ball.random
  set %px8ball.response $readini %px8ball.file %px8ball.topic2 %px8ball.temp2
  did -r $dname 23
  did -a $dname 23 %px8ball.response
}

on *:dialog:px8ball.main:sclick:25: {
  if ($active == Status Window) { echo $colour(info) -ta You must join a channel, or open a query window first, before attempting to disable a public game. }
  elseif ($active != Status Window) {
    msg $active  $+ %px8ball.sfb $+ , $+ %px8ball.sfg ProjectX 8-Ball de-activated!  $+ %px8ball.afb $+ , $+ %px8ball.afg Thanks for playing! 
    .disable #px8public
  }
  dialog -x $dname $dname
}

on *:dialog:px8ball.main:sclick:26: {
  if ($dialog(%px8ball.about)) { dialog -v px8ball.about px8ball.about }
  else { dialog -m px8ball.about px8ball.about } 
}

on *:dialog:px8ball.main:sclick:32: {
  set %px8ball.style $did($dname,32).text
  px.set px8ball style $did($dname,32).sel
}

on *:dialog:px8ball.main:sclick:33: { did -h $dname 55 }
on *:dialog:px8ball.main:sclick:34: {
  set %px8ball.sfb $left($did($dname,34).text,2)
  px.set px8ball sfb %px8ball.sfb
}

on *:dialog:px8ball.main:sclick:35: {
  set %px8ball.sfg $left($did($dname,35).text,2) 
  px.set px8ball sfg %px8ball.sfg
}

on *:dialog:px8ball.main:sclick:36: { 
  set %px8ball.afb $left($did($dname,36).text,2) 
  px.set px8ball afb %px8ball.afb
}

on *:dialog:px8ball.main:sclick:37: {
  set %px8ball.afg $left($did($dname,37).text,2) 
  px.set px8ball afg %px8ball.afg
}

on *:dialog:px8ball.main:sclick:38: { did -h $dname 55 }
on *:dialog:px8ball.main:sclick:39: {
  if ($active == Status Window) { echo $colour(info) -ta You must join a channel, or open a query window first, before attempting to start a public game. }
  elseif ($active != Status Window) {
    if ($group(#px8public) == on) { msg $active  $+ $colour(info) $+ ProjectX 8-Ball is active! To ask a question, type: !px8 question }
    else echo $colour(info) -a ProjectX 8-Ball is not activated. Activate it first from the main dialog.
  }
}

on *:dialog:px8ball.main:sclick:67: { did -v $dname 55 }

;-------- -  -
; Remote
;-------- -  -

#px8public off

alias px8ball.playdelayed { .timer -m 1 200 px8ball.delayed }
alias px8ball.delayed {
  var %px8ball.resp2
  set %px8ball.resp2  $+ %px8ball.sfb $+ , $+ %px8ball.sfg %px8ball.style  $+ %px8ball.afb $+ , $+ %px8ball.afg %px8ball.response 
  if (%px8ball.out == 1) { msg %px8ball.active %px8ball.resp2 }
  elseif (%px8ball.out == 0) { msg %px8ball.active %px8ball.style %px8ball.response }
}

on *:input:#: {
  var %px8ball.nick = $me, %px8ball.active = $active, %px8ball.temp = $strip($2)
  var %px8ball.lastc = $px8ball.findlast(%px8ball.file,%px8ball.topic2)
  var %px8ball.random = $calc($rand(1,%px8ball.lastc)-1), %px8ball.temp2 = n $+ %px8ball.random
  if ($strip($1) == $strip(!px8)) {
    if (%px8ball.temp == $null) { set %px8ball.topic2 None }
    elseif ($initopic(%px8ball.file,%px8ball.temp) != 0) { set %px8ball.topic2 %px8ball.temp }
    elseif ($initopic(%px8ball.file,%px8ball.temp) == 0) { set %px8ball.topic2 Unknown }
    set %px8ball.response $readini %px8ball.file %px8ball.topic2 %px8ball.temp2
    px8ball.playdelayed
  }
}

on *:text:*:#: {
  if ($strip($1) == !px8) {
    var %px8ball.active = $chan, %px8ball.nick = $nick, %px8ball.temp = $strip($2), %px8ball.topic2
    var %px8ball.lastc, %px8ball.random, %px8ball.temp2, %px8ball.response, %px8ball.resp2
    if (%px8ball.temp == $null) { set %px8ball.topic2 None }
    elseif ($initopic(%px8ball.file,%px8ball.temp) != 0) { set %px8ball.topic2 %px8ball.temp }
    elseif ($initopic(%px8ball.file,%px8ball.temp) == 0) { set %px8ball.topic2 Unknown }
    set %px8ball.lastc $px8ball.findlast(%px8ball.file,%px8ball.topic2)
    set %px8ball.random $calc($rand(1,%px8ball.lastc)-1)
    set %px8ball.temp2 n $+ %px8ball.random
    set %px8ball.response $readini %px8ball.file %px8ball.topic2 %px8ball.temp2
    set %px8ball.resp2  $+ %px8ball.sfb $+ , $+ %px8ball.sfg %px8ball.style  $+ %px8ball.afb $+ , $+ %px8ball.afg %px8ball.response 
    if (%px8ball.out == 1) { msg %px8ball.active %px8ball.resp2 }
    elseif (%px8ball.out == 0) { msg %px8ball.active %px8ball.style %px8ball.response }
  }
}

on *:text:*:?: {
  if ($strip($1) == !px8) {
  var %px8ball.active = $nick, %px8ball.nick = %px8ball.active, %px8ball.temp = $strip($2), %px8ball.topic2
  var %px8ball.lastc %px8ball.random, %px8ball.temp2, %px8ball.response, %px8ball.resp2
  if (%px8ball.temp == $null) { set %px8ball.topic2 None }
  elseif ($initopic(%px8ball.file,%px8ball.temp) != 0) { set %px8ball.topic2 %px8ball.temp }
  elseif ($initopic(%px8ball.file,%px8ball.temp) == 0) { set %px8ball.topic2 Unknown }
  set %px8ball.lastc $px8ball.findlast(%px8ball.file,%px8ball.topic2)
  set %px8ball.random $calc($rand(1,%px8ball.lastc)-1)
  set %px8ball.temp2 n $+ %px8ball.random
  set %px8ball.response $readini %px8ball.file %px8ball.topic2 %px8ball.temp2
  set %px8ball.resp2  $+ %px8ball.sfb $+ , $+ %px8ball.sfg %px8ball.style  $+ %px8ball.afb $+ , $+ %px8ball.afg %px8ball.response 
  if (%px8ball.out == 1) { msg %px8ball.active %px8ball.resp2 }
  elseif (%px8ball.out == 0) { msg %px8ball.active %px8ball.style %px8ball.response }
}
}

#px8public end

on *:CONNECT: {
  .remote on
  set %px8ball.out 1
  $px.reg($px8ball.fullname,$px8ball.ver)
}

on *:DISCONNECT: unset %px.using

on *:LOAD: {
  if ($version < 5.61) {
    echo $colour(info) -ae $px.lp $px8ball.fullname $px8ball.ver requires mIRC 5.61 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $shortfn($script)
    halt
  }
  else {
    echo $colour(info) -ae $px.lp $px8ball.fullname $px8ball.ver loaded. (by FolkLore <FolkLore@projectx.mx.dk>)
    px.info
    px.about
  }
  set %px8ball.out 0
  set %px8ball.style [8-Ball]
  set %px8ball.file $scriptdirpx8-positive.txt
  set %px8ball.sfb 0
  set %px8ball.sfg 1
  set %px8ball.afb 0
  set %px8ball.afg 2
  px.set sfb 0
  px.set sfg 1
  px.set afb 0
  px.set afg 0
  px.set out 0
  .disable #px8public
}

on *:START: {
  if ($version < 5.61) {
    echo $colour(info) -ae $px.lp ProjectX 8-Ball v2.20 requires mIRC 5.61 or higher. Visit http://www.mirc.com/ for the latest version of mIRC.
    unload -rs $shortfn($script)
    halt
  }
}

;-------- -  -
; ProjectX
;-------- -  -

alias -l px.about {
  window -alk +ef @ProjectX $px.centerwin(370,199) 370 199 @ProjectX Fixedsys
  clear @ProjectX
  px.aline ...............................__..._.._...
  px.aline .....___..____.__.._.___..___././_.\.\/./..
  px.aline ..../._.\.__/._.`/./.-_)/.__/.._/..)..(...
  px.aline .../.!__/_/..\___/./\___/\__/\__/../_/\_\..
  px.aline ../_/.--------/__/..---------------------..
  px.aline .....................Scripting.Crew.....
  px.aline .
  px.aline ......The.Official.ProjectX.Homepage:......
  px.aline ........http://www!projectx!mx!dk/.........
  px.aline .......Email:.info@projectx!mx!dk.........
  px.aline .
  px.aline ......(Double click window to close)
  sline @ProjectX 12
}

alias -l px.aline aline @ProjectX $replace($1-,., ,!,.,-, )
alias -l px.centerwin return $int($calc(($window(-3).w - $1) / 2)) $int($calc(($window(-3).h - $2) / 2))
alias -l px.get return $readini -n projectx.ini $1 $$2
alias -l px.lp return $iif($isalias(pxt.lp),$pxt.lp,***)
alias -l px.set $iif($3 != $null,writeini,remini) projectx.ini $$1-
alias -l px.using return ProjectX %px.using (12http://www.projectx.mx.dk/)
alias -l px.www if ($shortfn( [ $readini $mircini files browser ] )) run $ifmatch $$1
alias quit quit $iif($1,$1-,ProjectX :: www.projectx.mx.dk)

alias -l px.info {
  var %. = $shortfn($nopath($script))
  px.set %. name 8-Ball
  px.set %. author FolkLore
  px.set %. version v2.20
  px.set %. email FolkLore@projectx.mx.dk
  px.set %. date Sept 24, 1999
  px.set %. extra ProjectX 8-Ball script!
}

alias -l px.reg {
  var %. = $chr(32) $+ $1 $+ $chr(40) $+ $2 $+ $chr(41)
  %px.using = $addtok(%px.using,%.,44)
}

menu @ProjectX { 
  dclick: window -c @ProjectX 
}

ctcp &*:VERSION:*: {
  .ctcpreply $nick VERSION $px.using
  halt
}
