;
;         Msg Ignore Script v.1.2
;                        by Danaria (ladydana@animefan.org)
;
;             http://animedomain.com/ladydana/index.html

menu menubar,channel,status {
  Msg Ignore Script
  . $+ $msgignorestatus Script: if ($group(#msgignore) == on) { .disable #msgignore | .echo -a *** MsgIgnore - Disabled. } | else { .enable #msgignore | .echo -a *** MsgIgnore - Enabled }
  .-
  .Msg Ignore Menu: /dialog -m MsgIgnore msgignore  
  .Unaffected User List: /dialog -m MsgIgnoreUsers msgignoreusers
  .-
  .Open $nopath($migini(migset,textfile)) : .run $migini(migset,textfile)
  .Help with Script: run $scriptdirreadmemi.txt
  .-
  .Uninstall: miguninstall
}
; Creates the popups that you can be viewed in the MENUBAR section

menu nicklist,query {
  -
  Msg Ignore Add: if ($1) { migloadusers $$1 | echo -a *** $$1 has been added to the Msg Ignore Unaffected List }
  Msg Ignore Del:  if ($1) { migdelusers $$1 }
  -
}

On *:LOAD:{
  if ($version < 5.51) { 
    echo -s *** MsgIgnore - Sorry, but this script only runs with mIRC Version 5.1 or higher, please download it at http://www.mirc.co.uk/get.html
    unload -rs $script
  }
  else { 
    echo -s *** Msg Ignore - Thanks for using this script. You can change your settings in the menubar, channel or status popups
    writeini settings.ini migset replytext Sorry, but I don't accept private chats. Talk to me in the channel.
    writeini settings.ini migset textfile msgignore.txt
    run $scriptdirreadmemi.txt
  }
}
; Checks if the script is compatible with the version of mIRC that the user has currently installed.
; If it isn't, then it will return the appropriate error messages and unload the script
; Otherwise, it will big the user welcome and tell him where to change his/her settings

alias -l msgignorestatus { 
  if ($group(#msgignore).status == on) { return Disable }
  else { return Enable }
}
; Returns Enabled or Disabled, depending on whether the script is currently on/off

dialog msgignore {
  title "Message Ignore Options Menu"
  size -1 -1 300 350
  button "Done!", 1, 60 310 70 30, ok
  button "Forget it!", 2, 170 310 70 30, cancel
  text "What happens if someone sends you a private msg?", 10, 20 20 110 50, center
  radio "Don't display", 11, 150 15 110 20, group
  radio "Active window", 12, 150 35 110 20
  radio "Custom window", 13, 150 55 110 20
  check "Write to .txt file", 15, 30 100 110 20
  button "Modify Destination", 16, 150 100 110 20
  check "Message to sender", 17, 30 125 110 20
  button "Modify Message", 18, 150 125 110 20
  text "What happens if the person floods you?", 20, 20 165 260 20, center
  radio "Temp Private Ignore", 21, 20 185 130 20, group
  radio "Perm Private Ignore", 22, 20 205 130 20
  radio "No Flood Protection", 23, 20 225 130 20
  text "Note: When an ignore is in effect, nothing will be logged and all the msgs from that person will be lost.", 24, 152 187 140 60, center
  check "Allow MSG if Sender is an Op", 30, 30 255 170 20
  check "Allow MSG if Sender is a Voice", 31, 30 275 170 20
  text "in a channel you are on", 32, 205 260 70 40, center
  box "", 33, 20 245 260 54
}
; Creates the Dialog for the Msg Ignore Settings

dialog msgignoreusers {
  title "Msg Ignore Unaffected User List"
  size -1 -1 300 300
  button "Done!", 1, 60 260 70 30, ok
  button "Forget it!", 2, 170 260 70 30, cancel
  text "The following users won't be affected by this script. Only add nicks please.", 3, 20 20 260 50, center
  list 4, 20 60 260 140
  text "(Double click in order to remove a nick)", 5, 50 187 200 14, center
  edit " ", 6, 30 210 160 20
  button "Add!", 7, 200 210 70 20,center
}
; Creates the Dialog for the Msg Ignore Unaffected List Settings


; <>*<>*<>*<> Dialog Events <>*<>*<>*<>

On *:DIALOG:msgignoreusers:init:0: { migloadusers | did -r $dname 6 | did -f $dname 1 }
; When the Unaffected User List is first loaded, all the nicks will be loaded into there
; and also it will set the focus to the OK button in addition to removing the space from the EDIT box

On *:DIALOG:msgignoreusers:sclick:7: { if ($did(6).text == $null) { goto end } | else { migloadusers $did(6).text | did -r $dname 6 } | :end }
; If someone clicks on the ADD button in the Unaffected list, it will add the user to the list
; and then reset the entire list. The entry in the editbox is also cleared.

On *:DIALOG:msgignoreusers:dclick:4: .remini settings.ini migusers $did(4).sel | migusersorder | migloadusers
; Deletes the entries and sorts everything when you doubleclick in the list in order to delete a nick

On *:DIALOG:msgignore:init:0: { 
  did -h $dname 16 | did -h $dname 18
  ;hides the modification buttons
  if ($migini(migset,view) == $null) { .writeini settings.ini migset view nothing }
  if ($migini(migset,flood) == $null) { .writeini settings.ini migset flood temp }
  ;checking for empty values
  if ($migini(migset,view) == nothing) { did -c $dname 11 }
  if ($migini(migset,view) == active) { did -c $dname 12 }
  if ($migini(migset,view) == custom) { did -c $dname 13 }
  ;checking the Display section and filling out the radio button in question
  if ($migini(migset,flood) == temp) { did -c $dname 21 }
  if ($migini(migset,flood) == perm) { did -c $dname 22 }
  if ($migini(migset,flood) == off) { did -c $dname 23 }
  ;checking the Flood Reaction section and filling out the appropriate section
  if ($migini(migset,text) == $true) { did -c $dname 15 | did -v $dname 16 }
  if ($migini(migset,reply) == $true) { did -c $dname 17 | did -v $dname 18 }
  if ($migini(migset,oppro) == $true) { did -c $dname 30 }
  if ($migini(migset,voicepro) == $true) { did -c $dname 31 }
}
; Loads all the settings when the dialog for the settings has first been opened

On *:DIALOG:msgignore:sclick:15: { if ($did($did).state == 1) { did -v $dname 16 } | else { did -h $dname 16 } }
On *:DIALOG:msgignore:sclick:17: { if ($did($did).state == 1) { did -v $dname 18 } | else { did -h $dname 18 } }
; Makes the Modify buttons appear and dissappear depending on whether their
; respective check boxes are checked or not

On *:DIALOG:msgignore:sclick:16:{ .timer 1 0 migask }
On *:DIALOG:msgignore:sclick:18:{ .timer 1 0 migask2 }

On *:DIALOG:msgignore:sclick:1: { 
  if ($did(11).state == 1) { writeini settings.ini migset view nothing }
  if ($did(12).state == 1) { writeini settings.ini migset view active }
  if ($did(13).state == 1) { writeini settings.ini migset view custom }
  if ($did(21).state == 1) { writeini settings.ini migset flood temp }
  if ($did(22).state == 1) { writeini settings.ini migset flood perm }
  if ($did(23).state == 1) { writeini settings.ini migset flood off }
  if ($did(15).state == 1) { writeini settings.ini migset text $true }
  else {  writeini settings.ini migset text $false }
  if ($did(17).state == 1) { writeini settings.ini migset reply $true }
  else {  writeini settings.ini migset reply $false }
  if ($did(30).state == 1) { writeini settings.ini migset oppro $true }
  else { writeini settings.ini migset oppro $false }
  if ($did(31).state == 1) { writeini settings.ini migset voicepro $true }
  else { writeini settings.ini migset voicepro $false }
}
; Saves the settings if you click on the OK button

; <>*<> Aliases <>*<>

alias -l migask { set %_temp $file="Current: $migini(migset,textfile) " $mircdir*.txt | migaska }
alias -l migask2 { set %_temp2 $$?="What message do you want to send to the people who msg you? $crlf $+ Current: $migini(migset,replytext) " | migaskb }
; Asks the questions for the modify button

alias migini { return $readini settings.ini $1 $2 }

alias -l migaska {
  if (%_temp) { writeini settings.ini migset textfile %_temp  }
  else { writeini settings.ini migset textfile msgignore.txt }
  if ($exists($migini(migset,textfile)) == $false) { .write $migini(migset,textfile) $chr(32) }
  unset %_temp
}
alias -l migaskb {
  if (%_temp2) { writeini settings.ini migset replytext %_temp2 }
  else { writeini settings.ini migset replytext Sorry, but I don't accept private chats. Talk to me in the channel. }
  unset %_temp2
}
alias -l migdelusers { 
  set %i 0 
  :loop 
  inc %i 
  if ($migini(migusers,%i) == $null) { goto end } 
  if ($migini(migusers,%i) == $$1) {
    remini settings.ini migusers %i 
    remini settings.ini migusers $$1 
    migusersorder 
    echo -a *** $$1 has been removed from the Msg Ignore Unaffected List 
    flushini settings.ini
    halt
  } 
  goto loop 
  echo -a *** $$1 is not in the user list
  :end 
}
alias -l migusersorder {
  set %i 0
  :loop
  inc %i
  if ($migini(migusers,%i) == $null) { goto checking }
  else { goto loop }
  :checking
  if ($migini(migusers,$calc(%i + 1)) == $null) { goto end }
  writeini settings.ini migusers %i $migini(migusers,$calc(%i + 1)) 
  flushini settings.ini
  remini settings.ini migusers $calc(%i + 1)
  goto loop
  :end
}
; Makes sure that there won't be any skipped numbers in the settings.ini
; file concerning the Unaffected list of users

alias -l migloadusers {
  if ($dialog(msgignoreusers).x != $null) { did -r msgignoreusers 4 }
  set %i 0
  :loop
  inc %i
  if ($migini(migusers,%i) == $null) { 
    if ($1) {
      .writeini settings.ini migusers %i $1
      if ($dialog(msgignoreusers).x != $null) { did -a msgignoreusers 4 $migini(migusers,%i) }
    }
    goto end 
  }
  if ($dialog(msgignoreusers).x != $null) { did -a msgignoreusers 4 $migini(migusers,%i) }
  goto loop
  :end
  unset %i
}
; Loads the Unaffected User List nick by nick into the List in the dialog
alias -l migcheckini  if ($migini(migcount,$1) <= 0) { flushini settings.ini | .remini settings.ini migcount $1 }
alias -l migwhatever { flushini settings.ini | .timer 1 0 remini settings.ini migcount $1 }

alias -l miguninstall {
  if ($?!="Uninstall Msg Ignore?" == $false) { goto end }
  if ($exists($migini(migset,textfile))) { .remove $migini(migset,textfile) }
  if ($exists(settings.ini)) { .remove settings.ini }
  echo -a *** Uninstalled $script
  .unload -rs " $+ $script $+ "
  :end
}  

alias -l migcheckstatus {
  set -u %u 0
  :loop
  inc %u 1
  if ($comchan($1,%u) == $null) { return $false }
  if (($1 isop $comchan($1,%u)) && ($migini(migset,oppro) == $true)) { return $true }
  if (($1 isvo $comchan($1,%u)) && ($migini(migset,voicepro) == $true)) { return $true }
  goto loop
}

#msgignore on
On ^*:TEXT:*:?:{
  if ($istok(%msg.users,$nick,46)) { remini settings.ini migcount $nick | set %mig.users $remtok(%mig.users,$nick,1,46) }
  if ($migcheckstatus($nick) == $true) { goto end }
  set %i 0
  :loop
  inc %i
  if ($migini(migusers,%i) == $null) { goto checking }
  if ($migini(migusers,%i) == $nick) { goto end }
  goto loop
  :checking
  if ($migini(migcount,$nick) >= 6) { 
    if ($migini(migset,flood) == perm) { ignore -p $nick | echo -a *** Ignoring $nick for MSG Flood | msg $nick You are being ignored for MSG Flood. }
    elseif ($migini(migset,flood) == temp) {
      ignore -pu15 $nick
      echo -a *** Ignoring $nick for MSG Flood (15 seconds) 
      msg $nick You are being ignored for MSG Flood. 
      set %mig.users $addtok(%mig.users,$nick,46) 
    }
    flushini settings.ini
    migwhatever $nick
    .timer 1 0 .closemsg $nick
    .haltdef
    goto end
  }
  writeini settings.ini migcount $nick $calc($migini(migcount,$nick) + 1)
  flushini settings.ini
  .timer 1 15 .writeini settings.ini migcount $nick $calc($migini(migcount,$nick) - 1)
  .timer 1 30 .migcheckini $nick
  if ($migini(migset,view) == active) { echo -athi2 2P6( $+ $nick $+ ) $1- }
  elseif ($migini(migset,view) == custom) { 
    if ($window(@MsgIgnore).x == $null) { window -dk +Le @MsgIgnore | echo $colour(Info2 text) -ti2 @MsgIgnore *** Opened Msg Saver on $date $+ , at $time } 
    echo -hi2 @MsgIgnore $timestamp 6( $+ $nick $+ ) $1- 
  }
  if ($migini(migset,text) == $true) { write $migini(migset,textfile) $timestamp ( $+ $nick $+ ) $1- }
  if ($migini(migset,reply) == $true) { msg $nick [Auto-Msg] $migini(migset,replytext) }
  .haltdef
  .timer 1 0 .closemsg $nick
  :end
  unset %i
  if ($migini(migcount,$nick) == 1) && ($query($nick) == $null) { whois $nick }
}
#msgignore end

On *:DISCONNECT: flushini settings.ini | remini settings.ini migcount
