
alias mplogo {
  if ($1 == nc) return Mplay 1.51
  ;  if ($1 == color) return 9,1  3M9P3l9a3y9 3v9 $+  $+ 13.9 $+  $+ 53        1,1 
  if ($1 == color) return 9,1  3M9P3l9a3y9 3v9 $+  $+ 13.9 $+  $+ 53 $+  $+ 19        1,1 
}

;####################### MPLAY RESPONDING TO SOUND REQUESTS #########################;

ctcp ^*:sound: {

  unset %fname
  unset %mandesc

  ;distinct between filename and description.

  if (. !isin $2-) { %fname = $2 | %descbeg = 2 | goto checkex }
  if (. isin $2) { %fname = $2 | %descbeg = 2 | goto checkex }
  %checkpoint = 0
  :checkpoint
  inc %checkpoint 1
  if (. !isin $gettok($2-,%checkpoint,32)) { %fname = %fname $gettok($2-,%checkpoint,32) | goto checkpoint }
  %fname = %fname $gettok($2-,%checkpoint,32)
  %descbeg = $calc(%checkpoint + 1)

  unset %checkpoint
  :checkex

  %checkpoint = %descbeg
  :chuckpoint
  if ($gettok($2-,%checkpoint,32) != $null) { %mandesc = %mandesc $gettok($2-,%checkpoint,32) | inc %checkpoint 1 | goto chuckpoint }
  unset %checkpoint

  if ($chan != $null) {
    if (%mandesc == $null) /echo $colour(ctcp) $chan [ $+ $nick SOUND] Playing %fname
    if (%mandesc != $null) /echo $colour(action) $chan * $nick %mandesc  $+ $colour(ctcp) $+ [Playing %fname $+ ]
  }
  if ($chan == $null) {
    if (%mandesc == $null) /echo $colour(ctcp) $nick [ $+ $nick SOUND] Playing %fname
    if (%mandesc != $null) /echo $colour(action) $nick * $nick %mandesc  $+ $colour(ctcp) $+ [Playing %fname $+ ]
  }
  checkini 18 n3
  if (%value == 1) {

    %extpos = $calc($pos(%fname,.,$pos(%fname,.,0)) + 1)
    %tmpext = $mid(%fname,%extpos,$calc($len(%fname) - %extpos + 1))
    %tmpini = $readini lock.ini Lock %tmpext
    if (%tmpini != $null) { echo $colour(info) -a * mplay: lock on filetype, ignoring request | goto end }

    if ($right(%fname,4) == .wav) {
      %play = $findfile($wavedir,%fname,1)
      if (%play != $null) splay " $+ %play $+ "
    }
    if ($right(%fname,4) == .mid) {
      %play = $findfile($mididir,%fname,1)
      if (%play != $null) splay " $+ %play $+ "
    }
    if ($right(%fname,4) != .mid) {
      if ($right(%fname,4) != .wav) {
        %play = $findfile($mplaydir(%fname),%fname,1)
        if (%play != $null) mrun %play
      }
    }
  }
  :end
  unset %value
  unset %fname
  unset %mandesc
  unset %extpos
  unset %tmpext
  unset %tmpini
  unset %play
  halt
}

;########################### MPLAY SENDING SOUND REQUESTS ###########################;

alias sound {
  %mchan = $chan
  mpsound $1-
  unset %mchan
}
alias mpsound {
  unset %fname
  unset %mandesc
  if ($1 == $null) { echo $colour(info) -a * mplay: Sound requests $srq | halt }
  %active = 0
  %checked = 0
  %sw = Status Window
  :checkactive
  inc %active 1
  if ($active == %sw) goto fail
  if ($active == %mchan) goto play
  if ($active == $chat(%active)) goto play
  if ($active == $query(%active)) goto play
  if (%active == $chat(0)) inc %checked 1
  if (%active == $query(0)) inc %checked 1
  if (%checked == 2) goto fail
  goto checkactive
  :fail
  linesep -s
  echo $colour(info) -a * mplay: you're not on a channel
  linesep -s
  unset %active
  unset %checked
  unset %sw
  halt
  :play

  ;distinct between filename and description.

  if (. !isin $1-) { %fname = $1 | %descbeg = 2 | goto checkex }
  if (. isin $1) { %fname = $1 | %descbeg = 2 | goto checkex }
  %checkpoint = 0
  :checkpoint
  inc %checkpoint 1
  if (. !isin $gettok($1-,%checkpoint,32)) { %fname = %fname $gettok($1-,%checkpoint,32) | goto checkpoint }
  %fname = %fname $gettok($1-,%checkpoint,32)
  %descbeg = $calc(%checkpoint + 1)

  unset %checkpoint
  :checkex
  %fname = $remove(%fname,")

  %checkpoint = %descbeg
  :chuckpoint
  if ($gettok($1-,%checkpoint,32) != $null) { %mandesc = %mandesc $gettok($1-,%checkpoint,32) | inc %checkpoint 1 | goto chuckpoint }
  %mandesc = $remove(%mandesc,")
  unset %checkpoint

  %autodesc = $getdesc($nopath(%fname))
  if (%sinfo == $null) %sinfo = on
  if (%sinfo == off) %2 = %autodesc %mandesc
  if ($mid(%fname,2,2) == :\) { if (%sinfo == on) %2 = $nopath(%fname) [ $+ $lof(%fname) bytes] %autodesc %mandesc - %mplay }
  if ($right(%fname,4) == .wav) || ($right(%fname,4) == .mid) {
    if ($mid(%fname,2,2) == :\) {
      if ($exists(%fname) == $true) {
        .ctcp $active sound $nopath(%fname) %2
        if (%2 == $null) echo $colour(ctcp) -a [SOUND]
        if (%2 != $null) echo $colour(action) -a * $me %2
        msplay %fname
      }
      else { echo $colour(info) -a * mplay: no such file ' $+ $nopath(%fname) $+ ' | goto cleanup }
    }
    else {
      if ($right(%fname,4) == .wav) %play = $findfile($wavedir,%fname,1)
      if ($right(%fname,4) == .mid) %play = $findfile($mididir,%fname,1)
      if (%play == $null) echo $colour(info) -a * mplay: no such file ' $+ %fname $+ '
      if (%play != $null) {
        if (%sinfo == on) %2 = $nopath(%fname) [ $+ $lof(%play) bytes] %autodesc %mandesc - %mplay
        .ctcp $active sound $nopath(%fname) %2 
        if (%2 == $null) echo $colour(ctcp) -a [SOUND]
        if (%2 != $null) echo $colour(action) -a * $me %2
        msplay %fname
      }
    }
    unset %play
    unset %2
    halt
  }
  else {
    if ($mid(%fname,2,2) == :\) {
      if ($exists(%fname) == $true) {
        .ctcp $active sound $nopath(%fname) %2
        if (%2 == $null) echo $colour(ctcp) -a [SOUND]
        if (%2 != $null) echo $colour(action) -a * $me %2
        mrun %fname
      }
      else { echo $colour(info) -a * mplay: no such file ' $+ $nopath(%fname) $+ ' | goto cleanup }
    }
    else {
      %play = $findfile($mplaydir(%fname),%fname,1)
      if (%play == $null) { echo $colour(info) -a * mplay: no such file ' $+ %fname $+ ' | goto cleanup }
      else {
        if (%sinfo == on) %2 = $nopath(%fname) [ $+ $lof(%play) bytes] %autodesc %mandesc - %mplay
        .ctcp $active sound $nopath(%fname) %2
        if (%2 == $null) echo $colour(ctcp) -a [SOUND]
        if (%2 != $null) echo $colour(action) -a * $me %2
        mrun %play
      }
    }
  }
  :cleanup
  unset %fname
  unset %mandesc
  unset %play
  unset %2
  unset %autodesc
}

;############################# MPLAY CONTROLLED COMMANDS ############################;

; RUNNING FILES LIKE NORMAL BUT CHECKING THEIR DEFAULT DIR IF NONE IS SPECIFIED

alias fplay {
  if ($mid($1,2,2) == :\) {
    if ($exists($1-) == $true) mrun 
    else echo $colour(info) -a * /fplay: no such file: ' $+ $nopath($1-) $+ '
  }
  else {
    %play = $findfile($mplaydir($1-),$1-,1)
    if (%play != $null) mrun %play
    else echo $colour(info) -a * /fplay: no such file: ' $+ $1- $+ '
  }
}

; WILDCARD SUPPORT IN /SPLAY EVEN IF A DIR IS SPECIFIED

alias msplay {
  if ($nopath($1-) == $1-) {
    if ($right($1-,4) == .mid) splay " $+ $findfile($mididir,$nopath($1-),1) $+ "
    if ($right($1-,4) == .wav) splay " $+ $findfile($wavedir,$nopath($1-),1) $+ "
  }
  else {
    if ($right($1-,4) == .mid) splay " $+ $findfile($nofile($1-),$nopath($1-),1) $+ "
    if ($right($1-,4) == .wav) splay " $+ $findfile($nofile($1-),$nopath($1-),1) $+ "
  }
}

; RUNNING FILES WITH THE PROGRAM ASSOCIATED IN EXTS.INI

alias mrun {
  %extpos = $calc($pos($1-,.,$pos($1-,.,0)) + 1)
  %tmpext = $mid($1-,%extpos,$calc($len($1-) - %extpos + 1))
  %tmpini = $readini exts.ini Extensions %tmpext
  if (%tmpini != $null) {
    if ($exists(%tmpini)) run %tmpini " $+ $1- $+ "
    else { echo $colour(info) -a * mplay: the file associated to %tmpext files does not exist | goto end }
  }
  else run $1-
  splay stop
  :end
  unset %extpos
  unset %tmpext
  unset %tmpini
}

; PLAYING A RANDOM FILE

alias rndplay {
  %tmprnd = $findfile($1,$2,$rand(1,$findfile($1,$2,0)))
  if (%tmprnd == $null) { echo $colour(info) -a * mplay: random play couldn't find any matching file | .timer3554 off }
  else sound %tmprnd
}

; ADDING A DESCRIPTION TO THE DESCRIPTION DATABASE

alias adddesc {
  if ($1 != $null) { %tmpfname = $1- | goto desc }
  :fname
  %tmpfname = $?="Select a file name"
  if (%tmpfname == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
  :desc
  %origfname = %tmpfname
  %tmpfname = $replace(%tmpfname,$chr(32),?)
  %tmpdesc = $?="Write a brief description:"
  if (%tmpdesc == $null) goto desc
  writeini filedesc.ini Descriptions %tmpfname %tmpdesc
  echo $colour(info) -a * mplay: added a predefined description for %origfname
  :end
  unset %origfname
  unset %tmpfname
  return %tmpdesc
  unset %tmpdesc
}

;################################## MPLAY IDENTIFIERS #################################;

; CHECKS WETHER SOUND REQUESTS IS ON OR OFF

alias srq {
  if ($checkini(18,n3) == 1) return ON
  else return OFF
}

; GETS THE DESCRIPTION FOR A FILENAME IF ANY

alias getdesc {
  if (%shodesc == no) { return $null | halt }
  if ($checkhl($1-) != $null) return $checkhl($1-)
  else {
    %temporary = $replace($1-,$chr(32),?)
    %temporary = $remove(%temporary,")
    %filedesc = $readini filedesc.ini Descriptions %temporary
    if (%filedesc != $null) return %filedesc
    else {
      if (%askdesc != on) return $null
      if (%askdesc == on) {
        if ($?!="' $+ $1- $+ ' does not have a description, do you want to add one?" == $false) return $null
        else return $adddesc($1-)
      }
    }
  }
  unset %temporary
  unset %filedesc
  unset %askdesc
}

; CHECKS THE HL DESCRIPTION FILE FOR A DESCRIPTION

alias checkhl {
  unset %curfile
  unset %curdir
  unset %checkdir
  unset %dirdesc
  %checkdir = 0
  :loop
  inc %checkdir 1
  %curdir = $readini hlptit.ini Directory %checkdir
  if (%curdir == $null) goto end
  %dirdesc = $readini hlptit.ini %curdir desc
  %curfile = $readini hlptit.ini %curdir $1
  if (%curfile != $null) goto end
  goto loop
  :end
  if (%curfile == $null) return $null
  else return %curfile %dirdesc
}

; CHECKS THE mIRC OPTIONS

alias checkini {
  %ini = $readini mirc.ini options $2
  %comma = ,
  %value = $mid(%ini,$calc($pos(%ini,%comma,$1)+1),1)
  return $mid(%ini,$calc($pos(%ini,%comma,$1)+1),1)
}

; CHECKS WHERE TO FIND A FILE WITH CERTAIN SPECS BY LOOKING IN THE DATABASE

alias mplaydir {
  %maxdir = $readini mdirs.ini maxdir maxdir
  if (%maxdir == $null) goto endtwo
  :loop
  %dirini = $readini mdirs.ini wildcards %maxdir
  if (%dirini iswm $1-) goto endone
  dec %maxdir 1
  if (%maxdir == 0) goto endtwo
  goto loop
  :endone
  %dirini = $readini mdirs.ini dirs %maxdir
  if ($right(%dirini,1) == \) return %dirini
  else return %dirini $+ \
  goto end
  :endtwo
  return $wavedir
  :end
  unset %dirini
  unset %maxdir
}

; CHECKS WHERE A FILESPEC IS LOCATED IN MDIRS.INI IF IT IS THERE (ELSE RETURNING "ERROR")

alias findinini {
  %maxini = $readini $1 maxdir maxdir
  if (%maxini == $null) { unset %maxini | return error | halt }
  :loop
  %tmpini = $readini $1 $2 %maxini
  if (%tmpini == $3) { return %maxini | unset %tmpini | unset %maxini | halt }
  dec %maxini 1
  if (%maxini == 0) { unset %tmpini | unset %maxini | return error | halt }
  goto loop
}

; GETS THE FIRST WORD OF A STRING

alias firstword {
  return $1
}

; RETURNS THE REQUIRED MENU STRINGS

alias pmenuline {
  if ($1 == request) {
    if ($checkini(18,n3) == 1) return Don't accept sound requests
    else return Accept sound requests
    halt
  }
  return dummy
}

alias acceptrequest {
  if ($checkini(18,n3) == 1) return Don't accept file requests
  else return Accept file requests
}

; ################################### MPLAY MENUS ####################################;

; CHANNEL MENU

menu Channel {
  -
  &Mplay
  .&Advertise Mplay:describe $chan is using %mplay by 4,1|Sumez| 1- Get it at http://home7.inet.tele.dk/mrs/mplay
  .&Play a file: {
    %tmpsnd = $?="What file do you wish to play?"
    if (%tmpsnd == $null) { unset %tmpsnd | echo $colour(info) -a * mplay: dialog aborted | halt }
    %tmpsnd = %tmpsnd $?="Add an optional description?"
    sound %tmpsnd
    unset %tmpsnd
  }
  .Play a &random file: {
    :dire
    %dire = $?="Select a directory:"
    if (%dire == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    if ($mid(%dire,2,2) != :\) || ($exists(%dire) == $false) { echo $colour(info) -a * mplay: invalid dir | goto dire }
    :specs
    %specs = $?="Select filespecs(eg. *.mp3):"
    if (%specs == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    rndplay %dire %specs
    :end
    unset %dire
    unset %specs
  }
  &Launch Mplay console: mdialog
}

; MAIN MENU

menu Menubar {
  -
  &Mplay
  .Displaying file &info
  ..&Display file info on play:set %sinfo on | echo $colour(info) -a * mplay: now displaying file name and size and Mplay logo when playing a file
  ..Do&n't display file info on play:set %sinfo off | echo $colour(info) -a * mplay: not displaying file info
  .&Associate filetype
  ..&New: {
    :ext
    %tmpext = $?="Select a file extension (eg. mp3)"
    if ($left(%tmpext,1) == .) %tmpext = $right(%tmpext,$calc($len(%tmpext) - 1))
    if (%tmpext == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    :prog
    %tmpprog = $?="Write the full path of the program you want to use to open %tmpext files (eg. C:\winamp.exe)"
    if (%tmpprog == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    writeini exts.ini Extensions %tmpext %tmpprog
    echo $colour(info) -a * mplay: program %tmpprog associated to %tmpext
    :end
    unset %tmpext
    unset %tmpprog
  }
  ..&Delete {
    %tmpext = $?="Select a file extension (eg. mp3)"
    if ($left(%tmpext,1) == .) %tmpext = $right(%tmpext,$calc($len(%tmpext) - 1))
    if (%tmpext == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    remini exts.ini Extensions %tmpext
    echo $colour(info) -a * mplay: deleted the %tmpext association.
    :end
    unset %tmpext
  }
  .&Descriptions
  ..&Add/change file description:adddesc
  ..&Don't show descriptions: echo $colour(info) -a * mplay: no descriptions will be shown even if one is found | %shodesc = no
  ..&Show descriptions: echo $colour(info) -a * mplay: now showing descriptions is found | %shodesc = yes
  ..&Request description if none found: echo $colour(info) -a * mplay: now requesting descriptions | %askdesc = on
  ..&Don't request description: echo $colour(info) -a * mplay: not requesting descriptions | unset %askdesc
  .&Custom dirs
  ..&Add dir: {
    %tempset = $?="Select filespecs(eg. ff6*.mp*):"
    if (. !isin %tempset) goto end
    %tempsat = $?="Select a directory(eg. c:\mp3\ff6):"
    if (: !isin %tempsat) goto end
    %maxdir = $readini mdirs.ini maxdir maxdir
    if (%maxdir == $null) %maxdir = 1
    else %maxdir = $calc(%maxdir + 1)
    writeini mdirs.ini maxdir maxdir %maxdir
    writeini mdirs.ini wildcards %maxdir %tempset
    writeini mdirs.ini dirs %maxdir %tempsat
    echo $colour(info) -a * mplay: dir for %tempset set as %tempsat
    unset %tempsat
    unset %tempset
    unset %maxdir
    halt
    :end
    unset %tempsat
    unset %tempset
    unset %maxdir
    echo $colour(info) -a * mplay: dialog aborted
  }
  ..&Change dir: {
    %tempspecs = $?="What wildcard match do you want to change?(eg. ff6*.mp*):"
    if (%tempspecs == $null) goto errorend
    if ($findinini(mdirs.ini,wildcards,%tempspecs) == error) goto errorend
    %tempdir = $?="Select directory(eg. c:\mp3):"
    if (: !isin %tempdir) goto end
    writeini mdirs.ini dirs $findinini(mdirs.ini,wildcards,%tempspecs) %tempdir
    unset %tempdir
    unset %tempspecs
    halt
    :errorend
    unset %tempsepcs
    echo $colour(info) -a * mplay: no directory is specified for those filespecs
    halt
    :end
    unset %tempdir
    unset %tempspecs
    echo $colour(info) -a * mplay: please write a valid directory
  }
  .&File lock
  ..Add a file lock: {
    %ftype = $?="Enter a file type (.eg exe or .com)."
    if ($left(%ftype,1) == .) %ftype = $right(%ftype,$calc($len(%ftype) - 1))
    if (%ftype == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    writeini lock.ini Lock %ftype dummy
    echo $colour(info) -a * mplay: added request lock for %ftype files
    :end
    unset %ftype
  }
  ..Remove a file lock: {
    %ftype = $?="Enter a file type (.eg exe or .com)."
    if ($left(%ftype,1) == .) %ftype = $right(%ftype,$calc($len(%ftype) - 1))
    if (%ftype == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    %tmpini = $readini lock.ini Lock %ftype
    if (%tmpini == $null) { echo $colour(info) -a * mplay: file lock does not exist | goto end }
    remini lock.ini Lock %ftype
    echo $colour(info) -a * mplay: removed request lock for %ftype files
    :end
    unset %ftype
    unset %tmpini
  }
  .&Random play
  ..Play &random file: {
    :dire
    %dire = $?="Select a directory:"
    if (%dire == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    if ($mid(%dire,2,2) != :\) || ($exists(%dire) == $false) { echo $colour(info) -a * mplay: invalid dir | goto dire }
    :specs
    %specs = $?="Select filespecs(eg.*.mp3):"
    if (%specs == $null) { echo $colour(info) -a * mplay: dialog aborted | goto end }
    rndplay %dire %specs
    :end
    unset %dire
    unset %specs
  }
  ..&Start random play: {
    :interval
    %interval = $?="How many seconds between each file?"
    if (%interval < 10)  { echo $colour(info) -a * mplay: too low interval | goto end }
    if (%interval > 99999999)  { echo $colour(info) -a * mplay: far too big interval | goto end }
    :dir
    %dire = $?="Select a directory:"
    if ($mid(%dire,2,2) != :\) goto dir
    :specs
    %specs = $?="Select filespecs(*.mp3):"
    if (%specs == $null) goto specs
    .timer3554 0 %interval /rndplay %dire %specs
    rndplay %dire %specs
    :end
    unset %interval
    unset %dire
    unset %specs
  }
  ..S&top random play: { echo $colour(info) -a * mplay: random play stopped | .timer3554 off }
  .Mplay &logo
  ..&Don't color Mplay logo: echo $colour(info) -a * mplay: not coloring Mplay logo | %nocol = on | %mplay = $mplogo(nc)
  ..&Color Mplay logo: echo $colour(info) -a * mplay: now coloring Mplay logo | unset %nocol | %mplay = $mplogo(color)
  .&Tip of the day
  ..&Don't show tip a startup: echo $colour(info) -a * mplay: Tip of the day disabled | %totd = off
  ..&Show tip at startup: echo $colour(info) -a * mplay: Tip of the day enabled | unset %totd

  .Launch &Mplay console: mdialog
  .&Help: mhelp
}

; #################################### STARTUP SETTINGS ###############################;

on 1:start: {
  .load -rs mhelp.mrc
  if (%nocol == $null)  %mplay = $mplogo(color)
  if (%sinfo == $null) set %sinfo on
  if (%nocol != $null) %mplay = $mplogo(nc)

  if (%smsg == $null) {
    linesep
    echo -a Welcome, you are using %mplay
    echo -a To configure and play around with Mplay, use the Mplay menu, which you find in the menu called "Commands" in the menu bar.
    echo -a It may have a different name depending on any loaded scripts, but you will find it between "DCC" and "Window".
    echo -a Remember: You need to unlock the command /run in order to play secondary file types!
    linesep
    echo -a Mplay is a mIRC enhancement, so you just need to use the /sound command in order to play files using Mplay. Have fun.
    echo -a This welcome message won't appear again.
    linesep
    echo -a -- Visit the Mplay homepage at: 12http://home7.inet.tele.dk/mrs/mplay
    echo -a -- Got any trouble? Click the help button on the console!
    mdialog
    set %smsg done
  }
  if (%totd == $null) {
    linesep
    if ($exists(mtips.txt)) echo $colour(info) -a * mplay: Tip of the day: $read mtips.txt
    else echo $colour(info) -a * mplay: Couldn't find tip of the day file 'mtips.txt'
  }
}


;################################## THE MPLAY CONSOLE ###############################;

ctcp 1:version: .ctcpreply $nick VERSION - Enhanced /sound feature and sound handling by %mplay - http://home7.inet.tele.dk/mrs/mplay

on 1:dialog:Mplay:sclick:210:{
  run http://home7.inet.tele.dk/mrs/mplay
}
on 1:dialog:Mplay:sclick:321:{
  run mailto:mrs@post7.tele.dk
}

dialog Mplay {
  title "Mplay 1.51 console"
  size -1 -1 170 130
  option dbu

  tab "File database", 61, 3 1 167 120
  tab "Options", 62
  tab "About", 63

  text "Mplay version 1.51 by Morten 'Sumez' Riis Svendsen", 346,  20 80 150 10, tab 63
  button "&Visit the Mplay homepage", 210, 22 90 120 10, default tab 63
  button "&Write feedback to the author", 321, 22 100 120 10, default tab 63

  list 35, 7 18 100 75, extsel vsbar size tab 61
  button "&Add file", 123, 110 20 30 12, default tab 61
  button "&Remove file", 234, 110 35 35 12, default tab 61
  button "&Play file", 345, 110 77 35 12, default tab 61

  edit "", 25, 110 50 55 10, autohs tab 61
  button "&Update description", 410, 110 62 50 12, default tab 61

  check "Display file info", 1, 7 20 100 10, tab 62
  check "Color Mplay logo", 2, 7 35 100 10, tab 62
  check "Show tip of the day at startup", 3, 7 50 100 10, tab 62
  check "Request file description if none found", 4, 7 65 100 10, tab 62

  button "&Close", 400, 10 129 25 12, ok
  button "&Help", 500, 135 129 25 12, default

  ; text "File playin", 64, 5 5 200 20
  radio "#1", 101, 10 100 20 10, push, tab 61
  radio "#2", 102, 30 100 20 10, push, tab 61
  radio "#3", 103, 50 100 20 10, push, tab 61
  radio "#4", 104, 70 100 20 10, push, tab 61
  radio "#5", 105, 90 100 20 10, push, tab 61
  radio "#6", 106, 10 110 20 10, push, tab 61
  radio "#7", 107, 30 110 20 10, push, tab 61
  radio "#8", 108, 50 110 20 10, push, tab 61
  radio "#9", 109, 70 110 20 10, push, tab 61
  radio "#10", 110, 90 110 20 10, push, tab 61
}
on 1:dialog:Mplay:init:*:{
  if (%askdesc == tempoff) %askdesc = on
  if (%sinfo != off) did -c Mplay 1
  if ($left(%mplay,1) != M) did -c Mplay 2
  if (%totd != off) did -c Mplay 3
  if (%askdesc == on) did -c Mplay 4
  if (%curdb == $null) %curdb = $mircdir\filelist.ini
  did -c mplay 101
  %listmp = 1
  if (%mdlist == 2) { did -c mplay 102 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 3) { did -c mplay 103 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 4) { did -c mplay 104 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 5) { did -c mplay 105 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 6) { did -c mplay 106 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 7) { did -c mplay 107 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 8) { did -c mplay 108 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 9) { did -c mplay 109 | did -u mplay 101 | %listmp = 0 }
  if (%mdlist == 10) { did -c mplay 110 | did -u mplay 101 | %listmp = 0 }
  if (%listmp == 1) %mdlist = 1
  loadlist
}
on 1:dialog:Mplay:sclick:35:{
  upddesc
}
on 1:dialog:Mplay:sclick:123:{
  savelist
  dialog -x Mplay
  .timer399 -m 1 1 addfile
}
on 1:dialog:Mplay:sclick:234:{
  if ($did(Mplay,35,1).sel != $null) did -d Mplay 35 $did(Mplay,35,1).sel
  savelist
}
on 1:dialog:Mplay:sclick:345:{
  %mchan = $active
  %temp = $did(35,$did(Mplay,35,1).sel).text
  if (%temp == $null) goto end
  %file = $left(%temp,$calc($pos(%temp,<,1) - 2))
  %dir = $mid(%temp,$calc($pos(%temp,<,1) + 1),$calc($len(%temp) - $len(%file) - 3))
  if (%askdesc == on) %askdesc = tempoff
  mpsound %dir $+ %file
  if (%askdesc == tempoff) %askdesc = on
  :end
  unset %mchan
  unset %temp
}
on 1:dialog:Mplay:sclick:410:{
  unset %tmp
  %temp = $did(Mplay,35,$did(Mplay,35,1).sel).text
  if (%temp == $null) goto end
  %file = $left(%temp,$calc($pos(%temp,<,1) - 2))
  %tmpfile = $replace(%file,$chr(32),?)
  if ($did(25).text == $null) { remini filedesc.ini Descriptions %tmpfile | echo $colour(info) -a * mplay: description for %file deleted }
  else { writeini filedesc.ini Descriptions %tmpfile $did(25).text | echo $colour(info) -a * mplay: new preset description for %file }
  :end
  unset %temp
  unset %tmp
  unset %tmpfile
  unset %file
}
on 1:dialog:Mplay:sclick:1:{
  if ($did(1).state = 1) { set %sinfo on | echo $colour(info) -a * mplay: now displaying file name and size and Mplay logo when playing a file }
  if ($did(1).state = 0) { set %sinfo off | echo $colour(info) -a * mplay: not displaying file info }
}
on 1:dialog:Mplay:sclick:2:{
  if ($did(2).state = 1) { echo $colour(info) -a * mplay: now coloring Mplay logo | unset %nocol | %mplay = $mplogo(color) }
  if ($did(2).state = 0) { echo $colour(info) -a * mplay: not coloring Mplay logo | %nocol = on | %mplay = $mplogo(nc) }
}
on 1:dialog:Mplay:sclick:3:{
  if ($did(3).state = 1) { echo $colour(info) -a * mplay: Tip of the day enabled | unset %totd }
  if ($did(3).state = 0) { echo $colour(info) -a * mplay: Tip of the day disabled | %totd = off }
}
on 1:dialog:Mplay:sclick:4:{
  if ($did(4).state = 1) { echo $colour(info) -a * mplay: now requesting descriptions | %askdesc = on }
  if ($did(4).state = 0) { echo $colour(info) -a * mplay: not requesting descriptions | unset %askdesc }
}
on 1:dialog:Mplay:dclick:35:{
  %mchan = $active
  %temp = $did(35,$did(Mplay,35,1).sel).text
  if (%temp == $null) goto end
  %file = $left(%temp,$calc($pos(%temp,<,1) - 2))
  %dir = $mid(%temp,$calc($pos(%temp,<,1) + 1),$calc($len(%temp) - $len(%file) - 3))
  if (%askdesc == on) %askdesc = tempoff
  mpsound %dir $+ %file
  if (%askdesc == tempoff) %askdesc = on
  :end
  unset %mchan
  unset %temp
}

alias addfile {
  %tmpfile = $dir="Select a file to add" $wavedir\*.*
  if (%tmpfile == $null) goto end1
  dialog -mt Mplay Mplay
  chklist $nopath(%tmpfile) < $+ $nofile(%tmpfile) $+ >
  did -a Mplay 35 $nopath(%tmpfile) < $+ $nofile(%tmpfile) $+ >
  did -c Mplay 35 $did(Mplay,35).lines
  upddesc
  savelist
  goto end
  :end1
  dialog -mt Mplay Mplay
  :end
  unset %tmpname
}
alias loadlist {
  did -r mplay 35
  if (%curdb == $null) %curdb = $mircdir\filelist.ini
  %temp = 0
  if ($mdlist == 1) %listno = List
  else %listno = List $+ $mdlist
  :loop
  inc %temp 1
  %tmp = $readini %curdb %listno %temp
  if (%tmp == $null) goto end
  did -a Mplay 35 %tmp
  goto loop
  :end
  unset %tmp
  unset %temp
}
alias chklist {
  %temp = 0
  :loop
  inc %temp 1
  %tmp = $did(Mplay,35,%temp).text
  if (%tmp == $null) goto end
  if (%tmp == $1-) did -d Mplay 35 %temp
  goto loop
  :end
  unset %tmp
  unset %temp
}
alias savelist {
  if (%curdb == $null) %curdb = $mircdir\filelist.ini
  if (%mdlist == 1) %listno = List
  else %listno = List $+ %mdlist
  remini %curdb %listno
  %temp = 0
  if (%temp == $did(Mplay,35).lines) goto end
  :loop
  inc %temp 1
  %tmp = $did(Mplay,35,%temp).text
  writeini %curdb %listno %temp %tmp
  if (%temp == $did(Mplay,35).lines) goto end
  goto loop
  :end
  unset %tmp
  unset %temp
}
alias upddesc {
  unset %tmp
  %temp = $did(Mplay,35,$did(Mplay,35,1).sel).text
  if (%temp == $null) goto end
  %file = $left(%temp,$calc($pos(%temp,<,1) - 2))
  %file = $replace(%file,$chr(32),?)
  %tmp = $readini filedesc.ini Descriptions %file
  :end
  did -r Mplay 25
  did -a Mplay 25 %tmp
}
alias mdialog dialog -mt Mplay Mplay
on 1:dialog:Mplay:sclick:500:{ dialog -x Mplay Mplay | mhelp }

alias mdlist {
  if ($did(mplay,101).state == 1) %Ltemp = 1
  if ($did(mplay,102).state == 1) %Ltemp = 2
  if ($did(mplay,103).state == 1) %Ltemp = 3
  if ($did(mplay,104).state == 1) %Ltemp = 4
  if ($did(mplay,105).state == 1) %Ltemp = 5
  if ($did(mplay,106).state == 1) %Ltemp = 6
  if ($did(mplay,107).state == 1) %Ltemp = 7
  if ($did(mplay,108).state == 1) %Ltemp = 8
  if ($did(mplay,109).state == 1) %Ltemp = 9
  if ($did(mplay,110).state == 1) %Ltemp = 10
  return %Ltemp
  unset %Ltemp
}
on 1:dialog:Mplay:sclick:101:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:102:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:103:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:104:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:105:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:106:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:107:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:108:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:109:savelist | %mdlist = $mdlist | loadlist
on 1:dialog:Mplay:sclick:110:savelist | %mdlist = $mdlist | loadlist
