;Title:     Mix
;Author:    grammar
;Version:   v1.00
;File Name: gmix.mrc [zipped: gmix.ico]

;<aliases>
alias mver return v1.00
alias mix {
  %mix.monkey = $scriptdir $+ gmix.ico
  if ($exists(%mix.monkey) == $true) { 
    .echo $colour(info) -s *** Loading: %mix.monkey graphic.
    if ($dialog(gmix) == $null) { .dialog -m gmix mix1 } | else { .echo $colour(info) -a *** Error: Mix $mver is already running. | halt }
    else { .echo $colour(info) -a *** Error: Couldn't find %mix.monkey $+ . Unzip the Script again and ReInstall. | return }
  }
}
alias mix.scoreT if ($dialog(mixT) == $null) { .dialog -m mixT mix3 } | else { return }
alias mixv .did -v gmix $1
alias mixh .did -h gmix $1
alias mix.fscore %mix.fscore = %mix.score | .dialog -m mixs mix2 
alias mix.start %mix.rand = $rand(1,3) | mix.em | .did -ra gmix 8 randomizing...
alias mix.em .did -b gmix 16 | .did -b gmix 17 | .timerm1 10 0 mix.rand |  .timerm2 10 0 mix.rand2 | .timerm3 1 2.5 .mix.final
alias mix.rand %mix.emr = $rand(9,14) | .did -v gmix %mix.emr
alias mix.rand2 %mix.emr2 = $rand(9,14) | .did -v gmix %mix.emr2
alias mix.final {
  %gmix.click = 0 | mixv 10 | mixv 12 | mixv 14  
  mixh 3 | mixh 9 | mixh 11 | mixh 13
  .did -ra gmix 8 select a cup
  if (%mix.rand == 1) { mixh 11 | mixh 13 }
  if (%mix.rand == 2) { mixh 9 | mixh 13 }
  if (%mix.rand == 3) {  mixh 9 | mixh 11 }
}  
alias mix.right {
  inc %mix.score 3 | .did -ra gmix 19 %mix.score
  .did -ra gmix 8 correct.. hit next
  .did -e gmix 15 | .did -e gmix 17
}
alias mix.wrong {
  if (%mix.score < -4) { goto next }
  else { dec %mix.score | goto next }
  :next 
  .did -ra gmix 19 %mix.score
  .did -ra gmix 8 wrong.. hit next 
  .did -e gmix 15 | .did -e gmix 17
  if (%mix.rand == 1) { mixv 9 | mixhb }
  if (%mix.rand == 2) { mixv 11 | mixhb }
  if (%mix.rand == 3) { mixv 13 | mixhb }
}
alias mixhb mixh 10 | mixh 12 | mixh 14 
alias mix.done {
  .write Scores.txt $me ( $+ %mix.score $+ pts) [( $+ $date $+ / $+ $time(hh:nn:sstt) $+ )]
  mix.fscore %mix.score | unset %mix.hscore
  if (%mix.score > %mix.best) { %mix.hscore = TRUE | %mix.best = %mix.score | %mix.bestU = $me }
  %mix.score = 0 | .did -ra gmix 8 Mix v1.00 by grammar | .did -ra gmix 19 0
  .did -e gmix 16 | .did -b gmix 15 | .did -b gmix 17 
}
;<dialogs>
dialog mix1 {
  title "Mix v1.00 [Find the Monkey]"
  size -1 -1 350 180
  menu "File", 1
  item "High &Scores", 2
  item "&Readme", 3
  item break, 4
  item "E&xit Mix", 5, ok
  box "&Game Table", 6,2 30 345 90
  box "", 7,217 2 130 30
  text "Mix v1.00 by grammar", 8,220 13 125 15, center
  icon 9,30 60 50 50, %mix.monkey 
  button "C&UP 1", 10,25 55 80 55, hide
  icon 11,140 60 50 50, %mix.monkey
  button "C&UP 2", 12,135 55 80 55, hide
  icon 13,250 60 50 50, %mix.monkey
  button "C&UP 3", 14,245 55 80 55, hide
  button "&Stop", 15,265 125 80 30, disable   
  button "&Start", 16,183 125 80 30
  button "Ne&xt >>", 17,100 125 80 30, disable
  text "Score:", 18,2 123 50 15 
  edit "", 19,2 140 80 20, read
}
on *:dialog:gmix:init:*:%mix.score = 0
on *:dialog:gmix:menu:*: {
  if ($did == 2) { mix.ScoreT }
  if ($did == 3) { .run $scriptdir $+ mixReadme.txt }
}

on *:dialog:gmix:sclick:*: {
  if ($did == 16) { mix.start }
  if ($did == 15) { mix.done }
  if ($did == 17) { mix.start }
  if ($did == 10) {
    if (%gmix.click == 0) { 
      if (%mix.rand == 1) { mixh $did | mixv 9 | .mix.right }
      else { %gmix.click = 1 | .mix.wrong }
    }  
    else { return }
  }
  if ($did == 12) { 
    if (%gmix.click == 0) { 
      if (%mix.rand == 2) { mixh $did | mixv 11 | .mix.right }
      else { %gmix.click = 1 | .mix.wrong }
    }  
    else { return }
  }
  if ($did == 14) {
    if (%gmix.click == 0) { 
      if (%mix.rand == 3) { mixh $did | mixv 13 | .mix.right }
      else { %gmix.click = 1 | .mix.wrong }
    }  
    else { return }
  }
}
dialog mix2 {
  title "Mix v1.00 [Game Over]"
  size -1 -1 200 100
  button "O&K", 1,65 75 80 23, ok
  text "", 2,0 30 200 15, center
  text "", 3,0 5 200 15, center
}
on *:dialog:mixs:init:*: {
  if (%mix.hscore == TRUE) { .did -ra mixs 3 YOU HAVE THE HIGH SCORE! }
  .did -ra mixs 2 Final Score: %mix.score  
}
dialog mix3 {
  title "Mix v1.00 [High Scores]"
  size -1 -1 280 125
  button "&Close", 1,197 100 80 23, ok
  list 2,5 5 270 90, sort
  text "High Score: grammar (20pts)", 3,2 105 190 15, center
} 
on *:dialog:mixT:init:*: {
  %mix.scorefile = $mircdir $+ scores.txt
  if ($exists(%mix.scorefile) == $true) { 
    %mix.H1 = 0 | %mix.H2 = $lines(%mix.scorefile) 
    :loop
    inc %mix.H1 
    if (%mix.h1 > %mix.h2) { .did -ra mixT 3 High Score: %mix.bestU ( $+ %mix.best $+ pts) | return }
    else { .did -a mixT 2 $read -l $+ %mix.H1 %mix.scorefile | goto loop }
    halt
  }
  else { .did -a mixT 2 No File Found | .did -a mixt 2 Please make sure scores are saved. | return }
}
;<events>
on *:load: { 
  if ($version < 5.8) { .unload $script | .echo -a $colour(info) -a *** You need mIRC32 v45.8 $+ $colour(info) to run this script. 12http://www.mirc.net | return }
  echo $colour(info) -a *** Loaded Mix $mver [Find the Monkey]  
  echo $colour(info) -a *** To play type /mix or check the Menus.
  %mix.best = 0
  %mix.bestU = grammar
}

;<menus>
menu channel {
  Mi&x v1.00
  .&Mix:.mix
  .-
  .High &Scores:.mix.ScoreT 
  .&Readme:.run $scriptdir $+ mixReadme.txt
  .-
  .Unload:.unload $script | .echo $colour(info) -a *** Unloaded: Mix $mver was unloaded. | return 
}

;<END>
