;----------------------------------------------------------------------------------------------------------------------------------------------------------------------
;MCI Mp3 Player
;Author: Kona
;Thanks to DragonZap, for creating and allowing me to use his Media Control Interface DLL.
;----------------------------------------------------------------------------------------------------------------------------------------------------------------------



menu menubar {
  .Mp3 Player: mplay 
}
alias emp { return $dll($dlldir,MCIString,$1-) }
alias -l dlldir { 
  var %dll.dir
  set %dll.dir $scriptdir $+ mci.dll 
  return %dll.dir
} 
alias mplay { 
  var %mode.check
  set %mode.check $emp(status mircmp3 mode)
  dialog -md mp3 mp3 
}
alias -l addfile { 
  var %filetoadd
  set %filetoadd $file *.mp3
  write $scriptdirplaylist.txt %filetoadd
  did -a mp3 8 %filetoadd
}

dialog mp3 {
  size -1 -1 425 340
  title "MCI Mp3 Player"
  Button "Close" 1,355 150 60 20,ok
  edit "" 2, 8 175 410 20,read
  Button "Pause" 3, 280 150 60 20
  Button ">>" 4, 212 150 60 20
  Button "Play" 5, 145 150 60 20
  Button "<<" 6, 77 150 60 20
  Button "Stop" 7, 10 150 60 20
  list 8, 10 200 404 90,vsbar
  button "Add" 9, 100 289 60 20
  Button "Remove" 10,270 289 60 20
  text "Time Elapsed:" 11, 20 40 100 20
  text "Time Remaining:" 12, 20 70 100 20
  text "Total Time:" 13, 20 100 100 20
  text "" 14, 120 38 100 20,read
  text "" 15, 120 68 100 20,read
  text "" 16, 120 98 100 20,read
  button "Import" 17, 185 289 60 20
  box "Info" 18, 10 10 220 120
  icon 19, 275 20 100 100
}
on *:dialog:mp3:sclick:9: {
  .timeraddfile 1 0 addfile
}
on *:dialog:mp3:sclick:5: {
  set %file.to.play.p1 $did(8,$did(8).sel)
  set %file.playing.num $did(8).sel
  .timertrackcheck 0 1 checktrack
  playmp3
}
on *:dialog:mp3:init:0: {
  did -g mp3 19 $scriptdirmgb.bmp
  if ( $emp(status mircmp3 mode) == OK playing ) {
    .timerpausecheck 1 0 pause.check.2 
    .timertracktime 0 1 starttime 
    did -o mp3 16 1 $track.total.time
  }
  var %init.loop,%file.to.list
  set %init.loop 1
  :loop
  if ( $read -l $+ %init.loop $scriptdirplaylist.txt == $null ) { goto end }
  else {
    did -a mp3 8 $read -l $+ %init.loop $scriptdirplaylist.txt
    inc %init.loop 1
    goto loop
  }
  :end
}
on *:dialog:mp3:sclick:10: {
  if ( $did(8).sel ) { 
    write -dl $+ $did(8).sel " $+ $scriptdir $+ playlist.txt $+ "
    did -d mp3 8 $did(8).sel
  }
}
on *:dialog:mp3:sclick:3: {
  pause.mp3
}
alias -l playmp3 {
  if ( $mid(%file.to.play.p1,2,2) !== :\ ) { drivecheck }
  else {
    set %file.to.play " $+ %file.to.play.p1 $+ "
    var %total.time,%total.time2
    if ( $right(%file.to.play,4) !== mp3" ) { halt }
    else {
      adll close mircmp3
      if ( $emp(open [ %file.to.play type [ %mp3.cap ] ] alias mircmp3) == ERROR MMSYSTEM275 Cannot find the specified file. Make sure the path and filename are correct. ) { did -o mp3 2 1 Cannot find the specified file. Make sure the path and filename are correct. | return }
      adll play mircmp3 from 0
      adll set mircmp3 time format milliseconds
      .timertracktime 0 1 starttime
      set %total.time $emp(status mircmp3 length)
      set %total.time2 $gettok(%total.time,2,32)
      if ( $dialog(mp3) !== $null ) {
        did -o mp3 16 1 $track.total.time
        did -o mp3 2 1 Playing %file.to.play
      }
    }
  }
}
alias -l starttime {
  if ( $dialog(mp3) == $null ) { .timertracktime off }
  else { 
    adll set mircmp3 time format milliseconds
    did -o mp3 14 1 $track.time.gone
    did -o mp3 15 1 $track.time.left
  }
}
alias -l adll  { dll $dlldir MCIString $1- }
alias -l edll  { echo -a $dll(mci.dll,MCIString,$1-) }
alias track.total.time {
  var %track.total
  set %track.total $gettok($emp(status mircmp3 length),2,32)
  set %track.total $duration($calc(%track.total / 1000))
  return %track.total
}
alias -l track.time.gone {
  var %mp3.length
  set %mp3.length $gettok($emp(status mircmp3 position),2,32)
  set %mp3.length $duration($calc(%mp3.length / 1000 ))
  return %mp3.length
}
alias -l track.time.left {
  var %total.time,%mp3.remain
  set %mp3.remain $gettok($emp(status mircmp3 position),2,32)
  set %mp3.remain $calc(%mp3.remain / 1000)
  set %total.time $gettok($emp(status mircmp3 length),2,32)
  set %total.time $calc(%total.time / 1000)
  set %total.time $calc(%total.time - %mp3.remain)
  set %total.time $duration(%total.time)
  return %total.time
}
alias -l pause.mp3 {
  if ( $emp(status mircmp3 mode) == OK paused ) {
    adll play mircmp3
    did -o mp3 3 1 Pause
    did -o mp3 2 1 Playing %file.to.play
    .timertracktime 0 1 starttime
    did -o mp3 16 1 $track.total.time
  }
  else {
    if ( $gettok($emp(status mircmp3 mode),3-,32) == This is not a registered MCI device. ) {
      did -o mp3 2 1 Mp3 Is Stopped.
      did -o mp3 3 1 Pause
    }
    if ( $emp(status mircmp3 mode) == OK playing ) {
      adll pause mircmp3
      did -o mp3 3 1 Resume
      did -o mp3 2 1 Paused.
    }
  }
}

alias -l pause.check {   
  set %mode.check $emp(status mircmp3 mode)
  if ( %mode.check == OK paused ) {
    did -o mp3 3 1 Resume
    did -o mp3 2 1 Paused.
  }
  if ( %mode.check == OK playing ) {
    did -o mp3 3 1 Pause
    did -o mp3 2 1 Playing %file.to.play
  }
  if ( $gettok(%mode.check,3-,32) == This is not a registered MCI device. ) {
    did -o mp3 2 1 Mp3 Is Stopped.
    did -o mp3 3 1 Pause
  }
}
alias -l pause.check.2 {
  if ( %mode.check == OK paused ) {
    did -o mp3 3 1 Resume
    did -o mp3 2 1 Paused.
  }
  elseif ( $gettok(%mode.check,3-,32) == This is not a registered MCI device. ) {
    did -o mp3 2 1 Mp3 Is Stopped.
    did -o mp3 3 1 Pause
  }
  else {
    if ( %mode.check == OK playing ) {
      did -o mp3 3 1 Pause
      did -o mp3 2 1 Playing %file.to.play
    }
  }
}
on *:dialog:mp3:sclick:7: {
  adll close mircmp3
  did -o mp3 2 1 Mp3 Is stopped.
  .timertrackcheck off
}
on *:dialog:mp3:sclick:17: {
  .timerimport 1 0 mpu.import
}
alias -l mpu.import {
  var %mpu.loop,%mpu.add,%mpu.loc
  set %mpu.loc $file c:\*.m3u
  set %mpu.loop 1
  :loop
  if ( $read -l $+ %mpu.loop %mpu.loc == $null ) { goto end }
  else {
    if ( #* iswm $read -l $+ %mpu.loop %mpu.loc ) { inc %mpu.loop 1 | goto loop }
    else { 
      set %mpu.add $read -l $+ %mpu.loop %mpu.loc 
      did -a mp3 8 %mpu.add
      write " $+ $scriptdir $+ playlist.txt $+ " %mpu.add
      inc %mpu.loop
      goto loop
    }
  }
  :end
}

alias -l mp3.check {
  if ( $emp(status mircmp3 position) == $emp(status mircmp3 length) ) {
    set %file.to.play.2 $readn -w $+ %file.to.play
    set %file.to.play.2 $calc(%file.to.play.2 + 1)
    set %file.to.play " $+ $read -l $+ %file.to.play.2 $scriptdir $+ playlist.txt $+ "
    playmp3
  }
}
on *:dialog:mp3:sclick:4: {
  set %file.playing.id $calc(%file.playing.num + 1)
  set %file.playing.num $calc(%file.playing.num + 1)
  set %file.to.play.p1 $read -l $+ %file.playing.id $scriptdir $+ playlist.txt 
  playmp3
}
on *:dialog:mp3:sclick:6: {
  set %file.playing.id $calc(%file.playing.num - 1)
  set %file.playing.num $calc(%file.playing.num - 1)
  set %file.to.play.p1 $read -l $+ %file.playing.id $scriptdir $+ playlist.txt 
  playmp3
}
alias -l file.to.play.p1 { return %file.to.play.p1 }
alias -l drivecheck {
  var %drive.check.letter,%drive.check.number,%found.mp3,%mp3.drive
  set %drive.check.number 97
  :loop
  if ( %drive.check.number == 123 ) { set %found.mp3 yes | goto end }
  else {
    set %drive.check.letter $chr(%drive.check.number) $+ :
    if ( $disk(%drive.check.letter).type == fixed ) { set %mp3.drive %drive.check.letter $+ \ | goto check }
    else { inc %drive.check.number 1 | goto loop }
    :check {
      set %file.to.play.p2 %file.to.play.p1 $+ *
      if ( $findfile(%mp3.drive,%file.to.play.p2 ,1) !== $null ) {
        set %file.to.play.p1 $findfile(%mp3.drive,%file.to.play.p2 ,1)
        set %found.mp3 yes
        playmp3
        goto end
      }
      else {
        inc %drive.check.number 1 
        goto end
      }
    }
    :end {
      if ( %found.mp3 == yes ) { return }
      else { goto loop }
    }
  }
}
on *:load: { cap.check }
alias -l cap.check {
  if ( $emp(capability Mpegvideo device type) == OK digitalvideo ) { set %mp3.cap Mpegvideo | echo $colour(info) -s *** Mp3 player successfully loaded!  Type /mplay to use. }
  else { if ( $emp(capability Mpegvideo2 device type) == OK digitalvideo ) { set %mp3.cap Mpegvideo2 | echo $colour(info) -s *** Mp3 player successfully loaded!  Type /mplay to use. }
    else { if ( $emp(capability Mpegvideo3 device type) == OK digitalvideo ) { set %mp3.cap Mpegvideo3 | echo $colour(info) -s *** Mp3 player successfully loaded!  Type /mplay to use. }
      else { 
        echo $colour(info) -s *** Your version of Windows Media Player is not compatible with MCI Mp3 Player.
        echo $colour(info) -s *** The latest version of Windows Media Player can be downloaded at
        echo $colour(info) -s *** Please unload MCI Mp3 Player.
      }
    }
  }
}
alias -l playnext {
  set %file.playing.id $calc(%file.playing.num + 1)
  set %file.playing.num $calc(%file.playing.num + 1)
  set %file.to.play.p1 $read -l $+ %file.playing.id $scriptdir $+ playlist.txt 
  playmp3
}
alias -l checktrack {
  if ( $track.time.gone == $track.total.time ) { playnext }
}
