;---------------------------------------------------------------------------------------------------------------------------------------------------------------
;
;                                                              Ash Project
;                                       2000 - eViL_dEaD Scripts, All Rights Reserved.
;
;---------------------------------------------------------------------------------------------------------------------------------------------------------------

alias logOrganiser.about {
  if ($window(@LogOrganiser) == $null) { set %logOrganiser.about run | logOrganiser }
  else {
    clear @LogOrganiser
    titlebar @LogOrganiser - Au sujet de...
    aline @LogOrganiser 0,1 Gestionnaire de Logs version 4.0  $str($chr(160),137) Ash Project 
    aline @LogOrganiser $chr(160)
    aline -p @LogOrganiser $str($chr(160),4) Le Gestionnaire de Logs permet une gestion rapide et efficace de vos LOG .
    aline @LogOrganiser $chr(160)
    aline @LogOrganiser $chr(160) 4Dernire Version : 4.0
    aline -p @LogOrganiser $str($chr(160),4) o eViL_dEaD Copyright.
    aline -p @LogOrganiser $str($chr(160),4) o Dernire version ... De nombreux Bugs ont t limin :+)
    aline @LogOrganiser $chr(160)
  }
} 

alias logOrganiser {
  :start
  set %logOrganiser.window.h $window(-1).h
  set %logOrganiser.window.w $window(-1).w
  if ($window(@LogOrganiser) == $null) {  
    window -kl16 @LogOrganiser 200 200 830 200 @LogOrganiser 
    window -nls @LogOrganiser2 
    aline @LogOrganiser 0,1 Gestionnaire de Logs version 4.0  1,0 Chargement des donnes veuillez attendre ...
    set %logOrganiser.count 1
    :AddLog
    set %logOrganiser.log $findfile($logdir,*.log,%logOrganiser.count)
    if (%logOrganiser.log == $null) goto end
    else {
      aline -l @LogOrganiser2 $nopath(%logOrganiser.log)
      inc %logOrganiser.count 1
      goto addlog
    }
  }
  else { window -c @LogOrganiser | goto start }
  :end
  set %logOrganiser.lines $line(@LogOrganiser2,0,0)
  set %logOrganiser.count 1
  :lineadd
  if (%logOrganiser.count > %logOrganiser.lines) goto end2
  else {
    aline -l @LogOrganiser $line(@LogOrganiser2,%logOrganiser.count)
    inc %logOrganiser.count 1
    goto lineadd
  }
  :end2
  if (%logOrganiser.about == run) { logOrganiser.about | set %logOrganiser.about ran | goto end4 }
  :end3
  clear @LogOrganiser
  aline @LogOrganiser 0,1 Gestionnaire de Logs version 4.0  $str($chr(160),137) Ash Project
  aline @LogOrganiser $chr(160)
  aline -p @LogOrganiser $str($chr(160),4) Bienvenue dans le Gestionnaire de Logs version 4.0 ... Pour voir un log, double-clickez dessus dans la fentre.  Click droit pour plus de fonctionnalits .
  :end4
  iline -l @LogOrganiser 1 0,1 $chr(160) Logs Actuels  $str($chr(160),30)
  iline -l @LogOrganiser 2 0,1 $str($chr(160),175) 
  window -c @LogOrganiser2
}

alias logrefresh {
  :start
  if ($window(@LogOrganiser) == $null) { logOrganiser }
  else {
    clear -l @LogOrganiser
    window -nls @LogOrganiser2 
    set %logOrganiser.count 1
    :AddLog
    set %logOrganiser.log $findfile($logdir,*.log,%logOrganiser.count)
    if (%logOrganiser.log == $null) goto end
    else {
      aline -l @LogOrganiser2 $nopath(%logOrganiser.log)
      inc %logOrganiser.count 1
    goto addlog }
  }
  :end
  set %logOrganiser.lines $line(@LogOrganiser2,0,0)
  set %logOrganiser.count 1
  :lineadd
  if (%logOrganiser.count > %logOrganiser.lines) goto end2
  else {
    aline -l @LogOrganiser $line(@LogOrganiser2,%logOrganiser.count)
    inc %logOrganiser.count 1
    goto lineadd
  }
  :end2
  iline -l @LogOrganiser 1 0,1 $chr(160) Logs Actuels  $str($chr(160),30)
  iline -l @LogOrganiser 2 0,1 $str($chr(160),175) 
  window -c @LogOrganiser2
}

alias Logview {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2) { halt }
  else {
    if ( $sline(@LogOrganiser,1) == $null ) { halt }
    set %logOrganiser.file $logdir $+ $sline(@LogOrganiser,1)
    set %logOrganiser.size $lof(%logOrganiser.file)
    clear @LogOrganiser    
    iline @LogOrganiser 1 0,1 Gestionnaire de Logs v4.0 $str($chr(160),15) 1,0 Lecture de: $sline(@LogOrganiser,1) ( $+ %logOrganiser.size bytes)
    titlebar @LogOrganiser - $sline(@LogOrganiser,1)
    loadbuf -p @LogOrganiser  $logdir $+ $sline(@LogOrganiser,1)
    sline @LogOrganiser 15
  }
}

alias logview.newwindow {
  set %logOrganiser.window @ [ $+ [ $sline(@LogOrganiser,1) ] ]
  set %logOrganiser.file $logdir $+ $sline(@LogOrganiser,1)
  set %logOrganiser.size $lof(%logOrganiser.file)
  window %logOrganiser.window @LogView 
  iline %logOrganiser.window 1 0,1 Gestionnaire de Logs v4.0 $str($chr(160),15) 1,0 Lecture de: $sline(@LogOrganiser,1) ( $+ %logOrganiser.size bytes)
  loadbuf %logOrganiser.window $logdir $+ $sline(@LogOrganiser,1)
  sline %logOrganiser.window 15
}

menu @LogOrganiser {
  dclick loglist2
  Voire le Log
  .Dans la fentre:logview $sline(@LogOrganiser,1)
  .Dans une nouvelle fentre:logview.newwindow $sline(@LogOrganiser,1)
  Rechercher:logsearch
  -
  Effacer un Log:dellog $sline(@LogOrganiser,1)
  Copier un Log:copylog
  Renommer le Log:remlog
  -
  Ouvrir le log dans le WordPad:lognotepad
  -
  Rafrachir la Liste:logrefresh
  Fermer la fentre:window -c @LogOrganiser
  -
  Au sujet de...:logOrganiser.about
}

alias LogList2 {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2 || $sline(@LogOrganiser,1).ln == $null) { halt }
  else logview $sline(@LogOrganiser,1)
}

menu @Logview {
  Rechercher:logsearch.nw
  -
  Effacer un Log:/dellog $remove($active,@)
  Copier un Log:/copylog
  -
  Ouvrir un Log dans le WordPad:run wordpad.exe $logdir $+ $remove($active,@)
  -
  Fermer la fentre:window -c $active
  -
  Au sujet de...:window -a @LogOrganiser | logOrganiser.about
}

alias copylog {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2 || $sline(@LogOrganiser,1).ln == $null) { halt }
  set %fichier1 $sdir="COPIER $sline(@LogOrganiser,1) vers ..."
  if ( %fichier1 == $null ) { halt }
  /copy $logdir $+ $sline(@LogOrganiser,1) %fichier1 $+ $sline(@LogOrganiser,1)
}

alias remlog {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2 || $sline(@LogOrganiser,1).ln == $null) { halt }
  else {
    rename $logdir $+ $sline(@LogOrganiser,1) $logdir $+ $?="Entrez un nouveau nom de Fichier:" | logrefresh
  }
}

alias dellog {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2 || $sline(@LogOrganiser,1).ln == $null) { halt } 
  var %logOrganiser.log.delete = $sline(@LogOrganiser,1)
  var %temp = $?!="Effacer le fichier $sline(@LogOrganiser,1) ?"
  if ( %temp == $true ) { .remove $logdir $+ $sline(@LogOrganiser,1) | dline -l @LogOrganiser $sline(@LogOrganiser,1).ln | echo $colour(Info Text) -s $time => Le fichier %logOrganiser.log.delete a t effac }
}

alias lognotepad {
  if ($sline(@LogOrganiser,1).ln == 1 || $sline(@LogOrganiser,1).ln == 2 || $sline(@LogOrganiser,1).ln == $null) { halt }
  else run wordpad.exe $logdir $+ $sline(@LogOrganiser,1)
}

alias logsearch {
  if ($window(@LogOrganiser).title == - $sline(@LogOrganiser,1)) goto next
  else { logview $sline(@LogOrganiser,1) | goto next }
  :next
  if ($window(@LogSearch) != $null) /window -c @LogSearch
  window -kl @LogSearch @LogSearch 
  set %logOrganiser.file $logdir $+ $sline(@LogOrganiser,1)
  titlebar @LogSearch - $sline(@LogOrganiser,1) 
  set %logOrganiser.searchstring $$?="Entrez le Texte  rechercher:" | set %logOrganiser.searchstring * [ $+ [  %logOrganiser.searchstring ] $+ ] *
  aline @LogSearch 0,1 Gestionnaire de Logs version 4.0  $str($chr(160),150) 10Recherche $str($chr(160),100)
  aline @LogSearch 1,0 $str($chr(160),20) Recherche de:2,0 %logOrganiser.searchstring 
  filter -fwn %logOrganiser.file @LogSearch %logOrganiser.searchstring
}

menu @LogSearch {
  dclick logsearch2
  Aller  la ligne num:logsearch2
  -
  Fermer la fentre:window -c @LogSearch
  Au sujet de...:window -a @LogOrganiser | logOrganiser.about
} 

alias logsearch2 {
  if ($sline(@LogSearch,1).ln == 1 || $sline(@LogLogSearch,1).ln == 2 || $sline(@LogSearch,1).ln == $null) { halt }
  else {
    sline @LogOrganiser $calc($gettok($sline(@LogSearch,1),1,32) + 10)
    window -a @LogOrganiser
  }
}

alias logsearch.nw {
  set %logOrganiser.window $remove($active,@)
  if ($window(@LogSearch) != $null) window -c @LogSearch
  window -kl @LogSearch @LogSearch.nw 
  set %logOrganiser.file $logdir $+ %logOrganiser.window
  titlebar @LogSearch - %logOrganiser.window
  set %logOrganiser.searchstring $$?="Entrez le Texte  rechercher:" | set %logOrganiser.searchstring * [ $+ [  %logOrganiser.searchstring ] $+ ] *
  aline @LogSearch 0,1 Gestionnaire de Logs version 3.0  $str($chr(160),150) 10Recherche $str($chr(160),100)
  aline @LogSearch 1,0 $str($chr(160),20) Recherche de:2,0 %logOrganiser.searchstring  $str($chr(160),500)
  filter -fwn %logOrganiser.file @LogSearch %logOrganiser.searchstring
}

menu @LogSearch.nw {
  dclick:logsearchnw
  Aller  la ligne num:logsearchnw
  -
  Fermer la fentre:window -c @LogSearch
  Au sujet de...:window -a @LogOrganiser | logOrganiser.about
} 

alias logsearchnw {
  set %logOrganiser.window2 @ $+ %logOrganiser.window 
  if ($sline(@LogSearch,1).ln == 1 || $sline(@LogLogSearch,1).ln == 2 || $sline(@LogSearch,1).ln == $null) { halt }
  else {
    sline %logOrganiser.window2 $calc($gettok($sline(@LogSearch,1),1,32) + 10)
    window -a %logOrganiser.window2
  }
}

menu menubar,status,channel {
  -
  Log Organiser:/logOrganiser 
}

on 1:CLOSE:@LogOrganiser:/unset %logOrganiser.*

