;
;         @Locator Script v.1.0
;                        by Danaria (ladydana@animefan.org)
;
;                I can often be found in #HelpDesk or #mIRC on the IRC network
;           DALnet (http://www.dal.net/) - /server irc.dal.net 7000
;                My personal channel is called #RavenScar

menu menubar {
  Locator
  .Local Search: locator $$?="Search for?"
  .-
  .Turn $locator.status : if ($locator.status == off) { .disable #locator | echo -es 101410 Disabled @Locator Script } | else { .enable #locator | echo -es 101410  Enabled @Locator Script }
  .Set Directory: set %locator.directory $$?="What directory will the script look in?" | echo -es 101410 @Locator - Directory set to %locator.directory
  .-
  .Info on Script: echo -es 101410 @Locator Script Version 1.0 - http://www.helpdesk.mircx.com/scripts/index.html - by Danaria (ladydana@animefan.org)
}
; Takes care of the options available in the MENUBAR popups

On 1:LOAD:{
  if ($version < 5.5) { 
    echo -s 101410 @Locator - Sorry, your version of mIRC is too low. Get the newest version at http://www.mirc.co.uk/get.html
    unload -rs $script
  }
  else {
    if (%locator.directory == $null) { set %locator.directory $$?="What directory will the script look in?" }
    echo -s 101410 @Locator - Look for options in the MENUBAR popups
  }
}
; Makes sure that this version of mIRC is at least v5.5, if not, it will unload the script
; If it is, then it will ask for the directory that the @Locator Script will work in and tell the user to use the script via the menubar popups

alias -l locator.status {
  if ($group(#locator).status == on) { return Off }
  else { return On }
}
; Checks if the script is turned on or not for the popups

#locator on
alias -l addwildcards {
  unset %addwildcard
  set %addwildcard $replace($1-,$chr(32),$chr(42))
  set %addwildcard $chr(42) $+ %addwildcard $+ $chr(42)
  return %addwildcard
}
; Custom identifier $addwildcards
; It replaces all the spaces with * and adds * to both the beginning and the end of the search pattern

On 1:TEXT:@Locator*:*:{
  if ($chan) { set %locator.target $chan }
  ; if it's a channel window, then set the variable %locator.target to the channel window
  if ($active != $chan) { set %locator.target $nick }
  ; if it's not a channel window, then set it to the nick who has activated the command
  if ($2- == $null) { msg %locator.target 101410  Specify something after @Locator | goto end }
  ; if there are no search parameters, it will return an error message
  msg %locator.target 101410  Listing Files Matching 10(14 $+ $2- $+ 10)
  if ($findfile(%locator.directory,$addwildcards($2-),0) == 0) { goto end }
  ; if there are no files matching the search pattern, it will automatically go to the end
  if ($findfile(%locator.directory,$addwildcards($2-),0) >= 5) { locator.text.file $2- | goto end2 }
  ; if there are more than 5 files found, it will go to the alias called locator.text.file
  set %i 0
  :loop
  inc %i
  if (%i > $findfile(%locator.directory,$addwildcards($2-),0)) { goto end }
  msg %locator.target 101410  $findfile(%locator.directory,$addwildcards($2-),%i)
  goto loop
  ; looping to return all the matches that were found, one by one
  :end
  msg %locator.target 101410  Finished Matching 10(14 $+ $2- $+ 10) * Found  $findfile(%locator.directory,$addwildcards($2-),0) Match(es)
  msg %locator.target 101410  If you want to get a file, then type 10!get $nopath($findfile(%locator.directory,$addwildcards($2-),1)) for example.
  ; Gives the ending stats and instructions if the user is interested in downloading a file
  :end2
}

On 1:TEXT:!get*:*: {
  if ($send($nick) > 3) { notice $nick There are already 3 dcc sends in progress. Please wait until one of them has finished | goto end }
  ; Checks if the user already has 3 open send windows or not
  if ($2- == $null) { notice $nick Please specify a filename after !get | goto end }
  ; checks if the user specified anything after !get
  if ($exists($2-) == $false) { 
    notice $nick Sorry, this file doesn't exist
    if ($findfile(%locator.directory,$addwildcards($2-),0) == 0) { notice $nick There are also no files that resemble the name that you specified | goto end }
    else { notice $nick Perhaps you should try !get $findfile(%locator.directory,$addwildcards($2-),1)
  }
  else { dcc send $nick $2- }
  ; dcc sends the person this file
  :end
}

alias -l locator.text.file {
  write -c locator.txt $chr(32)
  ; clears the entire text file
  set %i 0
  :loop
  inc %i
  if (%i > $findfile(%locator.directory,$addwildcards($1-),0)) { goto startplaying }
  write locator.txt 101410 %i $+ ) $findfile(%locator.directory,$addwildcards($1-),%i)
  goto loop
  ; looping to write all the matches into the locator.txt file
  :startplaying
  play %locator.target locator.txt 3000
  ; plays the lines of the file one by one with a 3 second delay between each match found in order to prevent flooding
  .timer 1 $calc($calc($lines(locator.txt) * 3) + 1) msg %locator.target 101410  Finished Matching 10(14 $+ $1- $+ 10) * Found  $findfile(%locator.directory,$addwildcards($1-),0) Match(es)
  .timer 1 $calc($calc($lines(locator.txt) * 3) + 2) msg %locator.target 101410  If you want to get a file, then type 10!get $findfile(%locator.directory,$addwildcards($2-),1) for example.
  ; when the matches have all been displayed, it will give the ending messages
  .timer 1 $calc($calc($lines(locator.txt) * 3) + 5) .remove locator.txt
  ; deletes the locator.txt file at the end
}
#locator end

alias locator {
  if ($1- == $null) { echo -s 101410  Specify Something after @Locator | goto end }
  echo $colour(background) -s 
  echo -s 101410  Listing Files Matching 10(14 $+ $1- $+ 10)
  if ($findfile(%locator.directory,$addwildcards($1-),0) == 0) { goto end }
  set %i 0
  :loop
  inc %i
  if (%i > $findfile(%locator.directory,$addwildcards($1-),0)) { goto end }
  echo -s 101410 %i $+ ) $findfile(%locator.directory,$addwildcards($1-),%i)
  goto loop
  :end
  echo -s 101410  Finished Matching 10(14 $+ $1- $+ 10) * Found  $findfile(%locator.directory,$addwildcards($1-),0) Match(es)
  echo $colour(background) -s 
}
; Works the same as the On TEXT event
