; Itsy Archive Tool 1.0 
; by SoapForge

; RTFM

alias iview {
  tf.checkversion
  if ($1 == $null) {
    echo -a $tf.bold(syntax:) iview drive:\path\filename.ext 
    echo -a $tf.bold(description:) displays the contents of a IAT archive
    return
  }
  if ($isfile($1) == $false) {
    echo -a Error - can't find that file
    return
  }
  bread $1 0 3 &in
  if ($tf.bin2var(&in) !== IAT) { echo -a Error - file is not a IAT archive or is corrupted | tf.clearfiles | return }
  bread $1 3 3 &in
  if ($tf.bin2var(&in) > 1.0) { echo -a Error - IAT archive created by a more advanced version | tf.clearfiles | return }
  tf.clearfiles
  bread $1 6 1 &in  
  var %n $bvar(&in,1)
  var %p $calc(7 + %n)
  bread $1 7 %n &in
  var %l $calc(%p + $tf.bin2var(&in))
  tf.bingrab %p %l $1 _iattmp.001 
  tf.bingrab %l $lof($1) $1 _iattmp.002   
  if ($readini _iattmp.001 Z c != $crc(_iattmp.002)) { echo -a Error - Bad data crc | tf.clearfiles | return }
  if ($readini _iattmp.001 Z L != $lof(_iattmp.002)) { echo -a Error - Bad data length | tf.clearfiles | return }
  var %f $readini _iattmp.001 Z F
  echo -a found %f files in archive $$1
  :l
  if (%f > 0) {
    var %s $readini _iattmp.001 F %f 
    echo -a $gettok(%s,3,32) $round($calc($calc($gettok(%s,2,32) - $gettok(%s,1,32)) / 1024),1) $+ k (crc $gettok(%s,4,32) $+ $chr(41)
    dec %f 1 
    goto l
  }
  echo -a end of listing.
  tf.clearfiles
}
alias icreate { 
  tf.checkversion
  if ($2 == $null) {
    echo -a $tf.bold(syntax:) icreate drive:\path\filename.ext file1 file2 file3 file4 etc
    echo -a $tf.bold(description:) creates a IAT archive
    return
  }
  if ($isfile($1) == $true) { .remove $1 }
  var %a1 $numtok($2-,32)
  var %a2 0
  var %p1 0
  :loop
  if (%a1 > 0) {
    if ($isfile($gettok($2-,%a1,32)) == $true) {
      echo -a Adding file $gettok($2-,%a1,32) 
      inc %a2 1
      writeini _iattmp.001 f %a2 %p1 $calc(%p1 + $lof($gettok($2-,%a1,32))) $tf.cleanname($gettok($2-,%a1,32)) $crc($gettok($2-,%a1,32))
      var %p1 $calc(%p1 + $lof($gettok($2-,%a1,32)))
      .copy -a $gettok($2-,%a1,32) _iattmp.002
    }
    dec %a1 1
    goto loop
  }
  echo -a Generating header 
  writeini _iattmp.001 Z C $crc(_iattmp.002)
  writeini _iattmp.001 Z L $lof(_iattmp.002)
  writeini _iattmp.001 Z F %a2
  .flushini _iattmp.001
  var %z IAT1.0 $+ $chr($len($lof(_iattmp.001))) $+ $lof(_iattmp.001)
  bwrite $$1 0 $len(%z) %z 
  echo -a Creating file 
  .copy -a _iattmp.001 $$1
  .copy -a _iattmp.002 $$1
  tf.clearfiles
}
alias iextract { 
  tf.checkversion
  if ($isfile($1) == $false) {
    echo -a $tf.bold(syntax:) iextract drive:\path\filename.ext drive:\path
    echo -a $tf.bold(description:) extracts a IAT archive to a directory
    return
  }
  var %path $replace($2,$chr(92),$chr(47))
  if ($right(%path,1) != $chr(47)) { var %path %path $+ $chr(47) }
  bread $1 0 3 &in
  if ($tf.bin2var(&in) !== IAT) { echo -a Error - file is not a IAT archive or is corrupted | tf.clearfiles | return }
  bread $1 3 3 &in
  if ($tf.bin2var(&in) > 1.0) { echo -a Error - IAT archive created by a more advanced version | tf.clearfiles | return }
  tf.clearfiles
  bread $1 6 1 &in  
  var %n $bvar(&in,1)
  var %p $calc(7 + %n)
  bread $1 7 %n &in
  var %l $calc(%p + $tf.bin2var(&in))
  tf.bingrab %p %l $1 _iattmp.001
  tf.bingrab %l $lof($1) $1 _iattmp.002   
  if ($readini _iattmp.001 Z c != $crc(_iattmp.002)) { echo -a Error - Bad data crc | tf.clearfiles | return }
  if ($readini _iattmp.001 Z L != $lof(_iattmp.002)) { echo -a Error - Bad data length | tf.clearfiles | return }
  var %f $readini _iattmp.001 Z F
  var %path $readini _iattmp.001 SFX P $3  
  if (%path == $null) {
    if ($2 != $null) { 
      set %path $2 
    }
    else {
      Echo -a Error - no destination path | tf.clearfiles | return
    } 
  }
  if ($isdir(%path) == $false) { echo -a Attempting to create directory %path | .mkdir %path }
  :gfiles
  if (%f > 0) {  
    var %h $readini _iattmp.001 F %f
    if ($isfile(%path $+ $gettok(%h,3,32)) == $true) {
      echo -a $gettok(%h,3,32) already exists, skipping
    }
    else {
      tf.bingrab $gettok(%h,1,32) $gettok(%h,2,32) _iattmp.002 %path $+ $tf.cleanname($gettok(%h,3,32))
      if ($gettok(%h,4,32) == $crc($gettok(%h,3,32))) { echo -a $gettok(%h,3,32) extracted ok } | else { echo -a $gettok(%h,3,32) failed - bad crc }
    }
    dec %f 1
    goto gfiles
  }
  echo -a Finished processing archive
  tf.clearfiles
}
alias -l tf.bin2var { return $bvar($$1,1- [ $+ [ $bvar($$1,0) ] ] ).text }
alias -l tf.bingrab {
  var %i $$1
  var %o 0-
  :loop
  if ($calc(%i + 4096) >= $$2) {
    bread $$3 %i $calc($$2 - %i) &bingrab
    bwrite $$4 -1 -1 &bingrab
    return
  }
  bread $$3 %i $calc(%i + 4096) &bingrab
  bwrite $$4 -1 -1 &bingrab
  inc %i 4096
  goto loop
}
alias -l tf.clearfiles {
  var %num 1
  :l
  if (%num < 5) {
    var %v _iattmp.00 $+ %num
    if ($isfile(%v) == $true) { .remove %v }
    inc %num 1
    goto l
  }
}
alias -l tf.cleanname { return $gettok($replace($1,$chr(92),$chr(47)),$numtok($replace($1,$chr(92),$chr(47)),47),47) }
alias -l tf.bold { return $chr(2) $+ $$1- $+ $chr(2) }
alias -l tf.checkversion {
  if ($version < 5.6) { echo -a Error - This version of mIRC is too old. You can grab a new copy from http://www.mirc.co.uk }
}
