; ###############################################################################
; # Intense Creations Away System
; # By: fLeSh (webmaster@intensecreations.org) irc.gXtreme.net #support
; #
; # Pretty straightforward away system, no real frills or anything.
; # Autoaway after user defined timelimit (default is 15 minutes).
; # In case of bugs, email me, or visit me on irc (Information above).
; ###############################################################################

menu menubar,channel {
  -
  $strip(%away.logo)
  .Away:/away $$?="Enter reason for away"
  .Back:/away
  .-
  .Setup
  .Current Settings:/if (%idleaway.min) { echo -a %away.logo 10AutoAway (minutes): %idleaway.min $+  } | if (%away.reason) { echo -a %away.logo 10Away: %away.reason $+  } | if (%away.time) { echo -a %away.logo 10Time: $duration($calc($ctime - %away.time)) $+  }
  .AutoAway:/set %idleaway.min $$?="How long until you are marked as away? (minutes)" | .set %idleaway.sec $calc(%idleaway.min * 60)
  -
}

alias checkidle {
  if (%idleaway.sec == $null) { .set %idleaway.sec 1800 }
  if (%idleaway.min == $null) { .set %idleaway.min $calc(%idleaway.sec / 60) }
  if ($idle >= %idleaway.sec) { away auto away after %idleaway.min minutes }
}

alias away {
  if ($1) {
    set %away.reason $1-
    set %away.time $ctime
    .quote away %away.reason - %away.logo
    ame is away: [ $+ %away.reason $+ ] %away.logo
    .timeraway 0 1800 ame is away [ $+ %away.reason $+ ] $!awaytime %away.logo
    nick $me $+ |away
    .timeridle off
  }
  else { back }
}

alias awaytime {
  return ( $+ $duration($calc($ctime - %away.time)) $+ )
}

alias back {
  if ($right($me,5) == |away) {
    set %me.len $len($me)
    set %me.pos $pos($me,|)
    set %me.nick $mid($me,1,$calc(%me.pos - 1))
    ame has returned [ $+ %away.reason $+ ] ( $+ $duration($calc($ctime - %away.time)) $+ ) %away.logo
    .quote away
    .timeraway off
    nick %me.nick
    .unset %me.len %me.pos %me.nick %away.time %away.reason
    .timeridle 0 15 checkidle
  }
  else {
    echo -a %away.logo 4Error: 10You are not away.
  }
}
ON ^1:CONNECT:{
  .set %away.logo 14[4i5C14/7away14]
  .echo -at %away.logo 10Successfully loaded.
  .timeridle 0 15 checkidle
}

ON 1:LOAD:{
  if ($version < 5.82) {
    .set %away.crc $crc($script)
    .set %away.logo 14[4i5C14/7away14]
    echo -a %away.logo 4!!WARNING!!
    echo -a %away.logo 10I haven't tested this on anything other than mIRC 5.82.
    echo -a %away.logo 10While it may work on older versions, it may not.
    echo -a %away.logo 10You should consider upgrading to mIRC 5.82 or higher.
    echo -a %away.logo 10Successfully loaded.
  }
}
