; Import Server 1.1
; by SoapForge, original concept by Jonathans
; http://ns.iwarp.com/mirc/
;
;
; Small utility that retrieves a list of connected servers on the
; network and adds any new ones to the servers.ini file 
; in a reasonable manner.
;
;
; To install, copy the is11.mrc file in to your mIRC directory
; and issue this command at the mIRC prompt:
;
;  /load -rs is11.mrc
;
;
; Usage is /import [networkname]
;
; where [networkname] is a semioptional parameter used when the
; script is unable to figure out the name of the network by itself, or
; to override the name the script comes up with. This name is used 
; as the group to add the servers to.
;
; As there seems to be no way of retrieving port information for the 
; servers, each will default to 6666.
;
;
; Version history:
;
; 1.0 First release
; 1.1 Updated to make use of the /server command
;
;
; Feel free to use or modify this code for your own personal use.
; However, this code may not be reproduced, transcribed, stored in a
; retrieval system, translated into any language or computer
; language, retransmitted in any form or by any means  (electronic,
; mechanical, photocopied, recorded, or otherwise), resold, or
; redistributed by any person juggling live electric eels while naked.

alias import {
  writeini iserver.cfg data show $show
  if ($version < 5.61) {
    import.ewrite warning - this script has not been tested on this version of mIRC
  }
  if ($server == $null) {
    import.ewrite error - this command won't work while offline. 
    halt
  }
  if ($network == $null) && ($1 == $null) {
    import.ewrite error - no idea what network is currently connected. Enter the network name manually using /import networkname
    halt
  }
  if ($isfile(iserver.dat) == $true) {
    .remove iserver.dat
  }
  if ($isfile(iserver.dat) == $true) {
    import.ewrite error - unable to delete iserver.dat. Check the file attributes and make sure this file is not in use by another program.
    halt  
  }  
  if ($1 != $null) {
    writeini iserver.cfg data network $1
  }
  else {
    writeini iserver.cfg data network $network
  }
  import.ewrite retrieving server list...
  .enable #iserver
  raw -q links
}

alias -l import.ewrite {
  var %x = $readini iserver.cfg data show
  if (%x) {
    echo -a * /import: $1-
  }
}

alias -l import.pservers {
  var %l = $lines(iserver.dat) 
  var %r = $readini iserver.cfg data network
  var %a = 0
  if (%l < 1) || (%l == $null) {
    import.ewrite no servers were returned.
    goto z
  }
  import.ewrite adding new servers...
  :l
  if (%l > 0) {
    var %y = $read -nl $+ %l iserver.dat 
    var %z = $chr(42) $+ %y $+ $chr(42)
    var %c = $read -nw $+ %z servers.ini
    if (%c == $null) {
      inc %a 1
      .server -a %y -p 6666 -g %r -d %r $+ $chr(58) %y
    }
    dec %l 1
    goto l
  }
  .server -s
  import.ewrite task complete, added %a new server(s) to group %r
  :z
  if ($isfile(iserver.dat) == $true) {
    .remove iserver.dat
  }
  if ($isfile(iserver.cfg) == $true) {
    .remove iserver.cfg
  }
}

#iserver off
raw 364:*:{
  write iserver.dat $2
  halt
}
raw 365:*:{
  .disable #iserver
  .timer 1 0 import.pservers
  halt
}
alias links {
  echo * /links: you may not run this command while /import is active, please wait and try again
  halt
}
#iserver end

on 1:start:{
  .disable #iserver
}

; Autodetect line follows
; ki.basicregister [ ISERVER100/Import Server 1.0/SoapForge/imports list of servers on network to servers.ini file/false ]
