;
; IRCraft Away Manager V1.3 ( solo lite edition )
; By DarkHalf    (darkhalf@gamesinferno.com)
; Part of my upcoming IRCraft script   (http://www.sitesinferno.com/darkhalf/ircraft)
;

; On Start/Load Events
on *:load:{
  .load -rs $scriptdirg_afront.mrc
  .load -rs $scriptdirg_anick.mrc
  .load -rs $scriptdirg_amessage.mrc
  .load -rs $scriptdirg_atrigger.mrc
  _secho IRCraft Away Manager V1.3 ( solo lite edition ) Loaded
  _secho $chr(160)
  _secho By DarkHalf    (darkhalf@gamesinferno.com)
  _secho Part of my upcoming IRCraft script   (http://www.sitesinferno.com/darkhalf/ircraft)
  _secho Please see the readme file in the same zip as these script files.
  _secho $chr(160)
  _secho To configure this away script please select the "IRCraft Away" Menu from the Command menu.
  _away.onstart 
  set -u10 %g_away.firsttime 1
}
On *:Start:{
  if (%g_away.firsttime == 1) { halt | return }
  _secho IRCraft Away Manager V1.3 ( solo lite edition ) Loaded 
  _away.onstart 
}
alias _away.onstart {
  set %g_away.afile $scriptdirg_away.ini
  set %g_away.bfile $scriptdirg_back.ini
  _away.atimer 
}

; Menus
menu menubar,status {
  IRCraft Away
  .$iif($server != $null,$iif($_away.status == 0,Go &Away,Come &Back),Not Connected)
  ..Silent:_awaymenu.silent
  ..Public:_awaymenu.public
  .Configure:_away.front.winopen
}

; Decide between silent/public
alias _awaymenu.silent {
  if ($_away.status == 0) { .saway Gone }
  if ($_away.status == 1) { .sback }
}
alias _awaymenu.public {
  if ($_away.status == 0) { .away $?="Reason? (Leave Blank For 'Gone')" }
  if ($_away.status == 1) { .back }
}

: (s prefix = Siltent) Away an Back Functions
alias away {
  if ($_away.pref(On) == 1) && ($_away.status == 0)  && ($server != $null) {
    set %_away.reason $1-
    set %_away.time $ctime
    if (%_away.reason == $null) { %_away.reason = gone }
    _away.msg | _away.name | _away.raw | _away.triggers
    set %_away.status 1 | halt
  } else { return }
}
alias saway {
  if ($_away.pref(On) == 1) && ($_away.status == 0)  && ($server != $null) {
    set %_away.reason $1-
    set %_away.time $ctime
    if (%_away.reason == $null) { %_away.reason = gone }
    _away.name | _away.raw | _away.triggers
    set %_away.status 1 | halt
  } else { return }
}
alias back {
  if ($_away.pref(On) == 1) && ($_away.status) && ($server != $null) {
    if (%_away.aauto == 1) { _away.atimer }
    _away.msg.back |  _away.name.back | _away.raw.back |  _away.triggers.back
    set %_away.status 0 | editbox -s /qnull $chr(13) $+ $chr(10) 
    .timer._away.msg off 
    if ($_away.mpref(SCTCP) == 1) && ($_away.status == 1) {
      var %_num 1
      :looptop
      /ctcp $chan(%_num) BACK
      inc %_num | if (%_num > $chan(0)) { goto end } | goto looptop
      :end
    }
    halt
  } else { return }
}
alias sback {
  if ($_away.pref(On) == 1) && ($_away.status) && ($server != $null) {
    if (%_away.aauto == 1) { _away.atimer }
    _away.name.back | _away.raw.back | _away.triggers.back
    set %_away.status 0 | editbox -s /qnull $chr(13) $+ $chr(10)
    .timer._away.msg off 
    if ($_away.mpref(SCTCP) == 1) && ($_away.status == 1) {
      var %_num 1
      :looptop
      /ctcp $chan(%_num) BACK
      inc %_num | if (%_num > $chan(0)) { goto end } | goto looptop
      :end
    }
    halt
  } else { return }
}
alias qnull { return }

; Auto Away
alias -l _away.atimer { set %_away.aauto 0 | if ($_away.pref(Auto) == 1 ) { /timer.g_aauto 0 5 /_away.aautocheck } }
alias -l _away.aautocheck {
  if ($idle > $calc($_away.pref(ATime) * 60)) && ($server != $null) { 
    set %_away.aauto 1
    .timer.g_aauto off
    editbox -s /qnull $chr(13) $+ $chr(10)
    $iif($_away.pref(ASilent) != 1,away IdleAway,saway IdleAway)
  }
}

; Whois Away Variable
alias -l _away.raw { .raw -q AWAY %_away.reason }
alias -l _away.raw.back { .raw -q AWAY }

alias _away.time { if ($_away.status == 1) { return $duration($calc($ctime - %_away.time)) } else { return 0 } }
alias _away.status { if (%_away.status != $null) { return %_away.status } else { set %_away.status 0 | return 0 } }

; INI Access
alias _away.pref {
  if ($1 == $null) { halt | return }
  if ($1 != set) { return $readini %g_away.afile Prefs $1 }
  .writeini %g_away.afile Prefs $2 $$3- 
}
alias _away.bpref {
  if ($1 == $null) { halt | return }
  if ($1 != set) { return $readini %g_away.bfile Prefs $1 }
  .writeini %g_away.bfile Prefs $2 $$3-
}

;Common Functions
alias -l _echo { echo $1- }
alias -l _aecho { echo -a $1- }
alias -l _secho { echo -s $1- }
alias -l _asecho { if ($active != Status Window) { echo -as $1- | halt } echo -s $1- }

ctcp *:VERSION:*:{ if ($_away.pref(On) == 1) { .notice $nick IRCraft Away Solo Lite By DarkHalf } }
