; IRC Proxy Server by pQaTeFnET
;
; Yes, people can use your ip to IRC and they can feel so
; much safer.  And yes, you can see what the users are saying
; and people say to your users, server messages, everything!
; It's like spying on those who use your proxy server!  You
; can also kill them off your server.  If you have any
; suggestions, email me at susjoe@hotmail.com
;
; Bored, that's why I made this!
;
; Tell the user to do a: /server [your ip]:6999 <server>
; to connect to <server>.
;
; Added 11/15/98: You can set the max clients for the proxy.
;                 You can set the max connections for a client.
;                 You can ban users from the proxy.
;
;
alias proxy {
  if ($1 == start) {
    show started up server.
    proxy.close
    proxy.start
  }
  elseif ($1 == accept) {
    set -u1 %proxy.free.socket $proxy.find.socket
    set $evac(proxy.connected.,%proxy.free.socket) $false
    set $evac(proxy.socket.,%proxy.free.socket) ircproxy.client. $+ $proxy.find.socket
    sockaccept ircproxy.client. $+ %proxy.free.socket
    set $evac(proxy.ip.,%proxy.free.socket) $sock($evacl(proxy.socket.,%proxy.free.socket)).ip
    set -u1 %proxy.ip $evacl(proxy.ip.,%proxy.free.socket)
    if ($proxy.banned(%proxy.ip) == $true) {
      proxy.send %proxy.free.socket $symbol you are banned from using this proxy.
      .timer -m 1 1 proxy sclose %proxy.free.socket
    }
    inc $evac(proxy.max.hosts.,%proxy.ip)
    if ($evacl(proxy.max.hosts.,%proxy.ip) > %proxy.max.host.clients) {
      proxy.send %proxy.free.socket $symbol no more connections from your host, max host clients: %proxy.max.host.clients
      .timer -m 1 1 proxy sclose %proxy.free.socket
      return
    }
    if (%proxy.connections >= %proxy.max.clients) {
      proxy.send %proxy.free.socket $symbol no more connections, max clients: %proxy.max.clients
      .timer -m 1 1 proxy sclose %proxy.free.socket
      return
    }
    .timerproxy.sidle. $+ $proxy.find.socket 1 %proxy.startup.idle proxy sidle $proxy.find.socket
  }
  elseif ($1 == add) {
    if ($2 == ban) {
      if ($proxy.banned($3) == $true) {
        show that ip is already banned.
        return
      }
      show added $3 to the banlist.
      write $proxy.banfile $3
    }
  }
  elseif ($1 == close) {
    if ($sock(ircproxy.*,0) == 0) { show there are no current connections. }
    else { proxy.close }
  }
  elseif ($1 == help) {
    echo 12 -a -- irc proxy v1 by pQ --
    echo 13 -a 6usage: /proxy <add|remove|start|close|kill|sclose|send|sendinfo|sendserv|view> <ban|banned>
    echo 9 -a $space(5) 3add <ban>: let's you add <ban> to the banlist.
    echo 9 -a $space(5) 3remove <ban>: let's you remove <ban> from the banlist.
    echo 9 -a $space(5) 3start: starts the proxy server.
    echo 9 -a $space(5) 3close: kills everyone who's connected to you.
    echo 9 -a $space(5) 3sclose <N>: kills <N> connection to you.
    echo 9 -a $space(5) 3send <N> <data>: sends <data> to the <N> connection.
    echo 9 -a $space(5) 3sendinfo <N> <data>: sends <N> a special print out of <data>.
    echo 9 -a $space(5) 3servsend <N> <data>: sends <data> to <N> server connection.
    echo 9 -a $space(5) 3view: let's you spy on your users, kick users, etc.
    echo 9 -a $space(5) 3view banned: displays the banned ips.
    return
  }
  elseif ($1 == idledout) {
    proxy.send $$2 [proxy]: idled out.
    proxy.sclose $$2
  }
  elseif ($1 == kill) {
    show killed IRC proxy server.
    proxy.kill
  }
  elseif ($1 == remove) {
    if ($2 == ban) {
      proxy.banned remove $shortfn($proxy.banfile) $3-
      return
    }
  }
  elseif ($1 == resetidle) {
    proxy.resetidle $$2
  }
  elseif ($1 == sclose) {
    proxy.sclose $$2
  }
  elseif ($1 == send) {
    proxy.send $$2-
  }
  elseif ($1 == sendinfo) {
    proxy.send $$2 [proxy]: $$3-
  }
  elseif ($1 == servsend) {
    proxy.servsend $$2 $$3-
  }
  elseif ($1 == sidle) {
    proxy.sidle $$2-
  }
  elseif ($1 == view) {
    if ($2 == banned) { proxy.view.banned }
    else { goto view }
    :view
    proxy.view
  }
  elseif ($1 == viewdel) {
    proxy.view.del $$2
  }
}
; returns the banfile.
alias -l proxy.banfile { return $proxy.directory(proxy_banned.dat) }
; returns whether or not if the ip is banned.
alias -l proxy.banned {
  if (($1 == file || $1 == remove) && $2 != $null) { set %proxy.banned.file $2 }
  else { set %proxy.banned.file $proxy.banfile }
  if ($exists(%proxy.banned.file) == $false) { return $false }
  set -u1 %proxy.banned.num 0
  set -u1 %proxy.banned.len $lines(%proxy.banned.file)
  if ($1 == remove) { set %proxy.banned.total 0 }
  :readagain
  inc %proxy.banned.num
  if (%proxy.banned.num > %proxy.banned.len) {
    if ($1 != remove) { return $false }
    elseif ($1 == remove) {
      show removed %proxy.banned.total ips.
      return
    }
  }
  set -u1 %proxy.banned.read $read -nl $+ %proxy.banned.num %proxy.banned.file
  if ($1 != file && $1 != remove && %proxy.banned.read iswm $1) { return $true }
  elseif ($1 == file && $1 != $remove && %proxy.banned.read iswm $3) { return $true }
  elseif ($1 == remove && $1 != file && $3 iswm %proxy.banned.read) {
    inc %proxy.banned.total
    write -dl $+ %proxy.banned.num %proxy.banned.file
  }
  goto readagain
}
; close all irc proxy connections.
alias -l proxy.close {
  set %proxy.close.len $sock(ircproxy*,0)
  :loop
  if ($sock(ircproxy.*,0) == 0) {
    .timerproxy.* off
    set %proxy.connections 0
    unset %proxy.max.hosts.*
    return
  }
  sockclose $sock(ircproxy.*,1)
  goto loop
}
; returns this file's directory.
alias -l proxy.directory {
  set -u1 %proxy.directory.num 0
  :loop
  inc %proxy.directory.num
  if ($script < %proxy.directory.num) { return }
  if ($script(%proxy.directory.num) == $script) {
    return $nofile($script(%proxy.directory.num)) $+ $1-
  }
  goto loop
}
; find an open socket.
alias -l proxy.find.socket {
  set -u1 %proxy.find.socket.num 0
  :findagain
  inc %proxy.find.socket.num
  if ($sock($evau(ircproxy.client.,%proxy.find.socket.num)) == $null) { return %proxy.find.socket.num }
  goto findagain
}
; kills the IRC proxy entirely.
alias -l proxy.kill {
  proxy.close
  if ($sock(ircproxy)) { sockclose ircproxy }
  unset %proxy.*
}
; resets the idle time of a user.
alias -l proxy.resetidle {
  .timerproxy.idle. $+ $$1 1 %proxy.idle.client proxy idledout $$1
}
; kill a certain user.
alias -l proxy.sclose {
  if ($evacl(proxy.ip.,$1)) { dec $evac(proxy.max.hosts.,$evacl(proxy.ip.,$1)) }
  if ($sock($evacl(proxy.socket.,$1))) { sockclose $evacl(proxy.socket.,$1) }
  if ($sock($evacl(proxy.server.socket.,$1))) { sockclose $evacl(proxy.server.socket.,$1) }
  if ($timer($evau(proxy.sidle.,$1))) { .timerproxy.sidle. $+ $1 off }
  if ($timer($evau(proxy.idle.,$1))) { .timerproxy.idle. $+ $1 off }
  proxy viewdel $1
  unset $evac(proxy.*.,$1)
  dec %proxy.connections
}
; sends data to a user.
alias -l proxy.send {
  if ($sock($evau(ircproxy.client.,$1))) { sockwrite -tn $evau(ircproxy.client.,$1) $2- }
}
; sends data to the users server.
alias -l proxy.servsend {
  if ($sock($evau(ircproxy.server.,$1))) { sockwrite -tn $evau(ircproxy.server.,$1) $2- }
}
; checks if the user hasn't sent any info on what server to connect to.
alias -l proxy.sidle {
  if ($evacl(proxy.server.,$1) == $null) { 
    proxy sendinfo $1 you have not sent any server info, idled out.
    proxy sclose $1
  }
}
; listen to port 6999, unset all the variables, and set some variables.
alias -l proxy.start {
  unset %proxy.*
  set %proxy.connections 0
  set %proxy.idle.client 1000
  set %proxy.startup.idle 10
  set %proxy.max.host.clients 1
  set %proxy.max.clients 5
  if ($portfree(6999) == $true && $sock(ircproxy) == $null) { socklisten ircproxy 6999 }
}
; allows you to view the users, spy on them too.
alias -l proxy.view {
  if ($window(@ProxyUsers) == $null) { window -l @ProxyUsers $calc(($window(-1).w - 600) / 2) $calc(($window(-1).h - 300) / 2) 600 300 @ProxyUsers Verdana 11 }
  set -u1 %proxy.view.num 0
  set -u1 %proxy.view.len $sock(ircproxy.client.*,0)
  :loop
  inc %proxy.view.num
  if (%proxy.view.num > %proxy.view.len) {
    window -b @ProxyUsers
    return
  }
  set -u1 %proxy.find.userline proxy user %proxy.view.num $+ :*
  if ($fline(@ProxyUsers,%proxy.find.userline,1,0)) { rline @ProxyUsers $ifmatch proxy user %proxy.view.num $+ : $chr(91) $+ $evacl(proxy.nick.,%proxy.view.num) $+ ( $+ $evacl(proxy.server.,%proxy.view.num) $+ )] }
  else { aline @ProxyUsers proxy user %proxy.view.num $+ : $chr(91) $+ $evacl(proxy.nick.,%proxy.view.num) $+ ( $+ $evacl(proxy.server.,%proxy.view.num) $+ )] }
  goto loop
}
; displays the banned ips.
alias -l proxy.view.banned {
  if ($exists($proxy.banfile) == $false || $lines($proxy.banfile) == 0) {
    show no banned ip's in ban file.
    return
  }
  set -u1 %proxy.view.banned.num 0
  set -u1 %proxy.view.banned.len $lines($proxy.banfile)
  show banned ips ( $+ %proxy.view.banned.len $+ )
  :readagain
  inc %proxy.view.banned.num
  if (%proxy.view.banned.num > %proxy.view.banned.len) {
    return
  }
  set -u1 %proxy.view.banned.read $read -nl $+ %proxy.view.banned.num $proxy.banfile
  if (%proxy.view.banned.read) { echo 13 -a $space(4) %proxy.view.banned.read }
  goto readagain
}
; remove the user from the view list.
alias -l proxy.view.del {
  if ($window(@ProxyUsers) == $null) { return }
  set -u1 %proxy.view.del.find proxy user $$1 $+ : *
  set -u1 %proxy.view.del.num $fline(@ProxyUsers,%proxy.view.del.find,1,0)
  if (%proxy.view.del.num) {
    dline @ProxyUsers %proxy.view.del.num
    goto loop
  }
  :loop
  set -u1 %proxy.view.del.temp proxy user *:*
  if ($line(@ProxyUsers,%proxy.view.del.num) == $null || %proxy.view.del.temp iswm $line(@ProxyUsers,%proxy.view.del.num)) { return }
  dline @ProxyUsers %proxy.view.del.num
  goto loop
}
; variable handlers.
alias -l evac { if ($1 == $null) return | return $chr(37) $+ $1 $+ $2 }
alias -l evacl { if ($1 == $null) return | return % [ $+ [ $remove($1-2,$chr(32)) ] ] }
alias -l evacr { return $1- }
alias -l evar { if ($1 == $null) return | return % [ $+ [ $1 ] ] }
alias -l evau { return $remove($1-,$chr(32)) }
; trimming.
alias -l mtrim { return $rtrim($$1,$ltrim($$1,$$2-)) }
alias -l ltrim { return $right($2-,$calc($len($2-) - $1)) }
alias -l rtrim { return $left($2-,$calc($len($2-) - $1)) }
; prints text out in IRC proxy format.
alias -l show { echo -a [proxy]: $$1- }
; returns socket number.
alias -l socknum { return $gettok($sockname,3,46) }
; returns proxy symbol.
alias -l symbol { return [proxy]: }
; creates spaces with character 160.
alias -l space {
  unset %space
  if (($2 == $null) && ($1 isnum)) {
    set %space $str($chr(160),$$1)
    return %space
  }
  else {
    if ($len($strip($2-)) >= $1) set %space $left($strip($2-),$1)
    elseif ($len($strip($2-)) < $1) set %space $2- $+ $str($chr(160),$calc($1 - $len($strip($2-))))
    return %space
  }
}
; accept connections.
on 1:SOCKLISTEN:ircproxy: { proxy accept }
; opened connection.
on 1:SOCKOPEN:ircproxy.*: {
  if ($sockerr > 0) {
    proxy sendinfo $socknum error with connection, try again later.
    proxy sclose $socknum
  }
  inc %proxy.connections
  set $evac(proxy.connected.,$socknum) $true
  if ($evacl(proxy.pass.,$socknum) != $null) { sockwrite -tn $sockname PASS $evacl(proxy.pass.,$socknum) }
  if ($evacl(proxy.nick.,$socknum) != $null) { sockwrite -tn $sockname NICK $evacl(proxy.nick.,$socknum) }
  if ($evacl(proxy.user.,$socknum) != $null) { sockwrite -tn $sockname USER $evacl(proxy.user.,$socknum) }
}
; closing connection.
on 1:SOCKCLOSE:ircproxy.*: {
  proxy viewdel $socknum
  proxy sclose $socknum
}
; read incoming data.
on 1:SOCKREAD:ircproxy.*: {
  if ($sockerr > 0) { return }
  :readagain
  sockread %temp
  if ($sockbr == 0) { return }
  if ($gettok($sockname,2,46) == client) {
    if ($evacl(proxy.connected.,$socknum) == $true) {
      if ($window(@ProxyUsers)) {
        set -u1 %proxy.find.userline proxy user $socknum $+ :*
        iline @ProxyUsers $calc($fline(@ProxyUsers,%proxy.find.userline,1,0) + 1) $space(4) 6outgoing:13 %temp $+ 
      }
      sockwrite -tn $evacl(proxy.server.socket.,$socknum) %temp
      if (%proxy.idle.client != 0 && %proxy.idle.client != $null) { proxy resetidle $socknum }
    }
    else {
      set -u1 %proxy.incoming.command $gettok(%temp,1,32)
      if (%proxy.incoming.command == PASS) {
        if ($gettok(%temp,2,32) == $null) {
          proxy sendinfo $socknum you did not specify a server.
          proxy sclose $socknum
        }
        elseif ($gettok(%temp,2,32) != $null) {
          set -u1 %proxy.server $gettok($gettok(%temp,2,32),1,58)
          if (%proxy.server == 127.0.0.1 || %proxy.server == $ip || %proxy.server == localhost) {
            proxy sendinfo $socknum I don't think you would want to crash this server now would you?
            .timer 1 1 proxy sclose $socknum
            return
          }
          if ($gettok($gettok(%temp,2,32),2,64) != $null) { set $evac(proxy.pass.,$socknum) $gettok($gettok(%temp,2,32),2-,64) }
          set $evac(proxy.server.,$socknum) $gettok($gettok(%temp,2,32),1,58)
          set $evac(proxy.server.port.,$socknum) $iif($gettok($gettok(%temp,2,32),2,58) != $null,$gettok($gettok(%temp,2,32),2,58),6667)
          set $evac(proxy.server.socket.,$socknum) ircproxy.server. $+ $socknum
          sockopen ircproxy.server. $+ $socknum $evacl(proxy.server.,$socknum) $evacl(proxy.server.port.,$socknum)
        }
      }
      elseif (%proxy.incoming.command == USER) { set $evac(proxy.user.,$socknum) $gettok(%temp,2-,32) }
      elseif (%proxy.incoming.command == NICK) { set $evac(proxy.nick.,$socknum) $gettok(%temp,2-,32) }
    }
  }
  elseif ($gettok($sockname,2,46) == server) {
    if ($window(@ProxyUsers)) {
      set -u1 %proxy.find.userline proxy user $socknum $+ :*
      if ($fline(@ProxyUsers,%proxy.find.userline,1,0)) { iline @ProxyUsers $calc($fline(@ProxyUsers,%proxy.find.userline,1,0) + 1) $space(4) 3incoming:9 %temp $+  }
    }
    if ($gettok(%temp,2,32) == NICK && $gettok($ltrim(1,%temp),1,33) == $evacl(proxy.nick.,$socknum)) {
      set $evac(proxy.nick.,$socknum) $ltrim(1,$gettok(%temp,3,32))
    }
    proxy view
    sockwrite -tn ircproxy.client. $+ $socknum %temp
  }
  goto readagain
}
alias -l mp {
  if (proxy user *:* iswm $sline(@ProxyUsers,1)) {
    $$1-2 $rtrim(1,$gettok($sline(@ProxyUsers,1),3,32)) $3-
  }
}
menu @ProxyUsers {
  &send message to client: { mp proxy sendinfo $$?="Command to send to client:" }
  &send command to server: { mp proxy servsend $$?="Command to send to server:" }
  -
  &kill user: { mp proxy sclose }
}
