; Flow Control 1.0 
; by SoapForge

; Provides extra flow control commands

; * For Loop
;
; Uses the syntax /for start to stop do commands
;
; For example,
;
; for 1 to $nick($chan,0) do echo -a nicks in $chan - $!nick($chan,!n) 
;
; Would list all the nicks in the current channel to the active window.
;
; The !n is a internal variable for the current number the for loop is at.
;
; The exclaimation mark in $!nick is important - it stops mIRC from
; processing that identifer until the For loop runs it. You'll need to add 
; exclaimation marks to any identifers that use !n. 
;
; The code will attempt to guesstimate your intent by checking which
; of the start and stop numbers are larger. For example
; 
; for $nick($chan,0) to 1 do echo -a nicks in $chan - $!nick($chan,!n) 
;
; would do exactly the same thing, but loop from the total number of 
; nicks down to one - i.e, in reverse order.
;
; The For command should not be called from the command line. Wierd
; things may result.

; * Do loop
; 
; Uses the syntax /do commands until condition
;
; For example
;
; do readsocket until $!sockbr == 0
;
; Again, this command should not be used from the command line.

; * Notes
;
; Both of these two above commands need a workaround to use
; normal %variables inside the loop since the mIRC interpreter wil
; evaluate these beasties as soon as the line as processed.
; For example,
;
; do inc %wibble 1 until %wibble == 50
;
; won't work, while
;
; do inc % $+ wibble 1 until % $+ wibble == 50
;
; will. However, it's pretty ugly.

alias for {
  if ($2 != to) || ($4 != do) || ($1 !isnum) || ($3 !isnum) { return * For: Syntax /for start to stop do commands }
  if ($1 < $3) { 
    var %for.count up 
  }
  set %for.n $1
  :loop
  $ev($fr($5-))
  if (%for.count == up) {
    inc %for.n 1
    if (%for.n > $3) { unset %for.n | return }
  } 
  else {
    dec %for.n 1
    if (%for.n < $3) { unset %for.n | return }
  } 
  goto loop
} 

alias -l fr { return $replace($1-,!n,%for.n) }

alias do {
  var %do.u $findtok($1-,until,1,32)
  if ($do.get(check,$1-) == $false) { echo -a * Do loop: syntax - do commands until condition | return }
  var %do.if $do.get(ifstring,$1-)
  var %do.com $do.get(commandstring,$1-)
  :loop
  if ($iif( [ %do.if ] ,escape) == escape) { return }
  $ev(%do.com)
  goto loop
}

alias -l do.get {
  var %get.u $findtok($2-,until,1,32)
  if ($1 == ifstring) { 
    var %get.tmp $calc(%get.u + 1) $+ -
    return $gettok($2-,%get.tmp,32)
  }
  if ($1 == commandstring) { 
    var %get.tmp 1- $+ $calc(%get.u - 1) 
    return $gettok($2-,%get.tmp,32)
  }
  if ($1 == check) {
    if (%get.u == $null) || (%get.u == 0) || (%get.u == 1) { return $false }
    if (%get.u == $numtok($2-,32)) { return $false }
    return $true
  }
}

alias -l ev {
  var %ev.in $1-
  unset %ev.out
  :loop
  if ($gettok(%ev.in,1,32) != $null) {
    if (%ev.skipflag == 1) { 
      var %ev.out %ev.out $gettok(%ev.in,1,32) 
      unset %ev.skipflag
    }
    else {
      var %ev.out %ev.out [ [ $gettok(%ev.in,1,32) ] ]
    }
    if ($gettok(%ev.in,1,32) == set) || ($gettok(%ev.in,1,32) == dec) || ($gettok(%ev.in,1,32) == inc) || ($gettok(%ev.in,1,32) == unset) { var %ev.skipflag 1 }
    var %ev.in $deltok(%ev.in,1,32)
    goto loop   
  }
  return %ev.out
}
