; Encryption Thingy 1.2 
; basic key encryption 
; by SoapForge
;
; This is a complicated (as in "made more complex") Vigenere cipher. It's
; certainly not secure -  you can see the ciphertext isn't random just by
; looking at it - but I figure if you want that you wouldn't be using
; anything scripted with mIRC.
;
;
; ** Usage: $encrypt(key,string) / $decrypt(key,encrypted string)
;
; The key and string can be theoretically any length. In practice, mIRC will
; have a tantrum if it handles a string that's too long.
;
; The encrypted string length will be exactly double the unencrypted string
; length.
;
; Speed will depend on how fast your machine is. Expect some delay.
;
; Remember that to send the results though a irc server you'll need a method
; for handling any < 32 level characters the server might barf on. 
;
; Feel feel to correct, fold, tear, spindle, and/or multilate this code, and
; to include it in your own script (can't imagine anyone doing that, it
; ain't exactly useful)
;
;
; ** Note on valid characters:
; 
; While the binary / base 4 code can (hopefully) handle anything, the
; overlying code can't. Spaces in the string are handled with a simple
; character 32 > 160 and 160 > 32 replacement on encryption/decryption. Note
; that this *will* cause problems with binary files.
;
; No spaces in the key are allowed (you could patch this using the above
; method, should you care).
; 
; Should you want to use this code to encrypt in full binary without the
; limitations above, you'll have to rip off the overlaying character
; stuff - use $encrypt.bin(character to encrypt,key character) and
; $decrypt.bin(encrypted character pair,key character)
;
;
; ** Version changes
;
; 1.1 Bug fixes, optimized the code a smidgeon, added some (useless)
; comments, updated docs. Pretty much just a bugfix release.
;
; 1.2 Added example, fixed a typo. Wow. Another minor release.
;
; ** This header was brought to you by the letters T and S, and the number 7
;
;
; ** Example: 
; 
; A very simple encrypted talker thingy. 

#enc_example off
alias setkey {
  if ($1 != $null) {
    set %key $1
    if ($2 != $null) { echo -a Warning, only the first word will be used as the key }
  }
}
alias enctalk {
  if (%key == $null) { set %key agenerickeystring }
  if ($chan != $null) && ($1 != $null) {
    msg $chan [encrypted] $encrypt(%key,$1-)
  }
}
on *:text:[encrypted]*:#:{
  if ($2 != $null) { 
    if (%key == $null) { set %key agenerickeystring }
    echo $chan $nick said [decrypted] $decrypt(%key,$2-)
    halt
  }
}
#enc_example end

; ** The real script starts here (TM)

alias encrypt {
  ; $encrypt(key,string)
  unset %encrypt.*
  set %encrypt.keycount 1
  set %encrypt.strcount 1
  set %encrypt.s $replace($$2-,$chr(32),$chr(160))
  set %encrypt.slen $len(%encrypt.s)
  set %encrypt.klen $len($$1)
  :loop
  set %encrypt.out %encrypt.out $+ $encrypt.bin($mid(%encrypt.s,%encrypt.strcount,1),$mid($$1,%encrypt.keycount,1))
  inc %encrypt.keycount 1
  inc %encrypt.strcount 1
  if (%encrypt.keycount > %encrypt.klen) { set %encrypt.keycount 0 }
  if (%encrypt.strcount > %encrypt.slen) { 
    set -u0 %return %encrypt.out
    unset %encrypt.*
    return %return
  }
  goto loop  
}
alias decrypt {
  ; $decrypt(key,string)
  unset %encrypt.*
  set %encrypt.keycount 1
  set %encrypt.strcount 1
  set %encrypt.s $$2-
  set %encrypt.keylen $len($$1)
  set %encrypt.slen $len(%encrypt.s)
  :loop
  set %encrypt.out %encrypt.out $+ $decrypt.bin($mid(%encrypt.s,%encrypt.strcount,2),$mid($$1,%encrypt.keycount,1))
  inc %encrypt.keycount 1
  inc %encrypt.strcount 2
  if (%encrypt.keycount > %encrypt.keylen) { set %encrypt.keycount 0 }
  if (%encrypt.strcount > %encrypt.slen) { 
    set -u0 %return %encrypt.out
    unset %encrypt.*
    return  %return
  }
  goto loop  
}
alias -l encrypt.bin {
  ; Aka The Mother Of All Hard To Read Identifiers
  return $byte2chr($left($base42bin($digitadd($byte2bin($asc($$1)),$replace($replace($byte2bin($asc($$2)),1,2),0,1))),8)) $+ $byte2chr($right($base42bin($digitadd($byte2bin($asc($$1)),$replace($replace($byte2bin($asc($$2)),1,2),0,1))),8))
}
alias -l decrypt.bin {
  set %return $byte2bin($asc($left($$1,1))) $+ $byte2bin($asc($right($$1,1)))
  return $byte2chr($digitrem($bin2base4(%return),$replace($replace($byte2bin($asc($$2)),1,2),0,1)))
}
alias -l byte2chr {
  ; Ugly ducking 8 digit binary to decimal value routine
  unset %byte2chr.*
  set %byte2chr.count 1
  set %byte2chr.result 0
  if ($mid($$1,1,1) == 1) { inc %byte2chr.result 128 }
  if ($mid($$1,2,1) == 1) { inc %byte2chr.result 64 }
  if ($mid($$1,3,1) == 1) { inc %byte2chr.result 32 }
  if ($mid($$1,4,1) == 1) { inc %byte2chr.result 16 }
  if ($mid($$1,5,1) == 1) { inc %byte2chr.result 8 }
  if ($mid($$1,6,1) == 1) { inc %byte2chr.result 4 }
  if ($mid($$1,7,1) == 1) { inc %byte2chr.result 2 }
  if ($mid($$1,8,1) == 1) { inc %byte2chr.result 1 }
  set %return $chr(%byte2chr.result)
  unset %byte2chr.*
  return %return
}
alias -l base42bin {
  ; Another ugly duckling, this one converts the base4 string into binary again.   
  unset %base4.*  
  set %base4.count 1
  :loop
  if $mid($$1,%base4.count,1) == 0 { set %base4.result %base4.result $+ 00 }
  if $mid($$1,%base4.count,1) == 1 { set %base4.result %base4.result $+ 01 }
  if $mid($$1,%base4.count,1) == 2 { set %base4.result %base4.result $+ 10 }
  if $mid($$1,%base4.count,1) == 3 { set %base4.result %base4.result $+ 11 }
  inc %base4.count 1 
  if (%base4.count > $len($$1)) { 
    set -u0 %return %base4.result 
    unset %base4.*  
    return %return
  }
  goto loop
}
alias -l bin2base4 {
  ; Tweedledee and tweedledum. See above.
  unset %base4.*  
  set %base4.count 1
  :loop
  if $mid($$1,%base4.count,2) == 00 { set %base4.result %base4.result $+ 0 }
  if $mid($$1,%base4.count,2) == 01 { set %base4.result %base4.result $+ 1 }
  if $mid($$1,%base4.count,2) == 10 { set %base4.result %base4.result $+ 2 }
  if $mid($$1,%base4.count,2) == 11 { set %base4.result %base4.result $+ 3 }
  inc %base4.count 2
  if (%base4.count > $len($$1)) {
    set -u0 %return %base4.result
    unset %base4.*
    return %return
  }
  goto loop
}
alias -l digitadd {
  ; Curiouser and curiouser. Have a go at this one for yourself. 
  unset %digit.*  
  set %digit.count 1
  :loop
  set %digit.result %digit.result $+ $calc($mid($$1,%digit.count,1) + $mid($$2,%digit.count,1))
  inc %digit.count 1 
  if (%digit.count > $len($$1)) {
    set -u0 %return %digit.result
    unset %digit.*  
    return %return
  }
  goto loop
}
alias -l digitrem { 
  ; The reverse of digitadd. Nothin' exciting.
  unset %digit.*  
  set %digit.count 1
  :loop
  set %digit.result %digit.result $+ $calc($mid($$1,%digit.count,1) - $mid($$2,%digit.count,1))
  inc %digit.count 1 
  if (%digit.count > $len($$1)) { 
    set -u0 %return %digit.result
    unset %digit.*
    return %return
  }
  goto loop
}
alias -l byte2bin {
  ; Yup, another one that breaks mirrors. Decimal (0-255) to 8 digit binary string, left is most signifigant digit.
  unset %byte2bin.*
  set %byte2bin.1 $$1
  if (%byte2bin.1 > 127) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 128 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 63) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 64 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 31) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 32 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 15) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 16 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 7) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 8 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 3) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 4 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 1) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 2 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 }
  if (%byte2bin.1 > 0) { set %byte2bin.2 %byte2bin.2 $+ 1 | dec %byte2bin.1 1 } | else { set %byte2bin.2 %byte2bin.2 $+ 0 } 
  set -u0 %return %byte2bin.2 
  unset %byte2bin.*
  return %return
}
