;===========================------------------------------
;   Edge Topic Editor v1.1 (14th October, 1999) by Shawn Harkin / Edge Designs.
;==================================================


;=========----------------------
;   Events
;=============================
on *:LOAD:{ etloading | etinitaddon | unset %etapplied | unset %etchan* }
on *:START:{ etinitaddon | unset %etapplied | unset %etchan* }
on *:TOPIC:*:{ if ($1- != $null) { etsavetopic -t $chan $nick $1- } | if ($nick != $me) { etcheckdef -e $chan $1- } | if ($dialog(etopic) != $null) { etupdatedialog } }


;=========----------------------
;   Raw (when joining)
;=============================
raw 332:*:{ if ($3 != $null) { etsavetopic -j $2 $3- } | etcheckdef -e $2 $3- | if ($dialog(etopic) != $null) { etupdatedialog } }


;=========----------------------
;   Aliases
;=============================
alias etloading { linesep | echo -s  $+ $colour(topic) $+ ,99 $+ $timestamp *** Successfully Loaded Edge Topic Editor v1.1 - by Shawn Harkin.
  echo -s Edge Topic Editor will now appear in the Channel Menu
  echo -s /settopic in a Channel Window only will also present you with the Editor.
  echo -s If you have /run disabled (See General|Lock in Options), the help file will
  echo -s not run from the Editor, instead the file should be available at:
  echo -s  $mircdiredtopic\edtopic.txt | echo -s  $+ $colour(topic) $+ -------------- 
linesep }

alias etinitaddon { if ($isdir($mircdiredtopic) == $false) { mkdir edtopic }
  if ($isfile($mircdiredtopic\mytopics.log) == false) { write -c $mircdiredtopic\mytopics.log }
  if ($isfile($mircdiredtopic\global.log) == false) { write -c $mircdiredtopic\global.log }
etcheckhelpfile }

alias etcheckhelpfile { if ($isfile($mircdiredtopic\edtopic.txt) == $false) { if ($findfile($mircdir,edtopic.txt,1) != $null) { .rename $findfile($mircdir,edtopic.txt,1) $mircdiredtopic\edtopic.txt } } }

alias deftopic { if ($chan($active) == $active) { etcheckdef -d $active $chan($active).topic } }

alias topichelp { etcheckhelpfile | if ($isfile($mircdiredtopic\edtopic.txt) == $false) {
    echo -s  $+ $colour(topic) $+ ,99 $+ $timestamp *** Edge Topic Editor Help File Not Found!
  }
  else { run $mircdiredtopic\edtopic.txt }
}

alias settopic { ettopiceditor }

alias etupdatedialog {
  did -r etopic 40 | did -r etopic 41 | did -r etopic 42
  if ($lines($mircdiredtopic\mytopics.log) > 0) {
    var %mytopicslines = $lines($mircdiredtopic\mytopics.log)
    :mytopics
    if (%mytopicslines > 0) { did -a etopic 40 $read -nl $+ %mytopicslines $mircdiredtopic\mytopics.log | dec %mytopicslines | goto mytopics }
  }
  var %etchanfile = $mircdiredtopic\ $+ %etchan $+ .log
  if ($lines(%etchanfile) > 0) {
    var %etchanlines = $lines(%etchanfile)
    :etchan
    if (%etchanlines > 0) { did -a etopic 41 $read -nl $+ %etchanlines %etchanfile | dec %etchanlines | goto etchan }
  }
  if ($lines($mircdiredtopic\global.log) > 0) {
    var %globallines = $lines($mircdiredtopic\global.log)
    :etglobal
    if (%globallines > 0) { did -a etopic 42 $read -nl $+ %globallines $mircdiredtopic\global.log | dec %globallines | goto etglobal }
  }
  did -c etopic 40 1 | did -c etopic 41 1 | did -c etopic 42 1
}

alias etcheckdef {
  var %etoption = $right($1,1) | var %etchannel = $2 | var %ettopic = $3-
  if (%etoption == e) { if ($readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Enforce != 1) { goto end } }
  elseif (%etoption == d) { if ($readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Command != 1) { goto end } }
  if ($readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic != $null) && ($readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic != %ettopic) {
    var %etdefset = $readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings Style
    if (%etdefset == 2) { msg %etchannel $readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings ChanPrefix $readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic }
    elseif (%etdefset == 3) { var %etmsguser = $readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings DefUser | .msg %etmsguser $readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings UserPrefix $readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic }
    elseif (%etdefset == 4) { if ($readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings Custom != $null) { var %etcmd = $readini $mircdiredtopic\ $+ %etchannel $+ .ini Settings Custom | %etcmd $readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic } }
    else { topic %etchannel $readini $mircdiredtopic\ $+ %etchannel $+ .ini Default Topic }
  }
  :end
}

alias ettopiceditor { if ($chan($active) == $active) { var %chantopic = $dialog(etopic,etopic,-2) } }

alias etsavetopic {
  etinitaddon
  var %etnchan = $2
  if ($1 == -t) { var %enick = $3 | var %etopic = $4- }
  elseif ($1 == -j) { var %etopic = $3- }
  if (%enick == $me) {
    if ($isfile($mircdiredtopic\mytopics.log) == $false) { write -c $mircdiredtopic\mytopics.log }
    var %readtest = $read -w" $+ %etopic $+ " $mircdiredtopic\mytopics.log
    if (%readtest != $null) { write -dl $+ $readn $mircdiredtopic\mytopics.log }
    write $mircdiredtopic\mytopics.log %etopic
    if ($lines($mircdiredtopic\mytopics.log) > 15) { write -dl1 $mircdiredtopic\mytopics.log }
  }
  else {
    var %etchanfile = $mircdiredtopic\ $+ %etnchan $+ .log
    if ($isfile(%etchanfile) == $false) { write -c %etchanfile }
    var %readtest = $read -w" $+ %etopic $+ " %etchanfile
    if (%readtest != $null) { write -dl $+ $readn %etchanfile }
    write %etchanfile %etopic
    if ($lines(%etchanfile) > 15) { write -dl1 %etchanfile }
    if ($isfile($mircdiredtopic\global.log) == $false) { write -c $mircdiredtopic\global.log }
    var %readtest = $read -w" $+ %etopic $+ " $mircdiredtopic\global.log
    if (%readtest != $null) { write -dl $+ $readn $mircdiredtopic\global.log }
    write $mircdiredtopic\global.log %etopic
    if ($lines($mircdiredtopic\global.log) > 15) { write -dl1 $mircdiredtopic\global.log }
  }
}

alias etsavesettings {
  var %etchanini = $mircdiredtopic\ $+ %etchan $+ .ini
  if ($did(etopic,140).state == 1) { writeini %etchanini Default Enforce 1 } | else { remini %etchanini Default Enforce }
  if ($did(etopic,141).state == 1) { writeini %etchanini Default Default 1 } | else { remini %etchanini Default Default }
  if ($did(etopic,142).state == 1) { writeini %etchanini Default Command 1 } | else { remini %etchanini Default Command }
  if ($did(etopic,26) != $null) { writeini %etchanini Default Topic $did(etopic,26) } | else { remini %etchanini Default Topic }
  if ($did(etopic,27) != $null) { writeini %etchanini Settings ChanPrefix $did(etopic,27) } | else { remini %etchanini Settings ChanPrefix }
  if ($did(etopic,28) != $null) { writeini %etchanini Settings UserPrefix $did(etopic,28) } | else { remini %etchanini Settings UserPrefix }
  if ($did(etopic,29) != $null) && ($left($did(etopic,29),1) == /) && ($did(etopic,29) != /settopic) { writeini %etchanini Settings Custom $did(etopic,29) } | else { remini %etchanini Settings Custom }
  if ($did(etopic,146).state == 1) { var %etsettingsty = 2 } | elseif ($did(etopic,147).state == 1) { var %etsettingsty = 3 } | elseif ($did(etopic,148).state == 1) { var %etsettingsty = 4 } | else { var %etsettingsty = 1 }
  writeini %etchanini Settings Style %etsettingsty
  writeini %etchanini Settings DefUser $did(etopic,43)
}
alias etapplytopic {
  if ($chan(%etchan).topic != $did(etopic,25)) {
    if (%etapplied == $null) {
      if ($did(etopic,146).state == 1) { msg %etchan $did(etopic,27) $did(etopic,25) }
      elseif ($did(etopic,148).state == 1) { var %etmsguser = $did(etopic,43) | .msg %etmsguser $did(etopic,28) $did(etopic,25) }
      elseif ($did(etopic,147).state == 1) { if ($did(etopic,29) != $null) && ($left($did(etopic,29),1) == /) && ($did(etopic,29) != /settopic) { var %etcmd = $did(etopic,29) | %etcmd $did(etopic,25) } }
      else { topic %etchan $did(etopic,25) }
      set -u15 %etapplied yes
    }
  }
}


;=========----------------------
;   Dialog Events
;=============================
on *:dialog:etopic:init:0: {
  unset %etchan*
  unset %etapplied
  set %etchan $active
  dialog -t etopic Edge Topic Editor v1.0 (Editing %etchan $+ )
  did -r etopic 120
  did -a etopic 120 Topic for %etchan (Final Result)
  did -r etopic 122
  did -a etopic 122 Default Topic for %etchan
  etupdatedialog
  var %etchanini = $mircdiredtopic\ $+ %etchan $+ .ini
  if ($readini %etchanini Channel Channel == $null) { writeini %etchanini Channel Channel %etchan
    if ($readini %etchanini Settings Custom == $null) { writeini %etchanini Settings Custom $chr(47) }
    if ($readini %etchanini Settings ChanPrefix == $null) { writeini %etchanini Settings ChanPrefix !topic %etchan }
    if ($readini %etchanini Settings UserPrefix == $null) { writeini %etchanini Settings UserPrefix topic %etchan }
    if ($readini %etchanini Settings DefUser == $null) { writeini %etchanini Settings DefUser ChanServ }
  }
  if ($readini %etchanini Settings Style == $null) { writeini %etchanini Settings Style 1 }
  var %etpeople = $nick(%etchan,0)
  var %etperson = 1
  if (ChanServ ison %etchan) { did -a etopic 43 ChanServ | var %etChanServFound = 1 | if ($readini %etchanini Settings DefUser == ChanServ) { var %etSelectUser = 1 } }
  if (RealmServ ison %etchan) { did -a etopic 43 RealmServ | var %etRealmServFound = 1 | if ($readini %etchanini Settings DefUser == RealmServ) { var %etSelectUser = 1 | if (%etChanServFound == 1) { inc %etSelectUser } } }
  :loadusers
  if (%etperson <= %etpeople) {
    if ($nick(%etchan,%etperson) != ChanServ) && ($nick(%etchan,%etperson) != RealmServ) && ($nick(%etchan,%etperson) != $me) { did -a etopic 43 $nick(%etchan,%etperson)
      if ($readini %etchanini Settings DefUser == $nick(%etchan,%etperson)) { var %etSelectUser = %etperson
        if (%etChanServFound == 1) && (%etChanServFoundAgain != 1) { inc %etSelectUser }
        if (%etRealmServFound == 1) && (%etRealmServFoundAgain != 1) { inc %etSelectUser }
        if (%etFoundMe == 1) { dec %etSelectUser }
      }
    }
    elseif ($nick(%etchan,%etperson) == ChanServ) { var %etChanServFoundAgain = 1 }
    elseif ($nick(%etchan,%etperson) == RealmServ) { var %etRealmServFoundAgain = 1 }
    elseif ($nick(%etchan,%etperson) == $me) { var %etFoundMe = 1 }
  inc %etperson | goto loadusers }
  if (%etSelectUser == $null) { did -c etopic 43 1 } | else { did -c etopic 43 %etSelectUser }
  if ($readini %etchanini Default Enforce == 1) { did -c etopic 140 }
  if ($readini %etchanini Default Default == 1) { did -c etopic 141 }
  if ($readini %etchanini Default Command == 1) { did -c etopic 142 }
  did -a etopic 26 $readini %etchanini Default Topic
  did -a etopic 27 $readini %etchanini Settings ChanPrefix
  did -a etopic 28 $readini %etchanini Settings UserPrefix
  did -a etopic 29 $readini %etchanini Settings Custom
  var %style2 = $readini %etchanini Settings Style
  inc %style2 144
  did -c etopic %style2 1
  if ($readini %etchanini Default Default == 1) { did -a etopic 25 $readini %etchanini Default Topic } | else { did -a etopic 25 $chan(%etchan).topic }
}


on *:dialog:etopic:sclick:100: { did -r etopic 25 | did -a etopic 25 $chan(%etchan).topic }
on *:dialog:etopic:sclick:101: { did -r etopic 40 | write -c $mircdiredtopic\mytopics.log }
on *:dialog:etopic:sclick:102: { did -r etopic 41 | write -c $mircdiredtopic\ $+ %etchan $+ .log }
on *:dialog:etopic:sclick:103: { did -r etopic 42 | write -c $mircdiredtopic\global.log }
on *:dialog:etopic:sclick:104: { did -r etopic 25 | did -a etopic 25 $did(etopic,26) }
on *:dialog:etopic:sclick:40: { did -r etopic 25 | did -a etopic 25 $did(etopic,40) }
on *:dialog:etopic:sclick:41: { did -r etopic 25 | did -a etopic 25 $did(etopic,41) }
on *:dialog:etopic:sclick:42: { did -r etopic 25 | did -a etopic 25 $did(etopic,42) }
on *:dialog:etopic:edit:25: { unset %etapplied }
on *:dialog:etopic:sclick:80: { etsavesettings | etapplytopic }
on *:dialog:etopic:sclick:82: { etsavesettings | etapplytopic }
on *:dialog:etopic:sclick:83: { topichelp }


;=========----------------------
;   Dialog Table
;=============================
dialog etopic {
  title "Edge Topic Editor" 
  size -1 -1 625 295
  box "New Topic for Chan (will be used when Applying)", 120, 2 2 620 40
  edit "", 25, 7 17 530 20, autohs result
  button "Restore", 100, 540 17 75 20

  box "Recent Topics", 121, 2 45 620 85
  text "Set by You:", 60, 7 63 65 20, right
  combo 40, 80 60 450 270, drop
  button "Clear History", 101, 535 60 80 20
  text "This Channel:", 61, 7 84 65 20, right
  combo 41, 80 81 450 270, drop
  button "Clear History", 102, 535 81 80 20
  text "All Channels:", 62, 7 105 65 20, right
  combo 42, 80 102 450 270, drop
  button "Clear History", 103, 535 102 80 20

  box "Default Topic for Chan", 122, 2 133 620 60
  edit "", 26, 7 148 530 20, autohs
  button "Use Now", 104, 540 148 75 20
  check "Enforce Always", 140, 7 170 100 20
  check "Default Editable Topic", 141, 110 170 130 20
  check "Set Using /deftopic", 142, 245 170 120 20 

  box "Editor Settings", 123, 2 195 620 70
  radio "Set Topic (usually op only)", 145, 7 210 155 20, group
  radio "Msg Channel with Prefix:", 146, 160 210 140 20
  edit "", 27, 310 210 100 20, autohs
  radio "Custom Command (topic is applied)", 147, 425 210 250 20
  radio "Msg User(Bot?):", 148, 7 235 95 20
  combo 43, 110 235 140 200, drop vsbar
  text "with Prefix:", 63, 252 238 55 20
  edit "", 28, 305 235 100 20, autohs
  edit "", 29, 425 235 185 20, autohs

  button "OK", 80, 300 270 75 20, ok
  button "Cancel", 81, 380 270 75 20, cancel
  button "Apply", 82, 460 270 75 20, default
  button "Help", 83, 540 270 75 20
  text "Edge Topic Editor v1.1, by Shawn Harkin / Edge Designs", 64, 7 275 290 20
}


;=========----------------------
;   Menu Additions
;=============================
menu Channel {
  -
  Edge Topic Editor:settopic
  Edge Topic Editor Readme:topichelp
  -
}
menu Status {
  -
  Edge Topic Editor Readme:topichelp
  -
}
