; DBEProps.mrc - part of the mIRC DBE script
; author: Klaatu

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       I N S T A L L A T I O N
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Read the dbe.txt file for installation instructions
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       H I S T O R Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Read the dbevers.txt file history information
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; text properties events
on 1:dialog:proptext:sclick:5:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties...
  set %id $did($dname,10).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(4).state ) set %style %style $+ ,center
  if ( $did(8).state ) set %style %style $+ ,right
  if ( $did(12).state ) set %style %style ,disable
  if ( $did(13).state ) set %style %style ,hide
  if ( $did(14).state ) set %style %style ,group
  if ( $did(15).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; edit box properties events
on 1:dialog:propedit:sclick:21:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,24).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(4).state ) set %style %style ,center
  if ( $did(5).state ) set %style %style ,right
  if ( $did(6).state ) set %style %style ,multi
  if ( $did(7).state ) set %style %style ,pass
  if ( $did(8).state ) set %style %style ,read
  if ( $did(9).state ) set %style %style ,return
  if ( $did(10).state ) set %style %style ,disable
  if ( $did(11).state ) set %style %style ,hide
  if ( $did(12).state ) set %style %style ,group
  if ( $did(13).state ) set %style %style ,result
  if ( $did(14).state ) set %style %style ,hsbar
  if ( $did(15).state ) set %style %style ,autohs
  if ( $did(16).state ) set %style %style ,vsbar
  if ( $did(17).state ) set %style %style ,autovs
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; button properties events
on 1:dialog:propbutt:sclick:11:{
  ; local vars
  var %var, %size, %id, %tab, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,16).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %tab $did($dname,18).text
  set % $+ table.2.item $+ %object $+ .tab %tab
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(3).state ) set %style %style ,default
  if ( $did(5).state ) set %style %style ,ok
  if ( $did(6).state ) set %style %style ,cancel
  if ( $did(7).state ) set %style %style ,disable
  if ( $did(8).state ) set %style %style ,hide
  if ( $did(9).state ) set %style %style ,group
  if ( $did(10).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; check box properties events
on 1:dialog:propchk:sclick:11:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,16).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(3).state ) set %style %style ,3state
  if ( $did(5).state ) set %style %style ,left
  if ( $did(6).state ) set %style %style ,push
  if ( $did(7).state ) set %style %style ,disable
  if ( $did(8).state ) set %style %style ,hide
  if ( $did(9).state ) set %style %style ,group
  if ( $did(10).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; button properties events
on 1:dialog:proprad:sclick:10:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,15).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(4).state ) set %style %style ,left
  if ( $did(5).state ) set %style %style ,push
  if ( $did(6).state ) set %style %style ,disable
  if ( $did(7).state ) set %style %style ,hide
  if ( $did(8).state ) set %style %style ,group
  if ( $did(9).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; box properties events
on 1:dialog:propbox:sclick:7:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  ;;set %var % $+ table.2.item $+ %object $+ .size
  ;set %size [ [ %var ] ]
  ;getposandsize %size
  ;drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,11).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,2).text
  set % $+ table.2.item $+ %object $+ .text %text
  unset %style
  if ( $did(3).state ) set %style %style ,disable
  if ( $did(4).state ) set %style %style ,hide
  if ( $did(5).state ) set %style %style ,group
  if ( $did(6).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ; redraw entire dialog box
  drawdialog 2 @dialog
}

; list box properties events
on 1:dialog:proplist:sclick:6:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,12).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  unset %style
  if ( $did(1).state ) set %style %style ,sort
  if ( $did(2).state ) set %style %style ,disable
  if ( $did(3).state ) set %style %style ,hide
  if ( $did(4).state ) set %style %style ,group
  if ( $did(5).state ) set %style %style ,result
  if ( $did(10).state ) set %style %style ,extsel
  if ( $did(13).state ) set %style %style ,size
  if ( $did(14).state ) set %style %style ,vsbar
  if ( $did(15).state ) set %style %style ,hsbar
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; combo box properties events
on 1:dialog:propcombo:sclick:6:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  ;set %var % $+ table.2.item $+ %object $+ .size
  ;set %size [ [ %var ] ]
  ;getposandsize %size
  ;drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties
  set %id $did($dname,13).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  unset %style
  if ( $did(1).state ) set %style %style ,sort
  if ( $did(2).state ) set %style %style ,disable
  if ( $did(3).state ) set %style %style ,hide
  if ( $did(4).state ) set %style %style ,group
  if ( $did(5).state ) set %style %style ,result
  if ( $did(10).state ) set %style %style ,edit
  if ( $did(11).state ) set %style %style ,drop
  if ( $did(14).state ) set %style %style ,size
  if ( $did(15).state ) set %style %style ,vsbar
  if ( $did(16).state ) set %style %style ,hsbar
  set % $+ table.2.item $+ %object $+ .style %style
  ; repaint
  ;paintitem 2 %object @dialog %dbe.normal.color
  ; we redraw the entire dialog because if we just erase the object and repaint it
  ; it may cover up objects underneath it
  drawdialog 2 @dialog
}

; icon properties events - Ok button
on 1:dialog:propicon:sclick:7:{
  ; local vars
  var %id, %text, %filename, %index
  ; set the new properties
  set %id $did($dname,2).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  ; ensure filename has a relative path
  set %filename $did($dname,4).text
  set %filename $remove(%filename, $mircdir )
  if ( $exists(%filename) == $false ) {
    ; file doesn't exist!
    did -f propicon 4
    .timerdbeerror -m 1 10 /dbeerror propicon "File doesn't exist!"
    halt
  }
  set % $+ table.2.item $+ %object $+ .filename %filename
  set %index $did($dname,6).text
  set % $+ table.2.item $+ %object $+ .index %index
  unset %style
  if ( $did(18).state ) set %style %style ,disable
  if ( $did(19).state ) set %style %style ,hide
  if ( $did(20).state ) set %style %style ,group
  if ( $did(21).state ) set %style %style ,result
  set % $+ table.2.item $+ %object $+ .style %style
  ;drawcopy @dialogg 1 1 $window(@dialog).w $window(@dialog).h @dialog 1 1
  drawdialog 2 @dialog
}
; icon properties events - ... (Browse) button
on 1:dialog:propicon:sclick:9:{
  ; we can't use $dir= in a dialog event, so use a timer to run an alias
  .timerdbetimer -m 1 10 /dbegeticonfn 4
}
; dbegeticonfn - get icon filename - called by propicon dialog event when browse button is pressed.
;    $1 is filename object number in icon dialog box
alias -l dbegeticonfn {
  var %filename
  set %filename $dir="Select Icon File" *.bmp
  if ( %filename != $null && $exists(%filename) ) {
    ; convert path to a relative path
    set %filename $remove(%filename, $mircdir )
    did -o propicon $1 1 %filename
  }
}
; tab properties events
on 1:dialog:proptab:sclick:5:{
  ; local vars
  var %var, %size, %id, %text
  ; erase object
  set %var % $+ table.2.item $+ %object $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  drawcopy @dialogg %x %y %w %h @dialog %x %y
  ; set the new properties...
  set %id $did($dname,2).text
  if ( %id != $null ) { set % $+ table.2.item $+ %object $+ .id %id }
  set %text $did($dname,4).text
  set % $+ table.2.item $+ %object $+ .text %text
  ; repaint
  paintitem 2 %object @dialog %dbe.normal.color
}

; dialog properties events
on 1:dialog:propdialog:sclick:3:{
  var %text, %var, %size
  set %text $did($dname,2).text
  set % $+ table.2.dialog %text
  set %text $did($dname,6).text
  set % $+ table.2.title %text
  titlebar @dialog %text
  set %var % $+ table.2.size
  set %size [ [ %var ] ]
  getposandsize %size
  if ( $did(8).state ) {
    set % $+ table.2.option dbu
  }
  if ( $did(9).state ) {
    set % $+ table.2.option pixels
  }
}

; misc aliases
;
; getposandsize - set %x %y %w %h from $1-$4
alias getposandsize {
  %x = $1
  %y = $2
  %w = $3
  %h = $4
}

; deletegroup - delete all group items from specified table
;   $1 = table
alias deletegroup {
  var %i = 1, %id, %var, %group, %size
  :loop
  if ( %i <= %items ) {
    ; skip deleted objects
    set %var % $+ table. $+ $1 $+ .item $+ %i $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      set %var % $+ table. $+ $1 $+ .item $+ %i $+ .group
      set %group [ [ %var ] ]
      if ( %group ) {
        ; mark the item as deleted
        set % $+ table. $+ $1 $+ .item $+ %i $+ .id -1
        set %var % $+ table. $+ $1 $+ .item $+ %i $+ .size
        set %size [ [ %var ] ]
        getposandsize %size
        drawcopy @dialogg %x %y %w %h @dialog %x %y
      }
    }
    inc %i 1
    goto loop
  }
}

; paintgroup - display a group of items from specified table
;   $1 = table
alias paintgroup {
  var %i = 1, %id, %var, %group
  :loop
  if ( %i <= %items ) {
    ; skip deleted objects
    set %var % $+ table. $+ $1 $+ .item $+ %i $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      set %var % $+ table. $+ $1 $+ .item $+ %i $+ .group
      set %group [ [ %var ] ]
      if ( %group ) { paintitem $1 %i %window %dbe.group.color }
    }
    inc %i 1
    goto loop
  }
}

; paintitem - display a table item
;   $1 is the table number, $2 is the item number, $3 is the window, $4 is the color
alias paintitem {
  %dbe.win = %window
  %window = $3
  ; get fields common to all types
  var %var, %size, %type, %text, %table, %gwindow, %tabfocus, %tab, %id
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .size
  set %size [ [ %var ] ]
  ; get type
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .type
  set %type [ [ %var ] ]
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .style
  set %style [ [ %var ] ]
  ; don't paint items on tabs unless they are on the focus tab
  set %var % $+ table. $+ $1 $+ .tabfocus
  ; tabfocus is the id of tab that has the focus
  set %tabfocus [ [ %var ] ]
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .tab
  ; tab is the id of the tab this item is on. 0 means this item isn't on a tab.
  set %tab [ [ %var ] ]
  ; don't paint items that are on hidden tabs
  if ( %type != tab && %tab != 0 && %tab != %tabfocus ) { return }
  ; process by type
  if ( %type == text ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    diadrawtext $4 %size %type %text
  }
  if ( %type == edit ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    drawrect %window $4 1 %size
    diadrawtext $4 %size %type %text
  }
  if ( %type == button ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    set %style center
    drawrect %window $4 2 %size
    diadrawtext $4 %size %type %text
  }
  if ( %type isin checkradio ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    ; push button type?
    if ( push isin %style ) {
      drawrect %window $4 2 %size
      set %style center
      diadrawtext $4 %size %type %text
    }
    else {
      getposandsize %size
      ; calc space between the check box or radio button and the text.
      var %dbe.space
      set %dbe.space $calc(%dbe.fw + (%dbe.fw / 2))
      ; text on left or right of radio button
      if ( left isin %style ) {
        diadrawtext $4 %x %y $calc(%w - (%dbe.fw + 2)) %h %type %text
        if ( %type == check ) {
          drawrect %window $4 1 $calc(%x + $width(%text,%dbe.font,%dbe.fontsize,0,0) + %dbe.space) $calc(%y + ((%h - %dbe.fw) / 2))) %dbe.fw %dbe.fw
        }
        else {
          drawrect -e %window $4 1 $calc(%x + $width(%text,%dbe.font,%dbe.fontsize,0,0) + %dbe.space) $calc(%y + ((%h - %dbe.fw) / 2))) %dbe.fw %dbe.fw
        }
      }
      else {
        if ( %type == check ) {
          drawrect %window $4 1 %x $calc(%y + ((%h - %dbe.fw) / 2))) %dbe.fw %dbe.fw
        }
        else {
          drawrect -e %window $4 1 %x $calc(%y + ((%h - %dbe.fw) / 2))) %dbe.fw %dbe.fw
        }
        diadrawtext $4 $calc(%x + %dbe.space) %y $calc(%w - %dbe.space) %h %type %text
      }
    }
  }
  if ( %type == box ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    getposandsize %size
    ;drawrect %window 15 1 %x $calc(%y + (%dbe.fh / 2)) %w $calc(%h - (%dbe.fh / 2))
    drawrect %window $4 1 %x $calc(%y + (%dbe.fh / 2)) %w $calc(%h - (%dbe.fh / 2))
    diadrawtext $4 $calc(%x + %dbe.fw) %y %w %h %type %text
  }
  if ( %type == list ) {
    diadrawlistbox %size $4
  }
  if ( %type == combo ) {
    getposandsize %size
    drawrect %window $4 1 %x %y %w 21
    var %drop = no
    if ( drop isin %style ) { set %drop drop }
    diadrawlistbox %x $calc(%y + 24) %w $calc(%h - 24) $4 %drop
  }
  if ( %type ==  icon ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .filename
    set %fname [ [ [ %var ] ] ]
    getposandsize %size
    ; draw the icon within the allotted size...center it if it's smaller
    var %pic.fn, %pic.w, %pic.h, %pic.fit, %pic.x, %pic.y, %pic.size
    ;set %pic.fn $scriptdir $+ $nopath(%fname)
    set %pic.fn %fname
    set %pic.w $pic(%fname).width
    set %pic.h $pic(%fname).height
    set %pic.x %x
    set %pic.y %y
    ; assume pic is larger than allotted size
    set %pic.fit 0
    if ( %pic.w <= %w ) {
      ; icon is narrower... center it
      set %pic.x $calc(%x + ((%w - %pic.w)/2))
      set %pic.fit 1
    }
    if ( %pic.h <= %h ) {
    ;  ; icon is shorter... center it
      set %pic.y $calc(%y + ((%h - %pic.h)/2))
      inc %pic.fit 2
    }
    set %pic.size $iif( %w < %h , %w , %h )
    ; if icon fits inside the area... draw it centered
    if ( %pic.fit == 3 ) { drawpic %window %pic.x %pic.y %fname }
    ; if it fits width wise but not height wise
    elseif ( %pic.fit == 1 ) {
      drawpic -s %window $calc(%x + ((%w - %pic.size)/2)) %y %pic.size %pic.size %fname
    }
    ; if it fits height wise but not width wise
    elseif ( %pic.fit == 2 ) {
      drawpic -s %window %x $calc(%y + ((%h - %pic.size)/2)) %pic.size %pic.size %fname
    }
    ; if it doesn't fit at all...shrink it
    else { drawpic -s %window %x %y %w %h %fname }
    drawrect %window $4 1 %size
  }
  if ( %type == group ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .table
    set %table [ [ %var ] ]
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .window
    set %gwindow [ [ %var ] ]
    getposandsize %size
    drawcopy %gwindow 1 1 %w %h %window %x %y
    drawrect %window %dbe.group.color 1 %size
  }
  if ( %type == tab ) {
    ; draw the tab control
    drawtab $1 $2 $3 $4
  }
  %window = %dbe.win
}

; drawtab - draw a tab control
;   $1 is the table number, $2 is the item number, $3 is the window, $4 is the color
alias drawtab {
  var %var, %tabfocus, %id, %size, %focustab, %tabs, %tab, %items, %nexttab, %type, %text, %width, %newx
  set %var % $+ table. $+ $1 $+ .tabfocus
  ; tabfocus is the id of the tab that has the focus
  set %tabfocus [ [ %var ] ]
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .id
  ; id is the id of this item
  set %id [ [ %var ] ]
  set %var % $+ table. $+ $1 $+ .tabsize
  set %size [ [ %var ] ]
  getposandsize %size
  set %h $calc(%dbe.fh * 2)
  drawrect $3 $4 1 %size
  ; search all tab items in order and draw their names
  set %var % $+ table. $+ $1 $+ .tabs
  set %tabs [ [ %var ] ]
  if ( %tabs == $null ) { return }
  set %nexttab 1
  set %width 0
  set %style center
  :loop
  if ( %nexttab <= %tabs ) {
    set %var % $+ table. $+ $1 $+ .items
    set %items [ [ %var ] ]
    :loop2
    if ( %items != 0 ) {
      ; skip deleted items
      set %var % $+ table. $+ $1 $+ .item $+ %items $+ .id
      set %id [ [ %var ] ]
      if ( %id != -1 ) {
        set %var % $+ table. $+ $1 $+ .item $+ %items $+ .type
        set %type [ [ %var ] ]
        if ( %type == tab ) {
          set %var % $+ table. $+ $1 $+ .item $+ %items $+ .tab
          set %tab [ [ %var ] ]
          if ( %tab == %nexttab ) {
            set %var % $+ table. $+ $1 $+ .item $+ %items $+ .text
            set %text [ [ %var ] ]
            set %w $calc($width(%text,%dbe.font,%dbe.fontsize,0,0) + (5 * %dbe.fw)))
            set %newx $calc(%x + %width)
            if ( %id == %tabfocus ) {
              diadrawtext %dbe.group.color %newx %y %w %h button %text
            }
            else {
              diadrawtext %dbe.normal.color %newx %y %w %h button %text
            }
            ; save the tab's pos and size so we can tell when user clicks on it
            set %var % $+ table. $+ $1 $+ .item $+ %items $+ .size
            set [ [ %var ] ] %newx %y %w %h
            set %width $calc(%width + %w)
            goto nextloop
          }
        }
      }
      dec %items 1
      goto loop2
    }
    :nextloop
    inc %nexttab 1
    goto loop
  }
}

; diadrawlistbox
;   $1 = x, $2 = y, $3 = w $4 = h, $5 = color, $6 = drop
alias diadrawlistbox {
  ; seems the height of these things grows by font height...kinda
  var %lh
  set %lh $int( $calc(($4 - 6) / 20)))
  if ( %lh < 0 ) { set %lh 0 }
  if ( %lh > 3 ) { inc %lh 1 }
  if ( %lh > 8 ) { inc %lh 1 }
  if ( %lh > 12 ) { inc %lh 1 }
  set %lh $calc((%dbe.fh * %lh) + 6)
  if ( $6 == drop ) {
    drawrect -c %window $5 1 $1 $2 $3 %lh
  }
  else {
    drawrect %window $5 1 $1 $2 $3 %lh
  }
  ; show overhang
  if ( %lh < $4 ) {
    drawrect -c %window $5 1 $1 $calc($2 + %lh) $3 $calc($4 - %lh)
  }
}
; drawdialog - draw a dialog box from a dialog table
;   $1 is the table number, $2 is the window
alias drawdialog {
  ; local vars
  var %var, %objects, %id
  ; erase the window
  drawcopy @dialogg 1 1 $window($2).w $window($2).h $2 1 1
  ; process table
  set %var % $+ table. $+ $1 $+ .items
  set %objects [ [ %var ] ]
  :loop
  if ( %objects > 0 ) {
    ; skip deleted objects (ones with id==-1)
    set %var % $+ table. $+ $1 $+ .item $+ %objects $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      ; paint this object
      paintitem $1 %objects $2 %dbe.normal.color
    }
    dec %objects 1
    goto loop
  }
}

; convert - read a dialog table file into memory
;   $1 is optional filename
alias convert {
  if ( $1 == $null ) {
    ; get the dialog table filename
    set %dbe.tfn $dir="Select a dialog table file" $scriptdir*.mdt
  }
  else {
    %dbe.tfn = $1
  }
  if ( %dbe.tfn == $null ) { return }
  if ( $exists(%dbe.tfn) == $false ) {
    ; create a new table
    inc %tables 1
    var %fn = $gettok($nopath(%dbe.tfn),1,46)
    set % $+ table. $+ %tables $+ .dialog %fn
    set % $+ table. $+ %tables $+ .title $+ $chr(34) $+ %fn $+ $chr(34)
    set % $+ table. $+ %tables $+ .size -1 -1 -1 -1
    set % $+ table. $+ %tables $+ .option dbu
    set % $+ table. $+ %tables $+ .items 0
    set % $+ table. $+ %tables $+ .tabs 0
    set % $+ table. $+ %tables $+ .tabfocus 0
    set % $+ table. $+ %tables $+ .tabsize 0 0 0 0
    set % $+ table. $+ %tables $+ .nextid 1
    set %items 0
    return
  }
  ; open table file and find the first dialog
  var %l = $lines(%dbe.tfn), %option, %units, %var
  var %i = 1, %rec, %type, %size
  :loop
  if ( %i <= %l ) {
    %rec = $read -nl $+ %i %dbe.tfn
    ; check for comment
    if ( $left(%rec,1) == $asc(59) ) goto loopnext
    ; not comment... get record type
    %type = $gettok(%rec,1,32)
    ; handle the record type
    if ( %type == dialog ) {
      ; we have another dialog table
      inc %tables 1
      %items = 0
      ; create the var that will handle this dialog table
      set % $+ table. $+ %tables $+ .dialog $gettok(%rec,2,32)
      ; option was introduced in mIRC 5.61 ... older tables will not have it so we
      ; initialize the option to "none" which ensures we will NOT save an option
      ; unless the user sets one.
      set % $+ table. $+ %tables $+ .option none
      set % $+ table. $+ %tables $+ .tabs 0
      set % $+ table. $+ %tables $+ .tabfocus 0
      set % $+ table. $+ %tables $+ .tabsize 0 0 0 0
      ; assume units are in pixels incase we don't see an option statement
      set %option pixels
      set %units pixels
      goto loopnext
    }
    if ( %type == title ) {
      ; strip quotes if any
      set % $+ table. $+ %tables $+ .title $remove($gettok(%rec,2-,32),$chr(34))
      goto loopnext
    }
    if ( %type == size ) {
      set % $+ table. $+ %tables $+ .size $gettok(%rec,2-,32)
      goto loopnext
    }
    if ( %type == option ) {
      ; get the option
      set %option $gettok(%rec,2,32)
      set % $+ table. $+ %tables $+ .option %option
      if ( pixels isin %option ) {
        set %units pixels
        set %dbe.unit 1
      }
      if ( dbu isin %option ) {
        set %units dbu
        set %dbe.unit %dbe.dbu
      }
      goto loopnext
    }
    if ( %type isin texteditbuttoncheckradioboxtab ) {
      addtype1item %rec
      goto loopnext
    }
    if ( %type isin listcombo ) {
      addtype2item %rec
      goto loopnext
    }
    if ( %type == icon ) {
      addtype3item %rec
      goto loopnext
    }
    :loopnext
    inc %i 1
    goto loop
  }
  set %var % $+ table. $+ %tables $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  ; convert the size from dbu's to pixels here
  if ( %units == dbu ) {
    if ( %x != -1 ) {
      ; mIRC v5.61 bug?  it doesn't adjust x and y in size statement
      ;%dbe.wx = $pixels.x(%x)
      ;%dbe.wy = $pixels.y(%y)
      %dbe.wx = %x
      %dbe.wy = %y
      ; add border width
      set %dbe.ww $round($calc($pixels.x(%w) + (6 * %dbe.unit)),0)
      ; add height of titlebar
      set %dbe.wh $round($calc($pixels.y(%h) + (25 * %dbe.unit)),0)
    }
  }
  else {
    set %dbe.wx %x
    set %dbe.wy %y
    set %dbe.ww $round($calc(%w + 6),0)
    set %dbe.wh $round($calc(%h + 25),0)
  }
  ; set the nextid
  incnextid %tables
  ; everything is in pixels now
  set %units pixels
  set %dbe.unit 1
}

; addtype1item - add a type one item to the current table
;   $1- are the parameters:  type text,id,x y w h,styles
alias addtype1item {
  ; local vars
  var %rec, %type, %params, %text, %id, %var, %tabs, %style
  ;//echo -s addtype1item: 1 = $1 2 = $2 3 = $3 4 = $4 5 = $5 6 = $6 7 = $7 8 = $8 9 = $9
  set %rec $1-
  set %type $gettok(%rec,1,32)
  inc %items 1
  set % $+ table. $+ %tables $+ .item $+ %items $+ .type %type
  set %params $gettok(%rec,2-,32)
  set %text $gettok(%params,1,44)
  set %text $mid(%text,2,$calc($len(%text) - 2))
  set % $+ table. $+ %tables $+ .item $+ %items $+ .text %text
  set %id $gettok(%params,2,44)
  set %id $remove(%id,$chr(32))
  if ( %id == 0 ) {
    set %var % $+ table. $+ %tables $+ .nextid
    set %id [ [ %var ] ]
  }
  set % $+ table. $+ %tables $+ .item $+ %items $+ .id %id
  set % $+ table. $+ %tables $+ .item $+ %items $+ .size $pixels.size($gettok(%params,3,44))
  dbe.detab %tables %items $gettok(%params,4-,44)
  ; extra tab processing
  if ( %type == tab ) {
    ; update number of tabs in this dialog table
    set %var % $+ table. $+ %tables $+ .tabs
    set %tabs [ [ %var ] ]
    inc %tabs 1
    set [ [ %var ] ] %tabs
    if ( %tabs == 1 ) {
      ; first tab
      set %var % $+ table. $+ %tables $+ .tabsize
      set [ [ %var ] ] $pixels.size($gettok(%params,3,44))
      set %var % $+ table. $+ %tables $+ .tabfocus
      set [ [ %var ] ] %id
    }
    set % $+ table. $+ %tables $+ .item $+ %items $+ .tab %tabs
  }
  set % $+ table. $+ %tables $+ .items %items
  setnextid %tables %id
}

; addtype2item - add a type two item to the current table
;   $1- are the parameters:  type id,x y w h,styles
alias addtype2item {
  ; local vars
  var %rec, %type, %params, %text, %id,  %var
  ;//echo -s addtype2item: 1 = $1 2 = $2 3 = $3 4 = $4 5 = $5 6 = $6 7 = $7 8 = $8 9 = $9
  set %rec $1-
  set %type $gettok(%rec,1,32)
  inc %items 1
  set % $+ table. $+ %tables $+ .item $+ %items $+ .type %type
  set %params $gettok(%rec,2-,32)
  set %id $gettok(%params,1,44)
  set %id $remove(%id,$chr(32))
  if ( %id == 0 ) {
    set %var % $+ table. $+ %tables $+ .nextid
    set %id [ [ %var ] ]
  }
  set % $+ table. $+ %tables $+ .item $+ %items $+ .id %id
  set % $+ table. $+ %tables $+ .item $+ %items $+ .size $pixels.size($gettok(%params,2,44))
  dbe.detab %tables %items $gettok(%params,3-,44)
  set % $+ table. $+ %tables $+ .items %items
  setnextid %tables %id
}

; addtype3item - add a type three item to the current table
;   $1- are the parameters:  type id,x y w h,filename,index,style
alias addtype3item {
  ; local vars
  var %rec, %type, %params, %text, %id,  %var
  ;//echo -s addtype3item: 1 = $1 2 = $2 3 = $3 4 = $4 5 = $5 6 = $6 7 = $7 8 = $8 9 = $9
  set %rec $1-
  set %type $gettok(%rec,1,32)
  inc %items 1
  set % $+ table. $+ %tables $+ .item $+ %items $+ .type %type
  set %params $gettok(%rec,2-,32)
  set %id $gettok(%params,1,44)
  set %id $remove(%id,$chr(32))
  if ( %id == 0 ) {
    set %var % $+ table. $+ %tables $+ .nextid
    set %id [ [ %var ] ]
  }
  set % $+ table. $+ %tables $+ .item $+ %items $+ .id %id
  ;set % $+ table. $+ %tables $+ .item $+ %items $+ .size $gettok(%params,2,44)
  set % $+ table. $+ %tables $+ .item $+ %items $+ .size $pixels.size($gettok(%params,2,44))
  set % $+ table. $+ %tables $+ .item $+ %items $+ .filename $strip($gettok(%params,3,44))
  set % $+ table. $+ %tables $+ .item $+ %items $+ .index $gettok(%params,4,44)
  dbe.detab %tables %items $gettok(%params,5-,44)
  set % $+ table. $+ %tables $+ .items %items
  setnextid %tables %id
}

; addtype4item - add a type four item to the current table
; NOTE: type 4 is a group.  It is defined by DBE not by mIRC.
;   $1 = table, $2- are the parameters:  type id,x y w h,table,window,x,y
alias addtype4item {
  ; local vars
  var %rec, %type, %params, %text, %id,  %var
  set %rec $2-
  set %type $gettok(%rec,1,32)
  inc %items 1
  set % $+ table. $+ $1 $+ .item $+ %items $+ .type %type
  set %params $gettok(%rec,2-,32)
  set %id $gettok(%params,1,44)
  set %id $remove(%id,$chr(32))
  if ( %id == 0 ) {
    set %var % $+ table. $+ $1 $+ .nextid
    set %id [ [ %var ] ]
  }
  set % $+ table. $+ $1 $+ .item $+ %items $+ .id %id
  set % $+ table. $+ $1 $+ .item $+ %items $+ .tab 0
  set % $+ table. $+ $1 $+ .item $+ %items $+ .size $pixels.size($gettok(%params,2,44))
  set % $+ table. $+ $1 $+ .item $+ %items $+ .table $gettok(%params,3,44)
  set % $+ table. $+ $1 $+ .item $+ %items $+ .window $gettok(%params,4,44)
  set % $+ table. $+ $1 $+ .item $+ %items $+ .orgx $gettok(%params,5,44)
  set % $+ table. $+ $1 $+ .item $+ %items $+ .orgy $gettok(%params,6,44)
  set % $+ table. $+ $1 $+ .items %items
  setnextid $1 %id
}

; dbe.entab - add tab style if object is on a tab
;   $1=x, $2=y, $3=style
alias dbe.entab {
  var %var, %size, %focustab, %style
  set %var % $+ table. $+ %tables $+ .tabsize
  set %size [ [ %var ] ]
  getposandsize %size
  if ( $inrect($1,$2,%x,%y,%w,%h) ) {
    set %var % $+ table. $+ %tables $+ .tabfocus
    set %focustab [ [ %var ] ]
    set %style $3
    if ( %style != $null ) { set %style %style $+ $chr(44) }
    set %style %style $+ tab $+ $chr(32) $+ %focustab
  }
  return %style
}

; dbe.detab - parse a style specification, remove a tab specifier if any and
;   set the items' style and tab variables.
;   $1 = table, $2 = item, $3- = style
alias dbe.detab {
  var %match, %style, %tab = 0
  set %style $3-
  set %match $matchtok(%style,tab,1,44)
  if ( %match != $null ) {
    set %tab $gettok(%match,2,32)
    if ( %tab == $null ) { set %tab 0 }
    set %style $remtok(%style,%match,1,44)
  }
  set % $+ table. $+ $1 $+ .item $+ $2 $+ .tab %tab
  set % $+ table. $+ $1 $+ .item $+ $2 $+ .style %style
}

; setnextid - each table holds a nextid value.  This is the id we will
;   assign to the next item added to the dialog box.  When we read dialog box
;   tables in we keep track of the highest id we've seen and add one to it when
;   the reading is done.
;   $1 is the table, $2 is the id
alias setnextid {
  ; if id is > nextid then set nextid to it
  var %id
  set %id % $+ table. $+ $1 $+ .nextid
  if ( [ [ %id ] ] < $2 ) { set [ [ %id ] ] $2 }
}

; incnextid - inc the specified tables nextid value by 1
;   $1 is the table
alias incnextid {
  var %id
  set %id % $+ table. $+ $1 $+ .nextid
  inc [ [ %id ] ] 1
}

; diacopy - save a copy of the specified item in the specified table
;   so user can paste it later.  The third parameter specifies whether
;   to save the items id or save an id of zero.  The savedialog alias uses the
;   first form, while the Copy menu item uses the second.  The forth parameter
;   specifies how to change the objects size: valid values are none, dbu, and pixels.
;   Savedialog uses dbu or none while the Copy menu uses none, and convert uses pixels
;   or dbu.
;   $1 = table, $2 = item, $3 = save id?, $4 = convert size?
alias diacopyitem {
  var %var, %type, %text, %size, %style, %filename, %index, %id, %tab
  if ( $3 == true ) {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .id
    set %id [ [ %var ] ]
  }
  else { set %id 0 }
  ; save item as a %rec string
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .type
  set %type [ [ %var ] ]
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .tab
  set %tab [ [ %var ] ]
  if ( %type == tab && %tab == 1 ) {
    set %var % $+ table. $+ $1 $+ .tabsize
  }
  else {
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .size
  }
  if ( %tab != 0 ) {
    set %tab ,tab $+ $chr(32) $+ %tab
  }
  else {
    ; mirc bug? the following unset seems to set %tab to 1
    ;unset %tab
    set %tab $null
  }
  set %size [ [ %var ] ]
  ;if ( %type != icon ) {
    if ( $4 == dbu ) {
      set %size $dbu.size(%size)
    }
    elseif ( $4 == pixels ) {
      set %size $pixels.size(%size)
    }
  ;}
  if ( %type isin texteditbuttoncheckradio ) {
    ; %type "text",id,size,style
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .style
    set %style [ [ %var ] ]
    if ( %style != $null && $left(%style,1) != $chr(44)) { set %style $chr(44) $+ %style }
    set %dbe.copy.item %type " $+ %text $+ " $+ , %id $+ , %size $+ %style %tab
  }
  if ( %type isin tab ) {
    ; %type "text",id[,size]
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .tab
    set %tab [ [ %var ] ]
    if ( %tab == 1 ) {
      set %dbe.copy.item %type " $+ %text $+ " $+ , %id $+ , %size
    }
    else {
      set %dbe.copy.item %type " $+ %text $+ " $+ , %id
    }
  }
  if ( %type == box ) {
    ; box "text",id,size
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .text
    set %text [ [ %var ] ]
    set %dbe.copy.item %type " $+ %text $+ " $+ , %id $+ , %size %tab
  }
  if ( %type isin listcombo ) {
    ; %type id,size,style
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .style
    set %style [ [ %var ] ]
    if ( %style != $null && $left(%style,1) != $chr(44)) { set %style $chr(44) $+ %style }
    set %dbe.copy.item %type %id $+ , %size $+ %style %tab
  }
  if ( %type == icon ) {
    ; icon id,size,filename,index,style
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .filename
    set %filename [ [ %var ] ]
    ; if the icon file is in the script directory, then save just the filename
    if ( $nofile(%filename) == $scriptdir ) { set %filename $nopath(%filename) }
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .index
    set %index [ [ %var ] ]
    set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .style
    set %style [ [ %var ] ]
    if ( %style != $null && $left(%style,1) != $chr(44)) { set %style $chr(44) $+ %style }
    set %dbe.copy.item %type %id $+ , %size $+ , %filename $+ , %index %style %tab
  }
}

; savedialog
;   $1 = table number, $2 = filename
alias savedialog {
  var %fn, %var, %id, %option, %info, %type, %text, %size, %style, %filename, %index, %i, %w, %h, %units
  %fn = $2
  ; get the dialog table name
  set %var % $+ table. $+ $1 $+ .dialog
  set %info [ [ %var ] ]
  ; write a comment line
  write -c %fn $chr(59) %info table created by DBE v $+ %dbe.ver
  write %fn $chr(59) http://www.borg.com/~chuck
  ; dialog name {
  write %fn dialog %info $chr(123)
  ; title "title"
  set %var % $+ table. $+ $1 $+ .title
  set %info [ [ %var ] ]
  write %fn title $chr(34) $+ %info $+ $chr(34)
  ; option
  set %var % $+ table. $+ $1 $+ .option
  set %option [ [ %var ] ]
  if ( none isin %option ) { set %units pixels }
  if ( pixels isin %option ) { set %units pixels }
  if ( dbu isin %option ) { set %units dbu }
  write %fn option %option
  ;   size = x y (w - border width) (h - height of picture window titlebar)
  if ( %units == pixels ) {
    set %dbe.unit 1
  }
  else {
    set %dbe.unit %dbe.dbu
  }
  set %w $calc($window(%window).w - (6 * %dbe.unit))
  set %h $calc($window(%window).h - (25 * %dbe.unit))
  if ( %units == pixels ) {
    write %fn size $window(%window).x $window(%window).y %w %h
    ; all internal units are in pixels already so tell diacopyitem not to change them
    set %units none
  }
  else {
    ; mIRC v5.61 seems to have a bug?  it doesn't adjust the x and y values in the size
    ; statement but it does adjust them in the objects.
    ;write %fn size $dbu.x($window(%window).x) $dbu.y($window(%window).y) $dbu.x(%w) $dbu.y(%h)
    ;write %fn size $dbu.x($window(%window).dx) $dbu.y($window(%window).dy) $dbu.x(%w) $dbu.y(%h)
    write %fn size $window(%window).x $window(%window).y $dbu.x(%w) $dbu.y(%h)
  }
  ; now the controls... first the tab controls
  %i = 1
  :loop
  if ( %i <= %items ) {
    ; skip deleted objects
    set %var % $+ table. $+ $1 $+ .item $+ %i $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      set %var % $+ table. $+ $1 $+ .item $+ %i $+ .type
      set %type [ [ %var ] ]
      if ( %type == tab ) {
        diacopyitem $1 %i true %units
        write %fn %dbe.copy.item
      }
    }
    inc %i 1
    goto loop
  }
  ; now the non-tab controls
  %i = 1
  :loop2
  if ( %i <= %items ) {
    ; skip deleted objects
    set %var % $+ table. $+ $1 $+ .item $+ %i $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      set %var % $+ table. $+ $1 $+ .item $+ %i $+ .type
      set %type [ [ %var ] ]
      if ( %type != tab ) {
        diacopyitem $1 %i true %units
        write %fn %dbe.copy.item
      }
    }
    inc %i 1
    goto loop2
  }
  ; write closing brace
  write %fn $chr(125)
  ; unset %dbe.copy.item because it's not a valid copy item now...it has an id in it
  unset %dbe.copy.item
  ; reset to pixels
  set %dbe.unit 1
}

; dbeerror
;   $1 is the dialog that has the error, $2- is the error message
alias dbeerror {
  ;set %dbe.var $2-
  set %dbe.error $?!= [ $+ [ $2- ] ]
  dialog -v $1
}
