; DBE.mrc - mIRC Dialog Box Editor script
; author: Klaatu

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       I N S T A L L A T I O N
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Read the dbe.txt file for installation instructions
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       H I S T O R Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Read the dbevers.txt file.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; EVENTS Section
;
; install/initialize the script
;
on 1:load:/install
on 1:start:/initialize
;on 1:keyup:@dialog:*:{
;  //echo -s saw keyup: keyval = $keyval , keyrpt = $keyrpt
;}

; configure dialog - ok
on 1:dialog:dbeconfig:sclick:7:{
  set %dbe.grid.width $did($dname,3).text
  if ( %dbe.grid.width == $null ) set %dbe.grid.width 10
  set %dbe.grid.height $did($dname,3).text
  if ( %dbe.grid.height == $null ) set %dbe.grid.height 10
  set %dbe.grid.snap $did(6).state
  dbemakegrid
}

; MENUS Section
;
; Menubar Menu
menu menubar {
  &DBE
  .Edit dialog:/dbe
  .Configure:/dbeconfig
  .-
  .Uninstall:/dbe.uninstall
  .About:/echo -a DBE Script [ %dbe.ver ]
}

; ALIASES Section
;
; dbeconfig - configure the dbe
alias dbeconfig {
  dialog -m dbeconfig dbeconfig
  did -a dbeconfig 3 %dbe.grid.width
  did -a dbeconfig 5 %dbe.grid.height
  if ( %dbe.grid.snap == 1 ) { did -c dbeconfig 6 }
  else { did -u dbeconfig 6 }
}

; DBE - edit a dialog box
alias dbe {
  var %title
  reinitialize
  ; create support window
  window -hp @dialogs 1 1 $window(-1).w $window(-1).h
  ; tools window
  convert $scriptdirdbetools.mdt
  window -hk0p +L @dialogt $calc($window(-1).w - %dbe.ww) 1 %dbe.ww %dbe.wh @dialogt
  drawdialog 1 @dialogt

  ; read dialog table
  convert
  ; handle case where user canceled
  if ( %dbe.tfn == $null ) {
    window -c @dialogs
    window -c @dialogt
    return
  }
  ; create the edit window
  set %window @dialog
  window -hk0p %window %dbe.wx %dbe.wy %dbe.ww %dbe.wh @dialog
  set %title % $+ table. $+ %tables $+ .title
  titlebar %window [ [ %title ] ]
  ; show the grid
  drawcopy @dialogg 1 1 $window(%window).w $window(%window).h @dialog 1 1
  ; draw it
  drawdialog 2 %window
  ; save the drawing
  ;drawcopy @dialog 1 1 %dbe.ww %dbe.wh @dialogs 1 1
  drawcopy @dialog 1 1 $window(%window).w $window(%window).h @dialogs 1 1
  ; move tool window along right side of dialog window
  window @dialogt $calc(%dbe.wx + %dbe.ww + 2) %dbe.wy
  titlebar @dialogt DBE Tools
  ; show the tool window and the edit window
  window -ar @dialogt
  window -ar %window
}

; diadrawtext - draw text within an area
;   $1=color, $2=x, $3=y, $4=w, $5=h
;   $1=color, $2=x, $3=y, $4=w, $5=h, $6=type, $7-=text
alias diadrawtext {
  var  %line, %type = $6, %text = $7-
  ;//echo -s diadrawtext: $1 , $2 , $3 , $4 , $5 , $6 , $7-
  ; draw a box that shows the field size unless its text for a box object
  if ( %type != box ) { drawrect %window 15 1 $2 $3 $4 $5 }
  if ( %text == $null ) { return }
  var %dbeh, %dbey, %dbe.len, %dbe.chars, %dbes, %dbec, %dbel, %dbe.tw, %dbex, %dbew, %dbecanwrap, %dbewrap, %dbew1
  set %dbecanwrap $false
  set %dbex $2
  set %dbey $3
  set %dbew $4
  set %dbeh $5
  ; center text vertically
  if ( %type isin buttoncheckradio ) {
    %dbeh = $height(%text,%dbe.font,%dbe.fontsize)
    %dbey = $calc( $3 + 2 + (($5 - %dbeh) / 2 ))
  }
  elseif ( %type == edit ) {
    set %dbex $calc($2 + 6)
    dec %dbew 8
    set %dbey $calc($3 + 6)
    dec %dbeh 8
    ; if vertical scroll bar narrow width
    if ( vsbar isin %style ) { dec %dbew 15 }
    ; if horizontal scroll bar shorten height
    if ( hsbar isin %style ) { dec %dbeh 15 }
    ; if multiline we can try to wrap
    ;elseif ( multi isin %style ) { set %dbecanwrap $true }
    if ( multi isin %style ) { set %dbecanwrap $true }
  }
  elseif ( %type == text ) { set %dbecanwrap $true }
  set %dbe.maxy $calc(%dbey + %dbeh - 1)

  ; draw the text within the object's area, wrap if necessary.
  initgetword %text
  :loop
  set %line $buildline(%dbew)
  if ( %line == $null ) { return }
  ; left, center, right justify text horizontally
  %dbew1 = $width(%line,%dbe.font,%dbe.fontsize,0,0)
  if ( center isin %style ) {
    %dbex = $calc( $2 + (((%dbew - %dbew1) / 2 ) - 1))
  }
  elseif ( right isin %style ) {
    ;%dbex = $calc( $2 + (%dbew - %dbew1 - 2))
    %dbex = $calc( $2 + ((%dbew - %dbew1) - 1))
  }
  drawtext -c %window $1 %dbe.font %dbe.fontsize %dbex %dbey %dbew %dbeh %line
  if ( %dbecanwrap == $false ) { return }
  inc %dbey %dbe.fh
  dec %dbeh %dbe.fh
  if ( %dbey > %dbe.maxy) { return }
  ; multiline editboxes need multiples of font height
  if ( %type == edit && $calc(%dbe.maxy - %dbey + 1) < %dbe.fh ) { return }
  goto loop
}

alias -l initgetword {
  set %dbe.words $1-
  set %dbe.numwords $numtok(%dbe.words,32)
  set %dbe.nextword 1
}

alias -l peekword {
  if ( %dbe.nextword > %dbe.numwords ) { return $null }
  return $gettok(%dbe.words,%dbe.nextword,32)
}

alias -l getword {
  set %dbe.word $peekword()
  if ( %dbe.word != $null ) { inc %dbe.nextword 1 }
  return %dbe.word
}

; buildline - accumulate words that will fit in specified width
;   $1 = width
alias -l buildline {
  var %width, %line, %word, %line2
  set %width $1
  set %line $null
  :loop
  set %word $peekword
  if ( %word == $null ) { return %line }
  if ( %line == $null ) { set %line2 %word }
  else { set %line2 %line $+ $chr(32) $+ %word }
  if ( $width(%line2,%dbe.font,%dbe.fontsize,0,0) >= %width ) { return %line }
  set %line %line2
  inc %dbe.nextword 1
  goto loop
}

; Window Menu
menu @dialog {
  mouse:{
    ; local variables
    var %dist.x, %dist.y, %var, %type
    %mx = $mouse.x
    %my = $mouse.y
    set %var % $+ table.3.item $+ %object $+ .type
    set %type [ [ %var ] ]
    if ( %dbe.move ) {
      ; object moved ... erase object from old position
      drawcopy @dialogs %c1.x %c1.y %c1.w %c1.h @dialog %c1.x %c1.y
      ; calc new location = mouse location plus hot-spot offset
      %c1.x = $calc($mouse.x + %dbe.deltax)
      %c1.y = $calc($mouse.y + %dbe.deltay)
      ; now snap to grid
      if ( %dbe.grid.snap ) {
        set %c1.x $int($calc( %c1.x / %dbe.grid.width ))
        set %c1.y $int($calc( %c1.y / %dbe.grid.height ))
        set %c1.x $calc( %c1.x * %dbe.grid.width )
        set %c1.y $calc( %c1.y * %dbe.grid.height )
      }
      ; set objects new position and size
      if ( %type == tab ) {
        set %var % $+ table.3.tabsize
      }
      else {
        set %var % $+ table.3.item $+ %object $+ .size
      }
      set [ [ %var ] ] %c1.x %c1.y %c1.w %c1.h
      ; draw the object
      paintitem 3 %object %window %dbe.normal.color
    }
    if ( %dbe.resize ) {
      ; erase old image
      drawcopy @dialogs %c1.x %c1.y %c1.w %c1.h @dialog %c1.x %c1.y
      ; calc new size - need distance we traveled in the resize direction only
      %dist.x = $calc( $mouse.x - %c1.mx)
      %dist.y = $calc( $mouse.y - %c1.my)
      if (%c1.dir == 1 ) {
        ; resizing left
        %c1.x = $calc(%c1.x + %dist.x)
        %c1.w = $calc(%c1.w + (%dist.x * -1))
      }
      if (%c1.dir == 2 ) {
        ; resizing right
        %c1.w = $calc(%c1.w + %dist.x)
      }
      if (%c1.dir == 3 ) {
        ; resizing up
        %c1.y = $calc(%c1.y + %dist.y)
        %c1.h = $calc(%c1.h + (%dist.y * -1))
      }
      if (%c1.dir == 4 ) {
        ; resizing down
        %c1.h = $calc(%c1.h + %dist.y)
      }
      ; save the new mouse position
      %c1.mx = $mouse.x
      %c1.my = $mouse.y
      ; show the resize rectangle
      %x = %c1.x
      %y = %c1.y
      %w = %c1.w
      %h = %c1.h
      ; set objects new position and size
      if ( %type == tab ) {
        set %var % $+ table.3.tabsize
      }
      else {
        set %var % $+ table.3.item $+ %object $+ .size
      }
      set [ [ %var ] ] %c1.x %c1.y %c1.w %c1.h
      ; draw the object
      paintitem 3 %object %window %dbe.normal.color
      ; draw the resizing line
      if ( %c1.dir == 1 ) { drawline @dialog 3 1 %x %y %x $calc(%y + %h) }
      elseif ( %c1.dir == 2 ) { drawline @dialog 3 1 $calc(%x + %w) %y $calc(%x + %w) $calc(%y + %h) }
      elseif ( %c1.dir == 3 ) { drawline @dialog 3 1 %x %y $calc(%x + %w) %y }
      else { drawline @dialog 3 1 %x $calc(%y + %h) $calc(%x + %w) $calc(%y + %h) }
    }
    ; selecting multiple objects?
    if ( %dbe.group ) {
      ; yes... erase old box
      drawcopy @dialogs %dbe.gx %dbe.gy %dbe.gw %dbe.gh @dialog %dbe.gx %dbe.gy
      ; calc coordinates of top left corner
      var %x, %y, %w, %h
      set %w $calc(%mx - %c1.x)
      if ( %w > 0 ) { set %x %c1.x }
      else { set %x %mx | set %w $calc(%w * (0 - 1)) }
      set %h $calc(%my - %c1.y)
      if ( %h > 0 ) { set %y %c1.y }
      else { set %y %my | set %h $calc(%h * (0 - 1)) }
      ; draw box from origin to current location
      drawrect -c @dialog 4 1 %x %y %w %h
      set %dbe.gx %x | set %dbe.gy %y | set %dbe.gw %w | set %dbe.gh %h
    }
  }
  sclick:{
    ; left mouse button is down... prepare to move or resize object
    ; local variables
    var %dist.x.m, %dist.w.m, %dist.y.m, %dist.h.m, %var, %tab, %tabfocus, %id, %size, %type
    set %mx $mouse.x
    set %my $mouse.y
    ; is mouse in a dialog object?  note: $inobject returns with the object's
    ; position and size in %x, %y, %w, and %h
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      ; if object is a tab and tab doesn't have focus then give it the focus
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
      set %type [ [ %var ] ]
      if ( %type == tab ) {
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
        set %id [ [ %var ] ]
        set %var % $+ table. $+ %tables $+ .tabfocus
        set %tabfocus [ [ %var ] ]
        if ( %id != %tabfocus ) {
          set [ [ %var ] ] %id
          ; draw whole dialog so we erase the controls on the now hidden tab
          drawdialog %tables %window
          ; save new contents
          drawcopy @dialog 1 1 $window(%window).w $window(%window).h @dialogs 1 1
        }
        ; reset size to size of whole tab control
        set %var % $+ table. $+ %tables $+ .tabsize
        set %size [ [ %var ] ]
        getposandsize %size
      }
      ; we found an object (%object) that the mouse is in
      ; save the original coordinates so we can reposition tab controls
      set %dbe.orgx %x
      set %dbe.orgy %y
      ; calc hot-spot offset
      %dbe.deltax = $calc(%x - %mx)
      %dbe.deltay = $calc(%y - %my)
      ; resizing or moving?
      if ( $mouse.key & 2 ) {
        ; resizing... copy object to table 3
        copyitem 2 %object 3
        ;calc resize direction (the edge the mouse is closest to)
        %dist.x.m = $calc(%mx - %x)
        %dist.w.m = $calc((%x + %w) - %mx)
        %dist.y.m = $calc(%my - %y)
        %dist.h.m = $calc((%y + %h) - %my)
        ; assume direction is left
        %c1.dir = 1
        %c1.dir.size = %dist.x.m
        ; look for a better direction
        if ( %dist.w.m < %c1.dir.size ) { %c1.dir = 2 | %c1.dir.size = %dist.w.m }
        if ( %dist.y.m < %c1.dir.size ) { %c1.dir = 3 | %c1.dir.size = %dist.y.m }
        if ( %dist.h.m < %c1.dir.size ) { %c1.dir = 4 }
        ; show the side we are resizing
        if ( %c1.dir == 1 ) { drawline @dialog 3 1 %x %y %x $calc(%y + %h) }
        elseif ( %c1.dir == 2 ) { drawline @dialog 3 1 $calc(%x + %w) %y $calc(%x + %w) $calc(%y + %h) }
        elseif ( %c1.dir == 3 ) { drawline @dialog 3 1 %x %y $calc(%x + %w) %y }
        else { drawline @dialog 3 1 %x $calc(%y + %h) $calc(%x + %w) $calc(%y + %h) }
        ; save objects current location and size
        %c1.x = %x
        %c1.y = %y
        %c1.w = %w
        %c1.h = %h
        ; save mouse location
        %c1.mx = %mx
        %c1.my = %my
        ; set resizing flag
        set %dbe.resize $true
      }
      else {
        ;moving object... copy object to table 3
        copyitem 2 %object 3
        ; save objects current location and size
        %c1.x = %x
        %c1.y = %y
        %c1.w = %w
        %c1.h = %h
        ; set moving flag
        set %dbe.move $true
      }
    }
    ; left click outside of an object... prepare to box a group of objects
    else {
      if ( %table.9.items == $null ) {
        set %dbe.group $true
        ; remember starting location
        set %c1.x %mx
        set %c1.y %my
        ; now snap to grid
        if ( %dbe.grid.snap ) {
          set %c1.x $int($calc( %c1.x / %dbe.grid.width ))
          set %c1.y $int($calc( %c1.y / %dbe.grid.height ))
          set %c1.x $calc( %c1.x * %dbe.grid.width )
          set %c1.y $calc( %c1.y * %dbe.grid.height )
        }
        set %dbe.gx %c1.x | set %dbe.gy %c1.y | set %dbe.gw 0 | set %dbe.gh 0
      }
      else {
        beep 3 200
        var %tmp = $?!="Only one group at a time please."
      }
    }
  }
  leave:{
    if ( %dbe.group ) {
      ; user was drawing a group box but moved outside of the edit window...
      ; if they unclicked outside we won't see the uclick event when they come back inside
      ; so we just abort drawing group box
      set %dbe.group $false
      ; erase group box
      drawcopy @dialogs %dbe.gx %dbe.gy %dbe.gw %dbe.gh @dialog %dbe.gx %dbe.gy
      set %dbe.gx 0 | set %dbe.gy 0 | set %dbe.gw 0 | set %dbe.gh 0
    }
  }
  dclick:{
    ; double mouse click ... edit object or dialog box properties
    if ( %dbe.move || %dbe.resize || %dbe.group ) { return }
    ; local vars
    var %var, %type, %text, %id, %tab, %info, %title, %filename, %index, %option
    ; turn off false sclick
    set %dbe.move $false
    set %dbe.resize $false
    ; edit object properties if mouse is in an object
    set %mx $mouse.x
    set %my $mouse.y
    ; is mouse in a dialog object?
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      ; we have an object...get info about the object
      set %var % $+ table.2.item $+ %object $+ .type
      set %type [ [ %var ] ]
      set %var % $+ table.2.item $+ %object $+ .id
      set %id [ [ %var ] ]
      set %var % $+ table.2.item $+ %object $+ .tab
      set %tab [ [ %var ] ]
      set %var % $+ table.2.item $+ %object $+ .text
      set %text [ [ %var ] ]
      set %var % $+ table.2.item $+ %object $+ .style
      set %info [ [ %var ] ]
      if ( %type == text ) {
        dialog -m proptext proptext
        did -r proptext 2
        did -o proptext 10 1 %id
        did -a proptext 2 %text
        if ( %info == $null ) {
          did -c proptext 3
        }
        else {
          if ( center isin %info ) { did -c proptext 4 }
          elseif ( right isin %info ) { did -c proptext 8 }
          else { did -c proptext 3 }
          if ( disable isin %info ) { did -c proptext 12 }
          if ( hide isin %info ) { did -c proptext13 }
          if ( group isin %info ) { did -c proptext 14 }
          if ( result isin %info ) { did -c proptext 15 }
        }
      }
      if ( %type == edit ) {
        dialog -m propedit propedit
        did -r propedit 2
        did -o propedit 24 1 %id
        did -a propedit 2 %text
        if ( %info == $null ) {
          did -c propedit 3
        }
        else {
          if ( center isin %info ) { did -c propedit 4 }
          elseif ( right isin %info ) { did -c propedit 5 }
          else did -c propedit 3
          if ( multi isin %info ) { did -c propedit 6 }
          if ( pass isin %info ) { did -c propedit 7 }
          if ( read isin %info ) { did -c propedit 8 }
          if ( return isin %info ) { did -c propedit 9 }
          if ( disable isin %info ) { did -c propedit 10 }
          if ( hide isin %info ) { did -c propedit 11 }
          if ( group isin %info ) { did -c propedit 12 }
          if ( result isin %info ) { did -c propedit 13 }
          if ( hsbar isin %info ) { did -c propedit 14 }
          if ( autohs isin %info ) { did -c propedit 15 }
          if ( vsbar isin %info ) { did -c propedit 16 }
          if ( autovs isin %info ) { did -c propedit 17 }
        }
      }
      if ( %type == button ) {
        dialog -m propbutt propbutt
        did -r propbutt 2
        did -o propbutt 16 1 %id
        did -a propbutt 2 %text
        did -o propbutt 18 1 %tab
        if ( %info == $null ) {
          did -c propbutt 4
        }
        else {
          if ( default isin %info ) { did -c propbutt 3 }
          if ( ok isin %info ) { did -c propbutt 5 }
          elseif ( cancel isin %info ) { did -c propbutt 6 }
          else did -c propbutt 4
          if ( disable isin %info ) { did -c propbutt 7 }
          if ( hide isin %info ) { did -c propbutt 8 }
          if ( group isin %info ) { did -c propbutt 9 }
          if ( result isin %info ) { did -c propbutt 10 }
        }
      }
      if ( %type == check ) {
        dialog -m propchk propchk
        did -r propchk 2
        did -o propchk 16 1 %id
        did -a propchk 2 %text
        if ( %info == $null ) {
          did -c propchk 4
        }
        else {
          if ( 3state isin %info ) { did -c propchk 3 }
          if ( left isin %info ) { did -c propchk 5 }
          elseif ( push isin %info ) { did -c propchk 6 }
          else did -c propchk 4
          if ( disable isin %info ) { did -c propchk 7 }
          if ( hide isin %info ) { did -c propchk 8 }
          if ( group isin %info ) { did -c propchk 9 }
          if ( result isin %info ) { did -c propchk 10 }
        }
      }
      if ( %type == radio ) {
        dialog -m proprad proprad
        did -r proprad 2
        did -o proprad 15 1 %id
        did -a proprad 2 %text
        if ( %info == $null ) {
          did -c proprad 3
        }
        else {
          if ( left isin %info ) { did -c proprad 4 }
          elseif ( push isin %info ) { did -c proprad 5 }
          else did -c proprad 3
          if ( disable isin %info ) { did -c proprad 6 }
          if ( hide isin %info ) { did -c proprad 7 }
          if ( group isin %info ) { did -c proprad 8 }
          if ( result isin %info ) { did -c proprad 9 }
        }
      }
      if ( %type == box ) {
        dialog -m propbox propbox
        did -r propbox 2
        did -o propbox 11 1 %id
        did -a propbox 2 %text
        if ( %info != $null ) {
          if ( disable isin %info ) { did -c propbox 3 }
          if ( hide isin %info ) { did -c propbox 4 }
          if ( group isin %info ) { did -c propbox 5 }
          if ( result isin %info ) { did -c propbox 6 }
        }
      }
      if ( %type == list ) {
        dialog -m proplist proplist
        did -o proplist 12 1 %id
        if ( sort isin %info ) { did -c proplist 1 }
        if ( disable isin %info ) { did -c proplist 2 }
        if ( hide isin %info ) { did -c proplist 3 }
        if ( group isin %info ) { did -c proplist 4 }
        if ( result isin %info ) { did -c proplist 5 }
        if ( extsel isin %info ) { did -c proplist 10 }
        if ( size isin %info ) { did -c proplist 13 }
        if ( vsbar isin %info ) { did -c proplist 14 }
        if ( hsbar isin %info ) { did -c proplist 15 }
      }
      if ( %type == combo ) {
        dialog -m propcombo propcombo
        did -o propcombo 13 1 %id
        if ( sort isin %info ) { did -c propcombo 1 }
        if ( disable isin %info ) { did -c propcombo 2 }
        if ( hide isin %info ) { did -c propcombo 3 }
        if ( group isin %info ) { did -c propcombo 4 }
        if ( result isin %info ) { did -c propcombo 5 }
        if ( edit isin %info ) { did -c propcombo 10 }
        if ( drop isin %info ) { did -c propcombo 11 }
        if ( size isin %info ) { did -c propcombo 14 }
        if ( vsbar isin %info ) { did -c propcombo 15 }
        if ( hsbar isin %info ) { did -c propcombo 16 }
      }
      if ( %type == icon ) {
        dialog -m propicon propicon
        did -o propicon 2 1 %id
        set %var % $+ table.2.item $+ %object $+ .filename
        set %filename [ [ %var ] ]
        did -o propicon 4 1 %filename
        set %var % $+ table.2.item $+ %object $+ .index
        set %index [ [ %var ] ]
        did -o propicon 6 1 %index
        if ( %info != $null ) {
          if ( disable isin %info ) { did -c propicon 18 }
          if ( hide isin %info ) { did -c propicon 19 }
          if ( group isin %info ) { did -c propicon 20 }
          if ( result isin %info ) { did -c propicon 21 }
        }
      }
      if ( %type == tab ) {
        dialog -m proptab proptab
        did -o proptab 2 1 %id
        did -o proptab 4 1 %text
      }
    }
    else {
      ; double click outside of an object... global dialog properties.
      dialog -m propdialog propdialog
      did -r propdialog 2
      set %var % $+ table.2.dialog
      set %dbe [ [ %var ] ]
      did -a propdialog 2 %dbe
      did -r propdialog 6
      set %var % $+ table.2.title
      set %title [ [ %var ] ]
      did -a propdialog 6 %title
      set %var % $+ table.2.option
      set %option [ [ %var ] ]
      if ( dbu isin %option ) { did -c propdialog 8 }
      if ( pixels isin %option ) { did -c propdialog 9 }
    }
  }
  drop:{
    if ( %dbe.dragtool ) {
      ; local vars
      var %rec, %var, %type, %size, %text, %id, %style, %filename, %index
      ; save drop location
      %mx = $mouse.x
      %my = $mouse.y
      ; snap to grid
      if ( %dbe.grid.snap ) {
        set %mx $int($calc( %mx / %dbe.grid.width ))
        set %my $int($calc( %my / %dbe.grid.height ))
        set %mx $calc( %mx * %dbe.grid.width )
        set %my $calc( %my * %dbe.grid.height )
      }
      ; prepare to create object %dbe.tooltype
      set %var % $+ table.1.item $+ %dbe.tooltype $+ .type
      set %type [ [ %var ] ]
      set %var % $+ table.1.item $+ %dbe.tooltype $+ .size
      ; if dropping a tab control, use the controls size
      if ( %type == tab ) {
        set %var % $+ table.1.tabsize
      }
      set %size [ [ %var ] ]
      set %var % $+ table.1.item $+ %dbe.tooltype $+ .text
      set %text $chr(34) $+ [ [ %var ] ] $+ $chr(34)
      set %var % $+ table.1.item $+ %dbe.tooltype $+ .style
      set %style [ [ %var ] ]
      getposandsize %size
      if ( %type isin texteditbuttoncheckradioboxtab ) {
        //set %size %mx %my %w %h
        ; %type "text",id,size,style
        set %style $dbe.entab(%mx,%my,%style)
        set %rec %type %text $+ , 0, $+ %size $+ , %style
        addtype1item %rec
        ; set the nextid
        incnextid %tables
      }
      if ( %type isin listcombo ) {
        //set %size %mx %my %w %h
        ; %type id,size,style
        set %style $dbe.entab(%mx,%my,%style)
        set %rec %type 0, $+ %size $+ , $+ %style
        addtype2item %rec
        ; set the nextid
        incnextid %tables
      }
      if ( %type == icon ) {
        ;ask user for icon filename...
        set %filename $dir="Select Icon File" *.bmp
        ;continue only if user entered a filename and it exists
        if ( %filename != $null && $exists(%filename) ) {
          ; convert path to a relative path
          set %filename $remove(%filename, $mircdir )
          ; tbs - need to ask user for the index... use 1 for now
          set %index 1
          ; we want actual size of icon... not size of tool icon!!!!
          //set %size %mx %my $pic(%filename).width $pic(%filename).height
          ; icon id,size,filename,index
          set %style $dbe.entab(%mx,%my,%style)
          set %rec %type 0, $+ %size $+ , $+ %filename $+ , $+ %index
          addtype3item %rec
          ; set the nextid
          incnextid %tables
        }
      }
      ; draw the item
      paintitem %tables %items %window %dbe.normal.color
      ; save new contents
      drawcopy @dialog 1 1 $window(%window).w $window(%window).h @dialogs 1 1
      ; dragtool is done
      %dbe.dragtool = $false
    }
  }
  uclick:{
    ; local vars
    var %var, %type, %size, %tab, %tabfocus, %id
    if ( %dbe.move || %dbe.resize ) {
      ; did object move or was user changing size?  if not user is probably doing a
      ; double click.
      ; 10/25/99 3:02PM handle tab control resizing
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
      set %type [ [ %var ] ]
      if ( %type == tab ) {
        set %var % $+ table. $+ %tables $+ .tabsize
      }
      else {
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .size
      }
      set %size [ [ %var ] ]
      getposandsize %size
      if ( %x != %c1.x || %y != %c1.y || %dbe.resize ) {
        ; pos changed or user was resizing, save objects new location and size
        set [ [ %var ] ] %c1.x %c1.y %c1.w %c1.h
        ; if we moved a tab ... adjust all positions of all the controls on it
        if ( %dbe.move ) {
          if ( %dbe.move && %type == tab ) {
            ; calc the new offsets
            set %dbe.offx $calc(%c1.x - %dbe.orgx)
            set %dbe.offy $calc(%c1.y - %dbe.orgy)
            ; get number of objects in this dialog table
            set %var % $+ table. $+ %tables $+ .items
            set %object [ [ %var ] ]
            :loop
            if ( %object != 0 ) {
              ; skip deleted objects
              set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
              set %id [ [ %var ] ]
              if ( %id != -1 ) {
                ; is this object part of the tab?
                set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
                set %type [ [ %var ] ]
                if ( %type != tab ) {
                  ; object is not part of a tab control... is it on a tab control?
                  set %var % $+ table. $+ %tables $+ .item $+ %object $+ .tab
                  set %tab [ [ %var ] ]
                  if ( %tab != 0 ) {
                    ; object is on a tab... adjust its position
                    set %var % $+ table. $+ %tables $+ .item $+ %object $+ .size
                    set %size [ [ %var ] ]
                    getposandsize %size
                    set %x $calc(%x + %dbe.offx)
                    set %y $calc(%y + %dbe.offy)
                    set [ [ %var ] ] %x %y %w %h
                  }
                }
              }
              dec %object 1
              goto loop
            }
          }
          else {
            ; moved non-tab object... handle case where we moved it on/off a tab
            ; %c1.* has the new x y w h of the object... is it within the tab control if any?
            set %var % $+ table. $+ %tables $+ .tabsize
            set %size [ [ %var ] ]
            getposandsize %size
            set %var % $+ table. $+ %tables $+ .tabfocus
            set %tabfocus [ [ %var ] ]
            set %var % $+ table. $+ %tables $+ .item $+ %object $+ .tab
            if ( $inrect(%c1.x,%c1.y,%x,%y,%w,%h) ) {
              ; the control is on a tab... put it on the focustab
              set [ [ %var ] ] %tabfocus
            }
            else {
              ; object is not on a tab
              set [ [ %var ] ] 0
            }
          }
        }
        ; repaint entire window
        drawdialog %tables %window
        ; save new contents
        drawcopy @dialog 1 1 $window(%window).w $window(%window).h @dialogs 1 1
      }
      ; reset moving and resizing flags
      set %dbe.move $false
      set %dbe.resize $false
    }
    if ( %dbe.group ) {
      ; all done drawing group box
      set %dbe.group $false
      ; erase group box
      drawcopy @dialogs %dbe.gx %dbe.gy %dbe.gw %dbe.gh @dialog %dbe.gx %dbe.gy
      ; set the group flag for each object within the group box
      var %i = 1, %found = $false, %id, %gxl = -1, %gxr = -1, %gyt = -1, %gyb = -1, %var, %size, %rec
      set % $+ table.9.items 0
      :loop
      if ( %i <= %items ) {
        ; skip deleted objects
        set %var % $+ table. $+ %tables $+ .item $+ %i $+ .id
        set %id [ [ %var ] ]
        if ( %id != -1 ) {
          if ( $isobjectinrect(%tables, %i, %dbe.gx, %dbe.gy, %dbe.gw, %dbe.gh) ) {
            set % $+ table. $+ %tables $+ .item $+ %i $+ .group $true
            ;paintitem %tables %i %dialog %window %dbe.group.color
            ; save the item
            additem 2 %i 9
            set %found $true
            ; keep track of the size of the group
            ; note: %x %y %w and %h are the objects - set by $isobjectinrect()
            if ( %gxl == -1 ) {
              ; first object
              set %gxl %x | set %gxr $calc(%x + %w - 1)
              set %gyt %y | set %gyb $calc(%y + %h - 1)
            }
            else {
              ; subsequent object ... expand
              if ( %x < %gxl ) set %gxl %x
              if ( $calc(%x + %w - 1) > %gxr ) set %gxr $calc(%x + %w - 1)
              if ( %y < %gyt ) set %gyt %y
              if ( $calc(%y + %h - 1) > %gyb ) set %gyb $calc(%y + %h - 1)
            }
          }
          else {
            set % $+ table. $+ %tables $+ .item $+ %i $+ .group $false
          }
        }
        inc %i 1
        goto loop
      }
      if ( %found ) {
        ; set size of group
        set %dbe.gx %gxl | set %dbe.gy %gyt
        set %dbe.gw $calc(%gxr - %gxl)
        set %dbe.gh $calc(%gyb - %gyt)
        ; create a hidden window to hold the image of the group
        window -hp @group 1 1 %dbe.gw $calc(%dbe.gh + 50)
        drawcopy @dialog %dbe.gx %dbe.gy %dbe.gw %dbe.gh @group 1 1
        ; now delete the individual group objects
        deletegroup %tables
        ; replace the objects in the group with one group object
        ; %type id,size,table,window,org x,org y
        set %rec group 0, $+ %dbe.gx %dbe.gy %dbe.gw %dbe.gh $+ ,9,@group, $+ %dbe.gx $+ , $+ %dbe.gy
        addtype4item %tables %rec
        ; now show the group object
        paintitem %tables %items %window %dbe.group.color
        ; set the nextid
        incnextid %tables
      }
      else {
        set %dbe.gx 0 | set %dbe.gy 0 | set %dbe.gw 0 | set %dbe.gh 0
        unset %table.9.items
      }
    }
  }
  Delete:{
    ; local vars
    var %object, %var, %gwin, %type, %id, %tid, %ttype, %tabs, %objects, %focus, %delorder, %focusorder
    ; is mouse in a dialog object?
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      ; we found an object (%object) that the mouse is in... delete it
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
      set %id [ [ %var ] ]
      set [ [ %var ] ] -1
      ; if object was group then group dies
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
      set %type [ [ %var ] ]
      if ( %type == group ) {
        ; don't need the items now
        unset %table.9.*
        ; delete the window holding the image of the group
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .window
        set %gwin [ [ %var ] ]
        window -c %gwin
      }
      ; if object was a tab then it and all of its controls dies
      elseif ( %type == tab ) {
        ; delete all items on the deleted tab and reorder the remaining tabs to
        ; take up the position of the deleted tab
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .tab
        set %delorder [ [ %var ] ]
        set %var % $+ table. $+ %tables $+ .tabs
        set %tabs [ [ %var ] ]
        ; %focusorder is order number of the tab that will get the focus
        set %focusorder $iif(%delorder == %tabs,1,%delorder)
        set %var % $+ table. $+ %tables $+ .items
        set %objects [ [ %var ] ]
        :loop
        if ( %objects > 0 ) {
          ; skip deleted items
          set %var % $+ table. $+ %tables $+ .item $+ %objects $+ .id
          set %tid [ [ %var ] ]
          if ( %tid != -1 ) {
            set %var % $+ table. $+ %tables $+ .item $+ %objects $+ .type
            set %ttype [ [ %var ] ]
            ; %tab: if type is tab, %tab is order else it's id of the tab the control is on
            set %var % $+ table. $+ %tables $+ .item $+ %objects $+ .tab
            set %tab [ [ %var ] ]
            if ( %ttype != tab ) {
              if ( %tab == %id ) {
                ; this control is on the deleted tab ... delete it too
                set %var % $+ table. $+ %tables $+ .item $+ %objects $+ .id
                set [ [ %var ] ] -1
              }
            }
            else {
              ; reorder the remaining tabs after the deleted tab
              if ( %tab > %delorder ) {
                dec %tab 1
                set % $+ table. $+ %tables $+ .item $+ %objects $+ .tab %tab
              }
              ; since the delete tab had the focus we need to assign the focus to another
              ; tab... use the next tab if any else the 1st tab.
              if ( %tab == %focusorder ) {
                set %var % $+ table. $+ %tables $+ .item $+ %objects $+ .id
                set %focus [ [ %var ] ]
              }
            }
          }
          dec %objects 1
          goto loop
        }
        ; one less tab control now
        dec %tabs 1
        set % $+ table. $+ %tables $+ .tabs %tabs
        ; if we deleted the last tab...
        if ( %tabs == 0 ) {
          set % $+ table. $+ %tables $+ .tabsize 0 0 0 0
          set % $+ table. $+ %tables $+ .tabfocus 0
        }
        else {
          ; change the focus
          set %var % $+ table. $+ %tables $+ .tabfocus
          set [ [ %var ] ] %focus
        }
      }
      ; can't just erase object because it may be covering other objects
      drawdialog %tables @dialog
    }
  }
  Copy:{
    ; local vars
    var %object, %var
    ; is mouse in a dialog object?
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      ; we found an object (%object) that the mouse is in... remember its id
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
      diacopyitem %tables [ [ %var ] ] false no
    }
  }
  Paste:{
    ; local vars
    var %type, %size, %newsize
    ; ensure we have an item to copy
    if ( %dbe.copy.item == $null ) { return }
    ; we have an item... paste it at current mouse location (%mx, %my)
    if ( %dbe.grid.snap ) {
      ; snap to grid
      set %mx $int($calc( %mx / %dbe.grid.width ))
      set %my $int($calc( %my / %dbe.grid.height ))
      set %mx $calc( %mx * %dbe.grid.width )
      set %my $calc( %my * %dbe.grid.height )
    }
    ; we need to know the item type
    set %type $gettok(%dbe.copy.item,1,32)
    ; now add it
    if ( %type isin texteditbuttoncheckradiobox ) {
      set %size $gettok(%dbe.copy.item,3,44)
      getposandsize %size
      set %newsize %mx %my %w %h
      set %dbe.copy.item $replace(%dbe.copy.item,%size,%newsize)
      addtype1item %dbe.copy.item
    }
    else {
      set %size $gettok(%dbe.copy.item,2,44)
      getposandsize %size
      set %newsize %mx %my %w %h
      set %dbe.copy.item $replace(%dbe.copy.item,%size,%newsize)
    }
    if ( %type isin listcombo ) {
      addtype2item %dbe.copy.item
    }
    if ( %type == icon ) {
      addtype3item %dbe.copy.item
    }
    ; all done... show the new item
    incnextid %tables
    paintitem %tables %items %window %dbe.normal.color
  }
  -
  Details:{
    ; local vars
    var %var, %type, %text, %id, %size, %filename, %index, %style
    ; show details about an object ... is mouse in a dialog object?
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      ; we found an object (%object) that the mouse is in...
      dialog -m propdetails propdetails
      ; show command details first
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
      set %id [ [ %var ] ]
      did -o propdetails 2 1 %id
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
      set %type [ [ %var ] ]
      did -o propdetails 4 1 %type
      if ( %type == tab ) {
        set %var % $+ table. $+ %tables $+ .tabsize
      }
      else {
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .size
      }
      set %size [ [ %var ] ]
      getposandsize %size
      did -o propdetails 8 1 %x
      did -o propdetails 10 1 %y
      did -o propdetails 12 1 %w
      did -o propdetails 14 1 %h
      ; text attribute
      if ( %type isin texteditbuttoncheckradioboxtab ) {
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .text
        set %text [ [ %var ] ]
        did -o propdetails 6 1 %text
      }
      ; only icon has filename and index attributes
      if ( %type == icon ) {
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .filename
        set %filename [ [ %var ] ]
        did -o propdetails 19 1 %filename
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .index
        set %index [ [ %var ] ]
        did -o propdetails 21 1 %index
      }
      else {
        ; all objects except icon have style attribute
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .style
        set %style [ [ %var ] ]
        did -o propdetails 17 1 %style
      }
    }
  }
  Refresh:{
    ; redraw dialog edit box... first draw the grid
    ;drawcopy @dialogg 1 1 $window(%window).w $window(%window).h @dialog 1 1
    ; now the objects
    drawdialog 2 %window
  }
  -
  Save:{
    ; create .bak filename
    set %dbe.bfn $nofile(%dbe.tfn) $+ $gettok($nopath(%dbe.tfn),1,46) $+ .bak
    ; delete .bak file
    if ( $exists(%dbe.bfn) ) { remove %dbe.bfn }
    ; rename table file to .bak
    if ( $exists(%dbe.tfn) ) { rename %dbe.tfn %dbe.bfn }
    ; create new table file
    savedialog %tables %dbe.tfn
  }
  Save as:{
    ; get filename
    %dbe.tfn = $$?="Enter filename:"
    if ( %dbe.tfn == $nopath(%dbe.tfn) ) { set %dbe.tfn $scriptdir $+ %dbe.tfn }
    ; create new table file
    savedialog %tables %dbe.tfn
  }
  -
  Test:{
    ; local vars
    var %var
    ; test current dialog table...
    ; ... first, set a temporary filename
    set %dbe.testfn $scriptdirdbetest.mdt
    ; ... change the dialog name so it doesn't conflict with one in memory
    set %var % $+ table. $+ %tables $+ .dialog
    set %dbe.dialog.save [ [ %var ] ]
    set [ [ %var ] ] dbetest
    ; ... save the dialog table to the temporary file
    savedialog %tables %dbe.testfn
    ; ... load it as a script
    .load -rs %dbe.testfn
    ; ... run it
    dialog -m test dbetest
    ; ... clean up
    .unload -rs %dbe.testfn
    remove %dbe.testfn
    ; ... reset the dialog name
    set %var % $+ table. $+ %tables $+ .dialog
    set [ [ %var ] ] %dbe.dialog.save
  }
  -
  Ungroup:{
    var %group, %i = 1, %var, %id, %type, %size, %gx, %gy, %dx, %dy, %gitems, %gt, %gwin
    ; unset the group attribute on all grouped items if cursor is inside a group object
    %object = $inobject(%mx, %my, %tables)
    if ( %object != 0 ) {
      set %var % $+ table. $+ %tables $+ .item $+ %object $+ .type
      set %type [ [ %var ] ]
      if ( %type == group ) {
        ; which table are the group members in?
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .table
        set %gt [ [ %var ] ]
        ; get groups position ... we'll need to adjust the group members positions
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .size
        set %size [ [ %var ] ]
        set %gx $gettok(%size,1,32)
        set %gy $gettok(%size,2,32)
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .orgx
        set %dx [ [ %var ] ]
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .orgy
        set %dy [ [ %var ] ]
        ; delete the group object now
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .id
        set [ [ %var ] ] -1
        ; calc groups movement delta so we can apply it to the group objects
        set %dx $calc(%gx - %dx)
        set %dy $calc(%gy - %dy)
        ; get number of items in the group
        set %var % $+ table. $+ %gt $+ .items
        set %gitems [ [ %var ] ]
        ; copy each group member object from the group table to the current table
        ; and modify its position
        :loop
        if ( %gitems > 0 ) {
          set %var % $+ table. $+ %gt $+ .item $+ %gitems $+ .size
          set %size [ [ %var ] ]
          getposandsize %size
          set %x $calc(%x + %dx)
          set %y $calc(%y + %dy)
          set % $+ table. $+ %gt $+ .item $+ %gitems $+ .size %x %y %w %h
          additem %gt %gitems %tables
          dec %gitems 1
          goto loop
        }
        set %var % $+ table. $+ %tables $+ .items
        set %items [ [ %var ] ]
        ; delete the group table
        ;unset %table. $+ %gt $+ .*
        unset %table.9.*
        ; delete the window holding the image of the group
        set %var % $+ table. $+ %tables $+ .item $+ %object $+ .window
        set %gwin [ [ %var ] ]
        window -c %gwin
        ; redraw dialog edit box... first draw the grid
        drawcopy @dialogg 1 1 $window(%window).w $window(%window).h @dialog 1 1
        ; now the objects
        drawdialog %tables %window
        drawcopy @dialog 1 1 $window(%window).w $window(%window).h @dialogs 1 1
      }
    }
  }
  -
  Close:{
    window -c @dialog
    window -c @dialogs
    window -c @dialogt
    unset %table.2*
    unset %table.3*
  }
}

; menu for toolbar
menu @dialogt {
  sclick:{
    set %mx $mouse.x
    set %my $mouse.y
    ; is mouse in a dialog object?
    %object = $inobject(%mx, %my, 1)
    if ( %object != 0 ) {
      ; we found an object (%object) that the mouse is in...remember it
      %dbe.tooltype = %object
    }
  }
  leave:{
    if ( $mouse.key & 1 ) {
      %dbe.dragtool = $true
    }
  }
}

; Aliases
;
; inrect - returns $true if specified object is within specified rectangle
;   $1 = table, $2 = object number, $3-$6 = x y w h
alias isobjectinrect {
  var %rx = $3 + $5, %ry = $4 + $6, %var, %size, %ox, %oy
  ; get objects position and size
  set %var % $+ table. $+ $1 $+ .item $+ $2 $+ .size
  set %size [ [ %var ] ]
  getposandsize %size
  %ox = %x + %w
  %oy = %y + %h
  if ( $3 <= %x && %ox <= %rx ) {
    if ($4 <= %y && %oy <= %ry ) { return $true }
  }
  return $false
}

; inobject - test if x,y location is within an object.  If so return object number
;   else return 0.  NOTE: if x,y is within more than one object (i.e. objects overlap)
;   then this returns the number of the smallest object!
;
;   10/25/99 1:36PM - if object is just tab page return the focus tab object
;   10/23/99 3:09PM - also check to see if object is in a tab.. if so only return object
;     number of object that is on tabfocus.
;   $1=x, $2=y, $3=table
alias inobject {
  ; local vars
  var %io.a, %io.o, %io.tf, %var, %object, %id, %size, %tab, %tabfocus, %type
  ; keep track of objects size...we want the smallest one!
  set %io.a $calc($window(-1).w * $window(-1).h)
  set %io.o 0
  ; get number of objects in this dialog table
  set %var % $+ table. $+ $3 $+ .items
  set %object [ [ %var ] ]
  ; tabfocus is the id of tab that has the focus
  set %var % $+ table. $+ $3 $+ .tabfocus
  set %tabfocus [ [ %var ] ]
  :loop
  ; skip deleted objects
  set %var % $+ table. $+ $3 $+ .item $+ %object $+ .id
  set %id [ [ %var ] ]
  if ( %id != -1 ) {
    ; remember the object that has the tab focus
    if ( %id == %tabfocus ) { set %io.tf %object }
    ; this is a real object... are the x,y coordinates within this object?
    set %var % $+ table. $+ $3 $+ .item $+ %object $+ .size
    set %size [ [ %var ] ]
    getposandsize %size
    if ( $inrect($1,$2,%x,%y,%w,%h) ) {
      ; is object in a tab ... and if so is it in the focus tab?
      set %var % $+ table. $+ $3 $+ .item $+ %object $+ .tab
      set %tab [ [ %var ] ]
      if ( %tab != 0 ) {
        ; object is on a tab ... is object a tab?
        set %var % $+ table. $+ $3 $+ .item $+ %object $+ .type
        set %type [ [ %var ] ]
        if ( %type != tab ) {
          ; object is on a tab ... does that tab have the focus?
          if ( %tab != %tabfocus ) { goto next }
        }
      }
      ; is the object smaller than any we've seen so far?
      if ( $calc(%w * %h) < %io.a ) {
        ; yes, save this objects info
        %io.a = $calc(%w * %h)
        %io.o = %object
      }
    }
  }
  :next
  dec %object 1
  if ( %object > 0 ) { goto loop }
  ; all done... if we don't have an object, see if we are on a tab
  if ( %io.o == 0 ) {
    set %var % $+ table. $+ $3 $+ .tabsize
    set %size [ [ %var ] ]
    getposandsize %size
    if ( $inrect($1,$2,%x,%y,%w,%h) ) { return %io.tf }
  }
  ; all done... get objects size if we found one
  if ( %io.o != 0 ) {
    set %var % $+ table. $+ $3 $+ .item $+ %io.o $+ .size
    set %size [ [ %var ] ]
    getposandsize %size
  }
  return %io.o
}

; copygroup - copy items with group attribute from one table to another
;   $1 is source table, $2 is destination table
alias copygroup {
  var %i = 1, %id, %var, %group
  :loop
  if ( %i <= %items ) {
    ; skip deleted objects
    set %var % $+ table. $+ $1 $+ .item $+ %i $+ .id
    set %id [ [ %var ] ]
    if ( %id != -1 ) {
      set %var % $+ table. $+ $1 $+ .item $+ %i $+ .group
      set %group [ [ %var ] ]
      if ( %group ) { copyitem $1 %i $2 }
    }
    inc %i 1
    goto loop
  }
}

; copyitem - copy specified item from one table to another
;    $1 is table to be copied from, $2 is object number, $3 is table to be copied to
;    $4 is optional.. its the destination item number, if not specified $2 is used.
alias copyitem {
  ; local vars
  var %srcvar, %destvar, %item
  if ( $4 == $null ) { set %item $2 }
  else { set %item $4 }
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .type
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .type
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .text
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .text
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .id
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .id
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .size
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .size
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .style
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .style
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .filename
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .filename
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .index
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .index
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .group
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .group
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .table
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .table
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .window
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .window
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .item $+ $2 $+ .tab
  set %destvar % $+ table. $+ $3 $+ .item $+ %item $+ .tab
  set [ [ %destvar ] ] [ [ %srcvar ] ]
  set %srcvar % $+ table. $+ $1 $+ .tabsize
  set %destvar % $+ table. $+ $3 $+ .tabsize
  set [ [ %destvar ] ] [ [ %srcvar ] ]
}

; additem - add specified item from one table to another
;    $1 is table to be copied from, $2 is object number, $3 is table to be copied to
alias additem {
  ; local vars
  var %i, %srcvar, %destvar
  ; get number of items in destination table, inc it, and use it as the dest item number
  set %destvar % $+ table. $+ $3 $+ .items
  set %i [ [ %destvar ] ]
  inc %i 1
  set [ [ %destvar ] ] %i
  ; now copy
  copyitem $1 $2 $3 %i
}

; dbu.size - convert a size in pixels to dbus
;   $1 = x y w h
alias dbu.size {
  var %size
  getposandsize $1
  set %x $dbu.x(%x)
  set %y $dbu.y(%y)
  set %w $dbu.x(%w)
  set %h $dbu.y(%h)
  set %size %x %y %w %h
  return %size
}

; dbu.x - convert pixel x to dbu
;   $1 = x
alias dbu.x {
  return $round($calc($1 / %dbe.unit),0)
}

; dbu.y - convert pixel y to dbu
;   $1 = y
alias dbu.y {
  return $round($calc($1 / %dbe.unit),0)
}

; pixels.size - convert a size in dbus to pixels
;   $1 = x y w h
alias pixels.size {
  var %size
  getposandsize $1
  set %x $pixels.x(%x)
  set %y $pixels.y(%y)
  set %w $pixels.x(%w)
  set %h $pixels.y(%h)
  set %size %x %y %w %h
  return %size
}

; pixels.x - convert dbu x to pixels
;   $1 = x
alias pixels.x {
  return $round($calc($1 * %dbe.unit),0)
}

; pixels.y - convert dbu y to pixels
;   $1 = y
alias pixels.y {
  return $round($calc($1 * %dbe.unit),0)
}

; F10 - short-cut to uninstall
alias F10 {
  dbe.uninstall
}

; install this script - executed once when the script is loaded
alias -l install {
  if ( $version < 5.61 ) {
    echo 4 -s $nopath($script) requires mIRC version 5.61 or later!
    dbe.uninstall
  }
  if ( %dbe.ver != $null ) {
    echo 7 -s $nopath($script) is already loaded!
    halt
  }
  ; set script version number
  %dbe.ver = 2.3
  ; load the dialog tables
  .load -rs dbe\dbeconfig.mdt
  .load -rs dbe\propbox.mdt
  .load -rs dbe\propbutt.mdt
  .load -rs dbe\propchk.mdt
  .load -rs dbe\propcombo.mdt
  .load -rs dbe\propdetails.mdt
  .load -rs dbe\propdialog.mdt
  .load -rs dbe\propedit.mdt
  .load -rs dbe\propicon.mdt
  .load -rs dbe\proplist.mdt
  .load -rs dbe\proprad.mdt
  .load -rs dbe\proptext.mdt
  .load -rs dbe\proptab.mdt
  ; check for presence of required scripts here and uninstall if not found
  ; ...
  ; show user we are loaded
  echo 12 -s $nopath($script) version %dbe.ver is installed and running.
}

; initialize this script - executed each time you run mIRC.
alias -l initialize {
  .load -rs $scriptdirdbeprops.mrc
  set %dbe.gx 0 | set %dbe.gy 0 | set %dbe.gw 0 | set %dbe.gh 0
  set %dbe.normal.color 1
  set %dbe.group.color 10
  ;set %dbe.font MS Sans Serif
  set %dbe.font "MS Sans Serif"
  set %dbe.fontsize 16
  set %dbe.fw $width(X,%dbe.font,%dbe.fontsize,0,0)
  set %dbe.fh $height(X,%dbe.font,%dbe.fontsize)
  set %dbe.wx 1
  set %dbe.wy 1
  set %dbe.ww 1000
  set %dbe.wh 600
  if ( %dbe.grid.width == $null ) set %dbe.grid.width 10
  if ( %dbe.grid.height == $null ) set %dbe.grid.height 10
  if ( %dbe.grid.snap == $null ) set %dbe.grid.snap 1
  %tables = 0
  reinitialize
  ; create grid window
  dbemakegrid
}

alias -l dbemakegrid {
  ; delete old grid window if any
  if ( $window(@dialogg).state != $null ) { window -c @dialogg }
  ; create grid window
  window -hp @dialogg 1 1 $window(-1).w $window(-1).h
  ; create a small window that contains the grid for one row
  window -hp @dialogc 1 1 $window(-1).w 38
  var %c = %dbe.grid.width
  :loopc
  if ( %c < $window(-1).w ) {
    drawdot @dialogc 14 1 %c 1
    inc %c %dbe.grid.width
    goto loopc
  }
  ; now fill the grid window
  var %r = %dbe.grid.height
  :loopr
  if ( %r < $window(-1).h ) {
    drawcopy @dialogc 1 1 $window(-1).w 1 @dialogg 1 %r
    inc %r %dbe.grid.height
    goto loopr
  }
  window -c @dialogc
}

alias -l reinitialize {
  set %dbe.dragtool $false
  ; set the dbu constant for the current screen size...1152 x 864
  set %dbe.dbu 2.5
  set %dbe.unit 1
  unset %table*
}

; uninstall this script
;   $1 = $null if we should unload.  The Update script pass $true so we don't unload.
;         It does so so this alias will return rather than halt.
alias dbe.uninstall {
  ; stop timers
  ;.timerdbe* off
  ; disable groups
  ;.disable #dbe
  window -c @dialog
  window -c @dialogg
  window -c @dialogs
  window -c @dialogt
  window -c @group
  ; unset variables
  unset %dbe*
  unset %table*
  unset %x
  unset %y
  unset %w
  unset %h
  unset %style
  unset %fname
  unset %items
  unset %window
  unset %mx
  unset %my
  unset %object
  unset %c1*
  ; unload the dialog tables
  .unload -rs dbeconfig.mdt
  .unload -rs propbox.mdt
  .unload -rs propbutt.mdt
  .unload -rs propchk.mdt
  .unload -rs propcombo.mdt
  .unload -rs propdetails.mdt
  .unload -rs propdialog.mdt
  .unload -rs propedit.mdt
  .unload -rs propicon.mdt
  .unload -rs proplist.mdt
  .unload -rs proprad.mdt
  .unload -rs proptext.mdt
  .unload -rs proptab.mdt

  ; set var so user can quick install us via F11 key if user is running our install script
  %isd = $script
  .unload -rs dbeprops.mrc
  ; unload the script
  echo 12 -s $nopath($script) was uninstalled.
  if ( $1 == $null ) {
    .unload -rs $script | halt
  }
}
