alias -l row4.sound {
  var %row4.sound.play
  if ($1 == request) { %row4.sound.play = beepbeep.wav }
  if ($1 == start) { %row4.sound.play = rumble.wav }
  if ($1 == chip) { %row4.sound.play = click.wav }
  if ($1 == win) { %row4.sound.play = applause.wav }
  if ($1 == loose) { %row4.sound.play = idiot.wav }
  if (%row4.sound != $null) { splay -q $scriptdir $+ sound\ $+ %row4.sound.play }
}

on *:START:{
  unset %row4.ip.refuse.*
  unset %row4.coord*
}

on 1:LOAD:{
  set %row4.sound [ on ]
  set %row4.skin [ alien ]
  set %row4.colour [ 11 ]
  echo $colour(normal) -se To start a game, go to the nicklist or private chat popup, item "Connect4" >> Start Connect4 game
  echo $colour(normal) -se Or type 3/connect4 <nickname>
  echo $colour(normal) -se 4Note : your opponent must have the same add-on in order to play !!
}

alias uninstall {
  if ($1 == connect4) { 
    unset %row4*
    unset %sock.row4*
    echo $colour(info) -se *** Connect4 successfully uninstalled
  }
  .unload -rs $scriptdir $+ connect4.mrc
}

menu query,nicklist {
  Connect4 
  .start Connect4 game:connect4 $1
  .$row4.request:$row4.request.action
}


alias -l row4.request {
  if ($group(#row4) == on) { var %row4.request.msg = disable game requests  } 
  else { var %row4.request.msg = enable game requests }
  return %row4.request.msg
}

alias -l row4.request.action {
  if ($group(#row4) == on) { .disable #row4  } 
  else { .enable #row4 }
}


#row4 on
on *:NOTICE:Connect4*:?:{
  if ((%row4.ip.refuse. [ $+ [ $gettok($1-,4,32) ] ] == $null) && ($longip($gettok($1-,4,32) isnum)) && ($gettok($1-,5,32) isnum)) {
    if (($dialog(row4DialogAccept) == $null) && ($dialog(row4Dialog) == $null)) { 
      row4.sound request
      dialog -m row4DialogAccept row4DialogAccept 
      did -ra row4DialogAccept 1258 $gettok($1-,4-,32)
      var %row4.request = $nick requested to play a game of connect 4 :
      did -ra row4DialogAccept 1302 %row4.request
    } 
    else {  .notice $nick Already playing the game, try later please, thanks }
  }
}
#row4 end

alias connect4.window  {
  if ($window(@Connect4).state == $null) {
    window -bk[O]p @Connect4  0  0 315 235
    titlebar @Connect4 game - www.armathan.cjb.net
    drawpic @Connect4 0 0 $scriptdir $+ connectskins\ $+ %row4.skin $+ \connect4.png
    drawpic -c @Connect4 177 46 $scriptdir $+ connectskins\ $+ %row4.skin $+ \rd.png
    drawtext @connect4 %row4.colour 202 49 You
    drawpic -c @Connect4 177 74 $scriptdir $+ connectskins\ $+ %row4.skin $+ \bl.png
    drawtext @connect4 %row4.colour 202 75 %row4.nick
  }
  elseif (($window(@Connect4).state == minimized) || ($window(@Connect4).state == normal)) { window -a @Connect4 }
}

on *:CLOSE:@Connect4:{
  sockclose row4* 
  unset %row4.coord.*
  unset %row4.turn
  unset %row4.sock*
  unset %sock.row4*
  unset %row4.nick
  splay stop
  drawpic -c
}

menu @Connect4 {
  ;mouse:echo 4 -s ( $mouse.x , $mouse.y )
  sclick:row4.column $mouse.x $mouse.y
  $row4.menu($mouse.x,$mouse.y,replay):row4.replay
  $row4.sound.menu.off($mouse.x,$mouse.y,sound off):unset %row4.sound | splay stop
  $row4.sound.menu.on($mouse.x,$mouse.y,sound on):set %row4.sound [ on ]
  skins
  .$row4.menu($mouse.x,$mouse.y,alien):row4.skin alien 11
  .$row4.menu($mouse.x,$mouse.y,blue stain):row4.skin bluestain 0
  .$row4.menu($mouse.x,$mouse.y,dune):row4.skin dune 15
  .$row4.menu($mouse.x,$mouse.y,infrared):row4.skin infrared 9
  .$row4.menu($mouse.x,$mouse.y,lady violet):row4.skin violet 6
  .$row4.menu($mouse.x,$mouse.y,spooky):row4.skin spooky 15
  .$row4.menu($mouse.x,$mouse.y,virus):row4.skin virus 8
}

alias -l row4.menu {
  if ($inrect($1,$2,202,115,57,23) == $true) { return $3- }
}

alias row4.sound.menu.off {
  if (($inrect($1,$2,202,115,57,23) == $true) && (%row4.sound != $null)) { return $3- }
}

alias row4.sound.menu.on {
  if (($inrect($1,$2,202,115,57,23) == $true) && (%row4.sound == $null)) { return $3- }
}

alias -l  row4.win.msg {
  drawpic -c @Connect4 11 158 $scriptdir $+ connectskins\ $+ %row4.skin $+ \cover.png
  drawtext @connect4 %row4.colour 18 168 $1-
}

alias -l row4.column {
  if (%row4.turn != me) { return }
  if ($inrect($1,$2,11,28,19,116) == $true) { row4.choose.my.token 1 }
  if ($inrect($1,$2,32,28,19,116) == $true) { row4.choose.my.token 2 }
  if ($inrect($1,$2,53,28,19,116) == $true) { row4.choose.my.token 3 }
  if ($inrect($1,$2,74,28,19,116) == $true) { row4.choose.my.token 4 }
  if ($inrect($1,$2,95,28,19,116) == $true) { row4.choose.my.token 5 }
  if ($inrect($1,$2,116,28,19,116) == $true) { row4.choose.my.token 6 }
  if ($inrect($1,$2,137,28,19,116) == $true) { row4.choose.my.token 7 }
}


alias -l init.row4 {
  var %row.i = 1
  var %row.j 
  while (%row.i <= 7) {
    %row.j = 1
    while (%row.j <= 7) {
      var %coord.ij = %row.i $+ %row.j 
      set %row4.coord. [ $+ [ %coord.ij ] ] [ neutral ]
      inc %row.j 1
    }
    inc %row.i 1
  }
}

alias -l row4.replay {
  if (%row4.turn != winner) { echo $colour(info) -se **** Current game isn't finished yet ... are you going to loose or what ??? }
  else {
    splay stop
    unset %row4.coord*
    init.row4
    row4.redraw.partial
    row4.win.msg Opponent to crush : %row4.nick
    row4.sound start
    set %row4.turn [ you ]
    sockwrite -tn %sock.row4.play replay
    sockwrite -tn %sock.row4.play dice $rand(1,10)
  }
}

alias -l row4.redraw.partial {
  drawpic @Connect4 0 0 $scriptdir $+ connectskins\ $+ %row4.skin $+ \connect4.png
  drawpic -c @Connect4 177 46 $scriptdir $+ connectskins\ $+ %row4.skin $+ \rd.png
  drawtext @connect4 %row4.colour 202 49 You
  drawpic -c @Connect4 177 74 $scriptdir $+ connectskins\ $+ %row4.skin $+ \bl.png
  drawtext @connect4 %row4.colour 202 75 %row4.nick
}


alias -l row4.skin {
  drawpic -c
  set %row4.skin [ $1 ]
  set %row4.colour [ $2 ]
  row4.redraw.partial 
  if (%row4.turn == me) {  drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \green.png }
  else { drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png }
  var %row4.skin.i = 1
  var %row4.skin.j  = 1
  var %row4.skin.coord
  while (%row4.skin.i <= 7) {
    %row4.skin.j  = 1
    while (%row4.skin.j <= 7) {
      %row4.skin.coord = %row4.coord. [ $+ [ [ %row4.skin.i ] $+ [ %row4.skin.j ] ] ]
      if (%row4.skin.coord == me) { row4.draw.token %row4.skin.j %row4.skin.i rd.png }
      elseif (%row4.skin.coord  == opponent) { row4.draw.token %row4.skin.j %row4.skin.i bl.png }
      inc %row4.skin.j 1
    }
    inc %row4.skin.i 1
  }
  if (%row4.turn != winner) { row4.win.msg Opponent to crush : %row4.nick }
  else { row4.win.msg  Game over }
}

alias -l  row4.draw.token {
  drawpic -c @Connect4  $calc(11 + ( $1 - 1 ) * 21))  $calc(28 + (($2 - 1) * 20))  $scriptdir $+ connectskins\ $+ %row4.skin $+ \ $+ $3
}

;connect4 <nick>
alias connect4 {
  if (($dialog(row4DialogAccept) == $null) && ($window(@Connect4).state == $null)) {
    init.row4
    set %row4.nick [ $1 ]
    var %port.row4 = $rand(1024,9999)
    while ($portfree(%port.row4) == $false) { %port.row4 = $rand(1024,9999) }
    var %row4.sock.listen = row4.listen. $+ $1
    sockclose %row4.sock.listen
    socklisten %row4.sock.listen %port.row4
    .notice $1 Connect4 game request $ip %port.row4
    connect4.window
    row4.win.msg Waiting aknowlegdement request .... 
    drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png
  }
  else { echo $colour(info) -se *** Close first either the current game window or the acknowlegdment window, please   }
}


on *:SOCKLISTEN:row4.listen.*:{
  set %sock.row4.play [ row4.play. [ $+ [ $ticks ] ] ]
  sockaccept %sock.row4.play
  row4.win.msg Opponent to crush : %row4.nick
  var %row4.dice = dice $rand(1,10)
  sockwrite -tn %sock.row4.play %row4.dice
  sockclose $sockname
  row4.sound start
}


on *:SOCKREAD:row4.play.*:{
  if ($sockerr > 0) { return }
  :nextreadrow4
  var %read.row4
  sockread %read.row4
  if ($sockbr == 0) { return } 
  if (%read.row4) {

    var %row4.cmd = $gettok(%read.row4,1,32)
    var %row4.par = $gettok(%read.row4,2,32)

    if (%row4.cmd == replay) { init.row4 | row4.redraw.partial }

    if (%row4.cmd == dice) { 
      var %dice = %row4.par
      while (%dice == %row4.par) { %dice = $rand(1,10) }
      if (%dice > %row4.par) { 
        set %row4.turn [ me ]
        drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \green.png
        sockwrite -tn $sockname me
      }
      else { 
        drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png
        set %row4.turn [ you ]
        sockwrite -tn $sockname you
      }
      row4.sound start
      goto nextreadrow4
    } 

    if (%row4.cmd == me) { 
      set %row4.turn [ you ]
      drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png
      goto nextreadrow4
    }

    if ((%row4.cmd == you) && (%row4.turn != winner)) { 
      set %row4.turn [ me ]
      drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \green.png
      goto nextreadrow4
    }

    if (%row4.cmd == coord) { 
      row4.draw.token $right(%row4.par,-1) $left(%row4.par,1) bl.png
      row4.sound chip
      set %row4.coord. [ $+ [ %row4.par ] ] [ opponent ] 
      row4.check.winner 
      goto nextreadrow4
    }

  }
  goto nextreadrow4
}


on *:SOCKCLOSE:row4.play.*:{
  window -c @Connect4
  echo $colour(info) -se *** Other side closed the Connect4 game 
  unset %row4.coord.*
  sockclose row4*
}


alias row4.choose.my.token {
  row4.check.winner 
  if (%row4.turn != me) { return }
  var %row4.count.token = 0
  var %row4.i = 6
  var %row4.stop.count.i
  var %row4.coord 
  while (%row4.i >= 1) {
    %row4.coord =  %row4.i $+ $1
    if (%row4.coord. [ $+ [ %row4.coord ] ] == neutral) { %row4.stop.count.i = %row4.i | break }
    dec %row4.i 1
  }

  if (%row4.stop.count.i  != $null) {
    %row4.coord =  %row4.stop.count.i  $+ $1  
    set %row4.coord. [ $+ [ %row4.coord ] ] [ me ]
    row4.draw.token  $1  %row4.stop.count.i  rd.png
    row4.sound chip
    sockwrite -tn %sock.row4.play  coord %row4.coord
    sockwrite -tn %sock.row4.play you
    set %row4.turn [ you ]
    drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png
    row4.check.winner
  }
  else { return }
}



alias row4.check.winner {
  var %row.i
  var %row.j
  var %row.k
  var %row.l
  var %coord.first
  var %coord.var
  var %coord.type
  var %is.same.type
  var %row4.game.result 
  var %row4.type
  %row.i = 1
  %row.j = 1
  while (%row.j <= 7) {
    %row.i = 1
    while (%row.i <= 3) {
      %coord.var = %row.i $+ %row.j
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.k = 0
        while (%row.k <= 3) {
          %coord.var = $calc(%row.k + %row.i) $+ %row.j
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.k 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win  }
          else  { %row4.game.result = loose  }
          goto endrow4 
        }
      }
      inc %row.i 1
    }
    inc %row.j 1
  }

  %row.i = 1
  %row.j = 1
  while (%row.i <= 7) {
    %row.j = 1
    while (%row.j <= 4) {
      %coord.var = %row.i $+ %row.j
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.k = 0
        while (%row.k <= 3) {
          %coord.var = %row.i $+ $calc(%row.k + %row.j)
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.k 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win    }
          else  { %row4.game.result = loose   }
          goto endrow4
        }
      }
      inc %row.j 1
    }
    inc %row.i 1
  }

  %row.i = 1 
  while (%row.i <= 3) {
    %row.j = 1
    %row.k = %row.i
    while (%row.k <= 3) {
      %coord.var = %row.k $+ %row.j
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.l = 0
        while (%row.l <= 3) {
          %coord.var = $calc(%row.k + %row.l) $+ $calc(%row.j + %row.l)
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.l 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win   }
          else  { %row4.game.result = loose   }
          goto endrow4
        }

      }
      inc %row.j 1
      inc %row.k 1
    }
    inc %row.i 1
  }


  %row.j = 2 
  while (%row.j <= 4) {
    %row.i = 1
    %row.k = %row.i
    while (%row.k <= 3) {
      %coord.var = %row.k $+ %row.j
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.l = 0
        while (%row.l <= 3) {
          %coord.var = $calc(%row.k + %row.l) $+ $calc(%row.j + %row.l)
          ;scripted by a_d ude at w w w. ar ma than . c j b. n e t
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.l 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win  }
          else  { %row4.game.result = loose    }
          goto endrow4
        }

      }
      inc %row.i 1
      inc %row.k 1
    }
    inc %row.j 1
  }


  %row.j = 4 
  while (%row.j <= 7) {
    %row.i = 1
    %row.k = %row.j
    while (%row.k >= 4) {
      %coord.var = %row.i $+ %row.k
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.l = 0
        while (%row.l <= 3) {
          %coord.var = $calc(%row.i + %row.l) $+ $calc(%row.k - %row.l)
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.l 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win    }
          else  { %row4.game.result = loose  }
          goto endrow4
        }
      }
      inc %row.i 1
      dec %row.k 1
    }
    inc %row.j 1
  }

  %row.i = 1 
  while (%row.i <= 3) {
    %row.j = 7
    %row.k = %row.i
    while (%row.k <= 3) {
      %coord.var = %row.k $+ %row.j
      %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
      if (%coord.type != neutral) {
        %is.same.type = 0
        %row4.type = %coord.type
        %row.l = 0
        while (%row.l <= 3) {
          %coord.var = $calc(%row.k + %row.l) $+ $calc(%row.j - %row.l)
          if (%row4.coord. [ $+ [ %coord.var ] ] == %row4.type) { inc %is.same.type 1 }
          inc %row.l 1
        }
        if (%is.same.type == 4) {
          %coord.type = %row4.coord. [ $+ [ %coord.var ] ]
          if (%row4.type == me) { %row4.game.result = win  }
          else  { %row4.game.result = loose   }
          goto endrow4
        }
      }
      dec %row.j 1
      inc %row.k 1
    }
    inc %row.i 1
  }

  :endrow4
  if (%row4.game.result != $null) { 
    if (%row4.game.result  = win) { row4.sound win | %row4.game.result = you won ... you are da man, eh ? }
    if (%row4.game.result  = loose) { row4.sound loose | %row4.game.result = weak, man .. LOOOOOOSER !!!! }
    set %row4.turn [ winner ]
    row4.win.msg %row4.game.result 
    drawpic -c @Connect4 177 9 $scriptdir $+ connectskins\ $+ %row4.skin $+ \red.png
  }
}


dialog row4DialogAccept {
  title "Game - Connect 4 "
  size -1 -1 150 45
  option dbu
  text "",1302,10 5 140 10
  text "Play or ignore game request during 60 secs ?",1303,10 15 140 10
  text "",1258,1 1 1 1
  button "Play",1304, 40 30 30 12,ok
  button "Ignore",1305,80 30 30 12
  button "",1274,1 1 1 1,cancel 
}

;play button
ON *:DIALOG:row4DialogAccept:SCLICK:1304:{
  unset %row4.coord.*
  init.row4
  set %sock.row4.play [ row4.play. [ $+ [ $ticks ] ] ]
  sockopen %sock.row4.play $did(1258).text
  set %row4.nick [ $gettok($did(1302).text,1,32) ]
  connect4.window
  row4.win.msg Opponent to crush : $gettok($did(1302).text,1,32)
}

;Ignore button
ON *:DIALOG:row4DialogAccept:SCLICK:1305:{ 
  sockclose row4* 
  set -u60 %row4.ip.refuse. [ $+ [ $gettok($did(1258).text,1,32) ] ] [ on ]
  dialog -x row4DialogAccept
}

;"x" button
ON *:DIALOG:row4DialogAccept:SCLICK:1274:sockclose row4* 
