; Chess Lamer v2.0
; by Wrath

; $sq(square[,square | n]).x, .bx, .y, .by, .col, .piece, .my, .op, .first, .ge, .diag, .hv
; .det, .difx, .dify, .sel
;
; --- Returns:
;
; no prop. : <square> if valid (lowercase letters), 0 otherwise
; x	: the ascii value of the square's x co-ordinate (a6 -> 97)
; bx	: the square's top left x co-ordinate (h4 -> with blacks -> 10; whites -> 290)
; y	: the value of the square's y co-ordinate (g2 -> 2)
; by	: the square's top left y co-ordinate (c2 -> with blacks -> 50; whites -> 150)
; col	: the colour of the square -> 'w' or 'b' (e4 -> w)
; piece	: 1 if there's a piece on that square; 0 otherwise
; my	: <piece>N if there's your piece on the square; 0 otherwise
; op	: <piece>N if there's opponent piece there; 0 otherwise
; first	: <square> of the first met piece according to *n*; 0 if no piece met
; ge	: comma-sep. list of <squares> which are accessible by a knight on that sq.
; diag	: comma-sep. list of <squares> which are accessible by a bishop on that sq.
; hv	: comma-sep. list of <squares> which are accessible by a rook on that sq.
; det	: determines the direction (used as *n* in .first) between the *two* given sq.
; difx	: *absolute* value calc-ed by subtracting *first* square's x from *second*'s x
; dify	: *absolute* value calc-ed by subtracting *first* square's y from *second*'s y
; sel	: 1 if the square is selected; 0 otherwise
alias sq {
  if ($1 == $null) return
  if ($prop == $null) {
    var %low = $lower($1)
    if (($left(%low,1) isletter abcdefgh) && ($right($1,-1) isnum 1-8)) {
      return %low
    }
    return 0
  }
  var %col = $hget(me,colour)
  var %x = $asc($left($1,1)), %y = $right($1,-1), %res
  goto $prop
  :x
  return %x
  :y
  return %y
  :diag
  var %sqx = %x, %sqy = %y
  inc %x | inc %y
  while ((%x <= 104) && (%y <= 8)) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    inc %x | inc %y
  }
  %x = %sqx | %y = %sqy
  dec %x | inc %y
  while ((%x >= 97) && (%y <= 8)) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    dec %x | inc %y
  }
  %x = %sqx | %y = %sqy
  dec %x | dec %y
  while ((%x >= 97) && (%y >= 1)) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    dec %x | dec %y
  }
  %x = %sqx | %y = %sqy
  inc %x | dec %y
  while ((%x <= 104) && (%y >= 1)) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    inc %x | dec %y
  }
  return %res
  :hv
  var %sqx = %x, %sqy = %y
  inc %x
  while (%x <= 104) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    inc %x
  }
  %x = %sqx | inc %y
  while (%y <= 8) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    inc %y
  }
  %y = %sqy | dec %x
  while (%x >= 97) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    dec %x
  }
  %x = %sqx | dec %y
  while (%y >= 1) {
    %res = $addtok(%res, [ [ $chr(%x) ] $+ [ %y ] ] ,44)
    dec %y
  }
  return %res
  :ge
  var %s = $chr($calc(%x + 2)) $+ $calc(%y + 1)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x + 2)) $+ $calc(%y - 1)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x + 1)) $+ $calc(%y + 2)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x + 1)) $+ $calc(%y - 2)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x - 2)) $+ $calc(%y + 1)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x - 2)) $+ $calc(%y - 1)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x - 1)) $+ $calc(%y + 2)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  %s = $chr($calc(%x - 1)) $+ $calc(%y - 2)
  if ($_cksq(%s)) %res = $addtok(%res,%s,44)
  return %res
  :piece
  var %myp = $hget(me,all), %hisp = $hget(op,all)
  if (($istok(%myp,$1,44)) || ($istok(%hisp,$1,44))) return 1
  return 0
  :my
  :op
  var %plr = $iif($prop == my,me,op), %i = 1
  if ($hget(%plr,king) == $1) return king
  while (%i <= 10) {
    if (%i <= 8) {
      %res = pawn $+ %i
      if ($hget(%plr,%res) == $1) return %res
    }
    if (%i <= 9) {
      %res = queen $+ %i
      if ($hget(%plr,%res) == $1) return %res
    }
    %res = knight $+ %i
    if ($hget(%plr,%res) == $1) return %res
    %res = bishop $+ %i
    if ($hget(%plr,%res) == $1) return %res
    %res = rook $+ %i
    if ($hget(%plr,%res) == $1) return %res
    inc %i
  }
  return 0
  :det
  if ($2 == $null) return
  var %x2 = $asc($left($2,1)), %y2 = $right($2,-1)
  if ((%x < %x2) && (%y == %y2)) %res = 1
  elseif ((%x < %x2) && (%y < %y2)) %res = 2
  elseif ((%x == %x2) && (%y < %y2)) %res = 3
  elseif ((%x > %x2) && (%y < %y2)) %res = 4
  elseif ((%x > %x2) && (%y == %y2)) %res = 5
  elseif ((%x > %x2) && (%y > %y2)) %res = 6
  elseif ((%x == %x2) && (%y > %y2)) %res = 7
  elseif ((%x < %x2) && (%y > %y2)) %res = 8
  if (%col == b) {
    if (%res isnum 1-4) %res = $replace(%res,1,5,2,6,3,7,4,8)
    else %res = $replace(%res,5,1,6,2,7,3,8,4)
  }
  return %res
  :first
  if ($2 !isnum 1-8) return
  var %myp = $hget(me,all), %hisp = $hget(op,all), %2 = $2
  if (%col == b) {
    if ($2 isnum 1-4) %2 = $replace(%2,1,5,2,6,3,7,4,8)
    else %2 = $replace(%2,5,1,6,2,7,3,8,4)
  }
  goto first $+ %2
  :first1 | inc %x
  while (%x <= 104) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    inc %x
  }
  return 0
  :first2 | inc %x | inc %y
  while ((%x <= 104) && (%y <= 8)) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    inc %x | inc %y
  }
  return 0
  :first3 | inc %y
  while (%y <= 8) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    inc %y
  }
  return 0
  :first4 | dec %x | inc %y
  while ((%x >= 97) && (%y <= 8)) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    dec %x | inc %y
  }
  return 0
  :first5 | dec %x
  while (%x >= 97) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    dec %x
  }
  return 0
  :first6 | dec %x | dec %y
  while ((%x >= 97) && (%y >= 1)) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    dec %x | dec %y
  }
  return 0
  :first7 | dec %y
  while (%y >= 1) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    dec %y
  }
  return 0
  :first8 | inc %x | dec %y
  while ((%x <= 104) && (%y >= 1)) {
    %res = $chr(%x) $+ %y
    if (($istok(%myp,%res,44)) || ($istok(%hisp,%res,44))) return %res
    inc %x | dec %y
  }
  return 0
  :difx
  if ($2 == $null) return
  return $abs($calc($asc($left($2,1)) - %x))
  :dify
  if ($2 == $null) return
  return $abs($calc($right($2,-1) - %y))
  :bx
  if (%col == b) %x = $calc(201 - %x)
  return $calc(10 + (%x - 97) * 40)
  :by
  if (%col == b) %y = $calc(9 - %y)
  return $calc(290 - (%y - 1) * 40)
  :col
  var %black = a1.c1.e1.g1.b2.d2.f2.h2.a3.c3.e3.g3.b4.d4.f4.h4.a5.c5.e5.g5.b6.d6.f6.h6
  %black = %black $+ .a7.c7.e7.g7.b8.d8.f8.h8
  if ($istok(%black,$1,46)) return b
  return w
  :sel
  if ($1 == %chess_sel) return 1
  return 0
}
alias -l _cksq {
  if (($left($1,1) isletter abcdefgh) && ($right($1,-1) isnum 1-8)) {
    return $1
  }
  return 0
}
;
; ===== Move aliases =====
;
; $1 = from, $2 = to
alias -l _moverook {
  _ckturn
  var %i = 1, %rook, %capture = 0
  while (%i <= 10) {
    %rook = rook $+ %i
    if ($hget(me,%rook) == $1) goto skip
    inc %i
  }
  _error You don't have a Rook at $1 $+ !
  :skip
  if ($istok($sq($1).hv,$2,44) != $true) _error You can't move the Rook from $1 to $2
  var %mid = $sq($1,$sq($1,$2).det).first
  if (%mid) {
    var %difx = $sq($1,$2).difx, %dify = $sq($1,$2).dify
    ;we are moving the rook horizontally
    if (%dify == 0) {
      if ($sq($1,%mid).difx < %difx) _error Move blocked by the piece at %mid $+ !
    }
    ;we are moving it vertically
    else {
      if ($sq($1,%mid).dify < %dify) _error Move blocked by the piece at %mid $+ !
    }
    if (%mid == $2) {
      if ($sq(%mid).my) _error You can't capture your pieces!
      %capture = $sq($2).op
    }
  }
  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 %rook $1-2

  ;check for check after the move
  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 %rook $2 $1
    if (%capture) { hadd op $ifmatch $2 | hadd op all %hisp }
    _error You can't move the Rook! There's a check from %check $+ !
  }

  if (($1 == h1) || ($1 == h8)) hadd me rokado1 0
  elseif (($1 == a1) || ($1 == a8)) hadd me rokado2 0

  _drawpiece r $1-2 $hget(me,colour)
  hadd me turn 0
  _upd.status 1 r $1-2
  _chess.send CL_5000 r $1-2
}
alias -l _ckturn if ($hget(me,turn) == 0) _error It's not your turn!
alias -l _moveknight {
  _ckturn
  var %i = 1, %knight, %capture = 0
  while (%i <= 10) {
    %knight = knight $+ %i
    if ($hget(me,%knight) == $1) goto skip
    inc %i
  }
  _error You don't have a Knight on $1 $+ !
  :skip
  if ($istok($sq($1).ge,$2,44) != $true) _error You can't move the Knight from $1 to $2 $+ !
  if ($sq($2).piece) {
    if ($sq($2).my) _error You can't capture your pieces!
    %capture = $sq($2).op
  }
  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 %knight $1-2

  ;check for check after the move
  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 %knight $2 $1
    if (%capture) { hadd op $ifmatch $2 | hadd op all %hisp }
    _error You can't move the Knight! There's a check from %check $+ !
  }

  _drawpiece n $1-2 $hget(me,colour)
  hadd me turn 0
  _upd.status 1 n $1-2
  _chess.send CL_5000 n $1-2
}
alias -l _movebishop {
  _ckturn
  var %i = 1, %bishop, %capture = 0
  while (%i <= 10) {
    %bishop = bishop $+ %i
    if ($hget(me,%bishop) == $1) goto skip
    inc %i
  }
  _error You don't have a Bishop on $1 $+ !
  :skip
  if ($istok($sq($1).diag,$2,44) != $true) _error You can't move the Bishop from $1 to $2
  var %mid = $sq($1,$sq($1,$2).det).first
  ;is there a piece standing in our way?
  if (%mid) {
    if ($sq($1,%mid).difx < $sq($1,$2).difx) _error Move blocked by the piece at %mid $+ !
    if (%mid == $2) {
      if ($sq(%mid).my) _error You can't capture your pieces!
      %capture = $sq($2).op
    }
  }
  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 %bishop $1-2

  ;check for check after the move
  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 %bishop $2 $1
    if (%capture) { hadd op $ifmatch $2 | hadd op all %hisp }
    _error You can't move the Bishop! There's a check from %check $+ !
  }

  _drawpiece b $1-2 $hget(me,colour)
  hadd me turn 0
  _upd.status 1 b $1-2
  _chess.send CL_5000 b $1-2
}
alias -l _movequeen {
  _ckturn
  var %i = 1, %queen, %capture = 0
  while (%i <= 9) {
    %queen = queen $+ %i
    if ($hget(me,%queen) == $1) goto skip
    inc %i
  }
  _error You don't have a Queen at $1 $+ !
  :skip
  if ($istok($addtok($sq($1).hv,$sq($1).diag,44),$2,44) != $true) {
    _error You can't move the Queen from $1 to $2 $+ !
  }
  var %mid = $sq($1,$sq($1,$2).det).first
  if (%mid) {
    var %difx = $sq($1,$2).difx, %dify = $sq($1,$2).dify
    ;we are moving the queen horizontally
    if (%dify == 0) {
      if ($sq($1,%mid).difx < %difx) _error Move blocked by the piece at %mid $+ !
    }
    ;we are moving it vertically
    elseif (%difx == 0) {
      if ($sq($1,%mid).dify < %dify) _error Move blocked by the piece at %mid $+ !
    }
    ;moving it diagonally
    else {
      if ($sq($1,%mid).difx < %difx) _error Move blocked by the piece at %mid $+ !
    }
    if (%mid == $2) {
      if ($sq(%mid).my) _error You can't capture your pieces!
      %capture = $sq($2).op
    }
  }
  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 %queen $1-2

  ;check for check after the move
  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 %queen $2 $1
    if (%capture) { hadd op $ifmatch $2 | hadd op all %hisp }
    _error You can't move the Queen! There's a check from %check $+ !
  }

  _drawpiece q $1-2 $hget(me,colour)
  hadd me turn 0
  _upd.status 1 q $1-2
  _chess.send CL_5000 q $1-2
}
alias -l _moveking {
  _ckturn
  var %king = $hget(me,king), %capture = 0
  var %rok1 = $hget(me,rokado1), %rok2 = $hget(me,rokado2)
  var %col = $hget(me,colour)
  if (0-0* iswm $1) {
    var %err = _error You can't castle!
    if (($1 == 0-0) && (%rok1 == 0)) %err
    if (($1 == 0-0-0) && (%rok2 == 0)) %err
    var %bool = $iif($1 == 0-0,1,0), %n = $iif(%col == w,1,8)
    var %f_ = $iif(%bool,f,d) $+ %n, %g = $iif(%bool,g,c) $+ %n
    var %e = e $+ %n, %b = b $+ %n
    if ((%bool == 0) && ($sq(%b).piece)) %err
    if (($sq(%f_).piece) || ($sq(%g).piece)) %err
    if ($_ckcheck) _error You can't castle! The King is in check!
    _movepiece 1 king %e %f_
    if ($_ckcheck) {
      _movepiece 1 king %f_ %e
      _error You can't castle! The King steps into check on %f_ $+ !
    }
    _movepiece 1 king %f_ %g
    if ($_ckcheck) {
      _movepiece 1 king %g %e
      _error You can't castle! The King steps into check on %g $+ !
    }
    hadd me rokado1 0
    hadd me rokado2 0
    var %h = $iif(%bool,h,a) $+ %n
    _movepiece 1 $sq(%h).my %h %f_
    _drawpiece k %e %g %col
    _drawpiece r %h %f_ %col
    goto sock
  }

  if (%king != $1) _error Your King is not on $1 $+ !
  if (($sq($1,$2).difx !isnum 0-1) || ($sq($1,$2).dify !isnum 0-1) || ($1 == $2)) {
    _error You can't move the King from $1 to $2 $+ !
  }
  if ($sq($2).piece) {
    if ($sq($2).my) _error You can't capture your pieces!
    %capture = $sq($2).op
  }

  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 king $1-2

  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 king $2 $1
    if (%capture) { hadd op $ifmatch $2 | hadd op all %hisp }
    _error You can't move the King to $2 $+ ! There's a check from %check $+ !
  }

  if (%rok1) hadd me rokado1 0
  if (%rok2) hadd me rokado2 0
  _drawpiece k $1-2 %col
  :sock
  hadd me turn 0
  _upd.status 1 k $1-2
  _chess.send CL_5000 k $1-2
}
alias -l _movepawn {
  _ckturn
  var %pawn, %i = 1, %capture = 0, %promote = 0, %enpass = 0
  while (%i <= 8) {
    %pawn = pawn $+ %i
    if ($hget(me,%pawn) == $1) goto skip
    inc %i
  }
  _error You don't have a Pawn at $1 $+ !
  :skip
  if ($istok($addtok($sq($1).hv,$sq($1).diag,44),$2,44) != $true) {
    _error You can't move the Pawn from $1 to $2 $+ !
  }
  var %d = $sq($1,$2).det, %col = $hget(me,colour)
  if (%d !isnum 2-4) _error You can't move the Pawn from $1 to $2 $+ !
  var %dify = $sq($1,$2).dify

  ;moving the pawn up
  if (%d == 3) {
    var %first = $left($1,1) $+ $iif(%col == w,2,7), %fpsq = $sq($1,3).first
    if (%fpsq) var %dify' = $sq($1,%fpsq).dify
    ;moving the pawn one square up
    if (%dify == 1) {
      if (%dify' == 1) _error Move blocked by the piece at %fpsq $+ !
      ;is there a promotion?
      if ($right($2,-1) == $iif(%col == w,8,1)) %promote = 1
    }
    ;moving the pawn 2 squares up
    elseif (%dify == 2) {
      if ($1 != %first) _error Pawns move two squares only the first time!
      if (%dify' <= 2) _error Move blocked by the piece at %fpsq $+ !
    }
    else _error You can't move the Pawn from $1 to $2 $+ !
  }
  ;capturing with the pawn (diagonally)
  else {
    if (%dify != 1) _error You can't move the Pawn from $1 to $2 $+ !
    if ($sq($2).piece) {
      if ($sq($2).my) _error You can't capture your own pieces
      if ($right($2,-1) == $iif(%col == w,8,1)) %promote = 1
      %capture = $sq($2).op
    }
    else {
      ;capturing 'en passant' or error
      var %_1 = $left($2,1) $+ $iif(%col == w,7,2), %_2 = $left($2,1) $+ $iif(%col == w,5,4)
      var %toy = $right($2,-1)
      if ((p %_1 %_2 $+ * !iswm $hget(op,lastmove)) || (%toy != $iif(%col == w,6,3))) {
        _error You can't move the Pawn from $1 to $2 $+ !
      }
      else {
        ;do 'en passant'
        %capture = $sq(%_2).op
        %enpass = %_2
      }
    }
  }

  var %hisp = $hget(op,all)
  if (%capture) _delpiece 0 $ifmatch
  _movepiece 1 %pawn $1-2

  ;check for check after the move
  var %check = $_ckcheck
  if (%check) {
    _movepiece 1 %pawn $2 $1
    if (%capture) {
      hadd op $ifmatch $iif(%enpass,%enpass,$2)
      hadd op all %hisp
    }
    _error You can't move the Pawn! There's a check from %check $+ !
  }

  if (%promote) %promote = $_do.promote(%pawn,$1,$2,%col)
  else _drawpiece p $1-2 %col
  if (%enpass) { _fillsquare %enpass | drawdot -h @Chess }
  hadd me turn 0
  _upd.status 1 p $1-2 %promote
  if (%promote) _chess.send CL_5000 p $1-2 %promote
  elseif (%enpass) _chess.send CL_5000 p $1-2 %enpass
  else _chess.send CL_5000 p $1-2
}
; $1 = pawnN, $2 = from, $3 = to, $4 = me's colour
alias -l _do.promote {
  var %res = $dialog(promote,promote,-3)
  _delpiece 1 $1
  _addpiece 1 %prompiece $3
  _drawpiece %prompiece $2-4
  set -u %prompiece %prompiece
  return %prompiece
}
dialog promote {
  title "Promotion to..."
  size $calc($window(@Chess).x + 70) $calc($window(@Chess).y + 210) 116 40
  option dbu

  button "Ok", 1, 46 23 25 13, cancel default
  radio "Queen", 2, 5 5 25 15, push
  radio "Rook", 3, 32 5 25 15, push
  radio "Knight", 4, 59 5 25 15, push
  radio "Bishop", 5, 86 5 25 15, push
}
on *:DIALOG:promote:init:*:did -c $dname 2
on *:DIALOG:promote:sclick:1:{
  if ($did(2).state) %prompiece = q
  elseif ($did(3).state) %prompiece = r
  elseif ($did(4).state) %prompiece = n
  else %prompiece = b
}

; $1 = 1 (me), 0 (opponent), $2 = q,r,n,b, $3 = square
alias -l _addpiece {
  var %plr = $iif($1,me,op), %all = $hget(%plr,all), %i = 1
  goto $2
  :q
  var %queen = queen $+ %i
  while ($hget(%plr,%queen)) { inc %i | %queen = queen $+ %i }
  hadd %plr %queen $3
  goto done
  :r
  var %rook = rook $+ %i
  while ($hget(%plr,%rook)) { inc %i | %rook = rook $+ %i }
  hadd %plr %rook $3
  goto done
  :n
  var %knight = knight $+ %i
  while ($hget(%plr,%knight)) { inc %i | %knight = knight $+ %i }
  hadd %plr %knight $3
  goto done
  :b
  var %bishop = bishop $+ %i
  while ($hget(%plr,%bishop)) { inc %i | %bishop = bishop $+ %i }
  hadd %plr %bishop $3
  :done
  hadd %plr all $addtok(%all,$3,44)
}
; $1 = 1 (me's piece), 0 (opponent's one), $2 = pieceN, $3 = from, $4 = to
alias -l _movepiece {
  var %plr = $iif($1,me,op)
  hadd %plr $2 $4
  hadd %plr all $reptok($hget(%plr,all),$3,$4,1,44)
}
; $1 = 1 (me's piece), 0 (opponent's one), $2 = pieceN
alias -l _delpiece {
  var %plr = $iif($1,me,op), %sq = $hget(%plr,$2)
  hadd %plr $2 0
  hadd %plr all $remtok($hget(%plr,all),%sq,1,44)
}

alias -l _ckcheck {
  var %king = $hget(me,king), %i = 1
  var %king.x = $sq(%king).x, %king.y = $sq(%king).y
  ;search in all directions from the king's square
  while (%i <= 8) {
    ;ensure that a piece is actually met
    if ($sq(%king,%i).first != 0) {
      var %piece = $ifmatch
      ;ensure it's not your piece
      if ($sq(%piece).op) {
        var %type = $ifmatch, %pcx = $sq(%piece).x, %pcy = $sq(%piece).y
        ;horizontals and verticals
        if (%i isin 1357) {
          ;case of queen or rook
          if ((queen* iswm %type) || (rook* iswm %type)) return %piece
        }

        ;diagonals
        else {
          ;case of queen or bishop
          if ((queen* iswm %type) || (bishop* iswm %type)) return %piece
          ;check for pawns threatening the king
          if ((pawn* iswm %type) && (%i isin 24) && ($abs($calc(%pcx - %king.x)) == 1)) return %piece
        }

        ;case of king
        if (%type == king) {
          var %difx = $abs($calc(%pcx - %king.x)), %dify = $abs($calc(%pcy - %king.y))
          ;check if the king is right next to our king
          if ((%difx isnum 0-1) && (%dify isnum 0-1)) return %piece
        }
      }
    }
    inc %i
  }

  ;check for knights threatening the king
  var %toks = $sq(%king).ge
  while ($gettok(%toks,1,44)) {
    var %csq = $ifmatch
    if ($sq(%csq).op) {
      var %type = $ifmatch
      if (knight* iswm %type) return %csq
    }
    %toks = $deltok(%toks,1,44)
  }
  return 0
}

menu @Chess {
  sclick:{
    if (($sock(chess.game).status != active) || ($sock(chess.save*,0))) return
    tokenize 32 $mouse.x $mouse.y
    if (($1 > 329) || ($1 < 10) || ($2 > 329) || ($2 < 10)) {
      if (%chess_sel) _chess.unsel
      return
    }
    var %sq = $chr($calc($int($calc(($1 - 10) / 40)) + 97)) $+ $chr($calc(56 - $int($calc(($2 - 10) / 40))))
    var %colour = $hget(me,colour)
    if (%colour == b) {
      %sq = $chr($calc(201 - $asc($left(%sq,1)))) $+ $calc(9 - $right(%sq,-1))
    }
    if (%sq == %chess_sel) _chess.unsel
    elseif (%chess_sel == $null) {
      %chess_sel = %sq
      drawrect @Chess 4 1 $sq(%sq).bx $sq(%sq).by 41 41
      return
    }
    elseif ($sq(%chess_sel).my) {
      var %p = $ifmatch
      if (r* iswm %p) _moverook %chess_sel %sq
      elseif (kn* iswm %p) _moveknight %chess_sel %sq
      elseif (b* iswm %p) _movebishop %chess_sel %sq
      elseif (q* iswm %p) _movequeen %chess_sel %sq
      elseif (p* iswm %p) _movepawn %chess_sel %sq
      else {
        if (%colour == b) {
          if ((%chess_sel == e8) && (%sq == g8)) _moveking 0-0
          elseif ((%chess_sel == e8) && (%sq == c8)) _moveking 0-0-0
          else _moveking %chess_sel %sq
        }
        else {
          if ((%chess_sel == e1) && (%sq == g1)) _moveking 0-0
          elseif ((%chess_sel == e1) && (%sq == c1)) _moveking 0-0-0
          else _moveking %chess_sel %sq
        }
      }
      _chess.unsel
    }
  }
}
alias -l _chess.unsel {
  drawrect @Chess 1 1 $sq(%chess_sel).bx $sq(%chess_sel).by 41 41
  unset %chess_sel
}

; $1 = r,n,b,q,k,p, $2 = from (0-0, 0-0-0), $3 = to, [$4 = q,r,n,b | square]
alias _on.opponent.move {
  if ($2 == $null) return
  var %c = $hget(op,colour), %p = $sq($2).op
  if ($1 isletter rnbq) {
    if ($3 == $null) return
    if ($1 == r) {
      if (($2 == h1) || ($2 == h8)) hadd op rokado1 0
      elseif (($2 == a1) || ($2 == a8)) hadd op rokado2 0
    }
    _movepiece 0 %p $2-3
    if ($sq($3).my) _delpiece 1 $ifmatch
    _drawpiece $1-3 %c
    hadd me turn 1
    _upd.status 0 $1-3
  }
  elseif ($1 == k) {
    hadd op rokado1 0
    hadd op rokado2 0
    if ($2 == 0-0) {
      var %n = $iif(%c == w,1,8), %g = g $+ %n, %h = h $+ %n, %t = f $+ %n, %e = e $+ %n
      _movepiece 0 king %e %g
      _movepiece 0 $sq(%h).op %h %t
      _drawpiece k %e %g %c
      _drawpiece r %h %t %c
      hadd me turn 1
      _upd.status 0 k 0-0
    }
    elseif ($2 == 0-0-0) {
      var %n = $iif(%c == w,1,8), %g = c $+ %n, %h = a $+ %n, %t = d $+ %n, %e = e $+ %n
      _movepiece 0 king %e %g
      _movepiece 0 $sq(%h).op %h %t
      _drawpiece k %e %g %c
      _drawpiece r %h %t %c
      hadd me turn 1
      _upd.status 0 k 0-0-0
    }
    else {
      if ($3 == $null) return
      _movepiece 0 king $2-3
      if ($sq($3).my) _delpiece 1 $ifmatch
      _drawpiece $1-3 %c
      hadd me turn 1
      _upd.status 0 $1-3
    }
  }
  else {
    if ($3 == $null) return
    if ($4) {
      if ($sq($4)) {
        _delpiece 1 $sq($4).my
        _movepiece 0 %p $2-3
        _fillsquare $4
        _drawpiece $1-3 %c
        hadd me turn 1
        _upd.status 0 $1-3
      }
      elseif ($4 isletter qrnb) {
        if ($sq($3).my) _delpiece 1 $ifmatch
        _delpiece 0 %p
        _addpiece 0 $4 $3
        _drawpiece $4 $2-3 %c
        hadd me turn 1
        _upd.status 0 $1-4
      }
      return
    }
    if ($sq($3).my) _delpiece 1 $ifmatch
    _movepiece 0 %p $2-3
    _drawpiece $1-3 %c
    hadd me turn 1
    _upd.status 0 $1-3
  }
}

on *:INPUT:@Chess:{
  if ($ctrlenter) goto mess
  if (/* iswm $1) return
  if ((0-0* iswm $1) || (($1 isletter rnbqkpRNBQKP) && ($len($1) == 1))) {
    move $1-
    halt
  }
  :mess
  _chess.send mess $1-
  _echo $1-
  halt
}
alias move {
  if (($1 == $null) || ($sock(chess.game).status != active) || ($sock(chess.save*,0))) return
  if ($1 == 0-0) _moveking 0-0
  elseif ($1 == 0-0-0) _moveking 0-0-0
  elseif (($1 isletter rnbqkpRNBQKP) && ($len($1) == 1)) {
    if ($3 == $null) return
    if ($sq($2) && $sq($3)) {
      goto $1
      :r | _moverook $2-3 | return
      :n | _moveknight $2-3 | return
      :b | _movebishop $2-3 | return
      :q | _movequeen $2-3 | return
      :k | _moveking $2-3 | return
      :p | _movepawn $2-3
    }
  }
}
