; Chess Lamer v2.0
; by Wrath

on *:LOAD:{
  if (($version < 5.8) || ($bits < 32)) {
    echo -a 4*** CHESS LAMER $_cl.ver requires at least mIRC32 v5.8!
    goto error
  }
  var %s = " $+ $scriptdir $+ Chess2.mrc"
  if ($exists(%s) != $true) {
    %s = $dir="Find the second part of Chess Lamer!" $"($scriptdir)
    if (%s == $null) goto error
    %s = $"(%s)
    if (; Chess Lamer* !iswm $read -ntl1 %s) {
      echo -a 4*** Wrong file!
      goto error
    }
  }
  .load -rs %s
  echo -ea 4* 14Wrath Presents: CHESS LAMER $_cl.ver
  return
  :error
  .unload -rs $"($script)
}
alias -l " return " $+ $1- $+ "
alias -l _cl.ver return $gettok( [ $read -ntl1 $"($script) ] ,-1,32)

alias chess {
  if ($window(@Chess)) { window -a @Chess | return }
  unset %chess_*
  window -ekp @Chess -1 -1 505 430
  titlebar @Chess $gettok( [ $read -ntl1 $"($script) ] ,3-,32)
  _drawboard
}

; Draw aliases

alias -l _drawboard {
  clear -n @Chess
  drawfill -n @Chess 15 15 6 6
  drawrect -n @Chess 1 1 10 10 320 320
  var %i = 50, %j
  ;draw the squares
  while (%i <= 330) {
    drawline -n @Chess 1 1 %i 10 %i 330
    drawline -n @Chess 1 1 10 %i 330 %i
    inc %i 40
  }
  %i = 26
  ;fill the squares
  while (%i < 330) {
    %j = 66
    while (%j < 330) {
      drawfill -n @Chess 1 1 %j %i
      drawfill -n @Chess 1 1 %i %j
      inc %j 80
    }
    inc %i 80
  }
  drawdot -h @Chess
}

; $1 = w (white at the bottom), b (black at the bottom)
alias -l _draw.pieces {
  _reset.ht $1
  ;put numbers and letters for the columns and rows
  _put.coord $1
  var %i = 97
  ;draw the pawns
  while ($chr(%i) != i) {
    _drawpawn $chr(%i) $+ 2 w
    _drawpawn $chr(%i) $+ 7 b
    inc %i
  }
  ;draw the rest pieces
  _drawrook a1 w
  _drawrook h1 w
  _drawrook a8 b
  _drawrook h8 b
  _drawknight b1 w
  _drawknight g1 w
  _drawknight b8 b
  _drawknight g8 b
  _drawbishop c1 w
  _drawbishop f1 w
  _drawbishop c8 b
  _drawbishop f8 b
  _drawqueen d1 w
  _drawqueen d8 b
  _drawking e1 w
  _drawking e8 b
  ;draw the game status
  _draw.status $1
  drawdot -h @Chess
}
alias -l _put.coord {
  if ($1 == w) {
    var %char = 64, %num = 9, %i = 26, %j = 0
    while (%i < 330) {
      inc %char | inc %j | dec %num
      drawtext -n @Chess 1 %i 332 $chr(%char)
      drawtext -n @Chess 1 334 $calc(%i - %j) %num
      inc %i 40
    }
  }
  else {
    var %char = 73, %num = 0, %i = 26, %j = 0
    while (%i < 330) {
      dec %char | inc %j | inc %num
      drawtext -n @Chess 1 %i 332 $chr(%char)
      drawtext -n @Chess 1 334 $calc(%i - %j) %num
      inc %i 40
    }
  }
}
alias -l _draw.status {
  drawrect -n @Chess 1 1 350 10 140 160
  drawline -n @Chess 1 1 350 90 490 90
  drawtext -n @Chess $iif($1 == w,0,14) Fixedsys 12 355 100 $me
}
alias -l _reset.ht {
  var %m = $iif($1 == w,me,op), %o = $iif($1 == w,op,me)
  hfree -w me
  hfree -w op
  hmake me 20
  hmake op 20
  hadd me moveN 0
  hadd op moveN 0
  hadd op nick 0
  hadd me lastmove 0
  hadd op lastmove 0
  hadd %m colour w
  hadd %o colour b
  hadd %m all e1,d1,a1,h1,b1,g1,c1,f1,a2,b2,c2,d2,e2,f2,g2,h2
  hadd %o all e8,d8,a8,h8,b8,g8,c8,f8,a7,b7,c7,d7,e7,f7,g7,h7
  hadd %m king e1
  hadd %o king e8
  hadd %m queen1 d1
  hadd %o queen1 d8
  hadd %m rook1 a1
  hadd %o rook1 a8
  hadd %m rook2 h1
  hadd %o rook2 h8
  hadd %m knight1 b1
  hadd %o knight1 b8
  hadd %m knight2 g1
  hadd %o knight2 g8
  hadd %m bishop1 c1
  hadd %o bishop1 c8
  hadd %m bishop2 f1
  hadd %o bishop2 f8
  var %char = 97, %num = 1
  while (%num <= 8) {
    var %pawn = pawn $+ %num
    hadd %m %pawn $chr(%char) $+ 2
    hadd %o %pawn $chr(%char) $+ 7
    inc %num | inc %char
  }
  ;rokado1 -> short; rokado2 -> long
  hadd me rokado1 1
  hadd op rokado1 1
  hadd me rokado2 1
  hadd op rokado2 1
  hadd me turn $iif($1 == w,1,0)
}

; $1 = square, $2 = colour (w, b)
alias -l _drawrook {
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  var %x1 = $calc($1 + 7), %x2 = $calc($1 + 10), %x3 = $calc($1 + 30)
  var %y1 = $calc($2 + 37), %y2 = $calc($2 + 29), %y3 = $calc($2 + 16)
  var %x4 = $calc($1 + 26), %x5 = $calc($1 + 23), %x6 = $calc($1 + 17)
  var %y4 = $calc($2 + 8), %y5 = $calc($2 + 10), %x7 = $calc($1 + 14)
  var %x8 = $calc($1 + 20)
  drawline -n @Chess $3 2 %x1 %y1 $calc($1 + 33) %y1 %x3 %y2 %x2 %y2 %x1 %y1
  drawrect -n @Chess $3 2 $calc($1 + 11) %y3 18 13
  drawline -n @Chess $3 2 %x2 %y3 %x3 %y3 %x3 %y4 %x4 %y4 %x4 %y5 %x5 $&
  %y5 %x5 %y4 %x6 %y4 %x6 %y5 %x7 %y5 %x7 %y4 %x2 %y4 %x2 %y3
  drawfill -n @Chess $3 $3 %x8 $calc($2 + 34) %x8 $calc($2 + 22) %x8 $calc($2 + 11)
}
alias -l _drawknight {
  var %c = $iif($sq($1).col == b,1,15)
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  var %x1 = $calc($1 + 7), %x2 = $calc($1 + 25), %y1 = $calc($2 + 36)
  drawline -n @Chess $3 2 %x1 %y1 $calc($1 + 30) %y1 %x2 $calc($2 + 29) $&
  $calc($1 + 33) $calc($2 + 17) %x2 $calc($2 + 4) $calc($1 + 8) $calc($2 + 11) $&
  $calc($1 + 10) $calc($2 + 16) $calc($1 + 19) $calc($2 + 13) $calc($1 + 20) $&
  $calc($2 + 18) %x1 %y1
  drawfill -n @Chess $3 $3 $calc($1 + 18) $calc($2 + 25)
  drawdot -n @Chess %c 2 $calc($1 + 23) $calc($2 + 10)
}
alias -l _drawbishop {
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  drawrect -ne @Chess $3 2 $calc($1 + 13) $calc($2 + 4) 14 27
  drawrect -n @Chess $3 2 $calc($1 + 11) $calc($2 + 28) 18 10
  drawfill -n @Chess $3 $3 $calc($1 + 17) $calc($2 + 8) $calc($1 + 16) $calc($2 + 32)
}
alias -l _drawqueen {
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  var %x1 = $calc($1 + 20), %y1 = $calc($2 + 29)
  var %y2 = $calc($2 + 10), %y3 = $calc($2 + 21)
  var %y4 = $calc($2 + 7)
  drawrect -n @Chess $3 2 $calc($1 + 10) %y1 20 9
  drawline -n @Chess $3 2 $calc($1 + 11) %y1 $calc($1 + 7) %y2 $calc($1 + 14) $&
  %y3 $calc($1 + 15) %y4 %x1 $calc($2 + 19) $calc($1 + 25) %y4 $calc($1 + 26) $&
  %y3 $calc($1 + 33) %y2 $calc($1 + 29) %y1
  drawfill -n @Chess $3 $3 %x1 $calc($2 + 25) %x1 $calc($2 + 35)
}
alias -l _drawking {
  var %c = $iif($sq($1).col == b,1,15)
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  var %x1 = $calc($1 + 20), %y1 = $calc($2 + 29), %y2 = $calc($2 + 15)
  drawrect -n @Chess $3 2 $calc($1 + 10) %y1 20 9
  drawline -n @Chess $3 2 $calc($1 + 11) %y1 $calc($1 + 7) $calc($2 + 10) %x1 $&
  $calc($2 + 16) $calc($1 + 33) $calc($2 + 10) $calc($1 + 29) %y1
  drawline -n @Chess $3 2 $calc($1 + 16) %y2 %x1 $calc($2 + 7) $calc($1 + 24) %y2
  drawfill -n @Chess $3 $3 %x1 $calc($2 + 11) %x1 $calc($2 + 21) %x1 $calc($2 + 33)
  drawline -n @Chess %c 3 $calc($1 + 12) $calc($2 + 17) $calc($1 + 16) $calc($2 + 22)
  drawline -n @Chess %c 3 $calc($1 + 28) $calc($2 + 17) $calc($1 + 24) $calc($2 + 22)
}
alias -l _drawpawn {
  tokenize 32 $sq($1).bx $sq($1).by $iif($2 == w,0,14)
  var %x1 = $calc($1 + 11), %x2 = $calc($1 + 29), %x3 = $calc($1 + 20)
  var %y1 = $calc($2 + 38), %y2 = $calc($2 + 31)
  drawline -n @Chess $3 2 %x1 %y1 %x2 %y1 %x2 %y2 %x3 $calc($2 + 24) $&
  %x1 %y2 %x1 %y1
  drawrect -ne @Chess $3 2 $calc($1 + 12) $calc($2 + 14) 16 15
  drawfill -n @Chess $3 $3 %x3 $calc($2 + 18) %x3 $calc($2 + 33)
}
alias _fillsquare {
  var %c = $iif($sq($1).col == b,1,15)
  tokenize 32 $sq($1).bx $sq($1).by
  drawfill -n @Chess %c %c $calc($1 + 20) $calc($2 + 20)
  drawfill -n @Chess %c %c $calc($1 + 14) $calc($2 + 16)
  drawfill -n @Chess %c %c $calc($1 + 25) $calc($2 + 16)
}
; $1 = r,n,b,q,k,p, $2 = from, $3 = to, $4 = colour (w or b)
alias _drawpiece {
  _fillsquare $3
  if ($1 == r) _drawrook $3-4
  elseif ($1 == n) _drawknight $3-4
  elseif ($1 == b) _drawbishop $3-4
  elseif ($1 == q) _drawqueen $3-4
  elseif ($1 == k) _drawking $3-4
  else _drawpawn $3-4
  _fillsquare $2
  drawdot -h @Chess
}

; Menus

menu status,channel,query {
  Chess Lamer
  .Play Chess:{
    chess
    if (($menu == query) && ($server) && ($mouse.key & 2)) {
      .enable #chess.uhost
      .userhost $1
      _echo Collecting $1 $+ 's IP... Please wait!
    }
  }
  .Log Games $iif(%chess.logging,[On],[Off]):{
    if (%chess.logging) unset %chess.logging
    else set %chess.logging 1
    echo $colour(i) -ta * Game logging is now $iif(%chess.logging,ON,OFF)
  }
  .-
  .Unload!:{
    if ($?!="Are you sure?") {
      echo -ea 4* Unloading CHESS LAMER $_cl.ver $+ ...
      window -c @Chess
      _chess.onclose
      unset %chess.logging
      if ($script(Chess2.mrc)) .unload -rs $"($ifmatch)
      .unload -rs $"($script)
    }
  }
}
#chess.uhost off
raw 302:*:{
  .disable #chess.uhost | haltdef
  if ($2 != $null) {
    var %ip = $gettok($2,2,64)
    sockopen chess.game %ip 32173
    _echo Connecting to %ip $+ ... Please wait!
  }
  elseif ($window(@Chess)) _error They are not on IRC!
}
#chess.uhost end

menu @Chess {
  $iif($sock(chess.*,0) == 0,[Game])
  .Create New:_create.game
  .Load...:_load.game
  .-
  .Join:_join.game
  $iif(($sock(chess.game).status == active) && ($sock(chess.save*,0) == 0),[Diplomacy])
  .Send a message:_chess.send mess $$?="What message?" | _echo $!
  .Resign!:_chess.send quit!
  .$iif($hget(me,turn),Offer draw):_chess.send draw?
  .Ping:_chess.send ping?
  $iif($hget(op,nick),[Save Game]):_save.game
  $iif($sock(chess.*,0),[Cancel],[Close]):{
    if ($sock(chess.*,0)) { _chess.onclose | _drawboard }
    else { window -c @Chess | _chess.onclose }
  }
}

; Sockets & stuff

alias -l _ck.port if ($portfree(32173) != $true) _error Port 32173 is in use!
alias -l _create.game {
  var %col = $$?="Which pieces do you want to play with: $crlf $+ $&
  (choose a number) $crlf $+ 1. White $crlf $+ 2. Black"
  if (%col !isnum 1-2) _error Sorry, wrong number!
  _ck.port
  _draw.pieces $iif(%col == 1,w,b)
  socklisten chess.listen 32173
}
on *:SOCKLISTEN:chess.listen:{
  sockaccept chess.game
  sockclose $sockname
}
alias -l _join.game {
  sockopen chess.game $$?="Enter creator's IP or Hostname" 32173
  _echo Connecting to $! $+ ... Please wait!
}
on *:SOCKOPEN:chess.game:{
  if ($sockerr) _error Error connecting to $sock($sockname).ip $+ !
  _chess.send join $me
}
; $1 = header, $2- = data
alias _chess.send {
  if ($sock(chess.game).status != active) return
  sockwrite -n chess.game $chr(174) $+ $1 $+ $chr(174) $+ $2-
}
on *:SOCKCLOSE:chess.game:_chess.onsockclose
alias -l _chess.onsockclose {
  _chess.onclose
  if ($window(@Chess)) {
    _drawboard
    _echo Remote has closed the connection!
  }
}
on *:SOCKREAD:chess.game:{
  if ($sockerr) return
  var %data
  :nextread
  sockread %data
  if ($sockbr == 0) return
  var %header = $_get.header(%data)
  if (%header) {
    if (%header == join) _on.join $gettok(%data,2,174)
    elseif (%header == accept) _on.accept $gettok(%data,2-3,174)
    elseif (%header == accept_2) _on.accept2 $gettok(%data,2-,174)
    elseif (%header == ready) _on.ready $gettok(%data,2,174)
    elseif (%header == CL_5000) _on.opponent.move $gettok(%data,2-,174)
    elseif (%header == mess) _echo $gettok(%data,2-,174)
    elseif (%header == ping?) _chess.send pong!
    elseif (%header == pong!) _echo PING? PONG!
    elseif (%header == quit!) {
      _echo The opponent has resigned! | .timer -o 1 3 _chess.onsockclose
    }
    elseif (%header == draw?) .timer -om 1 0 _on.draw.offer
    elseif (%header == draw!) {
      _echo The game ended in a draw! | .timer -o 1 3 _chess.onsockclose
    }
    elseif (%header == !draw) _echo No draw! Play on!
  }
  goto nextread
}
alias -l _get.header {
  if (($left($1,1) == $chr(174)) && ($numtok($1-,174) >= 1)) {
    var %t = $gettok($1-,1,174)
    var %pb = CL_5000.join.mess.accept.ping?.pong!.quit!.draw?.draw!.!draw.accept_2.ready
    if ($istok(%pb,%t,46)) return %t
  }
  return 0
}
; $1 = opponent's nick
alias -l _on.join {
  if ($1 == $null) return
  hadd op nick $1
  var %col = $hget(op,colour)
  drawtext @Chess $iif(%col == w,0,14) Fixedsys 12 355 20 $1
  if (%chess_load != $null) {
    _chess.send accept_2 $me $ifmatch
    _echo Sending $1 the saved game... Please wait!
  }
  else {
    _chess.send accept $me %col
    _echo $1 has joined the game!
  }
  if (%chess.logging) write -c $_log $iif(%col == w, [ $1 vs. $me ] , [ $me vs. $1 ] )
}
alias -l _log return " $+ $scriptdir $+ Chess_Game.log"
; $1 = creator's nick, $2 = what client's colour should be (w or b)
alias -l _on.accept {
  if ($2 == $null) return
  _draw.pieces $2
  hadd op nick $1
  var %col = $hget(op,colour)
  drawtext @Chess $iif(%col == w,0,14) Fixedsys 12 355 20 $1
  _echo Let's get it on!
  if (%chess.logging) write -c $_log $iif(%col == w, [ $1 vs. $me ] , [ $me vs. $1 ] )
}
; $1 = creator's nick, $2- = save game name
alias -l _on.accept2 {
  if ($2 == $null) return
  var %dir = " $+ $scriptdir $+ clsaves\"
  if ($isdir(%dir) != $true) .mkdir %dir
  socklisten chess.save.t $_get.port
  sockmark chess.save.t $1 $left(%dir,-1) $+ $2- $+ .me.cls"
  _chess.send ready $sock(chess.save.t).port
  _echo Getting saved game from $1 $+ ... Please wait!
}
alias -l _get.port {
  while ($portfree(%p) != $true) { var %p = $r(1025,5000) }
  return %p
}
; $1 = client's port
alias -l _on.ready {
  if ($1 == $null) return
  sockopen chess.save $sock(chess.game).ip $1
}
alias -l _on.draw.offer {
  var %nick = $hget(op,nick)
  var %draw = $?!=" %nick has offered you a draw. $crlf $+ Do you accept it?"
  _chess.send $iif(%draw,draw!,!draw)
}

; Load game stuff

alias -l _save.game {
  var %game = $mkfn($$?="Game name?"), %dir = " $+ $scriptdir $+ clsaves\"
  if ($isdir(%dir) != $true) .mkdir %dir
  hsave -o me $left(%dir,-1) $+ %game $+ .me.cls"
  hsave -o op $left(%dir,-1) $+ %game $+ .op.cls"
  _echo Game $"(%game) saved!
}
alias -l _load.game {
  var %game = $$dialog(cl.lg,cl.lg,-3)
  _ck.port
  hmake me 20
  hmake op 20
  hload me " $+ $scriptdir $+ clsaves\ $+ %game $+ .me.cls"
  hload op " $+ $scriptdir $+ clsaves\ $+ %game $+ .op.cls"
  _fin.load
  socklisten chess.listen 32173
  set %chess_load %game
}
alias -l _fin.load {
  var %i = 1, %opc = $hget(op,colour), %myc = $hget(me,colour), %p
  _put.coord %myc
  _drawking $hget(me,king) %myc
  _drawking $hget(op,king) %opc
  while (%i <= 10) {
    if (%i <= 8) {
      %p = pawn $+ %i
      if ($hget(me,%p)) _drawpawn $ifmatch %myc
      if ($hget(op,%p)) _drawpawn $ifmatch %opc
    }
    if (%i <= 9) {
      %p = queen $+ %i
      if ($hget(me,%p)) _drawqueen $ifmatch %myc
      if ($hget(op,%p)) _drawqueen $ifmatch %opc
    }
    %p = rook $+ %i
    if ($hget(me,%p)) _drawrook $ifmatch %myc
    if ($hget(op,%p)) _drawrook $ifmatch %opc
    %p = knight $+ %i
    if ($hget(me,%p)) _drawknight $ifmatch %myc
    if ($hget(op,%p)) _drawknight $ifmatch %opc
    %p = bishop $+ %i
    if ($hget(me,%p)) _drawbishop $ifmatch %myc
    if ($hget(op,%p)) _drawbishop $ifmatch %opc
    inc %i
  }
  _draw.status %myc
  drawdot -h @Chess
}
dialog cl.lg {
  title "Load Game"
  size -1 -1 110 113
  option dbu

  button "Cancel", 100, 55 96 27 12, cancel
  box "Saved games:", 1, 5 3 100 90
  list 2, 8 12 94 82, sort vsbar hsbar
  button "Load", 3, 25 96 27 12, ok
  edit "", 4, 1 1 1 1, hide autohs result
}
on *:DIALOG:cl.lg:init:*:{
  var %dir = " $+ $scriptdir $+ clsaves\"
  if ($isdir(%dir) != $true) return
  %dir = $findfile(%dir,*.me.cls,0,if ($exists($puttok($1-,op,-2,46))) did -a $dname 2 $deltok($nopath($1-),-2-,46))
  did -z $dname 2
}
on *:DIALOG:cl.lg:sclick:2:did -o $dname 4 1 $did($did,$did($did,1).sel)
on *:DIALOG:cl.lg:dclick:2:did -o $dname 4 1 $did($did,$did($did,1).sel) | dialog -k $dname

on *:SOCKOPEN:chess.save:{
  if ($sockerr) {
    drawfill @Chess 15 1 353 13
    sockclose chess.game
    _ck.port
    socklisten chess.listen 32173
    _error Couldn't send saved game to $hget(op,nick)
  }
  bread " $+ $scriptdir $+ clsaves\ $+ %chess_load $+ .op.cls" 0 4096 &buf
  sockwrite $sockname &buf
}
on *:SOCKLISTEN:chess.save.t:{
  sockaccept chess.save
  sockmark chess.save $sock($sockname).mark
  sockclose $sockname
}
on *:SOCKREAD:chess.save:{
  if ($sockerr) return
  inc %chess_mid
  tokenize 32 $sock($sockname).mark
  sockread &buf
  if (%chess_mid > 1) {
    unset %chess_mid
    var %op.db = $puttok($2-,op,-2,46)
    .remove %op.db
    bwrite %op.db -1 $sockbr &buf
    hmake me 20 | hmake op 20
    hload me $2- | hload op %op.db
    hdel me nick | hadd op nick $1
    hadd me turn $iif($hget(op,turn),0,1)
    hdel op turn | _fin.load
    var %col = $hget(op,colour)
    drawtext @Chess $iif(%col == w,0,14) Fixedsys 12 355 20 $1
    _put.lmoves | _echo Let's get it on!
    if (%chess.logging) write -c $_log $iif(%col == w, [ $1 vs. $me ] , [ $me vs. $1 ] )
    sockclose $sockname
    return
  }
  elseif ($bvar(&buf,1-8).text == ^middle^) {
    bread " $+ $scriptdir $+ clsaves\ $+ %chess_load $+ .me.cls" 0 4096 &buf2
    sockwrite $sockname &buf2
    unset %chess_load %chess_mid
    return
  }
  else {
    inc %chess_mid
    .remove $2-
    bwrite $2- -1 $sockbr &buf
    sockwrite $sockname ^middle^
  }
}
on *:SOCKCLOSE:chess.save:_put.lmoves | _echo Go go go!
alias -l _put.lmoves {
  drawtext -n @Chess 12 360 40 $_process.move($hget(op,moveN),$hget(op,lastmove))
  drawtext -n @Chess 12 360 120 $_process.move($hget(me,moveN),$hget(me,lastmove))
  drawdot -h @Chess
}

; $1 = 1 (me), 0 (opponent), $2 = r,n,b,q,k,p, $3 = from, $4 = to
alias _upd.status {
  var %plr = $iif($1,me,op), %y = $iif($1,100,20)
  var %num = $hget(%plr,moveN), %col = $hget(%plr,colour)
  var %nick = $iif($1,$me,$hget(op,nick))
  drawfill -n @Chess 15 1 353 $iif($1,93,13)
  drawtext -n @Chess $iif(%col == w,0,14) Fixedsys 12 355 %y %nick
  inc %y 20
  if (%num) {
    var %m = $hget(%plr,lastmove)
    drawtext -n @Chess 12 360 %y $_process.move(%num,%m)
  }
  inc %num
  hadd %plr moveN %num
  hadd %plr lastmove $2-
  var %lsd = $_process.move(%num,$2-)
  drawtext -n @Chess 12 360 $calc(%y + 15) %lsd
  drawdot -h @Chess
  if (%chess.logging) {
    if (%col == w) write $_log %lsd $+ , $+ $chr(160)
    else write -as $+ %num $+ . $_log $gettok(%lsd,2-,32)
  }
}
; $1 = num, $2 = r,n,b,q,k,p from to [q,r,n,b]
alias -l _process.move {
  var %txt = $1 $+ .
  tokenize 32 $2
  var %2 = $replace($2-3,$chr(32),-)
  if ($1 == p) %txt = %txt %2 $iif($4 isletter qrnb,$upper($4))
  elseif ($1 == k) %txt = %txt $iif(0-0* iswm %2,%2,K [ %2 ] )
  else %txt = %txt $upper($1) %2
  return %txt
}

alias _error _echo $1- | halt
alias _echo {
  .timer.Chess.Echo off
  drawrect -h @Chess 1 1 10 350 480 30
  drawfill @Chess 15 1 13 355
  drawtext @Chess 6 15 355 $1-
  .timer.Chess.Echo -o 1 7 drawfill @Chess 15 1 13 355 $chr(124) drawrect @Chess 15 1 10 350 480 30
}

on *:CLOSE:@:if ($target == @Chess) _chess.onclose
alias -l _chess.onclose {
  .timer.Chess.Echo off
  hfree -w me
hfree -w op
  sockclose chess.*
  unset %chess_*
}
