;#nfo-start
;#script-mainfile: ChanCheck.mrc
;#script-unload: ccUnload
;#script-readme: ChanCheck.txt
;#script-type: 1
;#script-name: ChanCheck
;#script-version: v2.0
;#script-description: Channel scanner.
;#script-homepage: <none>
;#script-author-nick: SirReal
;#script-author-real: <none>
;#script-author-network: #celebpics on Undernet
;#script-author-email: <none>
;#script-author-icq: <none>
;#script-author-homepage: <none>
;#nfo-end
;
; Dialogs
;
dialog CcLoad {
  title " "
  size -1 -1 300 80
  box "Choose which settings to load", 1, 10 10 280 55
  button "From ini file",2, 20 30 80 25
  button "Set defaults",3, 110 30 80 25
  button "None",4, 200 30 80 25, cancel default
}
dialog CcMessageBox {
  title " "
  size -1 -1 200 80
  text "", 1, 10 10 180 40, center
  button "Ok",2, 75 50 50 25, ok default
}
alias ccSettings var %d = $dialog(CcSettings, CcSettings)
dialog CcSettings {
  title "ChanCheck Settings"
  size -1 -1 380 490
  button "&Apply", 1, 102 450 80 25
  button "C&lose", 2, 198 450 80 25
  button "Add", 3, 175 25 50 25
  button "Rem", 4, 235 25 50 25
  button "Add", 5, 10 125 40 25
  button "Rem", 6, 55 125 40 25
  button "Start", 7, 100 125 40 25
  button "Add", 8, 160 125 40 25
  button "Rem", 9, 205 125 40 25
  button "Start", 10, 250 125 40 25
  radio "Include", 11, 15 45 60 20, left group
  radio "Exclude", 12, 15 70 60 20, left
  radio "Include", 13, 100 45 60 20, left
  radio "Exclude", 14, 100 70 60 20, left
  button "&Save to ini", 15, 6 450 80 25
  combo 16, 320 45 40 100, drop size vsbar
  combo 17, 320 105 40 100, drop size vsbar
  combo 18, 175 65 110 120, sort edit drop size vsbar
  combo 19, 20 162 110 100, sort edit drop size vsbar
  combo 20, 170 162 110 100, sort edit drop size vsbar
  combo 21, 315 225 50 100, drop vsbar size
  combo 22, 315 280 50 100, drop vsbar size
  combo 23, 315 330 50 100, drop vsbar size
  combo 24, 25 225 150 100, drop size vsbar
  edit "", 25, 25 280 250 20, center autohs
  edit "", 26, 25 335 250 20, center autohs
  edit "", 27, 225 225 55 20, center autohs
  edit "", 28, 315 170 50 20, center autohs
  check "Warn,Kick and/or Ban from all common channels", 29, 65 415 250 20
  check "Ops" 30, 15 385 60 20
  check "Voices" 31, 65 385 60 20
  check "Regulars" 32, 125 385 65 20
  box "Scan on join", 33, 5 105 140 95
  box "Timed Scan", 34, 155 105 140 95
  box "Ban key", 35, 305 205 70 50
  box "Kick Message (you must specify @cc in it)", 36, 5 260 290 50
  box "Kick key", 37, 305 260 70 50
  box "Warn Message (you must specify @cc in it)", 38, 5 315 290 50
  box "Warn key", 39, 305 315 70 50
  box "Ban Mask", 40, 5 205 190 50
  box "Ban Time", 41, 205 205 90 50
  box "Scan Settings", 42, 5 5 290 95
  box "Scan timer", 43, 305 150 70 50
  box "Colors", 44, 305 5 70 140
  box "Scan who?", 45, 5 370 190 40
  box "SirReal's", 46, 205 370 170 40
  text "Channels", 47, 15 25 50 20, center
  text "Strings", 48, 100 25 50 20, center
  text "Primary", 49, 313 25 50 20, center
  text "Highlight", 50, 313 85 50 20, center
  text "ChanCheck v2.0", 51, 215 387 150 20, center
  button "&Cancel", 52, 294 450 80 25, cancel default
}
;
; Menus
;
menu channel {
  ChanCheck
  .Once:ccSweep #
  .On Join
  ..On:if ($findtok(%ccOnJoin,#,1,32)) ccEcho On join scan in $ccHi(#) already $ccHi(enabled) | else { set %ccOnJoin $addtok(%ccOnJoin,#,32) | set %ccOnJoinList $addtok(%ccOnJoinList,#,32) | ccEcho On join scan in $ccHi(#) is now $ccHi(enabled) }
  ..Off:if ($findtok(%ccOnJoin,#,1,32) == $null) ccEcho On join scan in $ccHi(#) already $ccHi(disabled) | else { set %ccOnJoin $remtok(%ccOnJoin,#,1,32) | ccEcho On join scan in $ccHi(#) is now $ccHi(disabled) }
  .Timed
  ..On:if ($findtok(%ccTimed,#,1,32)) ccEcho Timed scan in $ccHi(#) already $ccHi(enabled) | else { set %ccTimed $addtok(%ccTimed,#,32) | set %ccTimedList $addtok(%ccTimedList,#,32) | .timerCc $+ # 0 %ccTimer ccSweep # | ccEcho Timed scan in $ccHi(#) is now $ccHi(enabled) }
  ..Off:if ($findtok(%ccTimed,#,1,32) == $null) ccEcho Timed scan in $ccHi(#) already $ccHi(disabled) | else { set %ccTimed $remtok(%ccTimed,#,1,32) | .timerCc $+ # off | ccEcho Timed scan in $ccHi(#) is now $ccHi(disabled) }
  .-
  .Settings:ccSettings
  .-
  .Unload
  ..Yes, I'm sure:ccUnload
}
menu menubar,nicklist {
  ChanCheck: {
    if ($menu == menubar) ccSettings
  else { var %l $snick(#) | if (%l) { .enable #ccWhois | set %ccOnce $true | var %i 1 | :loop | var %n $gettok(%l,%i,44) | if (%n) { set %tempCcChan # | set %tempCcNick %n | whois %n } | set %ccOnce $false } } }
}
;
; Events
;
on Bot:join:#:=
on *:join:# { 
  if ($nick == $me) { if ($findtok(%ccTimed,$chan,1,32)) && ($timer( [ Cc [ $+ [ $chan ] ] ] ) == $null) { .timerCc [ $+ [ $chan ] ] 0 %ccTimer ccSweep $chan | ccEcho Timed scan in $ccHi($chan) is now $ccHi(enabled) } | halt }
  if ($findtok(%ccLevelExclude,$level($address($nick,3)),32)) return
  if ($findtok(%ccOnJoin,$chan,1,32)) { .enable #ccWhois | set %tempCcChan $chan | set %tempCcNick $nick | whois $nick }
}
on *:part:# {
  if ($nick == $me) && ($timer([ Cc [ $+ [ $chan ] ] ] ) > 0) { .timerCc $+ $chan off | ccEcho Timed scan in $ccHi($chan) is now $ccHi(disabled) }
}
on 1:start:unset %tempCc*
on 1:connect {
  unset %tempCc*
  var %i 1
  :loop
  var %t $gettok(%ccServiceBots,%tempCc,32)
  if (%t) { .auser Bot %t | inc %i | goto loop }    
}  
on 1:dialog:CcLoad:init:*:if ($exists($scriptdirChanCheck.ini) == $false) did -b $dname 2 | dialog -t $dname $ccVersion
on 1:dialog:CcLoad:sclick:*:if ($did == 2) ccLoadFromIni | elseif ($did == 3) ccSetDefaults | .raw on | .ial on | .timer 1 1 ccSettings | dialog -x $dname
on 1:dialog:CcSettings:init:* {
  did -b $dname 1
  set %tempCcOnJoin %ccOnJoin
  set %tempCcTimed %ccTimed
  set %tempCcOnJoinList %ccOnJoinList
  set %tempCcTimedList %ccTimedList
  set %tempCcIncludeChannel %ccIncludeChannel
  set %tempCcExcludeChannel %ccExcludeChannel
  set %tempCcIncludeString %ccIncludeString
  set %tempCcExcludeString %ccExcludeString
  set %tempCcTimerOn ""
  set %tempCcTimerOff ""
  did -c $dname 24 $calc(%ccBanType + 1)
  did -o $dname 25 1 %ccKickMsg
  did -o $dname 26 1 %ccWarnMsg
  did -o $dname 27 1 %ccBanTime
  did -o $dname 28 1 %ccTimer
  if (%ccCommon) did -c $dname 29
  if (o !isin %ccScanExclude) did -c $dname 30
  if (v !isin %ccScanExclude) did -c $dname 31
  if (r !isin %ccScanExclude) did -c $dname 32
  did -c $dname %ccLastRadio
  var %i 0
  :color
  did -a $dname 16 %i
  did -a $dname 17 %i
  inc %i
  if (%i < 16) goto color
  did -c $dname 16 $calc(%ccPc + 1)
  did -c $dname 17 $calc(%ccHi + 1)
  var %i 1
  var %f 3
  :key
  var %t $gettok(c.s,%f,46) $+ f $+ %i
  did -a $dname 21 %t
  did -a $dname 22 %t
  did -a $dname 23 %t
  if (%i = 12) { var %i 1 | dec %f }
  else inc %i
  if (%f > 0) goto key
  did -c $dname 21 $calc(12 * $finddtok(f.s.c, $left(%ccBan,1)) + $remove($remove($remove(%ccBan,s),f),c))
  did -c $dname 22 $calc(12 * $finddtok(f.s.c, $left(%ccKick,1)) + $remove($remove($remove(%ccKick,s),f),c))
  did -c $dname 23 $calc(12 * $finddtok(f.s.c, $left(%ccWarn,1)) + $remove($remove($remove(%ccWarn,s),f),c))
  ccFillControl $dname 24 %ccBanMasks
  did -c $dname 24 $calc(%ccBanType + 1)
  ccRadioSelected $dname %ccLastRadio
  ccFillControl $dname 19 %ccOnJoinList
  if ($findtok(%ccOnJoin,$did(19,1),1,32)) did -o $dname 7 1 Stop | else did -o $dname 7 1 Start
  ccFillControl $dname 20 %ccTimedList
  if ($findtok(%ccTimed,$did(19,1),1,32)) did -o $dname 10 1 Stop | else did -o $dname 10 1 Start
}
on 1:dialog:CcSettings:edit:*:did -e $dname 1
on 1:dialog:CcSettings:sclick:* {
  if ($did > 32) halt
  elseif ($did > 15) { var %t $did($did,$did($did).sel) | did -e $dname 1 | if ($did == 19) { if (($findtok(%ccOnJoin,%t,1,32)) || ($findtok(%tempCcOnJoin,%t,1,32))) did -o $dname 7 1 Stop | else did -o $dname 7 1 Start } | elseif ($did == 20) { if (($findtok(%ccTimed,%t,1,32)) || ($findtok(%tempCcTimed,%t,1,32))) did -o $dname 10 1 Stop | else did -o $dname 10 1 Start } | halt }
  elseif ($did == 15) ccSaveToIni
  elseif ($did < 3) {
    if ($did(1).enabled == $false) goto $did
    elseif (@cc !isin $did(25)) { ccDialog Error You didn't specify @cc in your kick message | goto error }
    elseif (@cc !isin $did(26)) { ccDialog Error You didn't specify @cc in your warn message | goto error }
    elseif ($did(27) !isnum) { ccDialog Error Please specify a number for the ban time | goto error }
    elseif ($did(28) !isnum) { ccDialog Error Please specify a number for the scan time | goto error }
    else { var %t xovr | if ($did(30).state) var %t $remove(%t,o) | if ($did(31).state) var %t $remove(%t,v) | if ($did(32).state) var %t $remove(%t,r) | if (%t == xovr) { ccDialog Error Please include at least someone to scan | goto error } }
    set %ccScanExclude %t
    set %ccIncludeChannel %tempCcIncludeChannel
    set %ccExcludeChannel %tempCcExcludeChannel
    set %ccIncludeString %tempCcIncludeString
    set %ccExcludeString %tempCcExcludeString
    set %ccOnJoin %tempCcOnJoin
    set %ccTimed %tempCcTimed
    set %ccOnJoinList %tempCcOnJoinList
    set %ccTimedList %tempCcTimedList
    set %ccCommon $iif($did($dname,29).state == 1, $true, $false)
    set %ccPc $did(16)
    set %ccHi $did(17)
    ccFKeys delete
    set %ccBan $did(21)
    set %ccKick $did(22)
    set %ccWarn $did(23)
    ccFKeys save
    set %ccBanType $calc($findtok(%ccBanMasks,$did(24),1,32) - 1)
    set %ccKickMsg $did(25)
    set %ccWarnMsg $did(26)
    set %ccBanTime $did(27)
    set %ccTimer $did(28)
    did -b $dname 1
    var %i $calc($numtok(%tempCcTimerOn,32) + 1)
    :timerOn
    if (%i > 1) { dec %i | var %c $gettok(%tempCcTimerOn,%i,32) | .timerCc $+ %c 0 %ccTimer ccSweep %c | goto timerOn }
    var %i $calc($numtok(%tempCcTimerOff,32) + 1)
    :timerOff
    if (%i > 1) { dec %i | .timerCc $+ $gettok(%tempCcTimerOff,%i,32) off | goto timerOff }
    goto $did
    :1 | halt
    :2 | dialog -x $dname | halt
    :error | did -b $dname 1 | halt
  }
  elseif ($did > 10) {
    set %ccLastRadio $did
    ccRadioSelected $dname $did
  }
  else {
    if ($did > 7) var %t $did(20)
    elseif ($did > 4) var %t $did(19)
    else var %t $did(18)
    if (%t == $null) ccDialog Error Please specify a channel to add/rem or scan
    if ($chr(32) isin %t) ccDialog Error Can't use spaces in this field since channel names don't contain spaces
    var %t $iif($left(%t,1) == $chr(35), %t, [ # [ $+ [ %t ] ] ] )
    goto $did
    :3
    if (($findtok($ccFindTok,%t,0,32) > 0) || (%tempCcRadio == 0)) halt
    goto %ccLastRadio $+ a
    :11a | set %tempCcIncludeChannel $addtok(%tempCcIncludeChannel,%t,32) | goto hell
    :12a | set %tempCcExcludeChannel $addtok(%tempCcExcludeChannel,%t,32) | goto hell
    :13a | set %tempCcIncludeString $addtok(%tempCcIncludeString,$right(%t,-1),32) | goto hell
    :14a | set %tempCcExcludeString $addtok(%tempCcExcludeString,$right(%t,-1),32) | goto hell
    :4
    goto %ccLastRadio $+ r
    :11r | set %tempCcIncludeChannel $remtok(%tempCcIncludeChannel,%t,1,32) | goto hell
    :12r | set %tempCcExcludeChannel $remtok(%tempCcExcludeChannel,%t,1,32) | goto hell
    :13r | set %tempCcIncludeString $remtok(%tempCcIncludeString,$right(%t,-1),1,32) | goto hell
    :14r | set %tempCcExcludeString $remtok(%tempCcExcludeString,$right(%t,-1),1,32) | goto hell
    :hell
    ccRadioSelected $dname %ccLastRadio 
    goto end
    :5
    if ($findtok(%tempCcOnJoinList,%t,1,32) == $null) {
      set %tempCcOnJoinList $addtok(%tempCcOnJoinList,%t,32)
      did -a $dname 19 %t
      did -o $dname 7 1 Start
    }
    goto end
    :6
    if ($findtok(%tempCcOnJoinList,%t,1,32)) {
      set %tempCcOnJoinList $remtok(%tempCcOnJoinList,%t,1,32)
      ccFillControl $dname 19 %tempCcOnJoinList
      var %t $did(19,1)
      if (($findtok(%ccOnJoin,%t,1,32)) || ($findtok(%tempCcOnJoin,%t,1,32))) did -o $dname 7 1 Stop | else did -o $dname 7 1 Start
    }
    goto end
    :7
    if ($findtok(%tempCcOnJoinList,%t,1,32)) {
      if ($did($did) === Start) {
        set %tempCcOnJoin $addtok(%tempCcOnJoin,%t,32)
        ccDialog Message people joining %t will be scanned when changes are saved
        did -o $dname $did 1 Stop
      }
      else {
        set %tempCcOnJoin $remtok(%tempCcOnJoin,%t,1,32)
        ccDialog Message people joining %t won't be scanned when changes are saved
        did -o $dname $did 1 Start
      }
    }
    else { ccDialog Error Please add the channel to the list first before starting to scan on join | halt }
    goto end
    :8
    if ($findtok(%tempCcTimedList,%t,1,32) == $null) {
      set %tempCcTimedList $addtok(%tempCcTimedList,%t,32)
      did -a $dname 20 %t
      did -o $dname 10 1 Start
    }
    goto end
    :9
    if ($findtok(%tempCcTimedList,%t,1,32)) {
      set %tempCcTimedList $remtok(%tempCcTimedList,%t,1,32)
      ccFillControl $dname 20 %tempCcTimedList
      var %t $did(20,1)
      if (($findtok(%ccTimed,%t,1,32)) || ($findtok(%tempCcTimed,%t,1,32))) did -o $dname 10 1 Stop | else did -o $dname 10 1 Start
    }
    goto end
    :10
    if ($findtok(%tempCcTimedList,%t,1,32)) {
      if ($did($did) === Start) {
        set %tempCcTimed $addtok(%tempCcTimed,%t,32)
        set %tempCcTimerOn $addtok(%tempCcTimerOn,%t,32)
        set %tempCcTimerOff $remtok(%tempCcTimerOff,%t,1,32)
        ccDialog Message %t will be scanned every %ccTimer seconds when changes are saved
        did -o $dname $did 1 Stop
      }
      else {
        set %tempCcTimed $remtok(%tempCcTimed,%t,1,32)
        set %tempCcTimerOff $addtok(%tempCcTimerOff,%t,32)
        set %tempCcTimerOn $remtok(%tempCcTimerOn,%t,1,32)
        ccDialog Message Timed scan for %t will be stopped when changes are saved
        did -o $dname $did 1 Start
      }
    }
    else { ccDialog Error Please add the channel to the list first before starting a timed scan | halt }
    :end | did -e $dname 1
  }
}
on 1:load:ccLoad
;
; Aliases
;
alias ccIntro
alias ccLoad { ccintro | unset %tempCc* | var %d $dialog(CcLoad, CcLoad) }
alias ccUnload { ccSaveToIni | unset %tempCc* %cc* | unload -rs ChanCheck.mrc | ccEcho ChanCheck has been unloaded and your settings have been saved to $scriptdirChanCheck.ini }
alias -l ccLoadFromIni {
  set %ccBanMasks $readini $scriptdirChanCheck.ini General BanMasks
  set %ccIncludeString $readini $scriptdirChanCheck.ini General IncludeString
  set %ccExcludeString $readini $scriptdirChanCheck.ini General ExcludeString
  set %ccIncludeChannel $readini $scriptdirChanCheck.ini General IncludeChannel
  set %ccExcludeChannel $readini $scriptdirChanCheck.ini General ExcludeChannel
  set %ccOnJoinList $readini $scriptdirChanCheck.ini General OnJoinList
  set %ccOnJoin $readini $scriptdirChanCheck.ini General OnJoin
  set %ccTimedList $readini $scriptdirChanCheck.ini General TimedList
  set %ccTimed $readini $scriptdirChanCheck.ini General Timed
  set %ccTimer $readini $scriptdirChanCheck.ini General Timer
  set %ccBanTime $readini $scriptdirChanCheck.ini General BanTime
  set %ccBanType $readini $scriptdirChanCheck.ini General BanType
  set %ccWarn $readini $scriptdirChanCheck.ini General Warn
  set %ccKick $readini $scriptdirChanCheck.ini General Kick
  set %ccBan $readini $scriptdirChanCheck.ini General Ban
  set %ccWarnMsg $readini $scriptdirChanCheck.ini General WarnMsg
  set %ccKickMsg $readini $scriptdirChanCheck.ini General KickMsg
  set %ccCommon $readini $scriptdirChanCheck.ini General Common
  set %ccServiceBots $readini $scriptdirChanCheck.ini General ServiceBots
  set %ccScanExclude $readini $scriptdirChanCheck.ini General ScanExclude
  set %ccSweep $readini $scriptdirChanCheck.ini General Sweep
  set %ccOnce $readini $scriptdirChanCheck.ini General Once
  set %ccPc $readini $scriptdirChanCheck.ini General Pc
  set %ccHi $readini $scriptdirChanCheck.ini General Hi
  ccFKeys save
}
alias -l ccSaveToIni {
  if (%ccBanMasks) writeini $scriptdirChanCheck.ini General BanMasks %ccBanMasks
  if (%ccIncludeString) writeini $scriptdirChanCheck.ini General IncludeString %ccIncludeString
  if (%ccExcludeString) writeini $scriptdirChanCheck.ini General ExcludeString %ccExcludeString
  if (%ccIncludeChannel) writeini $scriptdirChanCheck.ini General IncludeChannel %ccIncludeChannel
  if (%ccExcludeChannel) writeini $scriptdirChanCheck.ini General ExcludeChannel %ccExcludeChannel
  if (%ccScanOnJoin) writeini $scriptdirChanCheck.ini General ScanOnJoin %ccScanOnJoin
  if (%ccTimedScan) writeini $scriptdirChanCheck.ini General TimedScan %ccTimedScan
  if (%ccTimer) writeini $scriptdirChanCheck.ini General Timer %ccTimer
  if (%ccBanTime) writeini $scriptdirChanCheck.ini General BanTime %ccBanTime
  if (%ccBanType) writeini $scriptdirChanCheck.ini General BanType %ccBanType
  if (%ccWarn) writeini $scriptdirChanCheck.ini General Warn %ccWarn
  if (%ccKick) writeini $scriptdirChanCheck.ini General Kick %ccKick
  if (%ccBan) writeini $scriptdirChanCheck.ini General Ban %ccBan
  if (%ccWarnMsg) writeini $scriptdirChanCheck.ini General WarnMsg %ccWarnMsg
  if (%ccKickMsg) writeini $scriptdirChanCheck.ini General KickMsg %ccKickMsg
  if (%ccCommon) writeini $scriptdirChanCheck.ini General Common %ccCommon
  if (%ccServiceBots) writeini $scriptdirChanCheck.ini General ServiceBots %ccServiceBots
  if (%ccScanExclude) writeini $scriptdirChanCheck.ini General ScanExclude %ccScanExclude
  if (%ccSweep) writeini $scriptdirChanCheck.ini General Sweep %ccSweep
  if (%ccOnce) writeini $scriptdirChanCheck.ini General Once %ccOnce
  if (%ccChannelListJoin) writeini $scriptdirChanCheck.ini General ChannelListJoin %ccChannelListJoin
  if (%ccChannelListTimed) writeini $scriptdirChanCheck.ini General ChannelListTimed %ccChannelListTimed
  if (%ccPc) writeini $scriptdirChanCheck.ini General Pc %ccPc
  if (%ccHi) writeini $scriptdirChanCheck.ini General Hi %ccHi
  ccDialog Message Your settings have been saved to $scriptdirChanCheck.ini
  halt
}
alias -l ccSetDefaults {
  set %ccBanMasks *!user@host.domain *!*user@host.domain *!*@host.domain *!*user@*.domain *!*@*.domain nick!user@host.domain nick!*user@host.domain nick!*@host.domain nick!*user@*.domain nick!*@*.domain
  set %ccLastRadio 13
  set %ccIncludeString kid young teen boy girl daughter dad mom incest horse dog animal rape forbid family humil allsex baby highschool
  set %ccExcludeString College playboy
  set %ccIncludeChannel ""
  set %ccExcludeChannel ""
  set %ccTimer 300
  set %ccBanTime 300
  set %ccBanType 3
  set %ccWarn f5
  set %ccKick f6
  set %ccBan f7
  ccFKeys default
  set %ccWarnMsg Please leave @cc or leave here...
  set %ccKickMsg Being on @cc earned you the boot...
  set %ccServiceBots X!cservice@undernet.org,W!cservice@undernet.org
  set %ccScanExclude o
  set %ccSweep $false
  set %ccOnce $false
  set %ccCommon $false
  set %ccOnJoin ""
  set %ccTimed ""
  set %ccOnJoinList ""
  set %ccTimedList ""
  set %ccPc 1
  set %ccHi 4
}
alias -l ccFKeys {
  ; todo: check for existing aliases
  goto $1
  :default
  alias aliases.ini f5 ccAct msg
  alias aliases.ini f6 ccAct kick
  alias aliases.ini f7 ccAct ban
  return
  :save
  alias aliases.ini %ccWarn ccAct msg
  alias aliases.ini %ccKick ccAct kick
  alias aliases.ini %ccBan ccAct ban
  return
  :delete
  alias aliases.ini %ccWarn
  alias aliases.ini %ccKick
  alias aliases.ini %ccBan
}
alias ccSettings var %d $dialog(CcSettings, CcSettings)
alias ccDialog {
  dialog -makv $1 CcMessageBox
  dialog -t $1 $1 
  did -o $1 1 1 $2-
  if ($1 === Error) halt
}
alias ccEcho echo %ccPc -a $ccHi(***) $1-
alias ccHi return  $+ $calc(%ccHi + 32) $+ $1- $+  $+ $calc(%ccPc + 32)
alias -l ccFindTok {
  goto %ccLastRadio
  :11 | return %tempCcIncludeChannel
  :12 | return %tempCcExcludeChannel
  :13 | return %tempCcIncludeString
  :14 | return %tempCcExcludeString
  :0
}
alias -l ccFillControl {
  did -r $1 $2
  var %i 1
  :loop
  var %t $gettok($3-, %i, 32)
  if (%t == $null) { did -c $1 $2 1 | return }
  did -a $1 $2 %t
  inc %i
  goto loop
}
alias -l ccRadioSelected {
  goto $2
  :11 | ccFillControl $1 18 %tempCcIncludeChannel | return
  :12 | ccFillControl $1 18 %tempCcExcludeChannel | return
  :13 | ccFillControl $1 18 %tempCcIncludeString | return
  :14 | ccFillControl $1 18 %tempCcExcludeString | return
  :0
}
alias ccAct {
  if (%tempCcActNick == $null) { ccEcho I don't have enough $ccHi(info) to $ccHi($replace($1,msg,warn)) | halt }
  elseif (%tempCcActNick !ison %tempCcActChan) { ccEcho I can't $replace($1,msg,warn) $ccHi(%tempCcActNick) (not on $ccHi(%tempCcActChan) $+ ) | goto end }
  var %i 0
  :next
  inc %i
  var %c $iif(%ccCommon,$comchan(%tempCcActNick,%i),$gettok(%tempCcActChan,%i,32))
  if (%c == $null) goto end
  if ($me !isop %c) goto next
  var %a $1
  goto %a
  :ban
  if (%ccBotBan) %a -u $+ %ccBanTime %c %tempCcActNick %ccBanType
  else %a -u $+ %ccBanTime %c %tempCcActNick %ccBanType
  var %a kick
  :kick
  %a %c %tempCcActNick %tempCcActKickMsg | goto next
  :msg
  %a %c %tempCcActNick $+ : %tempCcActWarnMsg | goto next
  :end
  unset %tempCcAct*
}
alias ccSweep {
  set %tempCcChan $1
  if ($2 == next) goto next
  if ($me !ison $1) { if ($timer( [ Cc [ $+ [ $1 ] ] ] ) > 0) { .timerCc [ $+ [ $1 ] ] off | ccEcho Stopped the timedchannel scan in $ccHi($1) since you're not on it anymore } | else ccEcho You need to actually be on $ccHi($1) before doing a timed scan | halt }
  set %ccSweep $true
  ccSweepCount $1 1
  :next
  set %tempCcNick $nick($1,$ccSweepCount($1),a, %ccScanExclude)
  if (%tempCcNick == $null) { ccEcho Channel sweep of $ccHi($1) complete | set %ccSweep $false | halt }
  if (%tempCcNick == $me) || ($level($address(%tempCcNick,5)) == Bot) { inc %tempCcSweep | goto next }
  .enable #ccWhois
  whois %tempCcNick
}
alias ccSweepCount set %tempCc $+ $1 $iif(($2),$2,$calc( [ %tempCc  [ $+ [ $1 ] ] ] + 1)) | return [ %tempCc [ $+ [ $1 ] ] ]
alias ccVersion return ChanCheck v2.0
;
; Raw
;
raw 319:* {
  ; I'm using intermittent variables named %k1...4 and %h1...4, because I had some weird result when doing channel sweeps
  ; Until I figure out what has been causing that, this sloppy code will remain ;-)
  ; My first guess was that the supposed lifespan of the newly introduced temporary var is beyond the scope of the executing script
  ; although I have no means to truely verify that. If anyone knows the answer, please mail me at sirreal7@hotmail.com
  if (%tempCcNick != $2) && (%ccOnce != $true) && (%ccSweep != $true) return
  var %k1 = %tempCcNick, %h1 = %tempCcChan, %c = $3-, %i = $numtok(%c,32), %f
  :nomode
  if (%i > 0) { var %t $gettok(%c,%i,32) | if (($left(%t,1) == @) || ($left(%t,1) == +)) var %c $puttok(%c,$right(%t,-1),%i,32) | dec %i | goto nomode }
  var %i $numtok(%ccExcludeChannel,32)
  :excludeChan
  if (%i > 0) { var %c $remtok(%c,$remtok(%ccExcludeChannel,%i,32),1,32) | dec %i | goto excludeChan }
  var %i $numtok(%ccIncludeChannel,32)
  var %k2 = %k1, %h2 = %h1
  :includeChan
  if (%i > 0) { set %f %f $matchtok(%c,$gettok(%ccIncludeChannel,%i,32),1,32) | dec %i | goto includeChan }
  var %i $numtok(%ccIncludeString,32)
  var %k3 = %k2, %h3 = %h2
  :includeString
  if (%i > 0) { var %n $gettok(%ccIncludeString,%i,32) | var %t $matchtok(%c,%n,0,32) | :addString | if (%t > 0) { set %f $addtok(%f,$matchtok(%c,%n,%t,32),32) | dec %t | goto addString } | dec %i | goto includeString }
  if (%f == $null) return
  var %i $numtok(%ccExcludeString,32)
  var %k4 = %k3, %h4 = %h3
  :excludeString
  if (%i > 0) { var %x $gettok(%ccExcludeString,%i,32) | var %t $matchtok(%c,%x,0,32) | :remString | if (%t > 0) { set %f $remtok(%f,$matchtok(%c,%x,%t,32),1,32) | dec %t | goto remString } | dec %i | goto excludeString }
  if (%f == $null) return
  set %tempCcActNick %k4
  set %tempCcActChan %h4
  set %tempCcActWarnMsg  $+ $calc(%ccPc + 32) $+ $replace(%ccWarnMsg, @cc, $ccHi(%f))
  set %tempCcActKickMsg  $+ $calc(%ccPc + 32) $+ $replace(%ccKickMsg, @cc, $ccHi(%f))
  set %tempCcAllChan $true
  ccEcho %tempCcActNick is on $ccHi(%f) --- $ccHi(%ccWarn)  WARN - $ccHi(%ccKick) KICK - $ccHi(%ccBan) BAN
}
#ccWhois off
raw 301:*:halt
raw 311:*:halt
raw 312:*:halt
raw 313:*:halt
raw 317:*:halt
raw 318:* {
  .disable #ccWhois
  if (%ccSweep) ccSweep %tempCcChan next
  else { unset %tempCcChan | unset %tempCcNick }
  halt
}
#ccWhois end
