### annoyblocker.mrc - Annoying message blocker for mIRC 5.8+
### If you recieved this file without it's ZIP file, DO NOT USE and email kewlkow@hotmail.com.
### File starts now.

on *:text:* #*:?:adblock
on *:text:#*:?:adblock
on *:text:* #:?:adblock
on *:notice:* #*:?:adblock
on *:notice:#*:?:adblock
on *:notice:* #:?:adblock

on *:text:*a/s/l*:?:statsblock
on *:text:a/s/l*:?:statsblock
on *:text:*a/s/l:?:statsblock

on *:text:asl:?:statsblock
on *:text:asl*:?:statsblock

on *:text:stats*:?:statsblock
on *:text:*stats:?:statsblock



alias adblock {
  if (%ad.power == 0) { halt }
  if (ad isin $level($address($nick,3))) { halt }
  .ignore -pniu $+ %ad.sec $nick 3
  if (%ad.msg != "") { .msg $nick %ad.msg }
  closemsg $nick
  echo $colour(info2) %ad.disp $timestamp *** Placed  $+ $nick $+  on ignore for %ad.sec seconds (unwanted messages).
}

alias statsblock {
  if (%sb.power == 0) { halt }
  if (ad isin $level($address($nick,3))) { halt }
  .ignore -pniu $+ %ad.sec $nick 3
  if (%sb.msg != "") { .msg $nick %sb.msg }
  closemsg $nick
  echo $colour(info2) %ad.disp $timestamp *** Placed  $+ $nick $+  on ignore for %ad.sec seconds (unwanted messages).
}


menu nicklist {
  -
  AnnoyBlocker[ $+ $iif(ad isin $level($address($1,3)), allowed, blocked) $+ ] {
    if (ad isin $level($address($1,3))) { 
      .ruser ad $address($1,3) 
      echo $colour(info2) %ad.disp $timestamp *** Removed  $+ $1 $+  from AnnoyBlocker privileged list. 
      if (%ad.pmsg == 1) { .msg $1 You've been removed from the AnnoyBlocker privileged list. }
      halt 
    }
    else { 
      .auser ad $address($1,3) 
      echo $colour(info2) %ad.disp $timestamp *** Added  $+ $1 $+  to AnnoyBlocker privileged list. 
      if (%ad.pmsg == 1) { .msg $1 You've been added to the AnnoyBlocker privileged list. }
    }
  }
}

menu status,channel {
  -
  AnnoyBlocker (ads)[ $+ $iif((%ad.power == 0), off, on) $+ ] {
    if (%ad.power == 0) { unset %ad.power | echo $colour(info) %ad.disp $timestamp *** AnnoyBlocker (ads) is now active. | halt }
    else { set %ad.power 0 | echo $colour(info) %ad.disp $timestamp *** AnnoyBlocker (ads) is now inactive. | halt }
  }
  AnnoyBlocker (stats)[ $+ $iif((%sb.power == 0), off, on) $+ ] {
    if (%sb.power == 0) { unset %sb.power | echo $colour(info) %ad.disp $timestamp *** AnnoyBlocker (stats) is now active. | halt }
    else { set %sb.power 0 | echo $colour(info) %ad.disp $timestamp *** AnnoyBlocker (stats) is now inactive. | halt }
  }
  AnnoyBlocker Setup:/dialog -m ignore-control ignore-control
}

dialog ignore-control {
  title "AnnoyBlocker Setup"
  option dbu
  size -1 -1 255 107
  button "Save Options", 1, 30 90 38 12, ok
  button "Cancel", 99, 182 90 38 12, cancel


  text "Msg to send (ads):", 2, 5 5 50 10, left
  edit %ad.msg, 3, 85 5 150 12, left, autohs limit 160

  text "Msg to send (stats):", 25, 5 17 50 10, left
  edit %sb.msg, 26, 85 17 150 12, left, autohs limit 160

  text "Time to ignore:" 20, 5 29 50 10, left
  edit %ad.sec $+ s, 30, 85 29 20 12

  text "Display messages:" 80, 5 43 50 10, left
  radio "In status:", 81, 85 43 30 10, left
  radio "In active:", 82, 125 43 30 10, left

  text "Misc. Options:" 40, 5 55 50 10, left
  check "Send msg to users when added/removed from privileged list?" 41, 85 55 150 10

  text "Note: Your messages must not exceed 160 characters. Express time in terms of seconds/minutes (30s = 30 secs, 30m = 30 mins)", 50, 5 70 225 20, center
}

on *:dialog:ignore-control:sclick:1:{
  %ad.msg = $did(ignore-control,3)
  %sb.msg = $did(ignore-control,26)
  if ($right($did(ignore-control,30),1) == s) %ad.sec = $left($did(ignore-control,30),$calc($len($did(ignore-control,30)) - 1))
  if ($right($did(ignore-control,30),1) == m) %ad.sec = $calc($left($did(ignore-control,30),$calc($len($did(ignore-control,30)) - 1)) * 60)
  if ($did(ignore-control,81).state == 1) { set %ad.disp -s }
  if ($did(ignore-control,82).state == 1) { set %ad.disp -a }
  if ($did(ignore-control,41).state == 1) { set %ad.pmsg 1 } 
  else { unset %ad.pmsg }
}

on *:load {
  if ($version < 5.8) { echo -s Sorry! AnnoyBlocker is written for mIRC 5.8+. You're using version $version $+ . You can upgrade your client at http://www.mirc.com. | halt }
  set %ad.msg
  set %ad.sec
  set %ad.power 0
  .ial on
  dialog -m ignore-control ignore-control
  echo $colour(info) $timestamp AnnoyBlocker is now installed. If you haven't already, Please read the readme.txt that came in the .ZIP to learn how to use this script to it's full potentional (and to avoid losing messages you may want!)
}
