;
;    Acronyms by Danaria aka LadyDana (dany@mindless.com)
;           DALnet (irc.dal.net 7000) - #HelpDesk, #mIRC
;

menu channel,menubar {
  Acronyms On: /enable #acronyms
  Acronyms Off: /disable #acronyms
  View Acronyms: /acroview
}
; Defines the popups for the Menubar and the Channel

menu @Acronyms {
  dclick: if $calc($lines(acronyms.txt) + 5) == $sline(@Acronyms,1).ln { acroadd } | elseif ($sline(@Acronyms,1).ln == 2) { run charmap.exe } | else { acrochange $sline(@Acronyms,1) }
}
; Defines the commands to execute if you double click a line in the window
; called @Acronyms

On 1:START: {
  if (%acro.nocolor == $null) { .set %acro.nocolor #dalnethelp #irchelp #windows95 }
}
; When mIRC first starts, it will check if variable %acro.nocolor exists or not
; If it doesn't then the script will define the above mentioned variable

#acronyms on
; Defines the start of the group "#acronyms"

On 1:INPUT:#: .acroinput $1-
On 1:INPUT:?: .acroinput $1-
; Whenever you enter text into a channel or query window, the script will start the alias called ACROINPUT

alias -l acroinput {
  set %acro.commandchar $readini mirc.ini text commandchar
  if (%acro.commandchar == $left($1-,1)) { goto end }
  ; if the first character is the one you use to start your commands with
  ; then the script will go to the end
  set %acro.i 0
  :checking
  inc %acro.i
  set %acro.current $read -l $+ %acro.i acronyms.txt
  if (%acro.current == $null) { 
    unset %acro.i 
    unset %acro.current
    goto end
  }
  ; traditional loop (for help, go to http://www.helpdesk.mircx.com/scripting.html)
  ; used to check if I've gotten to the last line in acronyms.txt or not
  if ($gettok(%acro.current,1,32) == $1-) {
    if ((dal.net isin $server) && ($chan isin %acro.nocolor)) { say $strip($gettok(%acro.current,2-,32))  }
    else { say $gettok(%acro.current,2-,32) }    
    ; If you are currently on a dalnet server and in a channel that doesn't allow colours,
    ; then the script will strip all control codes from your acronym definition, otherwise,
    ; it will just use the specified acronym definition   
    goto done
  }
  else { goto checking }
  :done {
    unset %acro.i
    unset %acro.current
    halt
  }
  :end
}
#acronyms end

alias -l acroview {
  if ($window(@Acronyms).x != $null) { /window -c @Acronyms }
  ; If the window @Acronyms already exists, then it will close the window
  window -l @Acronyms 20 20 350 400
  ; Creates the window called Acronyms at the specified coordinates
  aline @Acronyms (Double click to modify)
  aline @Acronyms Run Char Map (For ASCII characters)
  aline @Acronyms --
  set %acro.i 0
  :loop
  inc %acro.i
  if (%acro.i > $lines(acronyms.txt)) { goto end }
  aline @Acronyms $read -l $+ %acro.i acronyms.txt
  goto loop
  :end
  unset %acro.i
  ; This loop servs to copy acronyms.txt into the custom window (line by line)
  aline @Acronyms --
  aline @Acronyms Add another Acronym
}
alias -l acroadd {
  if ($window(@AcroAddition).x != $null) { /window -c @AcroAddition }
  window -e @AcroAddition 70 20 350 200
  echo -i2 @AcroAddition Please input the Acronym to add (include the definition)
}
alias -l acrochange {
  if ($window(@AcroModify).x != $null) { /window -c @AcroModify }
  window -e @AcroModify 70 20 350 200
  aline @AcroModify -- $1- --
  echo -i2 @AcroModify What do you want to change $chr(91) $+ $gettok($1-,2-,32) $+ $chr(93) into?
}

On 1:INPUT:@AcroModify:{
  ; whenever you input text into the window called @AcroModify, this script will react
  set %acro.first $gettok($sline(@Acronyms,1),1,32)
  write -ls $+ %acro.first acronyms.txt $gettok($sline(@Acronyms,1),1,32) $1-
  ; searches acronyms.txt for a line beginning with the acronym and then replaces the definition
  window -c @AcroModify
  ; closes the window
  acroview
  halt
}
On 1:INPUT:@AcroAddition:{
  if ($count($1-,$chr(32)) < 1) { .echo -i2 @AcroAddition 4Error! The acronym and its definition have to be separated by spaces! | goto end }
; checks if there are any spaces in the text that was input in the custom window called @AcroAddition
  write acronyms.txt $1-
  ; writes the new acronym and its definition into the acronyms.txt file
  window -c @AcroAddition
  acroview
  :end
  halt
}
