; Aardvark UUdecode 1.0
; by SoapForge
;
: * Documentation (cough)
: 
; This script provides the identifier /uudecode, used to 
; convert a uuencoded file to it's binary counterpart. 
;
; Aardvark UUdecode is excellent for use in newsreader
; scripts, inline mail file transfers, salads and cakes.
;
; Feel free to include this with your own script and mess
; with it.
;
; * Usage
;
; /UUdecode uuencodedfile.ext newfile.ext [-silent]
;
; The -silent switch stops the script from displaying that
; horrible decoding status window.
;
; * Notes
;
; The input file needs to be complete, as well
; as FREE OF UUENCODE TAGS AND UNRELATED
; TEXT. The decoding routine will just blindly decode
; 'em, too, resulting in a corrupted file.
;
; Since this task is so processor intensive in mirc script,
; I've used a timer to background the script and allow 
; other events to execute.
;
; There's no error checking. It was slowing 
; the script down.
;
; I inhaled.

alias uudecode {
  if ($$2 == $null) { halt }
  if ($1 == $2) { halt }
  unset %uudecode.*
  if ($1 == -callself) {
    set %uudecode.file1 $$2
    set %uudecode.file2 $$3
    set %uudecode.lines $$4
    set %uudecode.current $$5
    set %uudecode.silentflag $$6
  }
  else {
    if ($exists($2) == $true) { .remove $2 }
    if ($exists($1) == $false) { halt }
    set %uudecode.lines $lines($$1)
    set %uudecode.file1 $$1
    set %uudecode.file2 $$2
    set %uudecode.current 1
    if ($3 == -silent) {
      set %uudecode.silentflag true
    }
    else {
      set %uudecode.silentflag false
    }
  }
  if (%uudecode.current > %uudecode.lines) { unset %uudecode.* | return }
  if (%uudecode.silentflag != true) { uudecode.statewindow %uudecode.current %uudecode.lines }
  set %uudecode.read $read -nl $+ %uudecode.current %uudecode.file1
  set %uudecode.lenread $len(%uudecode.read)
  set %uudecode.pos 2
  :readloop
  if ($calc(%uudecode.pos + 3) > %uudecode.lenread) { 
    inc %uudecode.current 1
    .timer 1 0 uudecode -callself %uudecode.file1 %uudecode.file2 %uudecode.lines %uudecode.current %uudecode.silentflag
    unset %uudecode.*
    return
  }
  set %uudecode.block $uudecode.block($mid(%uudecode.read,%uudecode.pos,4))
  bset &write 1 $gettok(%uudecode.block,1,32))
  bset &write 2 $gettok(%uudecode.block,2,32))
  bset &write 3 $gettok(%uudecode.block,3,32))
  bwrite %uudecode.file2 -1 3 &write
  inc %uudecode.pos 4
  goto readloop
}
alias -l uudecode.statewindow {
  if ($window(@uudecode).state == $null) {
    window -phkd @UUdecode $calc($calc($window(-1).w / 2) - 150)  $calc($calc($window(-1).h / 2) - 50) 300 100
  }
  set %uudecode.percent $round($calc($calc($$1 / $$2) * 100),2)
  if ($len($gettok(%uudecode.percent,1,46)) < 2) {
    set %uudecode.percent $chr(48) $+ %uudecode.percent
  }
  if (%uudecode.percent != 100.00) {
    drawrect -fnr @uudecode $rgb(face) 1 0 0 300 100
    drawtext -onr @uudecode $rgb(text) Arial 17 150 40 percent complete   
    drawtext -onr @uudecode $rgb(text) Arial 54 10 11 %uudecode.percent
    drawline @uudecode
  } 
  else {
    close -@ @uudecode
  }
}

alias -l uudecode.block {
  unset %uudecode.block.*
  set %uudecode.inpt1 $uudecode.block.downchar($asc($mid($1,1,1)))
  set %uudecode.inpt2 $uudecode.block.downchar($asc($mid($1,2,1)))
  set %uudecode.inpt3 $uudecode.block.downchar($asc($mid($1,3,1)))
  set %uudecode.inpt4 $uudecode.block.downchar($asc($mid($1,4,1)))
  set %uudecode.block.string $uudecode.byte2bin(%uudecode.inpt1) $+ $uudecode.byte2bin(%uudecode.inpt2) $+ $uudecode.byte2bin(%uudecode.inpt3) $+ $uudecode.byte2bin(%uudecode.inpt4)
  set %uudecode.block.strip $uudecode.block.strip(%uudecode.block.string)
  set -u0 %return $uudecode.bin2byte($mid(%uudecode.block.strip,1,8)) $uudecode.bin2byte($mid(%uudecode.block.strip,9,8)) $uudecode.bin2byte($mid(%uudecode.block.strip,17,8))
  unset %uudecode.block.*
  return %return
} 

alias -l uudecode.block.strip {
  return $mid($1-,3,6) $+ $mid($1-,11,6) $+ $mid($1-,19,6) $+ $mid($1-,27,6)
}

alias -l uudecode.block.downchar { if ($1 == 96) { return 0 } | else { return $calc($1 - 32) } }

alias -l uudecode.byte2bin {
  set -u0 %return 0
  set -u0 %tmp $$1
  if (%tmp > 127) { set %return 1 | dec %tmp 128 } | else { set %return 0 }
  if (%tmp > 63) { set %return %return $+ 1 | dec %tmp 64 } | else { set %return %return $+ 0 }
  if (%tmp > 31) { set %return %return $+ 1 | dec %tmp 32 } | else { set %return %return $+ 0 }
  if (%tmp > 15) { set %return %return $+ 1 | dec %tmp 16 } | else { set %return %return $+ 0 }
  if (%tmp > 7) { set %return %return $+ 1 | dec %tmp 8 } | else { set %return %return $+ 0 }
  if (%tmp > 3) { set %return %return $+ 1 | dec %tmp 4 } | else { set %return %return $+ 0 }
  if (%tmp > 1) { set %return %return $+ 1 | dec %tmp 2 } | else { set %return %return $+ 0 }
  if (%tmp > 0) { set %return %return $+ 1 } | else { set %return %return $+ 0 }
  return %return
}

alias -l uudecode.bin2byte {
  set -u0 %return 0
  if ($mid($1,1,1) == 1) { inc %return 128 }
  if ($mid($1,2,1) == 1) { inc %return 64 }
  if ($mid($1,3,1) == 1) { inc %return 32 }
  if ($mid($1,4,1) == 1) { inc %return 16 }
  if ($mid($1,5,1) == 1) { inc %return 8 }
  if ($mid($1,6,1) == 1) { inc %return 4 }
  if ($mid($1,7,1) == 1) { inc %return 2 }
  if ($mid($1,8,1) == 1) { inc %return 1 }
  return %return
}
