;-----------------------------------------------------------------------------
;  mIRC MUD/Telnet Client Script, release 2
;
;  Copyright (c) 2000 Kimmo Kulovesi
;                     http://arkku.n3.net/
;                     arkhan@softhome.net
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
;
;        Release 2 of the script fixes a bug with triggers.
;        It also changes the syntax used so that it works on mIRC 5.8
;        which no longer accepted the old syntax, breaking the script entirely.
;
;-----------------------------------------------------------------------------

on 1:load: {
  load -rv atelnet.cfg

  if ($colour(background) == 0 || $colour(background) == 15) {
    _tn1colsetw
  }
  else {
    _tn2colsetb
  }

  echo $colour(action) -s ***
  echo $colour(action) -s *** The mIRC MUD/Telnet Client is now installed.
  echo $colour(action) -s ***
  echo $colour(action) -s *** Usage: /telnet <address> [port]
  echo $colour(action) -s *** Once connected via telnet, type "/help" in that window.
  echo $colour(action) -s *** You can use "/telnet nowhere" to open a telnet window
  echo $colour(action) -s *** without connecting.
  echo $colour(action) -s ***
  echo $colour(action) -s *** Read the manual, too - you _will_ want to know how to
  echo $colour(action) -s *** configure the telnet colors. ;>
  echo $colour(action) -s ***

  set %_tndescfle atelnet.ini
  %_calcans = 0
}

menu status {
    &Telnet...: .telnet $$?="server:port or 'nowhere' for empty window"
}

;-----------------------------------------------------------------------------
; The command to start it all:
;-----------------------------------------------------------------------------

alias telnet {
  set %_atelnini " $+ $nofile($mircexe) $+ atelnet.ini"

  if ($1 == $null) {
    echo $colour(notice) -ta *** telnet: Usage: /telnet <address> [port]
    halt
  }

  if (%_tncfg.useansi == $null || %tncolor.plain == $null) {
    load -rv atelnet.cfg
  }

  var %_tnhname = $1
  var %_tnport = $2

  if ($2 == $null) {
    if ($1 == nowhere) {
        %_tnport = 42
    }
    else {
      if ($gettok($1,2,58) != $null) {
          %_tnport = $gettok($1,2,58)
          %_tnhname = $replace($1,$gettok($1,2,58),$chr(0))
          %_tnhname = $replace(%_tnhname,:,$chr(0))
      }
      else {
          %_tnport = 23
      }
    }
  }

  echo $colour(notice) -ta *** telnet: Connecting to %_tnhname $+ : $+ %_tnport $+ ... $+

  var %_tnnumc = 1

  if ($3 != $null) {
    %_tnnumc = $gettok($3,1,94)
    if ($left(%_tnnumc,1) == $chr(63) && $mid(%_tnnumc,2,1) != $chr(94)) {
      %_tnnumc = x
;HEREDEBUG
    }

    %_tnnumc = $gettok($3,2,94)
    if (%_tnnumc == $null) {
      %_tnnumc = 1
    }
  }

  var %_tnsockname = x
  %_tnhname = $replacecs(%_tnhname,$chr(58),$chr(59))

  :tntryname

  if (%_tnnumc == 1) {
    %_tnsockname = Telnet $+ $chr(160) $+ ( $+ %_tnhname $+ : $+ %_tnport $+ )
  }
  else {
    %_tnsockname = Telnet $+ $chr(160) $+ %_tnnumc $+ $chr(160) $+ ( $+ %_tnhname $+ : $+ %_tnport $+ )
  }

  if ($sock(%_tnsockname).name == $null) {
    sockopen %_tnsockname $replacecs(%_tnhname,$chr(59),$chr(58)) %_tnport
  }
  else {
    inc %_tnnumc
    goto tntryname
  }
  unset %_tnhname
  unset %_tnport
  unset %_tnnumc
  unset %_tnsockname
}

;-----------------------------------------------------------------------------
; When data is sent by user:
;-----------------------------------------------------------------------------

alias _atnssnd {
  if ($1 == $null || $2 == $null) {
    echo $colour(notice) -ta *** Usage: /_atnssnd <sockname> <commands>
    halt
  }

  if ($window(@__TN_ALIASES_).title == $null) {
    __xxtnaliasfill
  }

  var %_tnparse.num = 2
  var %_tnparse.txt = 1
  var %_tnparse.cmd = $chr(95) $+ $chr(92) $+ $2- $+ $chr(92)
  var %_tnparse.fst = x
  var %_xpndnum = 2
  var %_xpndta = x
  var %_xpnrda = x

  :tnoutp

  %_tnparse.txt = $gettok(%_tnparse.cmd,%_tnparse.num,92)

  if (%_tnparse.txt == $null) {
    unset %_xpndta
    unset %_xpndnum
    unset %_tnparse.fst
    unset %_tnparse.txt
    unset %_tnparse.num
    unset %_tnparse.cmd
    halt
  }

  %_tnparse.fst = $gettok(%_tnparse.txt,1,32)
  %_xpndnum = 2
  :xpprepeat

  %_xpndta = $line(@__TN_ALIASES_,%_xpndnum,0)
  if (%_xpndta != $null) {
    inc %_xpndnum
    if (%_tnparse.fst == %_xpndta) {
      %_xpndta = $chr(92) $+ %_tnparse.fst
      %_xpnrda = $line(@__TN_ALIASES_,%_xpndnum,0)
      if ($left(%_xpnrda,1) == $chr(92)) {

        %_xpnrda = $right(%_xpnrda,$calc($len(%_xpnrda) - 1))

        var %_xxxrrr = $chr(92) $+ %_tnparse.txt
        %_xxxrrr = $replace(%_xxxrrr,%_xpndta,$chr(92))
        %_xpnrda = %_xpnrda $+ $right(%_xxxrrr,$calc($len(%_xxxrrr) - 1))

        sockwrite -tn $1 %_xpnrda

        if ($sockerr > 0) {
          echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock($1).ip $+ ).
          halt
        }

        if ($left($sock($1).mark,1) == 1) {
          if ($mid(%_xpnrda,2,1) != $null) {
            echo %tncolor.own @ $+ $1 > %_xpnrda
          }
          if ($mid($sock($1).mark,4,1) == $chr(38)) {
            write -i $gettok($sock($1).mark,2,38) > %_xpnrda
          }
        }
        unset %_xxxrrr
        %_xpnrda = $chr(92)
      }
      else {
        %_xpnrda = $chr(92) $+ %_xpnrda
        if ($count(%_xpnrda,%_xpndta) >= 1) {
          echo $colour(action) -a *** ERROR: ALIAS " $+ %_tnparse.fst $+ " IS RECURSIVE.
          halt
        }
      }
      %_xpndta = $len(%_tnparse.fst)
      %_tnparse.fst = %_xpnrda $+ $right(%_tnparse.txt,$calc($len(%_tnparse.txt) - %_xpndta)) $+ $chr(92)
      %_tnparse.txt = $chr(92) $+ %_tnparse.txt $+ $chr(92)
      %_tnparse.cmd = $replace(%_tnparse.cmd,%_tnparse.txt,%_tnparse.fst)
      goto tnoutp
    }
    else {
      inc %_xpndnum
      goto xpprepeat
    }
  }
  sockwrite -tn $1 %_tnparse.txt

  if ($sockerr > 0) {
    echo $colour(notice) -bfta *** telnet: Cannot send to $sock($1).name ( $+ $sock($1).ip $+ ).
    halt
  }
  if ($left($sock($1).mark,1) == 1) {
    if ($mid($sock($1).mark,4,1) == $chr(38)) {
      write -i $gettok($sock($1).mark,2,38) > %_tnparse.txt
    }
  }
  inc %_tnparse.num

  if ($mid(%_tnparse.txt,2,1) != $null) {
    %_tnparse.fst = $gettok(%_tnparse.txt,1,32)

    if (%_tnparse.fst == enter) {
      var %_xxpath = @ $+ $1
      %_xxpath = $window(%_xxpath).title
      if ($right(%_xxpath,1) != $chr(46)) {
        titlebar @ $+ $1 %_xxpath $+ $chr(46)
      }
      if ($left($sock($1).mark,1) == 1) {
        echo %tncolor.own @ $+ $1 > %_tnparse.txt
      }
      unset %_xxpath
      goto tnoutp
    }

    var %_xwrdtwo = $gettok(%_tnparse.txt,2,32)

    if (%_tncfg.tabwords != 0 && %_tncfg.tabfind != 0 && %_xwrdtwo != $null) {

      if ($left($sock($1).mark,1) == 1) {
        echo %tncolor.own @ $+ $1 > %_tnparse.txt
      }

      if ($isupper($left(%_xwrdtwo,1))) {
        if (%_tnparse.fst == tell || %_tnparse.fst == look || %_tnparse.fst == greet) {

          %_tnparse.txt = $chr(64) $+ $1
          %_tnparse.fst = $chr(42) $+ %_xwrdtwo
          %_tnparse.txt = $fline(%_tnparse.txt,%_tnparse.fst,1,1)
          if (%_tnparse.txt == $null) {
            aline -l @ $+ $1 $chr(43) $+ %_xwrdtwo
          }
        }
      }
      unset %_xwrdtwo
      goto tnoutp
    }
    else if (%_tnparse.txt == se) {
      %_tnparse.txt = l
    }
    else if (%_tnparse.txt == sw) {
      %_tnparse.txt = k
    }
    else if (%_tnparse.txt == nw) {
      %_tnparse.txt = h
    }
    else if (%_tnparse.txt == ne) {
      %_tnparse.txt = j
    }
    else {
      if ($left($sock($1).mark,1) == 1) {
        echo %tncolor.own @ $+ $1 > %_tnparse.txt
      }
      unset %_xwrdtwo
      goto tnoutp
    }
  }
  else if (%_tnparse.txt == l || %_tnparse.txt == h || %_tnparse.txt == j || %_tnparse.txt == k) {
    if ($left($sock($1).mark,1) == 1) {
      echo %tncolor.own @ $+ $1 > %_tnparse.txt
    }
    goto tnoutp
  }
  unset %_xwrdtwo

  if ($left(%_tnparse.txt,1) == $chr(13) || $left(%_tnparse.txt,1) == $chr(10)) {
    if ($left($sock($1).mark,1) == 1) {
      echo %tncolor.own @ $+ $1 *
    }
  }
  else {
    var %_xxpath = @ $+ $1
    %_xxpath = $window(%_xxpath).title
    var %_xxprvc = $right(%_xxpath,1)

    if (%_xxprvc == %_tnparse.txt && %_tnparse.txt != $chr(46)) {
      %_xxprvc = $right(%_xxpath,2)
      %_xxprvc = $asc($left(%_xxprvc,1))
      if (%_xxprvc >= $asc(1) && %_xxprvc <= $asc(8)) {
        %_xxprvc = $calc(%_xxprvc + 1)
        %_xxpath = $left(%_xxpath,$calc($len(%_xxpath) - 2)) $+ $chr(%_xxprvc) $+ $right(%_xxpath,1)
      }
      else if (%_xxprvc == $asc(9)) {
        %_xxpath = %_xxpath $+ %_tnparse.txt
      }
      else {
        %_xxpath = $left(%_xxpath,$calc($len(%_xxpath) - 1)) $+ 2 $+ %_tnparse.txt
      }
      titlebar @ $+ $1 %_xxpath
    }
    else {
      if (%_tnparse.txt == n || %_tnparse.txt == s || %_tnparse.txt == e || %_tnparse.txt == w || %_tnparse.txt == u || %_tnparse.txt == d || %_tnparse.txt == j || %_tnparse.txt == k || %_tnparse.txt == l || %_tnparse.txt == h) {

        var %_oldttl = $gettok(%_xxpath,1,93)

        %_xxpath = $gettok(%_xxpath,2,93)

        if ($len(%_xxpath) < 25) {
          titlebar @ $+ $1 %_oldttl $+ $chr(93) $+ %_xxpath $+ %_tnparse.txt
        }
        else {

          if ($len(%_xxpath) > 50) {
            titlebar @ $+ $1 %_oldttl $+ $chr(93) $+ $chr(160) $+ %_tnparse.txt
            halt
          }

          %_xxprvc = $asc($mid(%_xxpath,2,1))
          if (%_xxprvc >= $asc(1) && %_xxprvc <= $asc(9)) {
            %_xxprvc = $right(%_xxpath,$calc($len(%_xxpath) - 3))
          }
          else {
            %_xxprvc = $right(%_xxpath,$calc($len(%_xxpath) - 2))
          }
          %_xxpath = %_oldttl $+ $chr(93) $+ $chr(160) $+ %_xxprvc $+ %_tnparse.txt
          titlebar @ $+ $1 %_xxpath
        }
        unset %_oldttl
      }
      else if ($left($sock($1).mark,1) == 1) {
        echo %tncolor.own @ $+ $1 > %_tnparse.txt
      }
    }
    unset %_xxprvc
    unset %_xxpath
  }
  goto tnoutp
}

alias totelnet {
  if ($1 == $null) {
    echo $colour(action) -ta Usage: /totelnet <window name> <command(s)>
    halt
  }

  if ($1 == cmd) {
    var %_scknm = $remove($active,@)
    if ($left(%_scknm,6) != Telnet) {
      echo $colour(notice) -ta Error: "/totelnet cmd" called, but not in a telnet window.
      halt
    }
  }
  else {
    var %_scknm = $1
  }

  if ($left($2,1) == $chr(47)) {

    %_tncmd = $right($2,$calc($len($2) - 1))

    if (%_tncmd == $chr(47) || %_tncmd == raw) {
      if ($3 == $null) {
        sockwrite -t %_scknm $chr(9)
        if ($sockerr > 0) {
          echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
        }
      }
      else {
        sockwrite -t %_scknm $3-
        if ($sockerr > 0) {
          echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
          halt
        }
        if ($left($sock(%_scknm).mark,1) == 1) {
          echo %tncolor.own @ $+ %_scknm % $3-
          if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
            write -i $gettok($sock(%_scknm).mark,2,38) % $3-
          }
        }
      }
    }
    else if (%_tncmd == close || %_tncmd == rec) {
      if ($sock(%_scknm).ip == nowhere) {
        halt
      }
      if ($sock(%_scknm).name != $null) {

        var %_sckmark = @ $+ %_scknm
        %_sckmark = $window(%_sckmark).title
        %_sckmark = $gettok(%_sckmark,2,93)
        titlebar @ $+ %_scknm $chr(63) $+ $sock(%_scknm).mark $+ $chr(93) $+ %_sckmark
        %_sckmark = $chr(63) $+ $sock(%_scknm).mark

        echo $colour(info) @ $+ %_scknm *** telnet: Disconnected.
        if (%_numtelnet == 1) {
          unset %_numtelnet

          if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
              write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- DISCONNECTED ---
          }
          if ($window(@__TN_DATA_).title != $null) {
            titlebar @__TN_DATA_ $null
            window -c @__TN_DATA_
          }
          if ($window(@__TN_ALIASES_).title != $null) {
            titlebar @__TN_ALIASES_ $null
            window -c @__TN_ALIASES_
          }
        }
        else {
          %_numtelnet = $calc(%_numtelnet - 1)
        }
        sockclose %_scknm
      }
      else {
        var %_sckmark = @ $+ %_scknm
        %_sckmark = $window(%_sckmark).title
        %_sckmark = $gettok(%_sckmark,1,93)
        if ($left(%_sckmark,1) != $chr(63)) {
          %_sckmark = $chr(63)
        }
      }
      if (%_tncmd == rec) {
        var %_tnhname = $gettok(%_scknm,2,40)
        %_tnhname = $gettok(%_tnhname,1,41)
        %_tnhname = $gettok(%_tnhname,1,58) $gettok(%_tnhname,2,58)

        %_tnhname = %_tnhname %_sckmark

        if ($mid(%_scknm,8,1) != $chr(40)) {
          %_tnhname = %_tnhname $+ $chr(94) $+ $gettok(%_scknm,2,160)
        }
        else {
          %_tnhname = %_tnhname $+ $chr(94) $+ $chr(49)
        }
        telnet %_tnhname
        halt
      }
      unset %_sckmark
    }
    else if (%_tncmd == status || %_tncmd == info) {
      if ($sock(%_scknm).name == $null) halt

      echo $colour(info2) @ $+ %_scknm *** telnet: status: IP address..: $sock(%_scknm).ip
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Port........: $sock(%_scknm).port
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Received....: $sock(%_scknm).rcvd bytes
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Sent........: $sock(%_scknm).sent bytes
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Time active.: $duration($sock(%_scknm).to)
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Last receive: $duration($sock(%_scknm).lr) ago
      echo $colour(info2) @ $+ %_scknm *** telnet: status: Last send...: $duration($sock(%_scknm).ls) ago
      if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Logfile.....: $gettok($sock(%_scknm).mark,2,38)
      }
      else {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Logfile.....: <none>
      }
      if ($mid($sock(%_scknm).mark,2,1) == 1) {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Color scheme: ANSI
      }
      else {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Color scheme: Custom
      }
      if ($left($sock(%_scknm).mark,1) == 1) {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Local echo..: + Enabled
      }
      else {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Local echo..: - Disabled
      }
      if ($mid($sock(%_scknm).mark,3,1) != 0) {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Triggers....: + Enabled
      }
      else {
        echo $colour(info2) @ $+ %_scknm *** telnet: status: Triggers....: - Disabled
      }
    }
    else if (%_tncmd == lecho) {
      if ($sock(%_scknm).name == $null) halt
      if ($3 == off) {
        if ($left($sock(%_scknm).mark,1) == 1) {
          echo $colour(info2) @ $+ %_scknm *** telnet: Local echo disabled.
          sockmark %_scknm 0 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 1))
        }
      }
      else if ($left($sock(%_scknm).mark,1) != 1 || $3 == on) {
        sockmark %_scknm 1 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 1))
        echo $colour(info2) @ $+ %_scknm *** telnet: Local echo enabled.
      }
      else {
        sockmark %_scknm 0 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 1))
        echo $colour(info2) @ $+ %_scknm *** telnet: Local echo disabled.
      }
    }
    else if (%_tncmd == quote) {
      unset %_tncmd
      _atnssnd %_scknm $3-
      halt
    }
    else if (%_tncmd == me) {
      unset %_tncmd
      _atnssnd %_scknm emote $3-
      halt
    }
    else if (%_tncmd == clear) {
      titlebar @ $+ %_scknm $chr(160) $+ $chr(93) $+ $chr(160)
      clear @ $+ %_scknm
    }
    else if (%_tncmd == calias) {
      calias $3-
    }
    else if (%_tncmd == creplace || %_tncmd == replace) {
      creplace $3-
    }
    else if (%_tncmd == ctrigger || %_tncmd == trigger) {
      ctrigger $3-
    }
    else if (%_tncmd == describe) {
      describe $3-
    }
    else if (%_tncmd == undesc) {
      undesc $3-
    }
    else if (%_tncmd == cansi) {
      if ($sock(%_scknm).name == $null) halt
      if ($mid($sock(%_scknm).mark,2,1) == 1) {
        sockmark %_scknm $left($sock(%_scknm).mark,1) $+ 0 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 2))
        echo $colour(info2) @ $+ %_scknm *** telnet: USING CUSTOM COLORS
      }
      else {
        sockmark %_scknm $left($sock(%_scknm).mark,1) $+ 1 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 2))
        echo $colour(info2) @ $+ %_scknm *** telnet: USING ANSI COLORS
      }
    }
    else if (%_tncmd == trigs) {
      if ($sock(%_scknm).name == $null) halt
      if ($mid($sock(%_scknm).mark,3,1) != 0) {
        sockmark %_scknm $left($sock(%_scknm).mark,2) $+ 0 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 3))
        echo $colour(info2) @ $+ %_scknm *** telnet: TRIGGERS DISABLED
      }
      else {
        sockmark %_scknm $left($sock(%_scknm).mark,2) $+ 1 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 3))
        echo $colour(info2) @ $+ %_scknm *** telnet: TRIGGERS ENABLED
      }
    }
    else if (%_tncmd == log) {
      if ($sock(%_scknm).name == $null) halt
      if ($3 == auto) {
        var %_tnalog = $gettok(%_scknm,2,40)
        %_tnalog = $replacecs($gettok(%_tnalog,1,41),$chr(46),$chr(95))
        %_tnalog = $replacecs(%_tnalog,$chr(58),$chr(35))
        if ($gettok(%_scknm,3,160) != $null) {
          %_tnalog = %_tnalog $+ $chr(95) $+ $gettok(%_scknm,2,160)
        }
        if (%_tncfg.autologdir != $null) {
          if ($right(%_tncfg.autologdir,1) == $chr(92) || $right(%_tncfg.autologdir,1) == $chr(47)) {
            %_tncfg.autologdir = $left($replacecs(%_tncfg.autologdir,$chr(92),$chr(47)),$calc($len(%_tncfg.autologdir) - 1))
          }
          %_tnalog = %_tncfg.autologdir $+ $chr(47) $+ %_tnalog
        }
        %_tnalog = %_tnalog $+ $chr(95) $+ $asctime(ddmmmyy)

        if ($mid(%_scknm,8,1) != $chr(40)) {
          %_tnalog = %_tnalog $+ $chr(95) $+ $gettok(%_scknm,2,160)
        }
        %_tnalog = %_tnalog $+ .log
        if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
          write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- LOG CLOSED ---
          echo $colour(info2) @ $+ %_scknm *** telnet: Log " $+ $gettok($sock(%_scknm).mark,2,38) $+ " closed.
        }
        sockmark %_scknm $left($sock(%_scknm).mark,3) $+ $chr(38) $+ %_tnalog
        echo $colour(info2) @ $+ %_scknm *** telnet: Logging to " $+ $gettok($sock(%_scknm).mark,2,38) $+ ".
        write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- LOG STARTED ---
        unset %_tnalog
      }
      else if ($3 == $null) {
        if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
          write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- LOG CLOSED ---
          echo $colour(info2) @ $+ %_scknm *** telnet: Log " $+ $gettok($sock(%_scknm).mark,2,38) $+ " closed.
          sockmark %_scknm $left($sock(%_scknm).mark,3) $+ x
        }
        else {
          echo $colour(info2) @ $+ %_scknm *** telnet: Logging not active.
        }
      }
      else {
        if ($3 == sfile) {
          var %_xtnlfn = $file=Logfile $nofile($mircexe)
          if (%_xtnlfn == $null) {
            halt
          }
        }
        else {
          var %_xtnlfn = $3-
        }
        if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
          write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- LOG CLOSED ---
          echo $colour(info2) @ $+ %_scknm *** telnet: Log " $+ $gettok($sock(%_scknm).mark,2,38) $+ " closed.
        }
        sockmark %_scknm $left($sock(%_scknm).mark,3) $+ $chr(38) $+ %_xtnlfn
        echo $colour(info2) @ $+ %_scknm *** telnet: Logging to " $+ $gettok($sock(%_scknm).mark,2,38) $+ ".
        write -i $gettok($sock(%_scknm).mark,2,38) > --- $fulldate --- LOG STARTED ---
      }
    }
    else if (%_tncmd == help) {
      unset %_tncmd
      if ($3 != $null) {
        return
        halt
      }
      echo $colour(action) @ $+ %_scknm $chr(160)
      echo $colour(action) @ $+ %_scknm * mIRC MUD/Telnet Client Script
      echo $colour(action) @ $+ %_scknm * Copyright (c) 2000 Kimmo Kulovesi
      echo $colour(action) @ $+ %_scknm * http://arkhan.cjb.net/
      echo $colour(action) @ $+ %_scknm *
      echo $colour(action) @ $+ %_scknm *  Click inside this window with the second mouse button for
      echo $colour(action) @ $+ %_scknm *  a menu. The "Command Reference" submenu describes the
      echo $colour(action) @ $+ %_scknm *  Usage of commands briefly.
      echo $colour(action) @ $+ %_scknm *
      echo $colour(action) @ $+ %_scknm *  To send multiple lines at once, separate them with a
      echo $colour(action) @ $+ %_scknm *  backslash ('\'), like: "line one\line two". Prefix the entire
      echo $colour(action) @ $+ %_scknm *  line with a backslash to send the rest of that line as is.
      echo $colour(action) @ $+ %_scknm *  That is: "\/text" sends "/text" to the server - use this to
      echo $colour(action) @ $+ %_scknm *  bypass all aliases and parsing.
      echo $colour(action) @ $+ %_scknm *

      echo $colour(action) @ $+ %_scknm $chr(160)
      halt
    }
    else if (%_tncmd == rw) {

      var %_ythschr = x

      if ($3 == $null) {
        %_tncmd = $chr(64) $+ %_scknm
        %_tncmd = $window(%_tncmd).title
        %_tncmd = $gettok(%_tncmd,2,93)
        %_tncmd = $right(%_tncmd,$calc($len(%_tncmd) - 1))
        if (%_tncmd == $null) {
          echo $colour(info2) @ $+ %_scknm ** telnet: No path to recall. Walk somewhere first.
        }
        %_ythschr = $chr(64) $+ %_scknm
        %_ythschr = $window(%_ythschr).title
        %_ythschr = $gettok(%_ythschr,1,93)
        titlebar @ $+ %_scknm %_ythschr $+ $chr(93) $+ $chr(160)
      }
      else {
        %_tncmd = $3-
      }

      var %_xrwpth = $chr(0)
      var %_zthsdir = $chr(0)

      :xxrwpthrpt

      %_ythschr = $left(%_tncmd,1)

      if (%_ythschr != $null) {
        if ($asc(%_ythschr) >= $asc(0) && $asc(%_ythschr) <= $asc(9)) {
          %_zthsdir = %_zthsdir $+ %_ythschr
        }
        else {
               if (%_ythschr == n) { %_ythschr = s }
          else if (%_ythschr == s) { %_ythschr = n }
          else if (%_ythschr == e) { %_ythschr = w }
          else if (%_ythschr == w) { %_ythschr = e }
          else if (%_ythschr == u) { %_ythschr = d }
          else if (%_ythschr == d) { %_ythschr = u }
          else if (%_ythschr == h) { %_ythschr = l }
          else if (%_ythschr == l) { %_ythschr = h }
          else if (%_ythschr == k) { %_ythschr = j }
          else if (%_ythschr == j) { %_ythschr = k }
          else if (%_ythschr != $chr(46)) {
            %_ythschr = $chr(63) $+ %_ythschr $+ $chr(63)
          }
          %_xrwpth = %_zthsdir $+ %_ythschr $+ %_xrwpth
          %_zthsdir = $chr(0)
        }
        %_tncmd = $right(%_tncmd,$calc($len(%_tncmd) - 1))
        goto xxrwpthrpt
      }
      editbox $chr(64) $+ %_scknm $chr(47) $+ sw %_xrwpth
      unset %_xrwpth
      unset %_ythschr
      unset %_zthsdir
    }
    else if (%_tncmd == sw) {

      if ($3 == $null) {
        %_tncmd = $chr(64) $+ %_scknm
        %_tncmd = $window(%_tncmd).title
        %_tncmd = $gettok(%_tncmd,2,93)
        %_tncmd = $right(%_tncmd,$calc($len(%_tncmd) - 1))
        if (%_tncmd != $null) {
          editbox $chr(64) $+ %_scknm $chr(47) $+ sw %_tncmd
        }
        else {
          echo $colour(info2) @ $+ %_scknm ** telnet: No path to recall. Walk somewhere first.
        }
        %_tncmd = $chr(64) $+ %_scknm
        %_tncmd = $window(%_tncmd).title
        %_tncmd = $gettok(%_tncmd,1,93)
        titlebar @ $+ %_scknm %_tncmd $+ $chr(93) $+ $chr(160)
        halt
      }

      if ($sock(%_scknm).name == $null) {
        halt
      }

      %_tncmd = $chr(92)
      var %_xcmdstr = $3-
      var %_xrdcnt = 1
      var %_xnmstr = 0
      var %_xthschr = 0

      :swxrpt

      %_xthschr = $mid(%_xcmdstr,%_xrdcnt,1)
      if (%_xthschr == $null) {
        unset %_xrdcnt
        unset %_xnmstr
        unset %_xcmdstr
        unset %_xthschr
        %_tncmd = $right(%_tncmd,$calc($len(%_tncmd) - 1))
        _atnssnd %_scknm %_tncmd
        unset %_tncmd
        halt
      }

      if ($asc(%_xthschr) >= $asc(0) && $asc(%_xthschr) <= $asc(9)) {
        if (%_xnmstr == 0) {
          %_xnmstr = %_xthschr
        }
        else {
          %_xnmstr = %_xnmstr $+ %_xthschr
        }
        inc %_xrdcnt
        goto swxrpt
      }

      if (%_xthschr == l) {
        %_xthschr = se
      }
      else if (%_xthschr == k) {
        %_xthschr = sw
      }
      else if (%_xthschr == h) {
        %_xthschr = nw
      }
      else if (%_xthschr == j) {
        %_xthschr = ne
      }

      if (%_xnmstr < 2) {
        %_tncmd = %_tncmd $+ $chr(92) $+ %_xthschr
        %_xnmstr = 0
      }
      else {
        if (%_xnmstr > 42) {
          echo $colour(action) @ $+ %_scknm *** ERROR: Refusing to flood " $+ %_xthschr $+ " %_xnmstr times.
          halt
        }
      
        %_xthschr = $chr(92) $+ %_xthschr
        %_tncmd = %_tncmd $+ %_xthschr
        dec %_xnmstr
        :scxrpt
        %_tncmd = %_tncmd $+ %_xthschr
        if (%_xnmstr > 1) {
          dec %_xnmstr
          goto scxrpt
        }
        %_xnmstr = 0
      }
      inc %_xrdcnt
      goto swxrpt
    }
    else if (%_tncmd == look || %_tncmd == l || %_tncmd == loo) {
      look $3-
    }
    else if (%_tncmd == pwd) {
      if ($3 == $null) {
        echo $colour(notice) @ $+ %_scknm *** Usage: /pwd <string to send unseen>
        halt
      }
      if ($left($sock(%_scknm).mark,1) == 1) {
        sockmark %_scknm 0 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 1))
        sockwrite -tn %_scknm $3-
        if ($sockerr > 0) {
          echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
          halt
        }
        sockmark %_scknm 1 $+ $right($sock(%_scknm).mark,$calc($len($sock(%_scknm).mark) - 1))
      }
      else {
        sockwrite -tn %_scknm $3-
        if ($sockerr > 0) {
          echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
          halt
        }
      }     
      if ($left($sock(%_scknm).mark,1) == 1) {
        echo %tncolor.own @ $+ %_scknm * <hidden>
      }
    }
    else {
      .alias __tntmpaliashackxxx $2-
      __tntmpaliashackxxx
      .alias __tntmpaliashackxxx
    }
    unset %_tncmd
    halt
  }

  if ($sock(%_scknm).name == $null) halt

  if ($left($2,1) == $chr(92)) {
    %_tncmd = $2-
    %_tncmd = $right(%_tncmd,$calc($len(%_tncmd) - 1))
    if (%_tncmd == $null) {
      unset %_tncmd
      sockwrite -t %_scknm $crlf
      if ($left($sock(%_scknm).mark,1) == 1) {
        echo %tncolor.own @ $+ %_scknm *
      }
      if ($sockerr > 0) {
        echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
      }
      unset %_scknm
      halt
    }
    sockwrite -tn %_scknm %_tncmd

    if ($sockerr > 0) {
      echo $colour(notice) -a *** telnet: Cannot send to $sock(%_scknm).name ( $+ $sock(%_scknm).ip $+ ).
      halt
    }
    if ($left($sock(%_scknm).mark,1) == 1) {
      echo %tncolor.own @ $+ %_scknm > %_tncmd
      if ($mid($sock(%_scknm).mark,4,1) == $chr(38)) {
        write -i $gettok($sock(%_scknm).mark,2,38) > %_tncmd
      }
    }
    unset %_tncmd
    unset %_scknm
    halt
  }

  unset %_tncmd

  _atnssnd %_scknm $2-

  unset %_scknm
}

on 1:INPUT:@Telnet*: {
  totelnet $remove($target,@) $1-
}

;-----------------------------------------------------------------------------
; When the connection is established:
;-----------------------------------------------------------------------------

alias __xxtnaliasfill {
  if ($window(@__TN_ALIASES_).title == $null) {
    window -nhl @__TN_ALIASES_ 1 1 500 400
    aline @__TN_ALIASES_ --- Telnet aliases - DO NOT CLOSE THIS WINDOW.

    titlebar @__TN_ALIASES_ Telnet Data
    aline @__TN_ALIASES_ /me
    aline @__TN_ALIASES_ emote

    if ($exists(%_atelnini) != $false) {
      var %_rndnum = 1
      var %_rndsc = x
      var %_rndta = x
      :xrprepeat
      %_rndta = %_atelnini
      %_rndsc = $ini(%_rndta,aliases,%_rndnum)
      if (%_rndsc != $null) {
        inc %_rndnum
        %_rndta = $readini %_atelnini aliases %_rndsc
        if (%_rndta != $null) {
          aline @__TN_ALIASES_ %_rndsc
          aline @__TN_ALIASES_ %_rndta
        }
        goto xrprepeat
      }
      unset %_rndsc
      unset %_rndta
      unset %_rndnum
    }
  }
}

alias __xxtndatafill {
  if ($window(@__TN_DATA_).title == $null) {
    window -nhl @__TN_DATA_ 1 1 500 400
    aline @__TN_DATA_ --- Telnet data - DO NOT CLOSE THIS WINDOW.

    titlebar @__TN_DATA_ Telnet Data

; When the host sends "IAC DO <anything>", reply "IAC WONT <anything>"
    aline @__TN_DATA_ $chr(255) $+ $chr(253)
    aline @__TN_DATA_ $chr(94) $+ $chr(255) $+ $chr(252)

; When the host sends "IAC WILL <anything>", reply "IAC DONT <anything>"
    aline @__TN_DATA_ $chr(255) $+ $chr(251)
    aline @__TN_DATA_ $chr(94) $+ $chr(255) $+ $chr(254)

; When the host sends "IAC WONT ECHO", turn local echo on
   aline @__TN_DATA_ $chr(255) $+ $chr(252) $+ $chr(1)
   aline @__TN_DATA_ ^/lecho on

    if ($exists(%_atelnini) != $false) {
      var %_rndnum = 1
      var %_rndsc = x
      var %_rndta = x
      :rprepeat

      %_rndta = %_atelnini
      %_rndsc = $ini(%_rndta,replace,%_rndnum)
      if (%_rndsc != $null) {
        inc %_rndnum
        %_rndta = $readini %_atelnini replace %_rndsc
        if (%_rndta == $null) {
          aline @__TN_DATA_ %_rndsc
          aline @__TN_DATA_ $chr(31)
        }
        else {
          aline @__TN_DATA_ %_rndsc
          %_rndsc = $chr(64) $+ $chr(81) $+ $chr(94)
          %_rndta = $replacecs(%_rndta,%_rndsc,$chr(34))
          %_rndsc = $chr(64) $+ $chr(83) $+ $chr(94)
          %_rndta = $replacecs(%_rndta,%_rndsc,$chr(39))
          %_rndsc = $chr(64) $+ $chr(66) $+ $chr(94)
          %_rndta = $replacecs(%_rndta,%_rndsc,$chr(2))
          %_rndsc = $chr(64) $+ $chr(67) $+ $chr(94)
          %_rndta = $replacecs(%_rndta,%_rndsc,$chr(3))
          %_rndsc = $chr(64) $+ $chr(78) $+ $chr(94)
          %_rndta = $replacecs(%_rndta,%_rndsc,$chr(31))
          aline @__TN_DATA_ %_rndta
        }
        goto rprepeat
      }
      unset %_rndsc
      unset %_rndta
      unset %_rndnum
    }
  }
}

on 1:SOCKOPEN:Telnet*: {

  if ($sockerr > 0 && $sock($sockname).ip != nowhere) {
    echo $colour(notice) -tfa *** telnet: Connection to $sock($sockname).name ( $+ $sock($sockname).ip $+ ) failed.
    halt
  }
  var %_tnscnt = $chr(64) $+ $sockname
  var %_tcmdsxx = " $+ $nofile($mircexe) $+ tcmds.cfg"

  if ($window(%_tnscnt).title == $null) {
    if ($exists(%_tcmdsxx) != $false) {
      if (%_tncfg.tabwords != 0) {
        if (%_tncfg.desktop == 1) {
          if (%_tncfg.hidetabs == 1) {
            window -deSl0 +bestxn @ $+ $sockname %_tcmdsxx
          }
          else {
            window -deSl10 +bestxn @ $+ $sockname %_tcmdsxx
          }
        }
        else {
          if (%_tncfg.hidetabs == 1) {
            window -eSl0 +bestxn @ $+ $sockname %_tcmdsxx
          }
          else {
            window -eSl10 +bestxn @ $+ $sockname %_tcmdsxx
          }
        }
      }
      else {
        if (%_tncfg.desktop == 1) {
          window -de +bestxn @ $+ $sockname %_tcmdsxx
        }
        else {
          window -e +bestxn @ $+ $sockname %_tcmdsxx
        }
      }
    }
    else {
      if (%_tncfg.tabwords != 0) {
        if (%_tncfg.desktop == 1) {
          if (%_tncfg.hidetabs == 1) {
            window -deSl0 +bestxn @ $+ $sockname
          }
          else {
            window -deSl10 +bestxn @ $+ $sockname
          }
        }
        else {
          if (%_tncfg.hidetabs == 1) {
            window -eSl0 +bestxn @ $+ $sockname
          }
          else {
            window -eSl10 +bestxn @ $+ $sockname
          }
        }
      }
      else {
        if (%_tncfg.desktop == 1) {
          window -de +bestxn @ $+ $sockname
        }
        else {
          window -e +bestxn @ $+ $sockname
        }
      }
    }
    unset %_tcmdsxx
    %_tnscnt = 1

    if (%_tncfg.tabwords != 0 && $exists($nofile($mircexe) $+ ttabword.cfg) != $false) {
      var %_tnrdxx = x
      :_tntabrd

      %_tnrdxx = $read -tl $+ %_tnscnt $nofile($mircexe) $+ ttabword.cfg

      if (%_tnrdxx != $null) {
        inc %_tnscnt
        if (%_tncfg.hidetabs == 1) {
          aline -l @ $+ $sockname $chr(64) $+ %_tnrdxx
        }
        else {
          aline -l @ $+ $sockname %_tnrdxx
        }
        goto _tntabrd
      }
      unset %_tnrdxx
    }
    titlebar @ $+ $sockname $chr(91) $+ $chr(160) $+ $chr(93) $+ $chr(160)
  }
  else {
    %_tnscnt = $window(%_tnscnt).title
    if ($left(%_tnscnt,1) == $chr(63)) {
      var %_winttlmark = $gettok(%_tnscnt,1,93)
      sockmark $sockname $right(%_winttlmark,$calc($len(%_winttlmark) - 1))
      unset %_winttlmark
    }
    titlebar @ $+ $sockname $chr(91) $+ $chr(160) $+ $chr(93) $+ $gettok(%_tnscnt,2,93)
  }
  %_tnscnt = 1

  if ($sock($sockname).ip == nowhere) {
    unset %_tnscnt
    halt
  }

  if (%_numtelnet == $null || %_numtelnet < 1) {
    %_numtelnet = 1
  }
  else {
    %_numtelnet = $calc(%_numtelnet + 1)
  }

  %_tnscnt = 1

  :xtntryname

  if ($sock(Telnet*,%_tnscnt).name == $null) {
    if (%_tnscnt < %_numtelnet) %_numtelnet = %_tnscnt
  }
  else {
    inc %_tnscnt
    goto xtntryname
  }

  unset %_tnscnt

  __xxtndatafill
  __xxtnaliasfill

  if ($sock($sockname).mark == $null) {
    if (%_tncfg.useansi == 1) {
      sockmark $sockname 111x
    }
    else {
      sockmark $sockname 101x
    }
  }

  echo $colour(info) -bf @ $+ $sockname *** telnet: Connected to $sock($sockname).name ( $+ $sock($sockname).ip $+ ).

  if ($mid($sock($sockname).mark,4,1) == $chr(120)) {
    if (%_tncfg.autolog == 1) {
      totelnet $sockname $chr(47) $+ log auto
    }
  }
  else {
    echo $colour(info2) @ $+ $sockname *** telnet: Logging to " $+ $gettok($sock($sockname).mark,2,38) $+ ". $chr(160)
    write -i $gettok($sock($sockname).mark,2,38) > --- $fulldate --- LOG STARTED ---
  }
}

;-----------------------------------------------------------------------------
; When the user closes the window:
;-----------------------------------------------------------------------------

on 1:CLOSE:@Telnet*: {

  if ($sock($remove($target,@)).name == $null) {
    halt
  }

  close -@ $target

  if (%_numtelnet == 1) {
    unset %_numtelnet
    if ($window(@__TN_DATA_).title != $null) {
      titlebar @__TN_DATA_ $null
      window -c @__TN_DATA_
    }
    if ($window(@__TN_ALIASES_).title != $null) {
      titlebar @__TN_ALIASES_ $null
      window -c @__TN_ALIASES_
    }
  }
  else {
    %_numtelnet = $calc(%_numtelnet - 1)
  }

  echo $colour(info) -bf $target *** telnet: Disconnected.
  echo $colour(notice) -bfta *** telnet: Connection to $sock($remove($target,@)).name ( $+ $sock($remove($target,@)).ip $+ ) terminated.

  if ($mid($sock($sockname).mark,4,1) == $chr(38)) {
      write -i $gettok($sock($sockname).mark,2,38) > --- $fulldate --- DISCONNECTED ---
  }

  sockclose $remove($target,@)
}

;-----------------------------------------------------------------------------
; If the server closes the connection:
;-----------------------------------------------------------------------------

on 1:SOCKCLOSE:Telnet*: {

  echo $colour(info) -bf @ $+ $sockname *** telnet: Disconnected.

  if ($mid($sock($sockname).mark,4,1) == $chr(38)) {
      write -i $gettok($sock($sockname).mark,2,38) > --- $fulldate --- DISCONNECTED ---
  }
  if (%_numtelnet == 1) {
    unset %_numtelnet
    if ($window(@__TN_DATA_).title != $null) {
      titlebar @__TN_DATA_ $null
      window -c @__TN_DATA_
    }
    if ($window(@__TN_ALIASES_).title != $null) {
      titlebar @__TN_ALIASES_ $null
      window -c @__TN_ALIASES_
    }
  }
  else {
    %_numtelnet = $calc(%_numtelnet - 1)
  }

  var %_xwinrenttl = @ $+ $sockname
  %_xwinrenttl = $window(%_xwinrenttl).title
  %_xwinrenttl = $gettok(%_xwinrenttl,2,93)
  titlebar @ $+ $sockname $chr(63) $+ $sock($sockname).mark $+ $chr(93) $+ %_xwinrenttl
  unset %_xwinrenttl
}

on 1:SOCKWRITE:Telnet*: {
  if ($sockerr > 0) {
    echo $colour(notice) -tfa *** telnet: Socket error occurred while writing to $sockname $+ .
    halt
  }
  return
}

;-----------------------------------------------------------------------------
; When data is received:
;-----------------------------------------------------------------------------

on 1:SOCKREAD:Telnet*: {
  if ($sockerr > 0) {
    echo $colour(notice) -tfa *** telnet: Socket error occurred while reading from $sockname $+ .
    halt
  }
  var %_tninputs = x
  var %_tntrigs = x
  :rdsckt
  sockread %_tninputs

  if ($sockerr > 0) {
    echo $colour(notice) -a *** telnet: Cannot read from $sock($sockname).name ( $+ $sock($sockname).ip $+ ).
    halt
  }

  if (%_tninputs == $null) {
    if (%_tncfg.emptylines == 1) {
      if ($sockbr != 0) {
        %_tninputs = $crlf
      }
      else {
        sockread -f %_tninputs
        if ($sockbr == 0) {
          return
        }
        if ($mid(%_tninputs,2,1) == $null || %_tninputs == $crlf) {
          if ($left(%_tninputs,1) == $cr || $left(%_tninputs,1) == $lf || $asc($left(%_tninputs,1)) == 32 || $left(%_tninputs,1) == $null) {
            %_tninputs = $null
          }
        }
      }
    }
    else {
      if ($sockbr != 0) {
        %_tninputs = $null
      }
      else {
        sockread -f %_tninputs
        if ($sockbr == 0) {
          return
        }
        if ($mid(%_tninputs,2,1) == $null || %_tninputs == $crlf) {
          if ($left(%_tninputs,1) == $cr || $left(%_tninputs,1) == $lf || $asc($left(%_tninputs,1)) == 32 || $left(%_tninputs,1) == $null) {
            %_tninputs = $null
          }
        }
      }
    }
  }

  if (%_tninputs != $null) {

    %_tninputs = $replacecs(%_tninputs,$cr,$chr(0),$lf,$chr(0))

    var %_tnrpl = $chr(3) $+ %tncolor.bold

    if ($mid($sock($sockname).mark,2,1) == 1) {
      %_tninputs = $ansi2mirc(%_tninputs)
    }
    else {
      
      %_tninputs = $replacecs(%_tninputs,[0m,$chr(3),[1m,%_tnrpl,[2m,$chr(32))
      %_tnrpl = $chr(3) $+ %tncolor.black

      if (%_tncfg.hlcols == 1) {
        %_tninputs = $replacecs(%_tninputs,[30m,%_tnrpl,[1;30m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.red
        %_tninputs = $replacecs(%_tninputs,[31m,%_tnrpl,[1;31m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.green
        %_tninputs = $replacecs(%_tninputs,[32m,%_tnrpl,[1;32m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.yellow
        %_tninputs = $replacecs(%_tninputs,[33m,%_tnrpl,[1;33m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.blue
        %_tninputs = $replacecs(%_tninputs,[34m,%_tnrpl,[1;34m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.magenta
        %_tninputs = $replacecs(%_tninputs,[35m,%_tnrpl,[1;35m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.cyan
        %_tninputs = $replacecs(%_tninputs,[36m,%_tnrpl,[1;36m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.white
        %_tninputs = $replacecs(%_tninputs,[37m,%_tnrpl,[1;37m,%_tnrpl)
      }
      else {
        %_tninputs = $replacecs(%_tninputs,[30m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.red
        %_tninputs = $replacecs(%_tninputs,[31m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.green
        %_tninputs = $replacecs(%_tninputs,[32m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.yellow
        %_tninputs = $replacecs(%_tninputs,[33m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.blue
        %_tninputs = $replacecs(%_tninputs,[34m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.magenta
        %_tninputs = $replacecs(%_tninputs,[35m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.cyan
        %_tninputs = $replacecs(%_tninputs,[36m,%_tnrpl)
        %_tnrpl = $chr(3) $+ %tncolor.white
        %_tninputs = $replacecs(%_tninputs,[37m,%_tnrpl)
      }
    }

    if (%_tncfg.flash == 1 && $away != $true) {
      %_tnrpl = $gettok($sockname,2,40)
      flash -r2 $chr(64) $+ $gettok(%_tnrpl,1,58)
    }

    %_tnrpl = $right(%_tninputs,2)

    if ($left(%_tnrpl,1) == $chr(93) || $mid(%_tnrpl,2,1) == $chr(93)) {
      if ($count(%_tninputs,$chr(91)) == 1) {
        var %_xroomnam = $strip($gettok(%_tninputs,1,91)) $+ $chr(93)
        %_xroomnam = $gettok(%_xroomnam,1,93)
        %_tnrpl = @ $+ $sockname
        %_tnrpl = $window(%_tnrpl).title
        %_tnrpl = $gettok(%_tnrpl,2,93)
        titlebar @ $+ $sockname $chr(91) $+ $chr(160) $+ %_xroomnam $+ $chr(160) $+ $chr(93) $+ %_tnrpl
      }
    }

    if ($mid($sock($sockname).mark,4,1) == $chr(38)) {
      write -i $gettok($sock($sockname).mark,2,38) $strip(%_tninputs)
    }

    if ($mid($sock($sockname).mark,3,1) != 0) {
      if ($window(@__TN_DATA_).title == $null) {
        __xxtndatafill
      }
      %_pndnum = 2
      %_pndta = x
      %_pnrda = x
      :pprepeat

      %_pndta = $line(@__TN_DATA_,%_pndnum,0)
      if (%_pndta != $null) {
        inc %_pndnum
        %_pnrda = $line(@__TN_DATA_,%_pndnum,0)
        inc %_pndnum
        if ($left(%_pnrda,1) == $chr(94)) {
          var %_trgcnt = $count(%_tninputs,$replacecs(%_pndta,$chr(160),$chr(32)))
          if (%_trgcnt >= 1) {
            if ($left(%_pndta,1) == $chr(255)) {
              if ($mid(%_pndta,2,1) == $chr(253)) {
                var %_cwnt = 2
                :_xwnt

                %_pnrda = $gettok(%_tninputs,%_cwnt,253)
                if (%_pnrda != $null) {
                  inc %_cwnt
                  %_pnrda = $chr(255) $+ $chr(252) $+ $left(%_pnrda,1) $+ $chr(160)
                  sockwrite $sockname $left(%_pnrda,3) $+ $chr(255) $+ $chr(241)
                  goto _xwnt
                }
                unset %_cwnt
              }
              else if ($mid(%_pndta,2,1) == $chr(251)) {
                var %_cwnt = 2
                :_xyyxwnt

                %_pnrda = $gettok(%_tninputs,%_cwnt,251)
                if (%_pnrda != $null) {
                  inc %_cwnt
                  if ($left(%_pnrda,1) != $chr(1)) {
                    %_pnrda = $chr(255) $+ $chr(254) $+ $left(%_pnrda,1) $+ $chr(160)
                    sockwrite $sockname $left(%_pnrda,3) $+ $chr(255) $+ $chr(241)
                  }
                  else {
                    if ($left($sock($sockname).mark,1) == 1) {
                      echo $colour(info2) @ $+ $sockname *** telnet: Local echo disabled by host request.
                      sockmark $sockname 0 $+ $right($sock($sockname).mark,$calc($len($sock($sockname).mark) - 1))
                    }
                  }
                  goto _xyyxwnt
                }
                unset %_cwnt
              }
              else {
                if ($mid(%_pndta,3,1) == $chr(1)) {
                  sockmark $sockname 1 $+ $right($sock($sockname).mark,$calc($len($sock($sockname).mark) - 1))
                  echo $colour(info2) @ $+ $sockname *** telnet: Local echo enabled by host request.
                }
                else {
                  %_pnrda = $right(%_pnrda,$calc($len(%_pnrda) - 1))
                  sockwrite $sockname %_pnrda
                }
              }
            }
            else if ($mid(%_pnrda,2,1) == $chr(64)) {
              var %_xonlyat = $gettok($sockname,2,40)
              %_xonlyat = $gettok(%_xonlyat,1,41)
              %_pnrda = $right(%_pnrda,$calc($len(%_pnrda) - 1))

              if ($count(%_xonlyat,$gettok(%_pnrda,1,64)) >= 1) {
                %_tntrigs = %_tntrigs $+ $chr(92) $+ $gettok(%_pnrda,2,64)
              }
              else {
                if ($count($sock($sockname).ip,$gettok(%_pnrda,1,64)) >= 1) {
                  %_tntrigs = %_tntrigs $+ $chr(92) $+ $gettok(%_pnrda,2,64)
                }
              }
            }
            else {
              :_xxtrgmore
              dec %_trgcnt
              %_tntrigs = %_tntrigs $+ $chr(92) $+ $right(%_pnrda,$calc($len(%_pnrda) - 1))
              if (%_trgcnt >= 1) {
                goto _xxtrgmore
              }
            }
          }
          unset %_trgcnt
        }
        else {
          %_tninputs = $replace(%_tninputs,$replacecs(%_pndta,$chr(160),$chr(32)),$replacecs(%_pnrda,$chr(160),$chr(32)))
        }
        goto pprepeat
      }
      unset %_pndta
      unset %_pnrda
      unset %_pndnum
    }

    %_tninputs = $replacecs(%_tninputs,$chr(31),$chr(0))

    %_tnrpl = $chr(32) $+ $chr(160)
    %_tninputs = $replacecs(%_tninputs,$str($chr(32),2),%_tnrpl)

    if ($mid($sock($sockname).mark,2,1) == 1) {
      echo -l @ $+ $sockname $chr(160) $+ $chr(160) $+ %_tninputs
    }
    else {
      echo %tncolor.plain -l @ $+ $sockname $chr(160) $+ $chr(160) $+ %_tninputs
    }
    unset %_tnrpl
    %_tninputs = $null
    if (%_tntrigs != x) {
      totelnet $sockname $right(%_tntrigs,$calc($len(%_tntrigs) - 2))
    }
    unset %_tntrigs
    var %_tntrigs = x
  }
  if ($sockbr != 0) goto rdsckt
  unset %_tninputs
  unset %_tntrigs
}

on 1:CLOSE:@__TN_*: {
  .titlebar $target $null
}

;-----------------------------------------------------------------------------
; Helper aliases to call stuff from "a_misc.mrc"
;-----------------------------------------------------------------------------

alias look {
  if ($1 == $null) {
    echo $colour(action) -a *** Usage: /look <search string>
    halt
  }
  if (%_xxxtrigfle == $null) {
    set %_xxxtrigfle %_tndescfle
  }
  set %_tndescfle %_atelnini
  desc $1-
}

alias describe {
  if ($1 == $null || $2 == $null) {
    echo $colour(action) -a *** Usage: /describe <name> <description>
    halt
  }
  if ($left($1,1) == $chr(94)) {
    halt
  }
  if (%_xxxtrigfle == $null) {
    set %_xxxtrigfle %_tndescfle
  }
  set %_tndescfle %_atelnini
  wdesc $strip($1) $strip($2-)
}

alias undesc {
  if ($1 == $null) {
    echo $colour(action) -a *** Usage: /undesc <name>
    halt
  }
  if ($left($1,1) == $chr(94)) {
    halt
  }
  if (%_xxxtrigfle == $null) {
    set %_xxxtrigfle %_tndescfle
  }
  set %_tndescfle %_atelnini
  rdesc $strip($1)
}

;-----------------------------------------------------------------------------
; Dialogs
;-----------------------------------------------------------------------------

alias creplace {
  if ($dialog(tnrepldlgnm).title == $null) {
    dialog -m tnrepldlgnm dialogtnreplace
    if ($1 != $null) {
      did -o tnrepldlgnm 2 1 $1
      if ($2 != $null) {
        did -o tnrepldlgnm 4 1 $2-
      }
      else {
        var %_drandsc = $readini %_atelnini replace $1

        if (%_drandsc != $null) {
          if ($left(%_drandsc,1) != $chr(94)) {
            var %_rerndsc = $chr(64) $+ $chr(81) $+ $chr(94)
            var %_rerndta = $replacecs(%_drandsc,%_rerndsc,$chr(34))
            %_rerndsc = $chr(64) $+ $chr(83) $+ $chr(94)
            %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(39))
            %_rerndsc = $chr(64) $+ $chr(66) $+ $chr(94)
            %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(2))
            %_rerndsc = $chr(64) $+ $chr(67) $+ $chr(94)
            %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(3))
            did -o tnrepldlgnm 4 1 %_rerndta
            did -o tnrepldlgnm 10 1 $1 --> %_rerndta
            unset %_rerndsc
            unset %_rerndta
          }
          else {
            did -o tnrepldlgnm 10 1 <TRIGGER> $1
          }
        }
        unset %_drandsc
      }
    }
    if ($exists(%_atelnini) != $false) {
      var %_rxrndnum = 1
      var %_rxrndsc = x
      var %_rxrnxx = x
      var %_rxrndta = %_atelnini
      :rxrprepeat
      %_rxrndsc = $ini(%_rxrndta,replace,%_rxrndnum)
      if (%_rxrndsc != $null) {
        %_rxrnxx = $readini %_rxrndta replace %_rxrndsc
        if ($left(%_rxrnxx,1) != $chr(94)) {
          did -a tnrepldlgnm 69 %_rxrndsc
        }
        inc %_rxrndnum
        goto rxrprepeat
      }
      unset %_rxrndnum
      unset %_rxrndta
      unset %_rxrndsc
      unset %_rxrnxx
    }
  }
  else {
    dialog -v tnrepldlgnm
  }
}

dialog dialogtnreplace {
  title "@Telnet String Replacement"
  size -1 -1 150 119
  option dbu

  tab "&Edit", 50, 1 1 148 116
  tab "&List", 51

  text    "Replace WH&AT:", 1, 8 16 134 8, tab 50
  edit    "", 2, 8 24 134 12, autohs autovs tab 50
  text    "Replace W&ITH:", 3, 8 40 134 8, tab 50
  edit    "", 4, 8 48 134 12, autohs autovs tab 50

  list    69, 8 16 134 52, sort vsbar tab 51

  button  "&Ok", 5, 8 66 32 10, ok tab 50
  button  "&Close", 6, 49 66 32 10, cancel

  edit    "", 10, 8 80 134 10, read tab 50
  text    "Leave WITH empty to delete an existing WHAT.", 8, 8 92 134 8, tab 50
  text    "Use CTRL-K for mIRC colors in WITH.", 9, 8 100 134 8, tab 50
  text    "Use  @N^  in WITH to replace with nothing.", 7, 8 108 134 8, tab 50
                    
  edit    "", 31, 8 80 134 10, read tab 51
  text    "Double click an entry on the list to edit it.", 32, 8 92 134 8, tab 51
  text    "", 33, 8 100 134 8, tab 51
  text    "", 34, 8 108 134 8, tab 51
}

on 1:dialog:tnrepldlgnm:edit:2 {
  var %_rrrxt = $replacecs($did($dname,2).text,$chr(32),$chr(160))
  var %_rrext = $readini %_atelnini replace %_rrrxt
  if (%_rrext != $null) {
    if ($left(%_rrext,1) != $chr(94)) {
      var %_rerndsc = $chr(64) $+ $chr(81) $+ $chr(94)
      var %_rerndta = $replacecs(%_rrext,%_rerndsc,$chr(34))
      %_rerndsc = $chr(64) $+ $chr(83) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(39))
      %_rerndsc = $chr(64) $+ $chr(66) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(2))
      %_rerndsc = $chr(64) $+ $chr(67) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(3))
      did -o $dname 10 1 %_rrrxt --> %_rerndta
      unset %_rerndta
      unset %_rerndsc
    }
    else {
      did -o $dname 10 1 <TRIGGER> %_rrrxt
    }
  }
  else {
    did -o $dname 10 1 $chr(160)
  }
  unset %_rrrxt
  unset %_rrext
}

on 1:dialog:tnrepldlgnm:sclick:69 {
  var %_rrrxt = $did($dname,69,1).sel
  if (%_rrrxt >= 1) {
    %_rrrxt = $did($dname,69,%_rrrxt).text
    var %_rrext = $readini %_atelnini replace %_rrrxt
    if (%_rrext != $null) {
      if ($left(%_rrext,1) != $chr(94)) {
        var %_rerndsc = $chr(64) $+ $chr(81) $+ $chr(94)
        var %_rerndta = $replacecs(%_rrext,%_rerndsc,$chr(34))
        %_rerndsc = $chr(64) $+ $chr(83) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(39))
        %_rerndsc = $chr(64) $+ $chr(66) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(2))
        %_rerndsc = $chr(64) $+ $chr(67) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(3))
        did -o $dname 31 1 %_rerndta
        unset %_rerndsc
        unset %_rerndta
      }
      else {
        did -o $dname 31 1 <TRIGGER>
      }
    }
    else {
      did -o $dname 31 1 $chr(160)
    }
    unset %_rrext
  }
  else {
    did -o $dname 31 1 $chr(160)
  }
  unset %_rrrxt
}

on 1:dialog:tnrepldlgnm:dclick:69 {
  var %_rrrxt = $did($dname,69,1).sel
  if (%_rrrxt >= 1) {
    %_rrrxt = $did($dname,69,%_rrrxt).text
    var %_rrext = $readini %_atelnini replace %_rrrxt
    if (%_rrext != $null && $left(%_rrext,1) != $chr(94)) {
      did -o $dname 2 1 %_rrrxt
      var %_rerndsc = $chr(64) $+ $chr(81) $+ $chr(94)
      var %_rerndta = $replacecs(%_rrext,%_rerndsc,$chr(34))
      %_rerndsc = $chr(64) $+ $chr(83) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(39))
      %_rerndsc = $chr(64) $+ $chr(66) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(2))
      %_rerndsc = $chr(64) $+ $chr(67) $+ $chr(94)
      %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(3))
      did -o $dname 4 1 %_rerndta
      did -o $dname 10 1 %_rrrxt --> %_rerndta
      did -fu $dname 50
      unset %_rerndsc
      unset %_rerndta
    }
    unset %_rrext
  }
  unset %_rrrxt
}

on 1:dialog:tnrepldlgnm:sclick:5 {
  var %_rwithtxt = $replacecs($did($dname,4).text,$chr(32),$chr(160))
  var %_rwhattxt = $replacecs($did($dname,2).text,$chr(32),$chr(160))
  var %_rext = 1
  var %_tnxxreload = 0

  %_rwhattxt = $strip(%_rwhattxt)

  if (%_rwhattxt == $null) {
    goto _trrend
  }

  if ($left(%_rwithtxt,1) == $chr(94)) {
    %_rwithtxt = $chr(64) $+ $chr(78) $+ $chr(94) $+ %_rwithtxt
  }

  %_rext = $readini %_atelnini replace %_rwhattxt

  if (%_rext != $null) {
    %_tnxxreload = 1
    if (%_rwithtxt == $null) {
      echo $colour(action) -a *** DELETING ENTRY: %_rwhattxt --> %_rext
      remini %_atelnini replace %_rwhattxt
      flushini %_atelnini
      goto _trrend
    }
    else {
      echo $colour(action) -a *** CHANGING ENTRY: %_rwhattxt --> %_rext
    }
  }
  else {
    if (%_rwithtxt == $null) {
      echo $colour(action) -a *** Error: Cannot have empty replacement text. Use "@N^" instead.
      goto _trrend
    }
    if ($window(@__TN_DATA_).title != $null) {
        aline @__TN_DATA_ %_rwhattxt
        var %_rerndsc = $chr(64) $+ $chr(81) $+ $chr(94)
        var %_rerndta = $replacecs(%_rwithtxt,%_rerndsc,$chr(34))
        %_rerndsc = $chr(64) $+ $chr(83) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(39))
        %_rerndsc = $chr(64) $+ $chr(66) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(2))
        %_rerndsc = $chr(64) $+ $chr(67) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(3))
        %_rerndsc = $chr(64) $+ $chr(78) $+ $chr(94)
        %_rerndta = $replacecs(%_rerndta,%_rerndsc,$chr(31))
        aline @__TN_DATA_ %_rerndta
        unset %_rerndsc
        unset %_rerndta
    }
  }

  %_rext = $chr(64) $+ $chr(67) $+ $chr(94)
  %_rwithtxt = $replacecs(%_rwithtxt,$chr(3),%_rext)
  %_rext = $chr(64) $+ $chr(66) $+ $chr(94)
  %_rwithtxt = $replacecs(%_rwithtxt,$chr(2),%_rext)
  %_rext = $chr(64) $+ $chr(81) $+ $chr(94)
  %_rwithtxt = $strip($replacecs(%_rwithtxt,$chr(34),%_rext))
  %_rext = $chr(64) $+ $chr(83) $+ $chr(94)
  %_rwithtxt = $replacecs(%_rwithtxt,$chr(39),%_rext)

  echo $colour(action) -a *** REPLACEMENT: %_rwhattxt --> %_rwithtxt

  writeini -n %_atelnini replace %_rwhattxt %_rwithtxt
  flushini %_atelnini

  :_trrend

  if (%_tnxxreload == 1) {
    titlebar @__TN_DATA_ $null
    window -c @__TN_DATA_
    __xxtndatafill
  }

  unset %_rwhattxt
  unset %_rwithtxt
  unset %_rext
  unset %_tnxxreload
}

alias calias {
  if ($dialog(tnaliasdlgnm).title == $null) {
    dialog -m tnaliasdlgnm dialogtnalias
    if ($1 != $null) {
      did -o tnaliasdlgnm 2 1 $1
      if ($2 != $null) {
        did -o tnaliasdlgnm 4 1 $2-
      }
      else {
        var %_aldrandsc = $readini %_atelnini aliases $1

        if (%_aldrandsc != $null) {
          did -o tnaliasdlgnm 4 1 %_aldrandsc
          did -o tnaliasdlgnm 10 1 $1 = %_aldrandsc
        }
        unset %_aldrandsc
      }
    }
    if ($exists(%_atelnini) != $false) {
      var %_alrxrndnum = 1
      var %_alrxrndsc = x
      var %_alrxrndta = %_atelnini
      :rxrprepeat
      %_alrxrndsc = $ini(%_alrxrndta,aliases,%_alrxrndnum)
      if (%_alrxrndsc != $null) {
        did -a tnaliasdlgnm 69 %_alrxrndsc
        inc %_alrxrndnum
        goto rxrprepeat
      }
      unset %_alrxrndnum
      unset %_alrxrndta
      unset %_alrxrndsc
    }
  }
  else {
    dialog -v tnaliasdlgnm
  }
}

dialog dialogtnalias {
  title "@Telnet Alias"
  size -1 -1 150 119
  option dbu

  tab "&Edit", 50, 1 1 148 116
  tab "&List", 51

  text    "&Alias:", 1, 8 16 134 8, tab 50
  edit    "", 2, 8 24 134 12, autohs autovs tab 50
  text    "Co&mmand(s):", 3, 8 40 134 8, tab 50
  edit    "", 4, 8 48 134 12, autohs autovs tab 50

  list    69, 8 16 134 52, sort vsbar tab 51

  button  "&Ok", 5, 8 66 32 10, ok tab 50
  button  "&Close", 6, 49 66 32 10, cancel

  edit    "", 10, 8 80 134 10, read tab 50
  text    "Leave commands empty to delete an existing alias.", 8, 8 92 134 8, tab 50
  text    "Separate multiple commands with backslashes:", 9, 8 100 134 8, tab 50
  text    "    <command 1>\<command 2>\<etc>", 7, 8 108 134 8, tab 50

  edit    "", 31, 8 80 134 10, read tab 51
  text    "Double click an entry on the list to edit it.", 32, 8 92 134 8, tab 51
  text    "", 33, 8 100 134 8, tab 51
  text    "", 34, 8 108 134 8, tab 51
}

on 1:dialog:tnaliasdlgnm:edit:2 {
  var %_alrrrxt = $strip($did($dname,2).text)
  var %_alrrext = $readini %_atelnini aliases %_alrrrxt
  if (%_alrrext != $null) {
    did -o $dname 10 1 %_alrrrxt = %_alrrext
  }
  else {
    did -o $dname 10 1 $chr(160)
    if ($left(%_alrrrxt,1) == $chr(47) || $left(%_alrrrxt,1) == $chr(92)) {
      did -o $dname 2 1 $right(%_alrrrxt,$calc($len(%_alrrrxt) - 1))
    }
  }
  unset %_alrrrxt
  unset %_alrrext
}

on 1:dialog:tnaliasdlgnm:sclick:69 {
  var %_alrrrxt = $did($dname,69,1).sel
  if (%_alrrrxt >= 1) {
    %_alrrrxt = $did($dname,69,%_alrrrxt).text
    var %_alrrext = $readini %_atelnini aliases %_alrrrxt
    if (%_alrrext != $null) {
      did -o $dname 31 1 = %_alrrext
    }
    else {
      did -o $dname 31 1 $chr(160)
    }
    unset %_alrrext
  }
  else {
    did -o $dname 31 1 $chr(160)
  }
  unset %_alrrrxt
}

on 1:dialog:tnaliasdlgnm:dclick:69 {
  var %_alrrrxt = $did($dname,69,1).sel
  if (%_alrrrxt >= 1) {
    %_alrrrxt = $did($dname,69,%_alrrrxt).text
    var %_alrrext = $readini %_atelnini aliases %_alrrrxt
    if (%_alrrext != $null) {
      did -o $dname 2 1 $did($dname,69,$did($dname,69,1).sel).text
      did -o $dname 4 1 %_alrrext
      did -o $dname 10 1 %_alrrrxt = %_alrrext
      did -fu $dname 50
    }
    unset %_alrrext
  }
  unset %_alrrrxt
}

on 1:dialog:tnaliasdlgnm:sclick:5 {
  var %_arwithtxt = $strip($did($dname,4).text)
  var %_arwhattxt = $strip($did($dname,2).text)
  var %_arext = 1
  var %_atnxxreload = 0

  if (%_arwhattxt == $null) {
    goto _trrend
  }

  %_arext = $readini %_atelnini aliases %_arwhattxt

  if (%_arext != $null) {
    %_atnxxreload = 1
    if (%_arwithtxt == $null) {
      echo $colour(action) -a *** DELETING ALIAS: %_arwhattxt = %_arext
      remini %_atelnini aliases %_arwhattxt
      flushini %_atelnini
      goto _trrend
    }
    else {
      echo $colour(action) -a *** REPLACING ALIAS: %_arwhattxt = %_arext
    }
  }
  else {
    if ($left(%_arwhattxt,1) == $chr(47) || $left(%_arwhattxt,1) == $chr(92)) {
      echo $colour(action) -a *** ERROR: Telnet aliases cannot begin with a slash ("/") or a backslash ("\").
      goto _trrend
    }
    if ($gettok(%_arwhattxt,2,32) != $null) {
      echo $colour(action) -a *** ERROR: Aliases cannot contain spaces.
      goto _trrend
    }
    if (%_arwithtxt == $null) {
      goto _trrend
    }
    if ($window(@__TN_ALIASES_).title != $null) {
        aline @__TN_ALIASES_ %_arwhattxt
        aline @__TN_ALIASES_ %_arwithtxt
    }
  }

  echo $colour(action) -a *** TELNET ALIAS: %_arwhattxt = %_arwithtxt

  writeini -n %_atelnini aliases %_arwhattxt %_arwithtxt
  flushini %_atelnini

  :_trrend

  if (%_atnxxreload == 1) {
    titlebar @__TN_ALIASES_ $null
    window -c @__TN_ALIASES_
    __xxtnaliasfill
  }

  unset %_arwhattxt
  unset %_arwithtxt
  unset %_arext
  unset %_atnxxreload
}

alias ctrigger {
  if ($dialog(tntrigdlgnm).title == $null) {
    dialog -m tntrigdlgnm dialogtntrigger
    if ($1 != $null) {
      did -o tntrigdlgnm 2 1 $1
      if ($2 != $null) {
        did -o tntrigdlgnm 4 1 $2-
      }
      else {
        var %_trdrandsc = $readini %_atelnini replace $1

        if (%_trdrandsc != $null) {
          if ($left(%_trdrandsc,1) == $chr(94)) {
            did -o tntrigdlgnm 10 1 $1 >> $right(%_trdrandsc,$calc($len(%_trdrandsc) - 1))
            if ($mid(%_trdrandsc,2,1) == $chr(64)) {
              did -o tntrigdlgnm 12 1 $gettok(%_trdrandsc,2,64)
              %_trdrandsc = $gettok(%_trdrandsc,3,64)
            }
            else {
                %_trdrandsc = $right(%_trdrandsc,$calc($len(%_trdrandsc) - 1))
            }
            did -o tntrigdlgnm 4 1 %_trdrandsc
          }
          else {
            did -o tntrigdlgnm 10 1 <REPLACEMENT> $1
          }
        }
        unset %_trdrandsc
      }
    }
    if ($exists(%_atelnini) != $false) {
      var %_trrxrndnum = 1
      var %_trrxrndsc = x
      var %_trrxrnxx = x
      var %_trrxrndta = %_atelnini
      :rxrprepeat
      %_trrxrndsc = $ini(%_trrxrndta,replace,%_trrxrndnum)
      if (%_trrxrndsc != $null) {
        %_trrxrnxx = $readini %_trrxrndta replace %_trrxrndsc
        if ($left(%_trrxrnxx,1) == $chr(94)) {
          did -a tntrigdlgnm 69 %_trrxrndsc
        }
        inc %_trrxrndnum
        goto rxrprepeat
      }
      unset %_trrxrndnum
      unset %_trrxrndta
      unset %_trrxrndsc
      unset %_trrxrnxx
    }
  }
  else {
    dialog -v tntrigdlgnm
  }
}

dialog dialogtntrigger {
  title "@Telnet Trigger"
  size -1 -1 150 144
  option dbu

  tab "&Edit", 50, 1 1 148 140
  tab "&List", 51

  text    "Look for wh&at:", 1, 8 16 134 8, tab 50
  edit    "", 2, 8 24 134 12, autohs autovs tab 50
  text    "Tr&igger command(s):", 3, 8 40 134 8, tab 50
  edit    "", 4, 8 48 134 12, autohs autovs tab 50
  text    "Limit to &domain (can be empty or partial):", 11, 8 64 134 8, tab 50
  edit    "", 12, 8 72 134 12, autohs autovs tab 50

  list    69, 8 16 134 73, sort vsbar tab 51

  button  "&Ok", 5, 8 90 32 10, ok tab 50
  button  "&Close", 6, 49 90 32 10, cancel

  edit    "", 10, 8 104 134 10, read tab 50
  text    "Leave commands empty to delete an existing trigger.", 8, 8 116 134 8, tab 50
  text    "Separate multiple commands with backslashes (cmd1\cmd2\etc).", 9, 8 124 134 8, tab 50
  text    "You can also trigger mIRC aliases/commands (/cmd).", 7, 8 132 134 8, tab 50

  edit    "", 31, 8 104 134 10, read tab 51
  text    "Double click an entry on the list to edit it.", 32, 8 116 134 8, tab 51
  text    "", 33, 8 124 134 8, tab 51
  text    "", 34, 8 132 134 8, tab 51
}

on 1:dialog:tntrigdlgnm:edit:2 {
  var %_trrrrxt = $replacecs($did($dname,2).text,$chr(32),$chr(160))
  var %_trrrext = $readini %_atelnini replace %_trrrrxt
  if (%_trrrext != $null) {
    if ($left(%_trrrext,1) == $chr(94)) {
      did -o $dname 10 1 %_trrrrxt >> %_trrrext
    }
    else {
      did -o $dname 10 1 <REPLACEMENT> %_trrrrxt
    }
  }
  else {
    did -o $dname 10 1 $chr(160)
  }
  unset %_trrrrxt
  unset %_trrrext
}

on 1:dialog:tntrigdlgnm:sclick:69 {
  var %_trrrrxt = $did($dname,69,1).sel
  if (%_trrrrxt >= 1) {
    %_trrrrxt = $did($dname,69,%_trrrrxt).text
    var %_trrrext = $readini %_atelnini replace %_trrrrxt
    if (%_trrrext != $null) {
      if ($left(%_trrrext,1) == $chr(94)) {
        did -o $dname 31 1 $right(%_trrrext,$calc($len(%_trrrext) - 1))
      }
      else {
        did -o $dname 31 1 <REPLACEMENT>
      }
    }
    else {
      did -o $dname 31 1 $chr(160)
    }
    unset %_trrrext
  }
  else {
    did -o $dname 31 1 $chr(160)
  }
  unset %_trrrrxt
}

on 1:dialog:tntrigdlgnm:dclick:69 {
  var %_trrrrxt = $did($dname,69,1).sel
  if (%_trrrrxt >= 1) {
    %_trrrrxt = $did($dname,69,%_trrrrxt).text
    var %_trrrext = $readini %_atelnini replace %_trrrrxt
    if (%_trrrext != $null && $left(%_trrrext,1) == $chr(94)) {
      if ($mid(%_trrrext,2,1) == $chr(64)) {
        did -o $dname 4 1 $gettok(%_trrrext,3,64)
        did -o $dname 12 1 $gettok(%_trrrext,2,64)
        did -o $dname 10 1 $did($dname,69,$did($dname,69,1).sel).text >> $right(%_trrrext,$calc($len(%_trrrext) - 1))
      }
      else {
        did -o $dname 4 1 $right(%_trrrext,$calc($len(%_trrrext) - 1))
        did -o $dname 12 1 $chr(32)
        did -d $dname 12 1
        did -o $dname 10 1 $did($dname,69,$did($dname,69,1).sel).text >> $right(%_trrrext,$calc($len(%_trrrext) - 1))
      }
      did -o $dname 2 1 $did($dname,69,$did($dname,69,1).sel).text
      did -fu $dname 50
    }
    unset %_trrrext
  }
  unset %_trrrrxt
}

on 1:dialog:tntrigdlgnm:edit:4 {
  var %_xrrrxt = $strip($did($dname,4).text)
  if ($count(%_xrrrxt,$chr(64)) >= 1) {
    %_xrrrxt = $replacecs(%_xrrrxt,$chr(64),$chr(0))
    did -d $dname 4 1
    did -o $dname 4 1 %_xrrrxt
  }
  unset %_xrrrxt
}

on 1:dialog:tntrigdlgnm:edit:12 {
  if ($count($did($dname,12).text,$chr(64)) >= 1) {
    did -d $dname 12 1
    did -o $dname 12 1 $replacecs($did($dname,12).text,$chr(64),$chr(0))
  }
}

on 1:dialog:tntrigdlgnm:sclick:5 {
  var %_trwithtxt = $strip($did($dname,4).text)
  var %_trwhattxt = $replacecs($did($dname,2).text,$chr(32),$chr(160))
  var %_trlimtxt = $replacecs($strip($did($dname,12).text),$chr(64),$chr(0))
  var %_trext = 1
  var %_ztnxxreload = 0

  %_trwhattxt = $strip(%_trwhattxt)

  if (%_trwhattxt == $null) {
    goto _trrend
  }

  if ($count(%_trwithtxt,$chr(64)) >= 1) {
    %_trwithtxt = $replacecs(%_trwithtxt,$chr(64),$chr(0))
  }

  %_trwhattxt = $replacecs(%_trwhattxt,$chr(32),$chr(160))

  if (%_trlimtxt != $null) {
    if (%_trwithtxt != $null) {
      %_trwithtxt = $chr(64) $+ %_trlimtxt $+ $chr(64) $+ %_trwithtxt
    }
  }
  else if ($left(%_trwithtxt,1) == $chr(64)) {
    %_trwithtxt = $right(%_trwithtxt,$calc($len(%_trwithtxt) - 1))
  }

  %_trext = $readini %_atelnini replace %_trwhattxt

  if (%_trext != $null) {
    %_ztnxxreload = 1
    if (%_trwithtxt == $null) {
      echo $colour(action) -a *** DELETING ENTRY: %_trwhattxt >> %_trext
      remini %_atelnini replace %_trwhattxt
      flushini %_atelnini
      goto _trrend
    }
    else {
      echo $colour(action) -a *** CHANGING ENTRY: %_trwhattxt >> %_trext
    }
  }
  else {
    if (%_trwithtxt == $null) {
      goto _trrend
    }
    if ($window(@__TN_DATA_).title != $null) {
        aline @__TN_DATA_ %_trwhattxt
        aline @__TN_DATA_ $chr(94) $+ %_trwithtxt
    }
  }

  echo $colour(action) -a *** TRIGGER: %_trwhattxt >> %_trwithtxt

  writeini -n %_atelnini replace %_trwhattxt $chr(94) $+ %_trwithtxt
  flushini %_atelnini

  :_trrend

  if (%_ztnxxreload == 1) {
    titlebar @__TN_DATA_ $null
    window -c @__TN_DATA_
    __xxtndatafill
  }

  unset %_trwhattxt
  unset %_trwithtxt
  unset %_trlimtxt
  unset %_trext
  unset %_ztnxxreload
}

;-----------------------------------------------------------------------------
; Color sets
;-----------------------------------------------------------------------------

alias _tn1colsetw {

; Black
  set %tncolor.plain 01
; Bright Blue
  set %tncolor.bold 12
; Light grey
  set %tncolor.black 15
; Maroon
  set %tncolor.red 05
; Green
  set %tncolor.green 03
; Orange
  set %tncolor.yellow 07
; Navy
  set %tncolor.blue 02
; Purple
  set %tncolor.magenta 06
; Teal
  set %tncolor.cyan 10
; Dark grey
  set %tncolor.white 14
; Bright red
  set %tncolor.own 04

  echo $(info2) -a *** Custom color set 1 (for white/light background) selected.
}

alias _tn2colsetb {

; Light grey
  set %tncolor.plain 15
; White
  set %tncolor.bold 00
; Navy
  set %tncolor.black 2
; Purple
  set %tncolor.red 06
; Green
  set %tncolor.green 03
; Orange
  set %tncolor.yellow 07
; Teal
  set %tncolor.blue 10
; Bright red
  set %tncolor.magenta 04
; Cyan
  set %tncolor.cyan 11
; Yellow
  set %tncolor.white 08
; Bright blue
  set %tncolor.own 12

  echo $(info2) -a *** Custom color set 2 (for black/dark background) selected.
}

alias _tn3colsetw {

; Black
  set %tncolor.plain 01
; Bright Blue
  set %tncolor.bold 12
; Light grey
  set %tncolor.black 15
; Maroon
  set %tncolor.red 05
; Navy
  set %tncolor.green 02
; Purple
  set %tncolor.yellow 06
; Orange
  set %tncolor.blue 07
; Green
  set %tncolor.magenta 03
; Teal
  set %tncolor.cyan 10
; Dark grey
  set %tncolor.white 14
; Bright red
  set %tncolor.own 04

  echo $(info2) -a *** Custom color set 3 (for white/light background) selected.
}

alias _tn4colsetb {

; Dark grey
  set %tncolor.plain 14
; Light grey
  set %tncolor.bold 15
; Navy
  set %tncolor.black 02
; Purple
  set %tncolor.red 06
; Bright green
  set %tncolor.green 09
; Yellow
  set %tncolor.yellow 08
; Teal
  set %tncolor.blue 10
; Orange
  set %tncolor.magenta 7
; Cyan
  set %tncolor.cyan 11
; White
  set %tncolor.white 00
; Bright blue
  set %tncolor.own 12

  echo $(info2) -a *** Custom color set 4 (for black/dark background) selected.
}

;-----------------------------------------------------------------------------
;   Helper Aliases for mIRC MUD/Telnet Client Script
;-----------------------------------------------------------------------------

; ----------------------------------------------------------------------------
; Write entry to "%_tndescfle".
; ----------------------------------------------------------------------------

alias wdesc {
  if ($1 == $null || $2 == $null) {
    echo $colour(action) -a *** Usage: /wdesc <name> <description>
    halt
  }
  if ($exists(%_tndescfle) != $false) {
    var %_wrrxrndnum = 1
    var %_wrrxrndsc = x
    var %_wrrxrnxx = x
    :wrxrprepeat
    %_wrrxrndsc = $ini(%_tndescfle,replace,%_wrrxrndnum)
    if (%_wrrxrndsc != $null) {
      %_wrrxrnxx = $readini %_tndescfle replace %_wrrxrndsc
      if (%_wrrxrnxx == $1) {
        echo $colour(action) -a >>> $1 = %_wrrxrndsc
        echo $colour(action) -a *** REPLACING ENTRY WITH:
        remini %_tndescfle replace %_wrrxrndsc
        flushini %_tndescfle
      }
      else {
        inc %_wrrxrndnum
        goto wrxrprepeat
      }
    }
    unset %_wrrxrndnum
    unset %_wrrxrndsc
    unset %_wrrxrnxx
  }
  writeini -n %_tndescfle replace $replacecs($2-,$chr(32),$chr(160)) $strip($1)
  flushini %_tndescfle
  echo $colour(action) -a <<< $1 = $2-
  if ($nopath(%_tndescfle) == atelnet.ini) {
    titlebar @__TN_DATA_ $null
    window -c @__TN_DATA_
    __xxtndatafill
  }
  if (%_xxxtrigfle != $null) {
    descf %_xxxtrigfle
    unset %_xxxtrigfle
  }
}

; ----------------------------------------------------------------------------
; Remove entry from "%_tndescfle".
; ----------------------------------------------------------------------------

alias rdesc {
  if ($1 == $null) {
    echo $colour(action) -a *** Usage: /rdesc <name>
    halt
  }
  if ($exists(%_tndescfle) != $false) {
    var %_wrrxrndnum = 1
    var %_wrrxrndsc = x
    var %_wrrxrnxx = x
    :wrxrprepeat
    %_wrrxrndsc = $ini(%_tndescfle,replace,%_wrrxrndnum)
    if (%_wrrxrndsc != $null) {
      %_wrrxrnxx = $readini %_tndescfle replace %_wrrxrndsc
      if (%_wrrxrnxx == $1-) {
        echo $colour(action) -a *** Deleting entry from " $+ %_tndescfle $+ ":
        echo $colour(action) -a >>> $1- = %_wrrxrndsc
        remini %_tndescfle replace %_wrrxrndsc
        flushini %_tndescfle
        unset %_wrrxrndnum
        unset %_wrrxrndsc
        unset %_wrrxrnxx
        if ($nopath(%_tndescfle) == atelnet.ini) {
          titlebar @__TN_DATA_ $null
          window -c @__TN_DATA_
          __xxtndatafill
        }
        if (%_xxxtrigfle != $null) {
          descf %_xxxtrigfle
          unset %_xxxtrigfle
        }
        halt
      }
      else {
        inc %_wrrxrndnum
        goto wrxrprepeat
      }
    }
    unset %_wrrxrndnum
    unset %_wrrxrndsc
    unset %_wrrxrnxx
  }
  echo $colour(action) -a *** Entry " $+ $1- $+ " not found in " $+ %_tndescfle $+ ".
  if (%_xxxtrigfle != $null) {
    descf %_xxxtrigfle
    unset %_xxxtrigfle
  }
}


; ----------------------------------------------------------------------------
; Get entries matching specified text, from "%_tndescfle".
; ----------------------------------------------------------------------------

alias desc {
  if ($1 == $null) {
    echo $colour(action) -a *** Usage: desc <part of name or text>
    halt
  }

  var %_dscdsrch = $replacecs($1-,$chr(32),$chr(160))
  var %_dscdnum = 1
  var %_dscdsc = x
  var %_dscdta = x
  var %_tnmatch = 0

  if ($exists(%_tndescfle) != $false) {
    :gdrepeat

    %_dscdsc = $ini(%_tndescfle,replace,%_dscdnum)
    if (%_dscdsc != $null) {
      inc %_dscdnum
      %_dscdta = $readini %_tndescfle replace %_dscdsc
      if (%_dscdsrch == $chr(42) || $count(%_dscdta,%_dscdsrch) != 0 || $count(%_dscdsc,%_dscdsrch) != 0) {
        echo $colour(action) -a >>> %_dscdta = %_dscdsc
        inc %_tnmatch
      }
      goto gdrepeat
    }
    if (%_tnmatch == 0) {
      echo $colour(action) -a *** No matches found for " $+ %_dscdsrch $+ "  in " $+ %_tndescfle $+ ".
    }
  }
  else {
    echo $colour(action) -a *** File " $+ %_tndescfle $+ " does not exist - can be created by "/wdesc".
  }

  unset %_dscdta
  unset %_dscdsc
  unset %_dscdnum
  unset %_dscdsrch
  unset %_tnmatch

  if (%_xxxtrigfle != $null) {
    descf %_xxxtrigfle
    unset %_xxxtrigfle
  }
}

; ----------------------------------------------------------------------------
; Change file to use
; ----------------------------------------------------------------------------

alias descf {
    if ($1 == $null) {
      echo $colour(action) -a *** Usage: /descf <filename.ext>
      echo $colour(action) -a *** Currently using " $+ %_tndescfle $+ ".
      halt
    }

    set %_tndescfle $1-
    if (%_xxxtrigfle != %_tndescfle) {
      if ($exists(%_tndescfle) != $false) {
        echo $colour(action) -a *** Now using file " $+ %_tndescfle $+ ".
      }
      else {
        echo $colour(action) -a *** File " $+ %_tndescfle $+ " will be created for use by a call to "/wdesc".
      }
    }
    else {
        echo $colour(action) -a ***
    }
}

; ----------------------------------------------------------------------------
; A silly little calculator - not related to the rest, but I like it. ;>
; ----------------------------------------------------------------------------

alias calc {
  if (%_calcans != $null) {
    var %_xcalc = $replace($1-,$chr(97),%_calcans)
    echo $colour(action) -a *** calculator: $replace($1-,$chr(97),%_calcans) = $calc(%_xcalc)
    %_calcans = $calc(%_xcalc)
    unset %_xcalc
  }
  else {
    %_calcans = $calc($1-)
    echo $colour(action) -a *** calculator: $1- = %_calcans
  }
}
