/*

  Here are defined some irc !commands considered essencial to the bot, and as
such, they were not included in a module. They are:

!modlist
List all loaded modules.

!modadd path
Load the module at the given <path>.

!moddel name
Unload the module with <name>, this must be a name returned by !modlist.

!quit [msg]
Make all bots in the current process quit with <msg>, else uses the default.

!set option [value]
If <value> is specified, sets <option> to it. Otherwise just show the content
of <option>. The available options (variables) depend on the modules loaded,
refer to their documentation for further help (note that some options are
part of the main code too).

!loadconf [filename]
Reload the current configuration file or use <filename>. Note that the changes
only take effect after reloading the module(s). USE WITH CARE, in particular,
don't change the bots' order (if multiple bots are defined of course).

*/

#include "scriptcmd.h"

#define SOURCE s->script->source
#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

// !modlist
void
scriptcmd_modlist (CServer *s)
{
  if (CMD[3][9] == 0)
    {
      CBot::module_type *buf = s->bot->module_list;
      if (buf == NULL)
        my_strncpy(BUF[1], "No modules loaded.", MSG_SIZE);
      else
        {
          my_strncpy(BUF[1], "Loaded Modules: ", MSG_SIZE);
          while (buf != NULL)
            {
              if (buf->m != NULL)
                if (buf->m->module->name != NULL)	// if a name is defined
                  {
                    if (strlen (BUF[1]) + strlen (buf->m->module->name) + 2 < MSG_SIZE)
                        snprintf (BUF[1] + strlen (BUF[1]),
                                  MSG_SIZE - strlen (BUF[1]), "%s ",
                                  buf->m->module->name);
                  }
                else				// else show "<unnamed>"
                  {
                    if (strlen (BUF[1]) + strlen ("<unnamed>") + 2 < MSG_SIZE)
                        snprintf (BUF[1] + strlen (BUF[1]),
                                  MSG_SIZE - strlen (BUF[1]), "%s ",
                                  "<unnamed>");
                  }
              buf = buf->next;
            }
        }
      SEND_TEXT (DEST, BUF[1]);
    }
}

// !modadd
void
scriptcmd_modadd (CServer *s)
{
  strsplit (CMD[3] + 8, BUF, 1);
  if (BUF[1][0] != 0 && CMD[3][7] == ' ')
    {
      CModule *mod = s->bot->add_module (BUF[1]);
      if (mod != NULL && s->bot->conf != NULL)
        {
          CServer *server = NULL;
          const char *bufline;
          char buf[10][MSG_SIZE+1];
          int server_cur = -1;

          s->bot->conf->strip_text_crlf ();
          s->bot->conf->rewind_text ();
          while ( (bufline = s->bot->conf->get_line ()) != NULL)
            {
              if (bufline[0] != 0 && bufline[0] != '#' && bufline[0] != 10)
                {
                  strsplit (bufline, buf, 1);
                  if (strcasecmp (buf[1], "server") == 0
                      || strcasecmp (buf[1], "bot") == 0)
                    {
                      server_cur++;
                      if (server_cur < s->bot->server_num)
                        server = s->bot->servers[server_cur];
                    }

                  if (server != NULL)
                    {
                      if (strcasecmp (buf[1], "set") == 0)
                        {
                          strsplit (bufline, buf, 2);
                          if (!s->vars->var_set (buf[2], buf[3]))
                            {
                              snprintf (buf[4], MSG_SIZE, "inexistant variable \"%s\".",
                                        buf[2]);
                              s->bot->conf_warn (buf[4]);
                            }
                        }
                      mod->module->conf (server, bufline);
                    }
                }
            }
          SEND_TEXT (DEST, "Module loaded.");
        }
      else
        SEND_TEXT (DEST, "Failed to load module.");
    }
  else
    SEND_TEXT (DEST, "!modadd == !modadd path");
}

// !moddel
void
scriptcmd_moddel (CServer *s)
{
  strsplit (CMD[3] + 8, BUF, 1);
  if (BUF[1][0] != 0 && CMD[3][7] == ' ')
    {
      if (s->bot->del_module (BUF[1]))
        SEND_TEXT (DEST, "Module unloaded.");
      else
        SEND_TEXT (DEST, "Failed to unload module.");
    }
  else
    SEND_TEXT (DEST, "!moddel == !moddel name");
}

// !quit
void
scriptcmd_quit (CServer *s)
{
  strsplit (CMD[3] + 6, BUF, 0);
  for (int i = 0; i < s->bot->server_num; i++)
    s->bot->servers[i]->irc_quit (BUF[1]);
  s->bot->irc_exit ();
}

// !set
void
scriptcmd_set (CServer *s)
{
  strsplit (CMD[3] + 5, BUF, 1);

  if (BUF[1][0] != 0)
    {
      if (BUF[2][0] != 0)
        {
          if (s->vars->var_set (BUF[1], BUF[2]))
            {
              s->vars->var_get (BUF[1], BUF[2], MSG_SIZE);
              snprintf (BUF[3], MSG_SIZE, "Value of \"%s\" changed to \"%s\".",
                        BUF[1], BUF[2]);
              SEND_TEXT (DEST, BUF[3]);
            }
          else
            SEND_TEXT (DEST, "Invalid option.");
        }
      else
        {
          if (s->vars->var_get (BUF[1], BUF[2], MSG_SIZE))
            {
              snprintf (BUF[3], MSG_SIZE, "Value of \"%s\" is \"%s\".",
                        BUF[1], BUF[2]);
              SEND_TEXT (DEST, BUF[3]);
            }
          else
            SEND_TEXT (DEST, "Invalid option.");
        }
    }
  else
    SEND_TEXT (DEST, "!set == !set option [value]");
}

// !loadconf
void
scriptcmd_loadconf (CServer *s)
{
  strsplit (CMD[3] + 10, BUF, 1);

  if (BUF[1][0] != 0)
    {
      my_strncpy (s->bot->conf_file, BUF[1], FILE_SIZE);
      snprintf (BUF[2], MSG_SIZE, "Configuration file set to \"%s\".",
                s->bot->conf_file);
      SEND_TEXT (DEST, BUF[3]);
    }
  if (s->bot->conf != NULL)
    delete s->bot->conf;
  s->bot->conf = new CText ();
  if (s->bot->conf->read_file (s->bot->conf_file))
    SEND_TEXT (DEST, "Configuration loaded.");
  else
    SEND_TEXT (DEST, "Couldn't load configuration!");
}

