/**************************************************

         mbot  -  mirage irc bot
         
***************************************************/

#include "mbot.h"

int 
main (int argc, char *argv[])
{
  printf ("\n    %s\n\n", VERSION_STRING);

  random_init ();

//  signal (SIGTERM, SIG_IGN);	gotta improve this!
  signal (SIGHUP, SIG_IGN);
  signal (SIGPIPE, SIG_IGN);

  CBot* bot;
  bot = new CBot ();

  bot->parse_cmd (argc, argv);
  bot->parse_conf ();
  bot->check_pid ();
  bot->server_info ();

  if (!bot->debug)
    {
      int i = fork ();
      if (i == -1)
        {
          printf (" ERROR: can't fork into background.\n\n");
          exit (1);
        }
      if (i != 0)
        {
          printf (" Running in background with PID %d.\n\n", i);
          exit (0);
        }
    }

  bot->write_pid ();

  bot->work ();

}

