#include "CVar.h"

CVar::CVar (CServer *server)
{ 
  s = server;
  vars = NULL; 
}

CVar::~CVar (void)
{
  var_delall ();
}

// check if a var with <name> exists and return its pointer, NULL if not found
struct CVar::var_type *
CVar::var_exist (char *name)
{
  struct var_type *buf = vars;
  while (buf != NULL)
    {
      if (strcasecmp (name, buf->name) == 0)
        return buf;
      buf = buf->next;
    }
  return NULL;
}

// add a var with <name> and <handler>, return 0 if <name> is in use
bool
CVar::var_add (char *name, void (*handler)(CServer *, const char *, char *, size_t))
{
  if (var_exist (name) != NULL)
    return 0;

  struct var_type *buf = vars;
  vars = new var_type;
  my_strncpy (vars->name, name, VAR_SIZE);
  vars->handler = handler;
  vars->next = buf;

  return 1;
}

// delete a var with <name>, return 0 if nonexistant
bool
CVar::var_del (char *name)
{
  struct var_type *buf, *buf2;
  if (vars != NULL)			// check if it's the first
    {
      if (strcasecmp (name, vars->name) == 0)
        {
          buf = vars->next;
          delete vars;
          vars = buf;
          return 1;
        }
      buf = vars;
      while (buf->next != NULL)		// nope, try the others
        {
          if (strcasecmp (name, buf->next->name) == 0)
            {
              buf2 = buf->next->next;
              delete buf->next;
              buf->next = buf2;
              return 1;
            }
          buf->next = buf->next->next;
        }
    }
  return 0;
}

// delete all variables
void
CVar::var_delall (void)
{
  struct var_type *buf;
  while (vars != NULL)
    {
      buf = vars->next;
      delete vars;
      vars = buf;
    }
}

// put the value of var <name> in <dest> with size <n>, return 0 if nonexistant
bool
CVar::var_get (char *name, char *dest, size_t n)
{
  struct var_type *buf = var_exist (name);
  if (buf == NULL)
    return 0;
  buf->handler (s, name, dest, n);
  return 1;
}

// set the value of var <name> to <src>, return 0 if nonexistant
bool
CVar::var_set (char *name, char *src)
{
  struct var_type *buf = var_exist (name);
  if (buf == NULL)
    return 0;
  buf->handler (s, name, src, 0);
  return 1;
}

