#include "CServices.h"

CServices::CServices (CServer *server)
{
  exist = 0;
  identified = 0;
  services_privmsg = 0;
  *nickserv_pass = *nickserv_mask = *nickserv_auth = 0;
  s = server;
}

CServices::~CServices (void)
{
}

void
CServices::irc_services (const char *service, const char *msg)
{
  if (services_privmsg)
    s->irc_privmsg (service, msg);
  else
    {
      snprintf (bufserv, MSG_SIZE, "%s %s", service, msg);
      s->irc_write (bufserv);
    }
}

void
CServices::irc_nickserv (const char *msg)
{
  irc_services (NICKSERV, msg);
}

void
CServices::nick_identify (void)
{
  snprintf (buf, MSG_SIZE, "identify %s", nickserv_pass);
  irc_nickserv (buf);
}

void
CServices::irc_chanserv (const char *msg)
{
  irc_services (CHANSERV, msg);
}

void
CServices::chan_invite (const char *channel)
{
  snprintf (buf, MSG_SIZE, "invite %s", channel);
  irc_chanserv (buf);
}

void
CServices::chan_unban (const char *channel)
{
  snprintf (buf, MSG_SIZE, "unban %s", channel);
  irc_chanserv (buf);
}

void
CServices::chan_op (const char *channel, const char *nick)
{
  snprintf (buf, MSG_SIZE, "op %s %s", channel, nick);
  irc_chanserv (buf);
}

void
CServices::chan_deop (const char *channel, const char *nick)
{
  snprintf (buf, MSG_SIZE, "deop %s %s", channel, nick);
  irc_chanserv (buf);
}

