#include "CScript.h"

CScript::CScript (CServer *server)
{
  for (int i = 0; i <= LEVEL_MAX; i++)
    cmds[i] = NULL;
  replies = NULL;
  events = NULL;
  timers = NULL;
  s = server;
  source[0] = 0;
  dest[0] = 0;
  bind_cmd (scriptcmd_modlist, 10, "!modlist");
  bind_cmd (scriptcmd_modadd, 10, "!modadd");
  bind_cmd (scriptcmd_moddel, 10, "!moddel");
  bind_cmd (scriptcmd_quit, 10, "!quit");
  bind_cmd (scriptcmd_set, 10, "!set");
  bind_cmd (scriptcmd_loadconf, 10, "!loadconf");
}

CScript::~CScript (void)
{
  delete_cmds ();
  delete_f_recursive (replies);
  delete_f_recursive (events);
}

void
CScript::bind_cmd (void (*action)(CServer *), int level, const char *cmd)
{
  if (level <= LEVEL_MAX)
    {
      cmd_type *c = cmds[level];
      cmds[level] = new cmd_type;
      cmds[level]->action = action;
      my_strncpy (cmds[level]->cmd, cmd, 15);
      cmds[level]->size = strlen (cmds[level]->cmd);
      cmds[level]->next = c;
    }
}

bool
CScript::unbind_cmd (const char *cmd)
{
  cmd_type *c, *c_previous;
  for (int i = 0; i <= LEVEL_MAX; i++)
    if (cmds[i] != NULL)
      {
        c = cmds[i];
        if (strcasecmp (cmd, c->cmd) == 0)	// if it's the first
          {
            cmds[i] = c->next;
            delete c;
            return 1;
          }
        c_previous = c;
        c = c->next;
        while (c != NULL)			// else checks the next
          if (strcasecmp (cmd, c->cmd) == 0)
            {
              c_previous->next=c->next;
              delete c;
              return 1;
            }
          else 
            {
              c_previous=c;
              c=c->next;
            }
      } 
  return 0;
}

void
CScript::add_reply (void (*f)(CServer *))
{
  f_type *f_buf = replies;
  replies = new f_type;
  replies->f = f;
  replies->next = f_buf;
}

void
CScript::del_reply (void (*f)(CServer *))
{
  f_type *f_temp;
  if (replies != NULL)				// check if it's the first
    if (replies->f == f)
      {
        f_temp = replies->next;
        delete replies;
        replies = f_temp;
        return;
      }
  f_type *buf = replies;
  while (buf->next != NULL)			// nope, try the others
    {
      if (buf->next->f == f)
        {
          f_temp = buf->next->next;
          delete buf->next;
          buf->next = f_temp;
          return;
        }
      buf = buf->next;
    }
}

void
CScript::add_event (void (*f)(CServer *))
{
  f_type *f_buf = events;
  events = new f_type;
  events->f = f;
  events->next = f_buf;
}

void
CScript::del_event (void (*f)(CServer *))
{
  f_type *f_temp;
  if (events != NULL)				// check if it's the first
    if (events->f == f)
      {
        f_temp = events->next;
        delete events;
        events = f_temp;
        return;
      }
  f_type *buf = events;
  while (buf->next != NULL)			// nope, try the others
    {
      if (buf->next->f == f)
        {
          f_temp=buf->next->next;
          delete buf->next;
          buf->next=f_temp;
          return;
        }
      buf=buf->next;
    }
}

void
CScript::add_timer (void (*f)(CServer *))
{
  f_type *f_buf = timers;
  timers = new f_type;
  timers->f = f;
  timers->next = f_buf;
}

void
CScript::del_timer (void (*f)(CServer *))
{
  f_type *f_temp;
  if (timers != NULL)				// check if it's the first
    if (timers->f == f)
      {
        f_temp = timers->next;
        delete timers;
        timers = f_temp;
        return;
      }
  f_type *buf = timers;
  while (buf->next != NULL)			// nope, try the others
    {
      if (buf->next->f == f)
        {
          f_temp=buf->next->next;
          delete buf->next;
          buf->next=f_temp;
          return;
        }
      buf=buf->next;
    }
}

void
CScript::send_partyline (const char *msg)
{
  for (int i = 0; i < DCC_NUM; i++)		// check all dccs
    if (DCCS[i]->status == DCC_CHAT)		// if it's a dcc chat
      DCCS[i]->dcc_chat_write (msg);		// send to it
}

void
CScript::send_text (const char *to, const char *msg)
{
  if (CMD[2][0] >= '0' && CMD[2][0] <= '9' && strcmp (source, dest) == 0)
    DCCS[atoi(CMD[2])]->dcc_chat_write (msg);
  else
    s->irc_privmsg (to, msg);
}

void
CScript::irc_reply (void)
{
  if (strcmp (CMD[1], INIT) == 0)
    reply_init ();
  else if (strcmp (CMD[1], RPL_NOTOPIC) == 0)
    reply_notopic ();
  else if (strcmp (CMD[1], RPL_TOPIC) == 0)
    reply_topic ();
  else if (strcmp (CMD[1], RPL_WHOREPLY) == 0)
    reply_whoreply ();
  else if (strcmp (CMD[1], RPL_ENDOFWHO) == 0)
    reply_endofwho ();
  else if (strcmp (CMD[1], ERR_NOSUCHNICK) == 0)
    reply_nosuchnick ();
  else if (strcmp (CMD[1], ERR_NOSUCHCHANNEL) == 0)
    reply_nosuchchannel ();
  else if (strcmp (CMD[1], ERR_TOOMANYCHANNELS) == 0)
    reply_toomanychannels ();
  else if (strcmp (CMD[1], ERR_UNKNOWNCOMMAND) == 0)
    reply_unknowncommand ();
  else if (strcmp (CMD[1], ERR_NICKNAMEINUSE) == 0)
    reply_nicknameinuse ();
  else if (strcmp (CMD[1], ERR_INVITEONLYCHAN) == 0)
    reply_inviteonlychan ();
  else if (strcmp (CMD[1], ERR_BANNEDFROMCHAN) == 0)
    reply_bannedfromchan ();
  else if (strcmp (CMD[1], ERR_CHANOPRIVSNEEDED) == 0)
    reply_chanoprivsneeded ();

  f_type *f_buf = replies;
  while (f_buf != NULL)
    {
      f_buf->f (s);
      f_buf = f_buf->next;
    }
}

void
CScript::reply_init (void)
{
  // identify, join channels, set away
  if (s->services->exist && !s->services->identified)
    {
      s->services->nick_identify ();
      s->services->identified = 1;
    }
  for (int i = 0; i < s->channel_num; i++)
    CHANNELS[i]->irc_join ();
  if (s->away[0] != 0)
    s->irc_away (s->away);
}

void
CScript::reply_ison (void)
{
  // check if the services are active
  if (strcmp (CMD[3], NICKSERV) == 0)
    s->services->exist = 1;
}

void
CScript::reply_notopic (void)
{
  int i = CHANNEL_INDEX (CMD[3]);
  if (i != -1)
    CHANNELS[i]->topic[0] = 0;		// channel has no topic set
}

void
CScript::reply_topic (void)
{
  int i = CHANNEL_INDEX (CMD[3]);
  if (i != -1)
    my_strncpy (CHANNELS[i]->topic, CMD[4], TOPIC_SIZE); // channel's topic
}

void
CScript::reply_whoreply (void)
{
  int i = CHANNEL_INDEX (CMD[3]);
  if (i != -1)		// add user to channel
    {
      sprintf (buf[0], "%s!%s@%s", CMD[7], CMD[4], CMD[5]);
      CHANNELS[i]->user_add (buf[0], CMD[8][1] == '@', CMD[8][1] == '+');

      if (CHANNELS[i]->kick_nick[0] != 0)      // if the bot was kicked by him
        if (strcasecmp (CHANNELS[i]->kick_nick, CMD[7]) == 0)
          {
            CHANNELS[i]->irc_kick (CMD[7], "");       // kick him back
            CHANNELS[i]->kick_nick[0] = 0;
          }
    }
}

void
CScript::reply_endofwho (void)
{
  int i = CHANNEL_INDEX (CMD[3]);
  if (i != -1)
    if (CHANNELS[i]->kick_nick[0] != 0)
      CHANNELS[i]->kick_nick[0] = 0;	// stop waiting for that nick
}

void
CScript::reply_nosuchnick (void)
{
  // check if services are missing
  if (strcmp (CMD[3], NICKSERV) == 0
      || strcmp (CMD[3], CHANSERV) == 0
      || strcmp (CMD[3], MEMOSERV) == 0
      || strcmp (CMD[3], OPERSERV) == 0)
    s->services = 0;
}

void
CScript::reply_nosuchchannel (void)
{
  // happens with an invalid name in !join or .conf file
  s->channel_del (CMD[3]);
}

void
CScript::reply_toomanychannels (void)
{
  s->channel_del (CMD[3]);
}

void
CScript::reply_unknowncommand (void)
{
  if (strcmp (CMD[3], NICKSERV) == 0
      || strcmp (CMD[3], CHANSERV) == 0
      || strcmp (CMD[3], MEMOSERV) == 0
      || strcmp (CMD[3], OPERSERV) == 0)
    s->services = 0;
}

void
CScript::reply_nicknameinuse (void)
{
  // nick in use, therefore another copy of the bot is running, so exit
  snprintf (buf[0], MSG_SIZE, "ERROR: Nick %s already in use, disconnecting.", s->nick);
  s->write_botlog (buf[0]);
  s->irc_restart ();
  s->irc_connect ();
}

void
CScript::reply_inviteonlychan (void)
{
  if (s->services->exist)
    {
      int i = CHANNEL_INDEX (CMD[3]);
      if (i != -1)
        {
          s->services->chan_invite (CMD[3]);
          sleep (1);
          CHANNELS[i]->irc_join ();
        }
    }
}

void
CScript::reply_bannedfromchan (void)
{
  if (s->services->exist)
    {
      int i = CHANNEL_INDEX (CMD[3]);
      if (i != -1)
        {
          s->services->chan_unban (CMD[3]);
          CHANNELS[i]->irc_join ();
        }
    }
}

void
CScript::reply_chanoprivsneeded (void)
{
  if (s->services->exist)
    s->services->chan_op (CMD[3], s->nick);
}


void
CScript::irc_event (void)
{
  if (strcmp (CMD[0],"PING") == 0)
    event_ping ();
  else if (strcmp (CMD[0],"ERROR") == 0)
    event_error ();
  else if (strcmp (CMD[1],"NOTICE") == 0)
    event_notice ();
  else if (strcmp (CMD[1], "JOIN") == 0)
    event_join ();
  else if (strcmp (CMD[1], "QUIT") == 0)
    event_quit ();
  else if (strcmp (CMD[1], "NICK") == 0)
    event_nick ();
  else if (strcmp (CMD[1], "KICK") == 0)
    event_kick ();
  else if (strcmp (CMD[1], "PART") == 0)
    event_part ();
  else if (strcmp (CMD[1], "MODE") == 0)
    event_mode ();
  else if (strcmp (CMD[1], "PRIVMSG") == 0)
    event_privmsg ();
  else if (strcmp (CMD[1], "TOPIC") == 0)
    event_topic ();

   f_type *f_buf=events;
   while (f_buf != NULL)
     {
       f_buf->f (s);
       f_buf = f_buf->next;
     }
}

void
CScript::event_ping (void)
{
  s->irc_pong (CMD[1]);
  if (s->services->exist && !s->services->identified)
    {
      s->services->nick_identify ();
      s->services->identified = 1;
    }
  for (int i = 0; i < s->channel_num; i++)
    if (!CHANNELS[i]->joined)
      CHANNELS[i]->irc_join ();
}

void
CScript::event_error (void)
{
  snprintf (buf[0], MSG_SIZE, "ERROR from server: %s", CMD[1]);
  s->write_botlog (buf[0]);
  s->irc_restart ();
  s->host_current = s->host_current->next;
  s->last_try = s->time_now;	// wait TIME_RETRY before connecting
  s->irc_connect ();
}

void
CScript::event_notice (void)
{
  // to when nickserv restarts
  if (strcasecmp (CMD[0], s->services->nickserv_mask) == 0
      && strncasecmp (CMD[3], s->services->nickserv_auth, strlen (s->services->nickserv_auth)) == 0)
    {
      s->services->exist = 1;
      s->services->nick_identify ();
    }
}

void
CScript::event_join (void)
{
  mask2nick (CMD[0], buf[0]);
  int level = (USERS == NULL ? 0 : USERS->mask_level (CMD[0]));
  int chan_num = CHANNEL_INDEX (CMD[2]);

  if (chan_num != -1)
    {
      CHANNELS[chan_num]->user_add (CMD[0], 0, 0);	// add it to the list

      if (strcmp(buf[0], s->nick) == 0)			// when the bot joins
        {
          CHANNELS[chan_num]->joined = 1;
          s->irc_who (CMD[2]);			// get users
        }

      if (level < 0)				// shitlist
        {
          CHANNELS[chan_num]->irc_deopban(buf[0],
                              USERS->users[USERS->mask_index (CMD[0])].mask);
          CHANNELS[chan_num]->irc_kick(buf[0],
                              USERS->users[USERS->mask_index (CMD[0])].msg);
        }

      if (level > 0)				// welcome msg
        {
          int i = USERS->mask_index (CMD[0]);
          if (USERS->users[i].msg[0] != 0)
            send_text (CMD[2], USERS->users[i].msg);
        }

      if (level >= 5)				// op
        CHANNELS[chan_num]->irc_op (buf[0]);
    }
}

void
CScript::event_quit (void)
{
  int level = (USERS == NULL ? 0 : USERS->mask_level (CMD[0]));
  int i, i2;
  mask2nick (CMD[0], buf[0]);

  for (i = 0; i < s->channel_num; i++)		// search in all channels
    {
      i2 = CHANNELS[i]->user_index (buf[0]);
      if (i2 != -1)				// if it was here  
        CHANNELS[i]->user_del (buf[0]);		// delete
    }

  if (level > 0)				// deactivate id
    USERS->set_id (CMD[0], 0);
}

void
CScript::event_nick (void)
{
  int level = (USERS == NULL ? 0 : USERS->mask_level (CMD[0]));
  int i;
  // build new mask
  mask2nick (CMD[0], buf[0]);
  mask2user (CMD[0], buf[1]);
  mask2host (CMD[0], buf[2]);
  snprintf (buf[3], MSG_SIZE, "%s!%s@%s", CMD[2], buf[1], buf[2]);

  for (i = 0; i < s->channel_num; i++)	// refresh in all channels
    CHANNELS[i]->user_change_nick (buf[0], buf[3]);

  if (level != 0)				// deactivate id
    USERS->set_id (CMD[0], 0);

  if (strcasecmp (buf[0], s->nick) == 0)	// check if bot's nick changed
    strcpy (s->nick, CMD[2]);

  if ((USERS == NULL ? 0 : USERS->mask_level (buf[3])) < 0)	// shitlist
    {
      int user_index = USERS->mask_index (buf[3]);
      for (i = 0; i < s->channel_num; i++)		// search all channels
        if (CHANNELS[i]->user_index (CMD[2]) != -1)	// if it's there
          {
            CHANNELS[i]->irc_deopban (CMD[2], USERS->users[user_index].mask);
            CHANNELS[i]->irc_kick (CMD[2], USERS->users[user_index].msg);
          }
    }
}

void
CScript::event_kick (void)
{
  int chan_num = CHANNEL_INDEX (CMD[2]);

  if (chan_num != -1)				// should never fail
    {
      mask2nick(CMD[0], buf[0]);

      CHANNELS[chan_num]->user_del (CMD[3]);	// delete kicked user

      if (strcmp (CMD[3], s->nick) == 0)		// if bot is kicked
        {
          for (int i = 0; CHANNELS[chan_num]->user_num > i; i++)
            delete CHANNELS[chan_num]->users[i];	// delete all users
          CHANNELS[chan_num]->user_num = 0;
          CHANNELS[chan_num]->joined = 0;		// the bot is out
          strcpy (CHANNELS[chan_num]->kick_nick, buf[0]);  // try to kick the other
          CHANNELS[chan_num]->irc_join ();		// join channel
        }
    }
}

void
CScript::event_part (void)
{
  int chan_num = CHANNEL_INDEX (CMD[2]);

  if (chan_num != -1)			// doesn't happen when the bot !part
    {
      mask2nick (CMD[0], buf[0]);

      if (strcmp (buf[0], s->nick) == 0)		// if the bot parts
        {
          for (int i = 0; CHANNELS[chan_num]->user_num > 0; i++)
            delete CHANNELS[chan_num]->users[i];	// delete all users
          CHANNELS[chan_num]->user_num = 0;
          CHANNELS[chan_num]->joined = 0;		// the bot is out
        }
      else
        CHANNELS[chan_num]->user_del (buf[0]);		// delete the user
    }
}

void
CScript::event_mode (void)
{
  int chan_num = CHANNEL_INDEX (CMD[2]);

  if (chan_num != -1)				// should never fail
    {
      u_char mode = 0, pos = 0;
      mask2nick (CMD[0], buf[0]);

      for (int i = 0; i < (int)strlen (CMD[3]); i++)
        switch (CMD[3][i])
          {
            case '-':
              mode = 0;
              break;
            case '+':
              mode = 1;
              break;
            case 'o':
              if (!mode)
                {
                  CHANNELS[chan_num]->user_change_op (CMD[4+pos], 0);
                  if (strcasecmp (CMD[4+pos], s->nick) == 0)	// op the bot
                    {
                      s->services->chan_op (CMD[2], s->nick);
                      mask2nick (CMD[0], buf[0]);
                      s->services->chan_deop (CMD[2], buf[0]);// deop the other
                    }
                }
              else
                CHANNELS[chan_num]->user_change_op (CMD[4+pos], 1);
            pos++;
            break;
          case 'b':
            pos++; 
            break;
          case 'v':
            if (!mode)
              CHANNELS[chan_num]->user_change_voice (CMD[4+pos], 0);
            else
              CHANNELS[chan_num]->user_change_voice (CMD[4+pos], 1);
            pos++;
            break;
          default:		// irc protocol changed?
            pos++;
       }
    }
}

void
CScript::event_privmsg (void)
{
  int level = (USERS == NULL ? 0 : USERS->mask_level(CMD[0]));
  mask2nick (CMD[0], source);
  if (CMD[2][0] != '#')
    mask2nick (CMD[0], dest);
  else
    strcpy (dest, CMD[2]);
  strcpy (CMD[3], CMD[3]+num_spaces (CMD[3]));	// remove spaces from beginning

  u_int size = num_notspaces(CMD[3]);
  for (int i = 0; i <= level; i++)		// check the binded commands
    {
      cmd_type *c = cmds[i];
      while (c != NULL)
        // if found
        if (strncasecmp (c->cmd, CMD[3], c->size) == 0 && size == c->size)
          {
            c->action (s);				// execute
            return;
          }
        else
          c = c->next;
    }

  if (CMD[2][0] >= '0' && CMD[2][0] <= '9')	// if it's a dcc chat
    {
      sprintf (buf[8], "<%s> %s", source, CMD[3]);
      send_partyline (buf[8]);
    }
}

void
CScript::event_topic (void)
{
  int i = CHANNEL_INDEX (CMD[2]);
  if (i != -1)
    my_strncpy (CHANNELS[i]->topic, CMD[3], TOPIC_SIZE); // channel's topic
}

// delete all commands
void
CScript::delete_cmds (void)
{
  cmd_type *c, *c2;
  for (int i = 0; i <= LEVEL_MAX; i++)
    {
      c = cmds[i];
      while (c != NULL)
        {
          c2 = c->next;
          delete c;
          c = c2;
        }
      cmds[i] = NULL; 
    }
}

// delete all f_types recursively, from <f>
void
CScript::delete_f_recursive (f_type *f)
{
  f_type *f_temp;
  while (f != NULL)
    {
      f_temp = f->next;
      delete f;
      f = f_temp;
    }
}

