#include "CChannel.h"

CChannel::CChannel (const char *channel, const char *ckey, CServer *ptr)
{
  int i;
  my_strncpy (name, channel, CHANNEL_SIZE);
  my_strncpy (key, ckey, CHANNEL_KEY_SIZE);
  topic[0] = 0;
  s = ptr;
  last_msg[0] = 0;
  last_mask[0] = 0;
  msg_num = 0;
  mask_num = 0;
  warn_num = 0;
  joined = 0;
  kick_nick[0] = last_deleted_nick[0] = 0;
  for (i = 0; i < C_USERS_MAX; i++)
    users[i] = NULL;
  user_num = 0;
}

CChannel::~CChannel (void)
{
  for (int i = 0; i < user_num; i++)		// delete all users
    delete users[i];
  user_num = 0;
}

void
CChannel::irc_join (void)
{
  snprintf (buf, MSG_SIZE, "JOIN %s %s", name, key);
  s->irc_write (buf);
}

void
CChannel::irc_part (void)
{
  sprintf (buf, "PART %s", name);
  s->irc_write (buf);
}

void
CChannel::irc_topic (const char *t)
{
  snprintf (buf, MSG_SIZE, "TOPIC %s :%s", name, t);
  s->irc_write (buf);
}

void
CChannel::irc_invite (const char *nick)
{
  snprintf (buf, MSG_SIZE, "INVITE %s %s", nick, name);
  s->irc_write (buf);
}

void
CChannel::irc_kick (const char *nick, const char *reason)
{
  snprintf (buf, MSG_SIZE, "KICK %s %s :", name, nick);
  if (reason[0] == 0)
    my_strncpy (buf + strlen (buf), kicks[random_num (kicks_num)],
                MSG_SIZE - strlen (buf));
  else 
    my_strncpy (buf + strlen (buf), reason, MSG_SIZE - strlen (buf));
  s->irc_write (buf);
}

void
CChannel::irc_mode (const char *mode, const char *data)
{
  snprintf (buf, MSG_SIZE, "MODE %s %s %s", name, mode, data);
  s->irc_write (buf);
}

void
CChannel::irc_op (const char *nick)
{
  irc_mode ("+o", nick);
}

void
CChannel::irc_deop (const char *nick)
{
  irc_mode ("-o", nick);
}

void
CChannel::irc_voice (const char *nick)
{
  irc_mode ("+v", nick);
}

void
CChannel::irc_devoice (const char *nick)
{
  irc_mode ("-v", nick);
}

void
CChannel::irc_deopban (const char *nick, const char *mask)
{
  snprintf (buf2, MSG_SIZE, "%s %s", nick, mask);
  irc_mode ("-o+b", buf2);
}

void
CChannel::irc_ban_nick (const char *nick)
{
  int i = user_index (nick);
  if (i != -1)
    {
      make_generic_mask (users[i]->mask, buf2);
      irc_ban_mask (buf2);
    }
}

void
CChannel::irc_ban_mask (const char *mask)
{
  irc_mode ("+b", mask);
}

void
CChannel::irc_unban_nick (const char *nick)
{
  int i = user_index (nick);
  if (i != -1)
    {
      make_generic_mask (users[i]->mask, buf2);
      irc_unban_mask (buf2);
    }
}

void
CChannel::irc_unban_mask (const char *mask)
{
  irc_mode ("-b", mask);
}

// return the nick's position on the list, -1 if nonexistant
int
CChannel::user_index (const char *nick)
{
  for (int i = 0; i < user_num; i++)
    if (strcasecmp (users[i]->nick, nick) == 0)
      return i;
  return -1;
}

// add a user to the list, ignore if the nick already exists
void
CChannel::user_add (const char *mask, bool op, bool voice)
{
  mask2nick (mask, buf);
  if (user_index (buf) == -1)				// if nonexistant
    {
      users[user_num] = new user;			// add it to the end
      my_strncpy (users[user_num]->mask, mask, MASK_SIZE);
      my_strncpy (users[user_num]->nick, buf, NICK_SIZE);
      users[user_num]->is_op = op;
      users[user_num]->is_voice = voice;
      user_num++;
    }
}

void
CChannel::user_del (const char *nick)
{
  int i = user_index (nick);
  if (i != -1)						// if exists
    {
      delete users[i];					// release memory
      for (int i2 = i; i2 < user_num; i2++)		// delete from the list
        users[i2] = users[i2+1];
      user_num--;
      my_strncpy (last_deleted_nick, nick, NICK_SIZE);
    }
}

void
CChannel::user_change_op (const char *nick, bool op)
{
  int i = user_index (nick);
  if (i != -1)
    users[i]->is_op = op;
}

void
CChannel::user_change_voice (const char *nick, bool voice)
{
  int i = user_index (nick);
  if (i != -1)
    users[i]->is_voice = voice;
}

void
CChannel::user_change_nick (const char *nick, const char *new_mask)
{
  int i = user_index (nick);
  if (i != -1)
    {
      my_strncpy (users[i]->mask, new_mask, MASK_SIZE);
      mask2nick (new_mask, users[i]->nick);
      my_strncpy (last_deleted_nick, nick, NICK_SIZE);
    }
}

