/*

  This module implements some mostly useless but fun commands. Although the
mechanisms these commands use are in the main source, there may be interest
in not activating them. They are:

!swapop op_nick deop_nick [#channel]
Give op to <op_nick> and take it from <deop_nick>, on the given <#channel>.

!randkick
Kick a random non-op user where the command is made.

!sayreverse [#channel | $nick] text
Send <text> to a <#channel> or <nick> with the letters reversed.

!time
Show current time and date.

!rose nick
Show a rose to <nick>.

!reverse text
Show <text> with the letters reversed.

*/

#include "mbot.h"

#define SOURCE s->script->source
#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

// !randkick's reason, change at will
#define RANDKICK_REASON "9 out of 10 people really hate this kick. how about you?"

///////////////
// prototypes
///////////////

static void main_fun_cmd_swapop (CServer *);
static void main_fun_cmd_sayreverse (CServer *);
static void main_fun_cmd_time (CServer *);
static void main_fun_cmd_rose (CServer *);
static void main_fun_cmd_reverse (CServer *);
static void main_fun_conf (CServer *, const char *);
static void main_fun_stop (CModule *);

/////////////
// commands
/////////////

// !swapop op_nick deop_nick [#channel]
static void
main_fun_cmd_swapop (CServer *s)
{
  strsplit(CMD[3] + 8, BUF, 3);
  if (BUF[2][0] != 0 && CMD[3][7] == ' ')
    {
      if (BUF[3][0] != '#')
        strcpy (BUF[3], CMD[2]);
      if (strcasecmp (BUF[2], s->nick) != 0)
        {
          int i = CHANNEL_INDEX (BUF[3]);
          if (i != -1)
            {
              CHANNELS[i]->irc_op (BUF[1]);
              CHANNELS[i]->irc_deop (BUF[2]);
            }
         else
            SEND_TEXT (DEST, SCRIPT_INVALID_CHAN);
        }
      else
        SEND_TEXT (DEST, SCRIPT_HURT_BOT);
    }
  else
    SEND_TEXT (DEST, "!swapop == !swapop op_nick deop_nick [#channel]");
}

// !randkick
static void
main_fun_cmd_randkick (CServer *s)
{
  if (CMD[3][9] == 0)
    if (strcasecmp (CMD[2], s->nick) != 0)
      {
        int i = CHANNEL_INDEX (CMD[2]);
        if (i != -1)
          {
            struct CChannel::user *list[C_USERS_MAX];
            int user_num, list_num = 0;

            // build non-ops list
            for (user_num = 0; user_num < CHANNELS[i]->user_num; user_num++)
              if ( ! (CHANNELS[i]->users[user_num]->is_op) )
                list[list_num++] = CHANNELS[i]->users[user_num];

            // if there's at least one
            if (list_num != 0)
              {
                int rand_user = random_num (list_num);
                CHANNELS[i]->irc_kick (list[rand_user]->nick, RANDKICK_REASON);
              }
            else
              SEND_TEXT (DEST, "There's no one to kick.");
          }
      }
    else
      SEND_TEXT(DEST, "!randkick can only be used inside channels.");
}

// !sayreverse [#channel | $nick] text
static void
main_fun_cmd_sayreverse (CServer *s)
{
  strsplit (CMD[3]+12, BUF, 0);
  if (BUF[1][0] != 0 && CMD[3][11] == ' ')
    {
      if (BUF[1][0] == '#')
        {
          int i = 0;
          while (BUF[1][i] != ' ' && BUF[1][i] != 0)
            i++;
          my_strncpy (DEST, BUF[1], i);
          my_strncpy (BUF[2], BUF[1] + i + num_spaces (BUF[1] + i), MSG_SIZE);
          my_strncpy (BUF[1], BUF[2], MSG_SIZE);
        }
      if (BUF[1][0] == '$')
        {
          int i = 0;
          while (BUF[1][i] != ' ' && BUF[1][i] != 0)
            i++;
          my_strncpy(DEST, BUF[1], i);
          my_strncpy(DEST, DEST+1, CHANNEL_SIZE);
          if (strcasecmp(NICKSERV, DEST) == 0
              || strcasecmp(CHANSERV, DEST) == 0
              || strcasecmp(MEMOSERV, DEST) == 0
              || strcasecmp(CHANSERV, DEST) == 0)
            {
              SEND_TEXT (SOURCE, "Cannot send to IRC Services.");
              return;
            }
          my_strncpy (BUF[2], BUF[1] + i + num_spaces(BUF[1] + i), MSG_SIZE);
          my_strncpy (BUF[1], BUF[2], MSG_SIZE);
        }
      char c;
      for (u_char i = 0; i < strlen (BUF[1]) / 2; i++)
        {
          c = BUF[1][i];
          BUF[1][i] = BUF[1][strlen (BUF[1]) - i - 1];
          BUF[1][strlen (BUF[1]) - i - 1] = c;
        }
      SEND_TEXT (DEST, BUF[1]);
    }
  else
    SEND_TEXT (DEST, "!sayreverse == !sayreverse [#channel | $nick] text");
}

// !time
static void
main_fun_cmd_time (CServer *s)
{
  if (CMD[3][5] == 0)
    SEND_TEXT (DEST, get_asctime (s->time_now, s->script->BUF[1], MSG_SIZE));
}

// !rose
static void
main_fun_cmd_rose (CServer *s)
{
  strsplit (CMD[3]+6, BUF, 1);
  if (BUF[1][0] != 0 && CMD[3][5] == ' ')
    {
      snprintf (BUF[2], MSG_SIZE,
                "ACTION %s offers this 7@3}-,-'-- to the beautiful %s :)",
                SOURCE, BUF[1]);
      SEND_TEXT (DEST, BUF[2]);
    }
  else
    SEND_TEXT (DEST, "!rose == !rose nick");
}

// !reverse text
static void
main_fun_cmd_reverse (CServer *s)
{
  strsplit (CMD[3]+9, BUF, 0);
  if (BUF[1][0] != 0 && CMD[3][8] == ' ')
    {
      char c;
      for (u_char i = 0; i < strlen (BUF[1]) / 2; i++)
        {
          c = BUF[1][i];
          BUF[1][i] = BUF[1][strlen (BUF[1]) - i - 1];
          BUF[1][strlen (BUF[1]) - i - 1] = c;
        }
      SEND_TEXT (DEST, BUF[1]);
    }
  else
    SEND_TEXT (DEST, "!reverse == !reverse text");
}

////////////////////
// module managing
////////////////////

// configuration file's local parser
static void
main_fun_conf (CServer *s, const char *bufread)
{
  char buf[10][MSG_SIZE+1];

  strsplit (bufread, buf, 1);

  // add these commands in each new server
  if (strcasecmp (buf[1], "server") == 0
      || strcasecmp (buf[1], "bot") == 0)
    {
      s->script->bind_cmd (main_fun_cmd_swapop, 5, "!swapop");
      s->script->bind_cmd (main_fun_cmd_randkick, 5, "!randkick");
      s->script->bind_cmd (main_fun_cmd_sayreverse, 2, "!sayreverse");
      s->script->bind_cmd (main_fun_cmd_time, 0, "!time");
      s->script->bind_cmd (main_fun_cmd_rose, 0, "!rose");
      s->script->bind_cmd (main_fun_cmd_reverse, 0, "!reverse");
    }
}

// module termination
static void
main_fun_stop (CModule *m)
{
  // try to remove from all servers, even if it's not there (we don't know)
  for (int i = 0; i < m->b->server_num; i++)
    {
      m->b->servers[i]->script->unbind_cmd ("!swapop");
      m->b->servers[i]->script->unbind_cmd ("!randkick");
      m->b->servers[i]->script->unbind_cmd ("!sayreverse");
      m->b->servers[i]->script->unbind_cmd ("!time");
      m->b->servers[i]->script->unbind_cmd ("!rose");
      m->b->servers[i]->script->unbind_cmd ("!reverse");
    }
}

struct CModule::module_type module = {
  MODULE_VERSION,
  "mainfun",
  NULL,
  main_fun_stop,
  main_fun_conf,
  NULL
};
