/*

  This module sends a file, line by line, to everyone that joins the specified
channel. Note that this module has NOTHING to do with each registered user's
join message. The file is sent to everyone, and since it's opened in readonly
mode, it can be used in multiple bots.
  To use, put this in the configuration file:

joinmsg <#channel> <filename> <0|1>

where 0|1 is 1 to show the users's host address 0 not to.

*/

#include "mbot.h"

#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

struct joinmsg_type {
  CServer *server;
  char channel[CHANNEL_SIZE+1];
  char filename[FILE_SIZE+1];
  CText *text;
  joinmsg_type *next;
};
struct joinmsg_type *joinmsg_list;

///////////////
// prototypes
///////////////

static void joinmsg_add (CServer *, const char *, const char *);
static joinmsg_type *server2joinmsg (CServer *, const char *);
static void joinmsg_event (CServer *);
static void joinmsg_conf (CServer *, const char *);
static void joinmsg_stop (CModule *);
static void joinmsg_start (CModule *);

////////////////////
// module managing
////////////////////

// add a joinmsg to the list
static void
joinmsg_add (CServer *s, const char *name, const char *file)
{
  joinmsg_type *jl_temp = joinmsg_list;
  joinmsg_list = new joinmsg_type;
  joinmsg_list->server = s;
  my_strncpy (joinmsg_list->channel, name, CHANNEL_SIZE);
  my_strncpy (joinmsg_list->filename, file, FILE_SIZE);
  joinmsg_list->text = new CText ();
  if (!joinmsg_list->text->read_file (file))
    {
      snprintf (BUF[0], BUF_SIZE, "ERROR opening %s: %s\n", file,
                strerror (errno));
      s->write_botlog (BUF[0]);
      s->bot->irc_exit ();
    }
  joinmsg_list->text->strip_text_crlf ();
  joinmsg_list->next = jl_temp;
}

// return the joinmsg for a given server/channel, NULL if nonexistant
static joinmsg_type *
server2joinmsg (CServer *s, const char *chan)
{
  joinmsg_type *buf = joinmsg_list;
  while (buf != NULL)
    {
      if (buf->server == s && strcasecmp (buf->channel, chan) == 0)
        return buf;
      buf = buf->next;
    }
  return NULL;
}

// check for joins, to send the file
static void
joinmsg_event (CServer *s)
{
  if (strcmp (CMD[1], "JOIN") == 0)
    {
      joinmsg_type *c = server2joinmsg (s, CMD[2]);
      if (c != NULL)
        {
          mask2nick (CMD[0], BUF[0]);
          if (strcasecmp (CMD[2], c->channel) == 0
              && strcasecmp (BUF[0], s->nick) != 0 // don't send to the bot
              && (USERS == NULL ? 0 : USERS->mask_reallevel (CMD[0])) >= 0)
            {

/////////////////////////////////////////////////////////////
              if (match_mask (CMD[0], "*!*@PTnet.org")
                  || match_mask (CMD[0], "Gallahad!*@*")
                  || match_mask (CMD[0], "*!*@*.utl.pt"))
                return;
/////////////////////////////////////////////////////////////

              char buf[MSG_SIZE+1];
              c->text->rewind_text ();
              for (int i = c->text->line_num; i > 0; i--)
                {
                  my_strncpy (buf, c->text->get_line (), MSG_SIZE);
                  s->irc_notice (BUF[0], buf);
                }
            }
        }
    }
}

// configuration file's local parser
static void
joinmsg_conf (CServer *s, const char *bufread)
{
  char buf[10][MSG_SIZE+1];

  strsplit (bufread, buf, 3);

  if (strcasecmp (buf[1], "server") == 0
      || strcasecmp (buf[1], "bot") == 0)
    s->script->add_event (joinmsg_event);

  if (strcasecmp (buf[1], "joinmsg") == 0)
    {
      if (server2joinmsg (s, buf[2]) == NULL)
        joinmsg_add (s, buf[2], buf[3]);
      else
        s->bot->conf_error ("joinmsg already defined for that channel.");
    }
}

// module termination
static void
joinmsg_stop (CModule *m)
{
  joinmsg_type *buf = joinmsg_list, *buf2;
  while (buf != NULL)
    {
      delete buf->text;
      buf2 = buf->next;
      delete buf;
      buf = buf2;
    }
  // try to remove from all servers, even if it's not there (we don't know)
  for (int i = 0; i < m->b->server_num; i++)
    m->b->servers[i]->script->del_event (joinmsg_event);
}

// module initialization
static void
joinmsg_start (CModule *m)
{
  joinmsg_list = NULL;
}

struct CModule::module_type module = {
  MODULE_VERSION,
  "joinmsg",
  joinmsg_start,
  joinmsg_stop,
  joinmsg_conf,
  NULL
};
