/*

  This is a module which probably no one will ever use ;) because giving
oper status to a bot is very risky. Anyway, this only implements a !kill
command. Use it by setting the oline's password (it uses the current nick's
oline):

ircop password

in the configuration file.

*/

#include "mbot.h"

#define IRCOP_PASS_SIZE MSG_SIZE

#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

struct ircop_type {
  CServer *server;
  char ircop_pass[IRCOP_PASS_SIZE+1];		// ircop password
  bool ircop;					// if it is ircop
  ircop_type *next;
};
struct ircop_type *ircop_list;

///////////////
// prototypes
///////////////

static void kill_cmd_kill (CServer *);
static void ircop_add (CServer *, const char *);
static ircop_type *server2ircop (CServer *);
static void ircop_reply (CServer *);
static void ircop_event (CServer *);
static void ircop_conf (CServer *, const char *);
static void ircop_stop (CModule *);
static void ircop_start (CModule *);

/////////////
// commands
/////////////

// !kill nick reason
static void
kill_cmd_kill (CServer *s)
{
  strsplit(CMD[3] + 6, BUF, 1);
  if (BUF[1][0] != 0 && BUF[2][0] != 0)
    {
      if (strcasecmp (BUF[1], s->nick) != 0)		// doesn't kill itself
        s->irc_kill (BUF[1], BUF[2]);
      else
        SEND_TEXT (DEST, SCRIPT_HURT_BOT);
    }
  else
    SEND_TEXT (DEST, "!kill == !kill nick reason");
}

////////////////////
// module managing
////////////////////

// add a server/channel pair to the list
static void
ircop_add (CServer *s, const char *pass)
{
  ircop_type *buf = ircop_list;
  ircop_list = new ircop_type;
  ircop_list->server = s;
  my_strncpy (ircop_list->ircop_pass, pass, IRCOP_PASS_SIZE);
  ircop_list->ircop = 0;
  ircop_list->next = buf;
}

// return the ircop for a given server, NULL if nonexistant
static ircop_type *
server2ircop (CServer *s)
{
  ircop_type *buf = ircop_list;
  while (buf != NULL)
    {
      if (buf->server == s)
        return buf;
      buf = buf->next;
    }
  return NULL;
}

// look for the first server init reply, to identify as ircop
static void
ircop_reply (CServer *s)
{
  if (strcmp (CMD[1], INIT) == 0)
    {
      ircop_type *ircop = server2ircop (s);
      if (ircop != NULL)
        if (ircop->ircop_pass[0] && !ircop->ircop)
          {
            s->irc_oper (s->nick, ircop->ircop_pass);
            ircop->ircop = 1;
          }
    }
}

// look for the first server ping, to identify as ircop
static void
ircop_event (CServer *s)
{
  if (strcmp (CMD[0], "PING") == 0)
    {
      ircop_type *ircop = server2ircop (s);
      if (ircop != NULL)
        if (ircop->ircop_pass[0] && !ircop->ircop)
          {
            s->irc_oper (s->nick, ircop->ircop_pass);
            ircop->ircop = 1;
          }
    }
}

// configuration file's local parser
static void
ircop_conf (CServer *s, const char *bufread)
{
  char buf[10][MSG_SIZE+1];

  strsplit (bufread, buf, 1);

  if (strcasecmp (buf[1], "ircop") == 0)
    {
      if (server2ircop (s) == NULL)
        {
          ircop_add (s, buf[2]);
          s->script->add_reply (ircop_reply);
          s->script->add_event (ircop_event);
          s->script->bind_cmd (kill_cmd_kill, 9, "!kill");
        } 
      else
        s->bot->conf_error ("ircop already defined for this server.");
    }
}

// module termination
static void
ircop_stop (CModule *m)
{
  ircop_type *buf = ircop_list, *buf2;
  while (buf != NULL)
    {
      buf->server->script->del_reply (ircop_reply);
      buf->server->script->del_event (ircop_event);
      buf->server->script->unbind_cmd ("!kill");
      buf2 = buf->next;
      delete buf;
      buf = buf2;
    }
}

// module initialization
static void
ircop_start (CModule *m)
{
  ircop_list = NULL;
}

struct CModule::module_type module = {
  MODULE_VERSION,
  "ircop",
  ircop_start,
  ircop_stop,
  ircop_conf,
  NULL
};
