/*

  This module adds some not-too-useful commands... !work, !dccchat (NOT a real
DCC Chat implementation), !ping, !scan and !host. Try them if you want to.

  By default, when a shitlisted nick is kick/banned, some pings are sent to
its host. Use this to turn that off:

set extra_akickping 0

*/

#include "mbot.h"

#define SOURCE s->script->source
#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

struct extra_type {
  CServer *server;
  bool akickping;
  extra_type *next;
};
struct extra_type *extra_list;

///////////////
// prototypes
///////////////

static void extra_cmd_work (CServer *);
static void extra_cmd_dccchat (CServer *);
static void extra_cmd_ping (CServer *);
static void extra_cmd_scan (CServer *);
static void extra_cmd_host (CServer *);
static void extra_add (CServer *);
static extra_type *server2extra (CServer *);
#ifdef PING_PATH
static void extra_pinghost (const char *);
static void extra_event (CServer *);
#endif
static void extra_conf (CServer *, const char *);
static void extra_stop (CModule *);
static void extra_var (CServer *, const char *, char *, size_t);

/////////////
// commands
/////////////

// !work raw_command
static void
extra_cmd_work (CServer *s)
{
  if (strncasecmp (CMD[3], "!work", 5) == 0)
    {
      strsplit (CMD[3] + 6, BUF, 0);
      if (BUF[1][0] != 0 & CMD[3][5] == ' ')
        {
          for (int i = 0; i < (signed) (strlen (BUF[1]) - 7); i++)
            if (strncasecmp (BUF[1]+i, NICKSERV, 8) == 0)
              {
                SEND_TEXT (DEST, "NickServ access denied.");
                return;
              }
          s->irc_write (BUF[1]);
        }
      else
        SEND_TEXT (DEST, "!work == !work raw_command");
    }
}

// !dccchat nick host port
static void
extra_cmd_dccchat (CServer *s)
{
  strsplit (CMD[3] + 9, BUF, 3);
  if (BUF[3][0] != 0 && CMD[3][8] == ' ')
    {
#ifndef HAVE_STRUCT_IP
      char addrbuf[12];
      struct ip ipe;
      struct hostent *addr = gethostbyname(BUF[2]);
      if (addr == NULL)
        {
          ipe.ip_dst.s_addr = inet_addr (BUF[2]);
          if (ipe.ip_dst.s_addr == (u_long) -1)
            {
              SEND_TEXT (DEST, "Cannot resolve host.");
              return;
            }
        }
      else
        memcpy (&ipe.ip_dst.s_addr, addr->h_addr_list[0], addr->h_length);

      itoa (ntohl (ipe.ip_dst.s_addr), addrbuf);
      snprintf (BUF[5], MSG_SIZE, "DCC CHAT chat %s %s", addrbuf, BUF[3]);
      SEND_TEXT (BUF[1], BUF[5]);
#else	// not HAVE_STRUCT_IP
      SEND_TEXT (DEST, "Command not available in this system.");
#endif
    }
  else
    SEND_TEXT (DEST, "!dccchat == !dccchat nick host port");
}

// !ping nick
static void
extra_cmd_ping (CServer *s)
{
  strsplit (CMD[3]+6, BUF, 1);
  if (BUF[1][0] != 0 && CMD[3][5] == ' ')
    {
#ifdef PING_PATH
      int i, i2;
      for (i = 0; i < s->channel_num; i++)		// search in channels
        {
          i2 = CHANNELS[i]->user_index (BUF[1]);
          if (i2 != -1)
            {
              mask2host (CHANNELS[i]->users[i2]->mask, BUF[3]);
              extra_pinghost (BUF[3]);
              snprintf (BUF[4], MSG_SIZE, "Ping sent to %s.", BUF[3]);
              SEND_TEXT (DEST, BUF[4]);
              return;
            }
        }
      SEND_TEXT (DEST, "Can't find that nick.");
#else
      SEND_TEXT (DEST, "Ping command not available.");
#endif
    }
  else
    SEND_TEXT (DEST, "!ping == !ping nick");
}

// !scan nick port
static void
extra_cmd_scan (CServer *s)
{
  strsplit (CMD[3] + 6, BUF, 2);
  if (BUF[2][0] != 0 && CMD[3][5] == ' ')
    {
      int i, i2;
      for (i = 0; i < s->channel_num; i++)		// search in channels
        {
          i2 = CHANNELS[i]->user_index (BUF[1]);
          if (i2 != -1)
            {
              mask2host (CHANNELS[i]->users[i2]->mask, BUF[4]);
              i = openhost (s->virtualhost, BUF[4], atoi (BUF[2]));
              if (i != -1)
                {
                  SEND_TEXT (DEST, "Port open.");
                  close (i);
                }
              else
                SEND_TEXT (DEST, "Port closed or host unreachable.");
              return;
            }
        }
      SEND_TEXT (DEST, "Can't find that nick.");
    }
  else
    SEND_TEXT (DEST, "!scan == !scan nick port");
}

// !host nick
static void
extra_cmd_host (CServer *s)
{
  strsplit (CMD[3] + 6, BUF, 1);
  if (BUF[1][0] != 0 && CMD[3][5] == ' ')
    {
      int i,i2;
      for (i=0; i<s->channel_num; i++)			// search in channels
        {
          i2 = CHANNELS[i]->user_index (BUF[1]);
          if (i2 != -1)
            {
              mask2host (CHANNELS[i]->users[i2]->mask, BUF[2]);
              snprintf (BUF[3], MSG_SIZE, "%s's host is %s.", BUF[1], BUF[2]);
              SEND_TEXT (DEST, BUF[3]);
              return;
            }
        }
      SEND_TEXT (DEST, "Can't find that nick.");
    }
  else
    SEND_TEXT (DEST, "!host == !host nick");
}

////////////////////
// module managing
////////////////////

// add a ctcp to the list
static void
extra_add (CServer *s)
{
  extra_type *buf = extra_list;
  extra_list = new extra_type;
  extra_list->server = s;
  extra_list->akickping = 1;
  extra_list->next = buf;
}

// returns the extra for a given server, NULL if nonexistant
static extra_type *
server2extra (CServer *s)
{
  extra_type *buf = extra_list;
  while (buf != NULL)
    {
      if (buf->server == s)
        return buf;
      buf = buf->next;
    }
  return NULL;
}

#ifdef PING_PATH

static void
extra_pinghost (const char *host)
{
  char buf[MSG_SIZE+1];
  snprintf (buf, MSG_SIZE,
            "%s %s -p 2b2b2b415448300d -c 3 > /dev/null 2> /dev/null&\n",
            PING_PATH, host);
  system (buf);
}

// look for shitlisteds in join and nick events
static void
extra_event (CServer *s)
{
  extra_type *buf = server2extra (s);
  if (buf != NULL)
    if (buf->akickping)
      {
        if (strcmp (CMD[1], "JOIN") == 0)
          {
            // shitlist
            if ((USERS == NULL ? 0 : USERS->mask_level (CMD[0])) < 0)
              {
                mask2host (CMD[0], BUF[0]);
                extra_pinghost (BUF[0]);
              }
          }
        else if (strcmp (CMD[1], "NICK") == 0)
          {
            // make new mask
            mask2user (CMD[0], BUF[0]);
            mask2host (CMD[0], BUF[1]);
            snprintf (BUF[2], MSG_SIZE, "%s!%s@%s", CMD[2], BUF[0], BUF[1]);
            // shitlist
            if ((USERS == NULL ? 0 : USERS->mask_level (BUF[2])) < 0)
              extra_pinghost (BUF[1]);
          }
      }
}

#endif	// PING_PATH

// configuration file's local parser
static void
extra_conf (CServer *s, const char *bufread)
{
  char buf[10][MSG_SIZE+1];

  strsplit (bufread, buf, 1);

  // add these commands in each new server
  if (strcasecmp (buf[1], "server") == 0
      || strcasecmp (buf[1], "bot") == 0)
    {
      if (server2extra (s) == NULL)
        {
          extra_add (s);
#ifdef PING_PATH
          s->script->add_event (extra_event);
#endif
          s->script->bind_cmd (extra_cmd_work, 10, "!work");
          s->script->bind_cmd (extra_cmd_dccchat, 10, "!dccchat");
          s->script->bind_cmd (extra_cmd_ping, 10, "!ping");
          s->script->bind_cmd (extra_cmd_scan, 10, "!scan");
          s->script->bind_cmd (extra_cmd_host, 7, "!host");
          s->vars->var_add ("extra_akickping", extra_var);
        }
    }
}

// module termination
static void
extra_stop (CModule *m)
{
  extra_type *buf = extra_list, *buf2;
  while (buf != NULL)
    {
      buf2 = buf->next;
      delete buf;
      buf = buf2;
    }
  // try to remove from all servers, even if it's not there (we don't know)
  for (int i=0; i<m->b->server_num; i++)
    {
#ifdef PING_PATH
      m->b->servers[i]->script->del_event (extra_event);
#endif
      m->b->servers[i]->script->unbind_cmd ("!work");
      m->b->servers[i]->script->unbind_cmd ("!dccchat");
      m->b->servers[i]->script->unbind_cmd ("!ping");
      m->b->servers[i]->script->unbind_cmd ("!scan");
      m->b->servers[i]->script->unbind_cmd ("!host");
      m->b->servers[i]->vars->var_del ("extra_akickping");
    }
}

static void
extra_var (CServer *s, const char *name, char *data, size_t n)
{
  extra_type *buf = server2extra (s);
  if (buf == NULL)
    return;
  if (strcasecmp (name, "extra_akickping") == 0)
    {
      if (n != 0)
        itoa (buf->akickping, data, n);
      else
        buf->akickping = (atoi (data) != 0);
    }
}

struct CModule::module_type module = {
  MODULE_VERSION,
  "extra",
  NULL,
  extra_stop,
  extra_conf,
  extra_var
};
