#ifndef _H_CUSER
#define _H_CUSER

class CUser;

#include "mbot.h"

class CUser {
public:
  CUser (CServer *, const char *);
  ~CUser (void);

  void open_users (void);
  void close_users (void);
  void setup_users (int);
  bool add_user(const char *, const char *, int, const char *);
  bool del_user(const char *);
  bool check_pass (const char *, const char *);
  void set_pass (const char *, const char *);
  void abs_set_pass (const char *, const char *);
  void set_msg (const char *, const char *);
  void abs_set_msg (const char *, const char *);
  void abs_set_mask (const char *, const char *);
  void set_level (const char *, int);
  void abs_set_level (const char *, int);
  int abs_user_index(const char *);
  void set_id (const char *, int);
  int mask_index (const char *);
  int abs_mask_index(const char *mask);
  int mask_level (const char *);
  int mask_reallevel (const char *);
  int user_level (const char *, const char *);
  int user_reallevel (const char *, const char *);

  char filename[FILE_SIZE+1];			// nome do ficheiro
  struct user_type {
    char mask[MASK_SIZE+1];			// mask (nick!user@host)
    char abs_mask[MASK_SIZE+1];			// current mask, complete
    char pass[ENC_PASS_SIZE+1];			// encrypted password
    short int level;				// user level
    bool id;					// if it's identified
    char msg[MSG_SIZE+1];			// join msg
    long index;					// file position
  } users[USER_MAX+1];
  int user_num;					// total users

private:

  CServer* s;					// server to which belongs
  FILE *ufd;					// file descriptor
  char buf[10*(MSG_SIZE+1)];

};

#endif
