#ifndef _H_CSERVER
#define _H_CSERVER

class CServer;

#include "mbot.h"
#include "CText.h"
#include "CChannel.h"
#include "CUser.h"
#include "CDCC.h"
#include "CVar.h"
#include "CServices.h"
#include "CScript.h"

class CServer {
public:
  CServer (CBot *);
  ~CServer (void);

  void irc_pong (const char *);
  void irc_quit (const char *);
  void irc_privmsg (const char *, const char *);
  void irc_notice (const char *, const char *);
  void irc_nick (const char *);
  void irc_user (const char *, const char *);
  void irc_whois (const char *);
  void irc_ison (const char *);
  void irc_who (const char *);
  void irc_oper (const char *, const char *);
  void irc_kill (const char *, const char *);
  void irc_away (const char *);

  void write_botlog (const char *);
  void irc_write (const char *);
  int irc_read (void);
  void irc_connect (void);
  void irc_restart (void);
  void work (void);

  int channel_add(const char *, const char *);
  int channel_del(const char *);
  int channel_index (const char *);

  void irc_parse (void);

  // circular list of hosts
  struct host_type {
    char host[HOST_SIZE+1];
    int port;
    host_type *next;
  } *hosts,				// hosts list
    *host_current;			// current host, points to one of them

  host_type *host_add (host_type *, const char *, int);

  char virtualhost[HOST_SIZE+1];
  char nick[NICK_SIZE+1];
  char nick_orig[NICK_SIZE+1];
  char user[USER_SIZE+1];
  char name[NAME_SIZE+1];
  char away[AWAY_SIZE+1];
  char quit[QUIT_SIZE+1];

  int sock;					// server's socket
  bool connected;	// if it's connected (on irc, not just the socket)
  time_t last_try; 	// last try to connect to the server

  int change_time;	// time (in seconds) to be added to local time
  time_t time_now;	// current local time, with change_time applied

  CUser *users;					// users

  CChannel *channels[CHANNEL_MAX];		// channels
  int channel_num;				// channels number

  CDCC *dccs[DCC_MAX];				// dccs
  int dcc_num;					// dccs number
  int dcc_port;					// port for dccs, 0 to any free
  char dcc_file[FILE_SIZE+1];			// file with !get definitions
  char dcc_motdfile[FILE_SIZE+1];		// file with dcc chat's motd
  CText *dcc_motd;				// opened motd or NULL

  CVar *vars;					// server variables
  CServices *services;				// nick/chan/oper/memoserv etc
  CScript *script;				// events and replies handler
  CBot *bot;					// bot to which belongs
  
  char cmd[CMD_SIZE][MSG_SIZE+1];		// parsed message
  int cmd_i;					// components
  char buf[CMD_SIZE*(MSG_SIZE+1)];
  char bufread[MSG_SIZE+1];			// irc_read() buffer
  int bufpos;					// strlen of bufread
  char bufwrite[MSG_SIZE+1];			// buffer for outgoing stuff
  u_int bytesin, bytesout;			// num of bytes read/written
  time_t time_read;				// last time a read was made
  time_t uptime;				// when the server connected

private:

  char buf2[MSG_SIZE+1];			// to irc_n* and irc_c*

};

#endif
