#ifndef _H_CDCC
#define _H_CDCC

class CDCC;

#include "mbot.h"

#define DCC_STOP 0			// nothing set, exit
#define DCC_SEND_INIT 1			// socket and file open for dcc send
#define DCC_SEND 2			// dcc send active
#define DCC_CHAT_INIT 3			// open socket for dcc chat
#define DCC_CHAT_AUTH 4			// ask password in chat
#define DCC_CHAT 5			// dcc chat active

class CDCC {
public:
  CDCC (CServer *, const char *, int, int);
  ~CDCC (void);

  void dcc_error (const char *);
  bool dcc_chat_start (void);
  bool dcc_send_start (const char *);
  void dcc_start_check (void);
  void dcc_chat_write (const char *);
  void dcc_chat_pass (void);
  void dcc_chat (void);
  void dcc_send (void);
  void dcc_stop (void);
  bool dcc_work (void);
  char *dcc_make_ctcp_chat (char *, size_t);
  char *dcc_make_ctcp_send (char *, size_t);

  char nick[NICK_SIZE+1];			// nick from the given mask
  char mask[MASK_SIZE+1];			// mask of who made the dcc
  int status;					// dcc status
  int index;					// this dcc's table index
  int dcc_from_index;	// index of dcc where _this_ dcc was started
  			// -1 if it was on a pvt

private:

  CServer *s;					// server to which belongs

  FILE *dfd;					// fd of file to send
  int filesize;					// total file size
  int filesent;					// number of bytes sent
  int socklocal, sockremote;
  time_t last_time;				// time of last change
  char filename[FILE_SIZE+1];			// name of file to send
  char dcc_buf[DCC_BUF_SIZE+1];
  char buf[BUF_SIZE+1];

};

#endif
