#include "net.h"

// dummy for openhost's alarm
RETSIGTYPE
connect_alarm (int signo)
{
  return;
}

// return a socket, -1 if failed
int
openhost (const char *src, const char *dest, int port)
{
  struct hostent *he;
  struct sockaddr_in sa;
  int sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0)
    return -1;
  if (src != NULL)
    if (src[0] != 0)			// use vhost
      {
        memset ((char *) &sa, 0, sizeof (struct sockaddr_in));
        sa.sin_family = AF_INET;
        he = gethostbyname (src);
        if (he == NULL)
          {
            close(sock);
            return -1;
          }
        memcpy (&sa.sin_addr, he->h_addr, he->h_length);
        if (bind (sock, (struct sockaddr *) &sa, sizeof (sa)) < 0)
          {
            close (sock);
            return -1;
          }
      }
  he = gethostbyname (dest);
  if (he == NULL)
    {
      close (sock);
      return -1;
    }
  memset ((char *) &sa, 0, sizeof (struct sockaddr_in));
  memcpy (&sa.sin_addr, he->h_addr, he->h_length);
  sa.sin_port = htons (port);
  sa.sin_family = AF_INET;
  memset (&sa.sin_zero, 0, sizeof (sa.sin_zero));
  alarm (0);
  signal (SIGALRM, connect_alarm);
  alarm (TIME_CONNECT);
  if (connect (sock, (struct sockaddr *)&sa, sizeof sa) < 0)
    {
      close (sock);
      if(errno == EINTR)
        errno = ETIMEDOUT;
      sock = -1;
    }
  alarm (0);
  signal (SIGALRM, SIG_DFL);
  return sock;
}

void
writesock (int sock, const char *buf)
{
  write (sock, buf, strlen (buf));
  write (sock, "\n", 1);
}

// read from sock to buf until a '\n' or buf_size bytes are read
// return read bytes, -1 on error
int
readsock (int sock, char *buf, size_t buf_size)
{
  int i = -1;
  do
    {
      i++;
      if (read(sock,buf+i,1) <= 0)
        return -1;
      if (buf[i] == '\r')
        i--;
    }
  while (buf[i] != '\n' && i < (int)buf_size);
  buf[++i] = 0;
  return i;
}

// return 1 if there's new data, 0 if not, -1 if failed
int
readok (int sock)
{
  fd_set rfds;
  struct timeval tv;
  FD_ZERO (&rfds);
  FD_SET (sock, &rfds);
  tv.tv_sec = 0;
  tv.tv_usec = 2;
  int i = select (sock+1, &rfds, NULL, &rfds, &tv);
  FD_ZERO (&rfds);
  return i;
}

// return 1 if there's new data, 0 if not, -1 if failed
int
writeok (int sock)
{
  fd_set wfds;
  struct timeval tv;
  FD_ZERO (&wfds);
  FD_SET (sock, &wfds);
  tv.tv_sec = 0;
  tv.tv_usec = 1;
  int i = select (sock+1, NULL, &wfds, &wfds, &tv);
  FD_ZERO (&wfds);
  return i;
}

// force the socket to flush buffers on a close()
void
sock_linger (int sock, int timeout)
{
  struct linger ling;
  ling.l_onoff = 1;
  ling.l_linger = timeout;
  setsockopt (sock, SOL_SOCKET, SO_LINGER, (void *) &ling, sizeof (&ling));
}

// create a socket and leave it waiting for connections on the specified port
// if port=0, use any free one. return the socket, -1 on error
int
bindsock (int port)
{
  int sock = -1;
  struct sockaddr_in local;

  memset (&local, 0, sizeof (local));
  local.sin_family = AF_INET;
  local.sin_port = htons(port);
  local.sin_addr.s_addr = INADDR_ANY;
  memset (&(local.sin_zero), 0, 8);
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock == -1)
    return -1;
  int parm = 1;
  setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, (void *) &parm, sizeof (int));

  if (bind (sock, (struct sockaddr *)&local, sizeof (struct sockaddr)) == -1)
    {
      close (sock);
      return -1;
    }
  if (listen (sock, 1) == -1)
    {
      close (sock);
      return -1;
    }
  return sock;
}

u_short
sock2port (int sock)
{
  struct sockaddr_in addr;
  socklen_t size = sizeof (struct sockaddr);

  memset (&addr, 0, sizeof (struct sockaddr_in));
  getsockname (sock, (struct sockaddr *)&addr, &size);

  return ntohs (addr.sin_port);
}

u_long
sock2addr (int sock)
{
  struct sockaddr_in addr;
  socklen_t size = sizeof (struct sockaddr);

  memset (&addr, 0, sizeof (struct sockaddr_in));
  getsockname (sock, (struct sockaddr *)&addr, &size);

  return ntohl (addr.sin_addr.s_addr);
}

