#include "CText.h"

CText::CText (void)
{
  filename[0] = 0;
  lines = lines_cur = NULL;
  line_num = line_cur = 0;
}

CText::~CText (void)
{
  delete_lines ();
}

// read a text file into memory
bool
CText::read_file (const char *name)
{
  char bufread[LINE_SIZE+1];
  my_strncpy (filename, name, FILE_SIZE);
  FILE *fd = fopen (filename, "r");
  if (fd == NULL)
    return 0;
  while (fgets (bufread, LINE_SIZE, fd) != NULL)
    add_line (bufread);
  fclose (fd);
  return 1;
}

// move the current line pointer to the beginning
void
CText::rewind_text (void)
{
  lines_cur = lines;
  line_cur = 0;
}

// get the current line and move to the next
const char *
CText::get_line (void)
{
  char *tmp = NULL;
  if (lines_cur != NULL)
    {
      tmp = lines_cur->text;
      lines_cur = lines_cur->next;
      line_cur++;
    }
  return tmp;
}

// run strip_crlf() in each line
void
CText::strip_text_crlf (void)
{
  if (line_num != 0)
    {
      rewind_text ();
      line_type *l = lines;
      while (l != NULL)
        {
          strip_crlf (l->text);
          l = l->next;
        }
    }
}

// delete all lines
void
CText::delete_lines (void)
{
  line_type *l = lines, *l2;
  while (l != NULL)
    {
      l2 = l->next;
      if (l->text != NULL)
        free (l->text);
      delete l;
      l = l2;
    }
  line_num = line_cur = 0;
}

// add a text line to the end
void
CText::add_line (const char *t)
{
  if (lines == NULL)				// if it's empty
    {
      lines = new line_type;
      lines->text = (char *)malloc (strlen (t) + 1);
      strcpy (lines->text, t);
      lines->next = NULL;
    }
  else
    {
      line_type *l_buf = lines;
      while (l_buf->next != NULL)		// else find the last
        l_buf = l_buf->next;
      l_buf->next = new line_type;
      l_buf->next->text = (char *)malloc (strlen (t) + 1);
      strcpy (l_buf->next->text, t);
      l_buf->next->next = NULL;
    }
  line_num++;
}

