#include "CModule.h"

CModule::CModule (CBot *bot)
{ 
  b = bot; 
  *filename = 0; 
  handle = NULL;
  module = NULL; 
}

CModule::~CModule (void)
{
  if (module != NULL)
    if (module->stop != NULL)
      module->stop (this);
  if (handle != NULL)
    dlclose (handle);
}

bool
CModule::init (const char *file)
{
  char buf[BUF_SIZE+1];
  my_strncpy (filename, file, FILE_SIZE);

  if (filename[0] == '/')		// if an absolute path was specified
    handle = dlopen (filename, RTLD_LAZY);
  else					// else build it
    {
      char *cwd = getcwd (NULL, 10000);	// should be enough
      char *path = (char *)malloc (strlen(cwd) + strlen (filename) + 10);
      sprintf (path, "%s/%s", cwd, filename);
      handle = dlopen(path, RTLD_LAZY);
      free (cwd);
      free (path);
    }
  if (handle == NULL)
    {
      snprintf (buf, BUF_SIZE, "ERROR: dlopen() returned: %s", dlerror ());
      b->write_botlog (buf);
      return 0;
    }
  module = (struct module_type *)dlsym (handle, "module");
  if (module == NULL)
    {
      module = (struct module_type *)dlsym (handle, "_module");
      if (module == NULL)
        {
          snprintf (buf, BUF_SIZE, "ERROR: dlsym() returned: %s", dlerror ());
          b->write_botlog (buf);
          return 0;
        }
    }
  if (module->version != MODULE_VERSION)
    {
      b->write_botlog ("ERROR: module was compiled with another version of mbot, recompile it");
      return 0;
    }

  if (module->start != NULL)
    module->start (this);

  return 1;
}

