/*

  This module implements the irc services commands. Although the
mechanisms these commands use are in the main source, there may be interest
in not activating them. They are:

!cop nick [#channel]
Use chanserv to op <nick> in the specified <#channel>.

!cdeop nick [#channel]
Use chanserv to deop <nick> in the specified <#channel>.

*/

#include "mbot.h"

#define SOURCE s->script->source
#define DEST s->script->dest
#define BUF s->script->buf
#define SEND_TEXT s->script->send_text

///////////////
// prototypes
///////////////

static void main_serv_cmd_cop (CServer *);
static void main_serv_cmd_cdeop (CServer *);
static void main_serv_conf (CServer *, const char *);
static void main_serv_stop (CModule *);

/////////////
// commands
/////////////

// !cop nick [#channel]
static void
main_serv_cmd_cop (CServer *s)
{
  strsplit (CMD[3] + 5, BUF, 2);
  if (BUF[1][0] != 0 && CMD[3][4] == ' ')
    {
      if (BUF[2][0] != '#')
        my_strncpy (BUF[2], CMD[2], MSG_SIZE);
      s->services->chan_op (BUF[2], BUF[1]);
    }
  else
    SEND_TEXT (DEST, "!cop == !cop nick [#channel]");
}

// !cdeop nick [#channel]
static void
main_serv_cmd_cdeop (CServer *s)
{
  strsplit (CMD[3] + 7, BUF, 2);
  if (BUF[1][0] != 0 && CMD[3][6] == ' ')
    {
      if (BUF[2][0] != '#')
        strcpy (BUF[2], CMD[2]);
      if (strcasecmp (BUF[1], s->nick) != 0)
        {
          s->services->chan_deop (BUF[2], BUF[1]);
        }
      else
        SEND_TEXT (DEST, SCRIPT_HURT_BOT);
    }
  else
    SEND_TEXT (DEST, "!cdeop == !cdeop nick [#channel]");
}

////////////////////
// module managing
////////////////////

// configuration file's local parser
static void
main_serv_conf (CServer *s, const char *bufread)
{
  char buf[10][MSG_SIZE+1];

  strsplit (bufread, buf, 1);

  if (strcasecmp (buf[1], "bot") == 0)
    {
      s->script->bind_cmd (main_serv_cmd_cop, 7, "!cop");
      s->script->bind_cmd (main_serv_cmd_cdeop, 7, "!cdeop");
    }
}

// module termination
static void
main_serv_stop (CModule *m)
{
  // try to remove from all servers, even if it's not there (we don't know)
  for (int i = 0; i < m->b->server_num; i++)
    {
      m->b->servers[i]->script->unbind_cmd ("!cop");
      m->b->servers[i]->script->unbind_cmd ("!cdeop");
    }
}

struct CModule::module_type module = {
  MODULE_VERSION,
  "mainserv",
  NULL,
  main_serv_stop,
  main_serv_conf,
  NULL
};
