#ifndef _H_CSCRIPT
#define _H_CSCRIPT

class CScript;

#include "mbot.h"
#include "scriptcmd.h"

// shortcuts

#define CMD s->cmd
#define USERS s->users
#define CHANNEL_INDEX s->channel_index
#define CHANNELS s->channels
#define DCCS s->dccs
#define DCC_NUM s->dcc_num

// server replies

#define INIT "001"
#define RPL_WHOISUSER "311"
#define RPL_ENDOFWHOIS "318"
#define RPL_NOTOPIC "331"
#define RPL_TOPIC "332"
#define RPL_WHOREPLY "352"
#define RPL_ENDOFWHO "315"
#define ERR_NOSUCHNICK "401"
#define ERR_NOSUCHCHANNEL "403"
#define ERR_TOOMANYCHANNELS "405"
#define ERR_UNKNOWNCOMMAND "421"
#define ERR_NICKNAMEINUSE "433"
#define ERR_INVITEONLYCHAN "473"
#define ERR_BANNEDFROMCHAN "474"
#define ERR_CHANOPRIVSNEEDED "482"

// these are here to avoid repeating them
#define SCRIPT_HURT_BOT "I'm not _that_ dumb, wiseguy.. :P"
#define SCRIPT_INVALID_CHAN "I'm not on that channel."

class CScript {
public:

  CScript (CServer *);
  ~CScript (void);

  void bind_cmd (void (*)(CServer *), int, const char *);
  bool unbind_cmd (const char *);
  void add_reply (void (*)(CServer *));
  void del_reply (void (*)(CServer *));
  void add_event (void (*)(CServer *));
  void del_event (void (*)(CServer *));
  void add_timer (void (*)(CServer *));
  void del_timer (void (*)(CServer *));

  void send_partyline (const char *);
  void send_text (const char *, const char *);
  void irc_reply (void);
  void irc_event (void);

  char source[NICK_SIZE+1];			// these 2 are for privmsg
  char dest[CHANNEL_SIZE+1];

  char buf[10][MSG_SIZE+1];

  struct cmd_type {
    char cmd[15+1];
    void (*action)(CServer *);
    size_t size;
    cmd_type *next;
  };
  cmd_type *cmds[LEVEL_MAX+1];		// comands list (for pvt and dcc)

  struct f_type {
    void (*f)(CServer *);
    f_type *next;
  };
  f_type *timers;				// list of timer handlers

  CServer *s;					// server to which belongs

private:

  void reply_init (void);
  void reply_ison (void);
  void reply_notopic (void);
  void reply_topic (void);
  void reply_whoreply (void);
  void reply_endofwho (void);
  void reply_nosuchnick (void);
  void reply_nosuchchannel (void);
  void reply_toomanychannels (void);
  void reply_unknowncommand (void);
  void reply_nicknameinuse (void);
  void reply_inviteonlychan (void);
  void reply_bannedfromchan (void);
  void reply_chanoprivsneeded (void);

  void event_ping (void);
  void event_error (void);
  void event_notice (void);
  void event_join (void);
  void event_quit (void);
  void event_nick (void);
  void event_kick (void);
  void event_part (void);
  void event_mode (void);
  void event_privmsg (void);
  void event_topic (void);

  void delete_cmds (void);
  void delete_f_recursive (f_type *);

  f_type *replies;				// list of reply handlers
  f_type *events;				// list of event handlers

};

#endif
