#ifndef _H_CCHANNEL
#define _H_CCHANNEL

class CChannel;

#include "mbot.h"

class CChannel {
public:
  CChannel (const char *, const char *, CServer *);
  ~CChannel (void);

  void irc_join (void);
  void irc_part (void);
  void irc_topic (const char *);
  void irc_invite (const char *);
  void irc_kick (const char *, const char *);
  void irc_mode (const char *, const char *);
  void irc_op (const char *);
  void irc_deop (const char *);
  void irc_voice (const char *);
  void irc_devoice (const char *);
  void irc_deopban (const char *, const char *);
  void irc_ban_nick (const char *);
  void irc_ban_mask (const char *);
  void irc_unban_nick (const char *);
  void irc_unban_mask (const char *);
  
  int user_index (const char *);
  void user_add (const char *, bool, bool);
  void user_del (const char *);
  void user_change_op (const char *, bool);
  void user_change_voice (const char *, bool);
  void user_change_nick (const char *, const char *);

  char name[CHANNEL_SIZE+1];			// channel name
  char key[CHANNEL_KEY_SIZE+1];			// channel key
  char topic[TOPIC_SIZE+1];			// channel topic
  CServer *s;					// server to which belongs

  char last_msg[MSG_SIZE+1];		// last privmsg
  char last_mask[MASK_SIZE+1];		// mask who said it
  u_int msg_num;			// num of equal msg/mask in a row
  u_int mask_num;			// num of equal masks in a row
  u_int warn_num;	// num of msgs, after the others, to kick
			// if !0, send flood_kick_msg to pvt on the 1st time
  bool joined;					// if it's inside the channel

  char kick_nick[NICK_SIZE+1];			// to kick who kicked it
  char last_deleted_nick[NICK_SIZE+1];	// mainly to log quit and nick events

  struct user {
    char nick[NICK_SIZE+1];			// nick
    char mask[MASK_SIZE+1];			// mask
    bool is_op;					// if has op
    bool is_voice;				// if has voice
  } *users[C_USERS_MAX];			// users inside the channel
  int user_num;					// how many

private:

  char buf[CMD_SIZE*(MSG_SIZE+1)];
  char buf2[MSG_SIZE+1];

};

#endif
