#ifndef _H_CBOT
#define _H_CBOT

class CBot;

#include "CServer.h"
#include "CModule.h"
#include "CText.h"
#include "CVar.h"

class CBot {
public:
  CBot (void);
  ~CBot (void);

  void write_botlog (const char *);
  CModule *add_module (const char *);
  bool del_module (const char *);
  void parse_cmd (int argc, char *argv[]);
  void check_pid (void);
  void write_pid (void);
  void server_info (void);
  void conf_error (const char *);
  void conf_warn (const char *);
  void check_server (CServer *);
  void parse_conf (void);
  void irc_exit (void);
  void work (void);

  CServer* servers[SERVER_MAX];
  int server_num;

  struct module_type {
    CModule *m;
    module_type *next;
  } *module_list;

  CText *conf;
  char conf_file[FILE_SIZE+1];
  char pid_file[FILE_SIZE+1];

  u_int line;		// to store the current configuration line
  u_short debug;	// if 1, doesn't go into bg and show read/writes

  time_t time_now;

private:
  char buf[BUF_SIZE+1];
};

#endif
